unit Memmiser;
{
// MEMMISER.PAS (C) 1995 W. Raike
//              ALL RIGHTS RESERVED.
}
interface
{*******************************************************************}
{
  Class TOLEObjectList is a list for keeping track of TOLEObjects.
  This produces a (sort of) polymorphic TList.
}
{*******************************************************************}

uses
  SysUtils, Classes, OLEAuto;

type

  { Use this as a template for a list of any kind of objects. }
  TOLEObjectList = class(TList)
  protected
    { These methods hide the inherited (protected) ones of the same names. }
    { Return/assign an object type instead of a pointer. }
    function Get(i : Integer) : TOLEObject;
    procedure Put(i : Integer; val : TOLEObject);
  public
    { Hide inherited property by declaring another with same name.}
    { This one is the default property of TList, so is also the
      default array property of this class. }
    property Items[i : Integer] : TOLEObject read Get write Put;
    destructor Destroy; override;
  end;

implementation

function TOLEObjectList.Get(i : Integer) : TOLEObject;
begin
  Result := TOLEObject(inherited Items[i]);
end;

procedure TOLEObjectList.Put(i : Integer ; val : TOLEObject);
begin
  inherited Put(i, val);
end;

destructor TOLEObjectList.Destroy;
begin
  Clear;
  inherited Destroy;
end;

end.

