unit Xldriv7;

interface

uses
  Oleauto, XLCls, SafeOle,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ToCtrl, Menus;

type
  TForm1 = class(TForm)
    OleAutoClient1: TOleAutoClient;
    btnSaveSheet: TButton;
    btnQuit: TButton;
    SaveDialog1: TSaveDialog;
    edCellText: TEdit;
    Label2: TLabel;
    btnStartExcel: TButton;
    procedure btnQuitClick(Sender: TObject);
    procedure btnSaveSheetClick(Sender: TObject);
    procedure btnStartExcelClick(Sender: TObject);
end;

var
  Form1: TForm1;
  ExcelApp : TExcelApp;

implementation

{$R *.DFM}

procedure TForm1.btnQuitClick(Sender: TObject);
begin
  if Assigned(ExcelApp) then
  begin
    ExcelApp.Quit;
    ExcelApp.Release;
    ExcelApp := nil;
  end;
  TSafeOleObject.FreeOobList;

  Close;
end;

procedure TForm1.btnSaveSheetClick(Sender: TObject);
var
  i : Integer;
  FirstCell : TExcelCells;
  XLActiveSheet : TExcelSheet;
  XLNewBook : TXLWorkBook;
begin
  if Assigned(ExcelApp) then
  begin
    XLNewBook := ExcelApp.WorkBooks.Add;
    XLActiveSheet := XLNewBook.ActiveSheet;
    FirstCell := XLActiveSheet.Cells[1,1];
    FirstCell.Value := edCellText.Text;
    if SaveDialog1.Execute then
      XLActiveSheet.FileSave(SaveDialog1.FileName)
    else
      { Mark it so Excel doesn't ask us if we want to save it. }
      XLNewBook.Saved := True;
    btnQuitClick(Sender); {Shut down and exit. }
  end;
end;

procedure TForm1.btnStartExcelClick(Sender: TObject);
begin
  { Protection block for Ooblist memory allocation. }
  try
  { Create a list to keep track of created OLE objects. }
  TSafeOleObject.CreateOobList;
    { Protection block for OLE Automation. }
    try
      { Tell OLE to start up Excel. }
      ExcelApp := TExcelApp.CreateObject('Excel.Application');
      ExcelApp.Visible := True;
      { Move this app to top of Z-order }
      SetWindowPos(Handle, HWND_TOP, 0,0,0,0, SWP_NOMOVE Or SWP_NOSIZE);
    except
      ShowMessage('Caught an exception.  Excel may not be ' +
          'installed correctly.  Otherwise, did you remember ' +
          'to drop a TOLEAutoClient component on your form?');
      btnQuitClick(Sender);
    end;
  except
    ShowMessage('Not enough memory for internal record keeping.');
  end;

end;

end.

