unit SafeOLE;
{
// SAFEOLE.PAS (C) 1995 W. Raike
//              ALL RIGHTS RESERVED.
}
interface
{*******************************************************************}
{
  Class TSafeOLEObject inherited from TOLEObject (TOLEAutoClient)
  keeps track of all sub-objects created using a ConnectInterface
  constructor so that they can be freed later.
}
{*******************************************************************}

uses
  SysUtils, OleAuto, MemMiser;

type

  { This class overrides the ConnectInterface constructor so as to
    keep track of all objects created so that they can later be released. }
  TSafeOLEObject = class(TOleObject)
  public
    constructor ConnectInterface(pI : pInterface); override;
    class procedure CreateOobList;
    class procedure FreeOobList;
  end;

implementation

var
  { Static class member to keep track of all TOLEObjects created
    using ConnectInterface constructors. }
  OobList : TOleObjectList;

constructor TSafeOleObject.ConnectInterface(pI : pInterface);
begin
  inherited ConnectInterface(pI);
  if Assigned(OobList) then
    OobList.Add(self);
end;

class procedure TSafeOleObject.CreateOobList;
begin
  if not Assigned(Ooblist) then
    OobList := TOleObjectList.Create;
end;

class procedure TSafeOleObject.FreeOobList;
var
  i : Integer;
begin
  i := 0;
  if Assigned(OobList) then
  begin
    { Free up any nested OLE objects. }
    while i <= (OobList.Count - 1) do
    begin
      OobList.Items[i].Release;
      Inc(i);
    end;
    OobList.Free;
  end;
end;

end.

