unit Xldriv;

interface

uses
  Oleauto, XLCls, SafeOle,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ToCtrl, Menus;

type
  TForm1 = class(TForm)
    ScrollBox1: TScrollBox;
    MainMenu1: TMainMenu;
    OleAutoClient1: TOleAutoClient;
    btnSaveSheet: TButton;
    OleContainer1: TOleContainer;
    btnQuit: TButton;
    SaveDialog1: TSaveDialog;
    edCellText: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure btnQuitClick(Sender: TObject);
    procedure btnSaveSheetClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
end;

var
  Form1: TForm1;
  ExcelApp : TExcelApp;

implementation

{$R *.DFM}

procedure TForm1.btnSaveSheetClick(Sender: TObject);
var
  i : Integer;
  XLNewBook : TXLWorkBook;
  XLActiveSheet : TExcelSheet;
  FirstCell : TExcelCells;
begin
  { Protection block for Ooblist memory allocation. }
  try
  { Create a list to keep track of created OLE objects. }
  TSafeOleObject.CreateOobList;
    try

      { Protection block for OLE Automation. }
      try
        { Tell OLE to start up Excel. }
        ExcelApp := TExcelApp.GetObject('Excel.Application');
        try
          { ExcelApp.Visible := True; }

          XLNewBook := ExcelApp.WorkBooks.Add;
          XLActiveSheet := XLNewBook.ActiveSheet;
          FirstCell := XLActiveSheet.Cells[1,1];
          FirstCell.Value := edCellText.Text;
          if SaveDialog1.Execute then
            XLActiveSheet.FileSave(SaveDialog1.FileName);
          ExcelApp.Quit;
        finally
          { Call the destructor for the OLE object. }
          ExcelApp.Release;
          ExcelApp := nil; { So btnQuit doesn't try to use it. }
        end;
      except
        ShowMessage('Caught an exception.  Excel may not be ' +
            'installed correctly.  Otherwise, did you remember ' +
            'to drop a TOLEAutoClient component on your form?');
      end;

    finally
      TSafeOleObject.FreeOobList;
    end;
  except
    ShowMessage('Not enough memory for internal record keeping.');
  end;

  Close;
end;

procedure TForm1.btnQuitClick(Sender: TObject);
begin
  if Assigned(ExcelApp) then
  begin
    ExcelApp.Quit;
    ExcelApp.Release;
    ExcelApp := nil;
  end;
  Close;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
  { Set focus to the TOLEContainer so the server is started. }
  ActiveControl := OleContainer1;
end;

end.

