unit Numsvcls;

interface

uses
   SysUtils, OleAuto;

type
    TNumSvrOb = class(TOleObject)
    private
        procedure SetX(newx : Integer);
        function GetX : Integer;
    public
        property X : integer read GetX write SetX;
        procedure Incr(var x : Integer);
    end;

implementation

procedure TNumSvrOb.Incr(var x : Integer);
begin
    { Specify argument type as '&Integer' to pass by reference. }
    SetOleMethodArg('&Integer', x);
    CallOleProc('Incr');
end;

procedure TNumSvrOb.SetX(newx : Integer);
begin
    SetOleMethodArg('integer', newx);
    CallOleProc('SetX');
end;

function TNumSvrOb.GetX : Integer;
var
    x : Integer;
begin
    CallOleFunction('GetX', 'Integer', x);
    Result := x;
end;

end.
