unit NumSvr;

interface

uses
  OleAuto,
  NumSvCls,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TfrmNumSvr = class(TForm)
    cmdExit: TButton;
    cmdBumpit: TButton;
    txtXVal: TEdit;
    cmdIncr: TButton;
    OleAutoClient1: TOleAutoClient;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure cmdExitClick(Sender: TObject);
    procedure cmdBumpitClick(Sender: TObject);
    procedure cmdIncrClick(Sender: TObject);
  private
    { Private declarations }
   ob : TNumSvrOb;
   bObExists : Boolean;
  public
    { Public declarations }
  end;

var
  frmNumSvr: TfrmNumSvr;

implementation

{$R *.DFM}

procedure TfrmNumSvr.FormCreate(Sender: TObject);
begin
   bObExists := False;
   ob := TNumSvrOb.CreateObject('NumSvr.Document');
   bObExists := True;
end;

procedure TfrmNumSvr.FormDestroy(Sender: TObject);
begin
   if bObExists then
        ob.Release;
end;

procedure TfrmNumSvr.cmdExitClick(Sender: TObject);
begin
   Close;
end;

procedure TfrmNumSvr.cmdBumpitClick(Sender: TObject);
var
    x : Integer;
begin
   if not bObExists then Exit;
   ob.X := ob.X + 1;
end;

procedure TfrmNumSvr.cmdIncrClick(Sender: TObject);
var
   x : Integer;
begin
   if not bObExists then Exit;
   x := Integer(StrToInt(txtXVal.text));
   { After the following call, the value of x should be incremented by the OLE object. }
   ob.Incr(x);
   txtXVal.text := IntToStr(Longint(x));
end;

end.
