{
// WORDDRIV.PAS (C) 1995 W. Raike
//              ALL RIGHTS RESERVED.
//   NOTICE:    This file consists of trade secrets that are the property
//              of William Raike.  The contents may not be used or disclosed
//              without express written permission of the owner.
}
{*******************************************************************}
{
    User interface for driver for the OLE Automation server functions
  in Microsoft Word for Windows 6.0.
}
{*******************************************************************}
unit Worddriv;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls,
  WordCls,
  OleAuto;

type
  TfrmWordDriv = class(TForm)
    btnCreate: TButton;
    btnDestroy: TButton;
    btnExit: TButton;
    btnFileNew: TButton;
    btnDiscard: TButton;
    btnMacro: TButton;
    btnEditOptions: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    txtMacroName: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    OleAutoClient1: TOleAutoClient;
    btnGetSelection: TButton;
    lblSelection: TLabel;
    gbxFFTest: TGroupBox;
    btnFileFind: TButton;
    edtFileFindDir: TEdit;
    edtFileFindName: TEdit;
    btnCountFoundFiles: TButton;
    lblCountFoundFiles: TLabel;
    btnFFNames: TButton;
    cbFFNames: TComboBox;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    procedure btnCreateClick(Sender: TObject);
    procedure btnDestroyClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure btnFileNewClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure btnMacroClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnEditOptionsClick(Sender: TObject);
    procedure btnFileFindClick(Sender: TObject);
    procedure btnCountFoundFilesClick(Sender: TObject);
    procedure btnFFNamesClick(Sender: TObject);
    procedure btnGetSelectionClick(Sender: TObject);
  private
    { Private declarations }
  public
    procedure DestroyObject;
  end;

var
  frmWordDriv: TfrmWordDriv;
  ooWord : TWordObj;
  bObExists : Boolean;

implementation

{$R *.DFM}

procedure TfrmWordDriv.DestroyObject;
begin
  ooWord.Release;
  bObExists := False;
end;

procedure TfrmWordDriv.btnCreateClick(Sender: TObject);
begin
  ooWord := TWordObj.CreateObject('word.basic');
  bObExists := True;
  ooWord.AppShow;  { Required to make Word 7 visible. }
  { Move this form to the top of the z-order. }
  SetWindowPos(Handle, HWND_TOP, 0,0,0,0, SWP_NOMOVE Or SWP_NOSIZE);
  cbFFNames.ItemIndex := 0; { Show prompt in list box. }
end;

procedure TfrmWordDriv.btnDestroyClick(Sender: TObject);
begin
  if Not bObExists then Exit;
  DestroyObject;
end;

procedure TfrmWordDriv.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmWordDriv.btnFileNewClick(Sender: TObject);
begin
  if Not bObExists then Exit;
  ooWord.FileNew('normal.dot');
end;

procedure TfrmWordDriv.btnDiscardClick(Sender: TObject);
begin
  if Not bObExists then Exit;
  ooWord.FileClose(2);
end;

procedure TfrmWordDriv.btnMacroClick(Sender: TObject);
var
  s : String;
begin
  if Not bObExists then Exit;
  s := txtMacroName.text;
  ooWord.ToolsMacro(s);
end;

procedure TfrmWordDriv.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if bObExists then
      DestroyObject;
end;

procedure TfrmWordDriv.btnEditOptionsClick(Sender: TObject);
begin
  if Not bObExists then Exit;
  ooWord.ToolsOptionsEdit;
end;

procedure TfrmWordDriv.btnFileFindClick(Sender: TObject);
var
  StartDir, FileMask : String;
begin
  if not bObExists then Exit;
  StartDir := edtFileFindDir.Text;
  FileMask := edtFileFindName.Text;
  ooWord.FileFind(FileMask, StartDir);
end;

procedure TfrmWordDriv.btnCountFoundFilesClick(Sender: TObject);
begin
  if not bObExists then Exit;
  lblCountFoundFiles.Caption := IntToStr(ooWord.CountFoundFiles);
end;

procedure TfrmWordDriv.btnFFNamesClick(Sender: TObject);
var
  i : Integer;
begin
  if not bObExists then Exit;
  i := 1;
  while i <= ooWord.CountFoundFiles do
  begin
    cbFFNames.Items.Add(ooWord.FoundFileName(i));
    Inc(i);
  end;
end;

procedure TfrmWordDriv.btnGetSelectionClick(Sender: TObject);
var
  pszStr : PChar;
begin
  if not bObExists then Exit;
  lblSelection.Caption := '';
  pszStr := ooWord.Selection;
  if pszStr <> nil then
    if StrLen(pszStr) <=255 then
      lblSelection.Caption := StrPas(ooWord.Selection);
end;

end.
