unit Graphcls;
{
//__________________________________________________________________________
// Unit File  : GRAPHCLS.PAS
// Summary    :
// Author     : William M. Raike
// Created on : 31 Dec 1995
// Project    :
// Compiler   : Borland Delphi 1.0
//__________________________________________________________________________
//                       INTERFACE CHANGE HISTORY
//  No.	When	Who    Why
//  0           WMR  Original File.
//
//__________________________________________________________________________
//
// Description:
      Mirror class for MS-GRAPH OLE Automation server, describing
      Application sub-object with its Visible property.  Illustrates
      accessing nested objects using TOLEAutoClient component.
}

interface

uses
  OleAuto;

type

  { Describes Application object nested within top-level
    MSGraph.Chart server object.  This class models only
    the Visible property of the Application object.}
  TGraphChartApp = class(TOleObject)
  private
    function GetVisible : Boolean;
    procedure SetVisible(vis : Boolean);
  public
    property Visible : Boolean read GetVisible write SetVisible;
  end;

  { Describes top-level MSGraph.Chart server object.  This
    class models only the Application property (sub-object)
    of the server. }
  TGraphChart = class(TOLEObject)
  private
    FApplication : TGraphChartApp;
    function GetApplication : TGraphChartApp;
    procedure SetApplication(app : TGraphChartApp);
  public
    property Application : TGraphChartApp
                read GetApplication write SetApplication;
    destructor Release; override;
  end;

{***************************************************************************}
implementation
{***************************************************************************}

destructor TGraphChart.Release;
begin
  { Override destructor to free up the private FApplication
    sub-object if it has been created. }
  if Assigned(FApplication) then
    FApplication.Release;
  inherited Release;
end;

function TGraphChart.GetApplication : TGraphChartApp;
var
  pApp : pInterface;
begin
  if Assigned(FApplication) then
    Result := FApplication
  else
  begin
    GetOleProperty('Application', 'pInterface', pApp);
    if Assigned(pApp) then
    begin
      FApplication := TGraphChartApp.ConnectInterface(pApp);
      Result := FApplication;
    end
    else
      Result := nil;
  end;
end;

procedure TGraphChart.SetApplication(app : TGraphChartApp);
begin
  FApplication := app;
end;

function TGraphChartApp.GetVisible : Boolean;
var
  intvis : Integer;
begin
  GetOleProperty('Visible', 'Integer', intvis);
  Result := Boolean(intvis);
end;

procedure TGraphChartApp.SetVisible(vis : Boolean);
var
  intvis : Integer;
begin
  intvis := Integer(vis);
  SetOleProperty('Visible', 'Integer', intvis);
end;

end.
