unit Graphole;
{
//__________________________________________________________________________
// Unit File  : GRAPHOLE.PAS
// Summary    :
// Author     : William M. Raike
// Created on : 31 Dec 1995
// Project    :
// Compiler   : Borland Delphi 1.0
//__________________________________________________________________________
//                       INTERFACE CHANGE HISTORY
//  No.	When	Who    Why
//  0           WMR  Original File.
//
//__________________________________________________________________________
//
// Description:
      Illustration of controlling MS-GRAPH, with nested objects,
      using TOLEAutoClient component.
}

interface

uses
  GraphCls,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Oleauto;

type
  TForm1 = class(TForm)
    btnVisible: TButton;
    OleAutoClient1: TOleAutoClient;
    btnExit: TButton;
    procedure btnVisibleClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  GraphChart : TGraphChart;
  bObExists : Boolean;

implementation

{$R *.DFM}

procedure TForm1.btnVisibleClick(Sender: TObject);
begin
  if bObExists then
    { Toggle visibility on/off. }
    GraphChart.Application.Visible := not GraphChart.Application.Visible;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if bObExists then
  begin
    GraphChart.Release;
    bObExists := False;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Application.ShowHint := True;
  Application.HintPause := 10;

  GraphChart := TGraphChart.CreateObject('MSGraph.Chart');
  if Assigned(GraphChart) then
    bObExists := True;

  { Move this window to the top of the z-order. }
  SetWindowPos(Handle, HWND_TOPMOST, 0,0,0,0, SWP_NOMOVE Or SWP_NOSIZE);
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
  Close;
end;

end.
