unit Demofrm;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Spin, Ssbc, ExtCtrls, Printers;

type
  TfmDemo = class(TForm)
    ssBarCode: TssBarCode;
    Panel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cbType: TComboBox;
    ckBearer: TCheckBox;
    ckReadable: TCheckBox;
    cbOrientation: TComboBox;
    edData: TEdit;
    btUpdate: TBitBtn;
    btClose: TBitBtn;
    Panel1: TPanel;
    edWidth: TEdit;
    Label5: TLabel;
    btPrint: TBitBtn;
    procedure btUpdateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ckBearerClick(Sender: TObject);
    procedure ckReadableClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure btPrintClick(Sender: TObject);
  private
    procedure RepositionCode;
  public
  end;

var
  fmDemo: TfmDemo;

implementation

{$R *.DFM}

procedure TfmDemo.btUpdateClick(Sender: TObject);
begin
  with ssBarCode do
  begin
    Data := edData.Text;
    BarWidth := StrToFloat(edWidth.Text);
    case cbType.ItemIndex of
      0 : BarCodeType := bcCode39;
      1 : BarCodeType := bcInt2of5;
      2 : BarCodeType := bcPostnet;
      3 : BarCodeType := bcUPC_A;
    end;
    case cbOrientation.ItemIndex of
      0 : Orientation := orLeft_Right;
      1 : Orientation := orRight_Left;
      2 : Orientation := orTop_Bottom;
      3 : Orientation := orBottom_Top;
    end;
    ckBearer.Checked := BearerBars;
  end;
  RepositionCode;
end;

procedure TfmDemo.FormCreate(Sender: TObject);
begin
  cbType.ItemIndex := 0;
  cbOrientation.ItemIndex := 0;
  RepositionCode;
end;

procedure TfmDemo.ckBearerClick(Sender: TObject);
begin
  try
    ssBarCode.BearerBars := ckBearer.Checked;
  finally
    ckBearer.Checked := ssBarCode.BearerBars;
  end;
end;

procedure TfmDemo.ckReadableClick(Sender: TObject);
begin
  ssBarCode.PrintHumanReadable := ckReadable.Checked;
end;

procedure TfmDemo.RepositionCode;

begin
  ssBarCode.Left := (fmDemo.Width - ssBarCode.Width) div 2;
  ssBarCode.Top := ((fmDemo.Height-Panel.Height) - ssBarCode.Height) div 2;
end;

procedure TfmDemo.FormResize(Sender: TObject);
begin
  RepositionCode;
end;

procedure TfmDemo.btPrintClick(Sender: TObject);
begin
  with Printer do
  begin
    Canvas.Font.Name := 'Courier New';
    BeginDoc;
    { It's this easy to print your barcode!  Specify the X and Y positions in inches.
      The third parameter is the height in inches.  If you specify 0 (zero), ssBarcode will
      calculate the standard height-to-width ratio for this code }

    ssBarCode.PrintBarcode(1.0,1.0,0);
    EndDoc;
  end;
end;

end.
