Attribute VB_Name = "T2WIN_32_DEF"
Option Explicit

' object

Declare Function cObjectGetBoolean Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As Boolean
Declare Function cObjectGetByte Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As Byte
Declare Function cObjectGetInteger Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As Integer
Declare Function cObjectGetLong Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As Long
Declare Function cObjectGetString Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As String
Declare Function cObjectGetStringW Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As String
Declare Function cObjectGetVariant Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String) As Variant
Declare Function cObjectGetIndex Lib "t2win-32.dll" (ByVal Obj As Object) As Integer

Declare Function cGetObjCaption Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjContainer Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjParent Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjTag Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjText Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjDataField Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjDataSource Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjName Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjIndex Lib "t2win-32.dll" (ByVal Obj As Object) As Integer
Declare Function cGetObjNameIndex Lib "t2win-32.dll" (ByVal Obj As Object) As String
Declare Function cGetObjClassName Lib "t2win-32.dll" (ByVal Obj As Object) As String

Declare Sub cObjectPutBoolean Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As Boolean)
Declare Sub cObjectPutByte Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As Byte)
Declare Sub cObjectPutInteger Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As Integer)
Declare Sub cObjectPutLong Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As Long)
Declare Sub cObjectPutString Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As String)
Declare Sub cObjectPutVariant Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Property As String, ByVal Value As Variant)

Declare Sub cPutObjCaption Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Value As String)
Declare Sub cPutObjDataField Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Value As String)
Declare Sub cPutObjDataSource Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Value As String)
Declare Sub cPutObjTag Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Value As String)
Declare Sub cPutObjText Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Value As String)

Declare Sub cObjectMethod Lib "t2win-32.dll" (ByVal Obj As Object, ByVal Method As String, ByVal Value As Variant)

Declare Sub cDisableFI Lib "t2win-32.dll" (ByVal Obj As Object)
Declare Sub cEnableFI Lib "t2win-32.dll" (ByVal Obj As Object)

Declare Function cCloseAllEditForm Lib "t2win-32.dll" () As Integer
Declare Function cHideAllEditForm Lib "t2win-32.dll" () As Integer
Declare Function cHideDebugForm Lib "t2win-32.dll" () As Integer
Declare Function cUnHideAllEditForm Lib "t2win-32.dll" () As Integer
Declare Function cUnHideDebugForm Lib "t2win-32.dll" () As Integer

Declare Sub cEnableForm Lib "t2win-32.dll" (ByVal hWnd As Long)
Declare Sub cEnableRedraw Lib "t2win-32.dll" (ByVal hWnd As Long)
Declare Sub cObjEnableRedraw Lib "t2win-32.dll" (ByVal Obj As Object)
Declare Sub cDisableForm Lib "t2win-32.dll" (ByVal hWnd As Long)
Declare Sub cDisableRedraw Lib "t2win-32.dll" (ByVal hWnd As Long)
Declare Sub cObjDisableRedraw Lib "t2win-32.dll" (ByVal Obj As Object)

' windows 95

'  structure for windows 95 memory
Type tagMEMORYSTATUS
   dwLength             As Long        'sizeof(MEMORYSTATUS)
   dwMemoryLoad         As Long        'percent of memory in use
   dwTotalPhys          As Long        'bytes of physical memory
   dwAvailPhys          As Long        'free physical memory bytes
   dwTotalPageFile      As Long        'bytes of paging file
   dwAvailPageFile      As Long        'free bytes of paging file
   dwTotalVirtual       As Long        'user bytes of address space
   dwAvailVirtual       As Long        'free user bytes
End Type

Declare Sub cMemoryStatus Lib "t2win-32.dll" (MEMORYSTATUS As tagMEMORYSTATUS)
Declare Function cPBFileCopy Lib "t2win-32.dll" (ByVal hWndParent As Long, ByVal FileNameIn As String, ByVal FileNameOut As String) As Integer
Declare Function cDBFileCopy Lib "t2win-32.dll" (ByVal Title As String, ByVal CaptionFrom As String, ByVal CaptionTo As String, ByVal CaptionButton As String, ByVal FileNameIn As String, ByVal FileNameOut As String) As Integer

' file

'  definition for error type for ISFileNameVALID
Public Const IFV_ERROR = 0
Public Const IFV_NAME_TOO_LONG = 1
Public Const IFV_EXT_TOO_LONG = 2
Public Const IFV_TOO_MANY_BACKSLASH = 3
Public Const IFV_BAD_DRIVE_LETTER = 4
Public Const IFV_BAD_COLON_POS = 5
Public Const IFV_EXT_WITHOUT_NAME = 6

' definition for sFile attributes
Public Const A_RDONLY = &H1             'Read only file
Public Const A_HIDDEN = &H2             'Hidden file
Public Const A_SYSTEM = &H4             'System file
Public Const A_SUBDIR = &H10            'Subdirectory
Public Const A_ARCHIVE = &H20           'Archive file
Public Const A_NORMAL = &H80            'Normal sFile - No read/write restrictions
Public Const A_COMPRESSED = &H800       'Compressed file
Public Const A_NORMAL_ARCHIVE = &HFE    'Normal, Archive
Public Const A_ALL = &HFF               'Normal, Archive, Read-Only, Hidden, System

' definition for drive type
Public Const DRIVE_UNKNOWN = 0
Public Const DRIVE_NO_ROOT_DIR = 1
Public Const DRIVE_REMOVABLE = 2
Public Const DRIVE_FIXED = 3
Public Const DRIVE_REMOTE = 4
Public Const DRIVE_CDROM = 5
Public Const DRIVE_RAMDISK = 6

'  definition for sFile sort
Public Const SORT_ASCENDING = 1
Public Const SORT_DESCENDING = 2
Public Const SORT_CASE_SENSITIVE = 4
Public Const SORT_CASE_INSENSITIVE = 8

' definition for sFile I/O
Public Const EOFILE = -1
Public Const SEEK_CUR = 1
Public Const SEEK_END = 2
Public Const SEEK_SET = 0

' definition for sFile uucp
Public Const MODE_UUENCODE = 0
Public Const MODE_UUDECODE = 1

'  structure for sFile attributes
Type FileAttributeType
   ErrNo             As Integer
   Archive           As Integer
   Hidden            As Integer
   Normal            As Integer
   ReadOnly          As Integer
   SubDir            As Integer
   System            As Integer
   Compressed        As Integer
End Type

'  structure for split path
Type tagSPLITPATH
   nDrive            As String
   nDir              As String
   nName             As String
   nExt              As String
End Type

Declare Function cAllSubDirectories Lib "t2win-32.dll" (ByVal lpBaseDirectory As String, nDir As Long) As String
Declare Function cChDir Lib "t2win-32.dll" (ByVal lpDir As String) As Integer
Declare Function cChDrive Lib "t2win-32.dll" (ByVal lpDrive As String) As Integer
Declare Function cCmpFileAttribute Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileContents Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal Sensitivity As Integer) As Integer
Declare Function cCmpFileSize Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCmpFileTime Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Integer
Declare Function cCountDirectories Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cCountFiles Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileSize Lib "t2win-32.dll" (ByVal lpFilename As String) As Long
Declare Function cIsFilenameValid Lib "t2win-32.dll" Alias "cIsFileNameValid" (ByVal nFilename As String) As Integer
Declare Function cKillDir Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillDirFilesAll Lib "t2win-32.dll" (ByVal lpDir As String, ByVal lpMask As String) As Integer
Declare Function cKillDirs Lib "t2win-32.dll" (ByVal lpDir As String, ByVal HeaderDirectory As Integer) As Integer
Declare Function cKillFile Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFileAll Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFiles Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cKillFilesAll Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeDir Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cMakeMultipleDir Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFileResetAllAttrib Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetArchive Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetFlag Lib "t2win-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileResetHidden Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetReadOnly Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileResetSystem Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAllAttrib Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetArchive Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetAttrib Lib "t2win-32.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileSetFlag Lib "t2win-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cFileSetHidden Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetReadOnly Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cFileSetSystem Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cUniqueFileName Lib "t2win-32.dll" (Txt As String) As String
Declare Function cFileCopy Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileCopy2 Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileDrive Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileGetAttrib Lib "t2win-32.dll" (ByVal nFilename As String, nFileAttribute As Any) As Integer
Declare Function cFileMove Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFilePathExists Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cFilesSize Lib "t2win-32.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSizeOnDisk Lib "t2win-32.dll" (ByVal nFilename As String) As Long
Declare Function cFilesSlack Lib "t2win-32.dll" (ByVal nFilename As String, Size1 As Long, Size2 As Long) As Integer
Declare Function cGetDiskClusterSize Lib "t2win-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskFree Lib "t2win-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskSpace Lib "t2win-32.dll" (ByVal lpDrive As String) As Long
Declare Function cGetDiskUsed Lib "t2win-32.dll" (ByVal lpDrive As String) As Long
Declare Function cRcsCountFileDir Lib "t2win-32.dll" (ByVal FileOrDir As Integer, ByVal FirstFileOrDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Integer
Declare Function cRcsFilesSize Lib "t2win-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSizeOnDisk Lib "t2win-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer) As Long
Declare Function cRcsFilesSlack Lib "t2win-32.dll" (ByVal FirstDir As String, ByVal MaskDir As String, ByVal Recurse As Integer, Size1 As Long, Size2 As Long) As Integer
Declare Function cSubDirectory Lib "t2win-32.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFileChangeChars Lib "t2win-32.dll" (ByVal nFilename As String, CharSet As String, NewCharSet As String, ByVal nFileTemp As String) As Long
Declare Function cFileCompressTab Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Long) As Long
Declare Function cFileExpandTab Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal nTab As Long) As Long
Declare Function cFileFilter Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileFilterNot Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, Filter As String) As Long
Declare Function cFileLineCount Lib "t2win-32.dll" (ByVal lpFilename As String) As Long
Declare Function cFileMerge Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal fileTo As String) As Long
Declare Function cFileSearch Lib "t2win-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchAndReplace Lib "t2win-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Replace As String, ByVal nFileTemp As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileSearchCount Lib "t2win-32.dll" (ByVal nFilename As String, ByVal Search As String, ByVal Sensitivity As Integer) As Long
Declare Function cFileToUpper Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileToLower Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cTruncatePath Lib "t2win-32.dll" (ByVal nFilename As String, ByVal NewLength As Long) As String
Declare Function cFullPath Lib "t2win-32.dll" (ByVal nFilename As String) As String
Declare Function cMakePath Lib "t2win-32.dll" (ByVal nDrive As String, ByVal nDir As String, ByVal nFilename As String, ByVal Ext As String) As String
Declare Function cSplitPath Lib "t2win-32.dll" (ByVal nFilename As String, SPLITPATH As Any) As Integer
Declare Function cFileDateCreated Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateAccess Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastDateModified Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileTimeCreated Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeAccess Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cFileLastTimeModified Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cGetDriveType Lib "t2win-32.dll" (ByVal lpDrive As String) As Integer
Declare Function cFileSort Lib "t2win-32.dll" (ByVal FileIn As String, ByVal FileOut As String, ByVal SortMethod As Integer, ByVal RecordLength As Long, ByVal KeyOffset As Long, ByVal KeyLength As Long, rRecords As Long) As Long
Declare Function cFileStatistics Lib "t2win-32.dll" (ByVal nFilename As String, nLines As Long, nWords As Long, nChars As Long) As Long
Declare Function cFilesInDirectory Lib "t2win-32.dll" (ByVal nFilename As String, ByVal FirstNext As Integer) As String
Declare Function cFilesInDirOnDisk Lib "t2win-32.dll" (ByVal nFile As String, ByVal nFilename As String, ByVal nAttribute As Integer) As Integer
Declare Function cFilesInDirToArray Lib "t2win-32.dll" (ByVal nFilename As String, ByVal nAttribute As Integer, array() As String) As Integer
Declare Function cRenameFile Lib "t2win-32.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String) As Integer
Declare Function cSearchFile Lib "t2win-32.dll" (ByVal lpStartPath As String, ByVal lpFileMask As String, ByVal lpFileResult As String) As Long
Declare Function cFileUUCP Lib "t2win-32.dll" (ByVal lpFilename1 As String, ByVal lpFilename2 As String, ByVal EncodeDecode As Integer) As Long

' binary

Declare Function cCreateBits Lib "t2win-32.dll" (ByVal nBits As Long) As String
Declare Function cFindBitReset Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As Long
Declare Function cFindBitSet Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As Long
Declare Function cGetBit Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As Integer
Declare Function cGiveBitPalindrome Lib "t2win-32.dll" () As String
Declare Function cIsBitPalindrome Lib "t2win-32.dll" (Txt As String) As Integer
Declare Sub cReverseAllBits Lib "t2win-32.dll" (Txt As String)
Declare Sub cReverseAllBitsByChar Lib "t2win-32.dll" (Txt As String)
Declare Sub cSetAllBits Lib "t2win-32.dll" (Txt As String, ByVal Value As Integer)
Declare Sub cSetBit Lib "t2win-32.dll" (Txt As String, ByVal Position As Long, ByVal Value As Integer)
Declare Sub cSetBitToFalse Lib "t2win-32.dll" (Txt As String, ByVal Position As Long)
Declare Sub cSetBitToTrue Lib "t2win-32.dll" (Txt As String, ByVal Position As Long)
Declare Sub cToggleAllBits Lib "t2win-32.dll" (Txt As String)
Declare Sub cToggleBit Lib "t2win-32.dll" (Txt As String, ByVal Position As Long)
Declare Function cB2I Lib "t2win-32.dll" (ByVal Txt As String) As Integer
Declare Function cB2L Lib "t2win-32.dll" (ByVal Txt As String) As Long
Declare Function cFromBinary Lib "t2win-32.dll" (Text As String) As String
Declare Function cFromBinary2 Lib "t2win-32.dll" (Text As String, Bin As String) As String
Declare Function cToBinary Lib "t2win-32.dll" (Text As String) As String
Declare Function cToBinary2 Lib "t2win-32.dll" (Text As String, Bin As String) As String

' compress

Declare Function cFileCompress Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cFileExpand Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cStringCompress Lib "t2win-32.dll" (Txt As String) As String
Declare Function cStringExpand Lib "t2win-32.dll" (Txt As String) As String

' timer

Declare Function cCheckWait Lib "t2win-32.dll" (ByVal nTimer As Integer) As Integer
Declare Function cReadBasisTimer Lib "t2win-32.dll" () As Long
Declare Function cReadTimer Lib "t2win-32.dll" (ByVal nTimer As Integer) As Long
Declare Sub cSetWait Lib "t2win-32.dll" (ByVal nTimer As Integer, ByVal nValue As Long)
Declare Function cSleep Lib "t2win-32.dll" (ByVal delay As Long) As Integer
Declare Sub cStartBasisTimer Lib "t2win-32.dll" ()
Declare Sub cStartTimer Lib "t2win-32.dll" (ByVal nTimer As Integer)
Declare Sub cStartWait Lib "t2win-32.dll" (ByVal nTimer As Integer)
Declare Sub cStopBasisTimer Lib "t2win-32.dll" ()
Declare Function cStopTimer Lib "t2win-32.dll" (ByVal nTimer As Integer) As Long
Declare Function cTimerClose Lib "t2win-32.dll" (ByVal TimerHandle As Integer) As Integer
Declare Function cTimerOpen Lib "t2win-32.dll" () As Integer
Declare Function cTimerRead Lib "t2win-32.dll" (ByVal TimerHandle As Integer) As Long
Declare Function cTimerStart Lib "t2win-32.dll" (ByVal TimerHandle As Integer) As Integer

' array

'  definition for array on disk
Public Const PUT_ARRAY_ON_DISK = 0
Public Const GET_ARRAY_ON_DISK = 1

'  structure for VB array
Type ArrayType
   Bounds            As Long
   LBound            As Integer
   UBound            As Integer
   ElemSize          As Integer
   IndexCount        As Integer
   TotalElem         As Integer
End Type

Declare Function cAddD Lib "t2win-32.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cAddI Lib "t2win-32.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cAddL Lib "t2win-32.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cAddS Lib "t2win-32.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cArrayOnDisk Lib "t2win-32.dll" (ByVal sFile As String, array() As Any, ByVal GetPut As Integer) As Long
Declare Function cArrayPrm Lib "t2win-32.dll" (array() As Any, nArray As ArrayType) As Integer
Declare Function cArrayStringOnDisk Lib "t2win-32.dll" (ByVal sFile As String, array() As String, ByVal GetPut As Integer, rRecords As Long) As Long
Declare Function cCountD Lib "t2win-32.dll" (array() As Double, ByVal Value As Double) As Long
Declare Function cCountI Lib "t2win-32.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cCountL Lib "t2win-32.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cCountS Lib "t2win-32.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cDeviationD Lib "t2win-32.dll" (array() As Double) As Double
Declare Function cDeviationI Lib "t2win-32.dll" (array() As Integer) As Double
Declare Function cDeviationL Lib "t2win-32.dll" (array() As Long) As Double
Declare Function cDeviationS Lib "t2win-32.dll" (array() As Single) As Double
Declare Function cFillD Lib "t2win-32.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cFillI Lib "t2win-32.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cFillL Lib "t2win-32.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cFillS Lib "t2win-32.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cFillIncrD Lib "t2win-32.dll" (array() As Double, ByVal nValue As Double, ByVal Increment As Double) As Integer
Declare Function cFillIncrI Lib "t2win-32.dll" (array() As Integer, ByVal nValue As Integer, ByVal Increment As Integer) As Integer
Declare Function cFillIncrL Lib "t2win-32.dll" (array() As Long, ByVal nValue As Long, ByVal Increment As Long) As Integer
Declare Function cFillIncrS Lib "t2win-32.dll" (array() As Single, ByVal nValue As Single, ByVal Increment As Single) As Integer
Declare Function cMaxD Lib "t2win-32.dll" (array() As Double) As Double
Declare Function cMaxI Lib "t2win-32.dll" (array() As Integer) As Integer
Declare Function cMaxL Lib "t2win-32.dll" (array() As Long) As Long
Declare Function cMaxS Lib "t2win-32.dll" (array() As Single) As Single
Declare Function cMeanD Lib "t2win-32.dll" (array() As Double) As Double
Declare Function cMeanI Lib "t2win-32.dll" (array() As Integer) As Double
Declare Function cMeanL Lib "t2win-32.dll" (array() As Long) As Double
Declare Function cMeanS Lib "t2win-32.dll" (array() As Single) As Double
Declare Function cMinD Lib "t2win-32.dll" (array() As Double) As Double
Declare Function cMinI Lib "t2win-32.dll" (array() As Integer) As Integer
Declare Function cMinL Lib "t2win-32.dll" (array() As Long) As Long
Declare Function cMinS Lib "t2win-32.dll" (array() As Single) As Single
Declare Function cReverseSortD Lib "t2win-32.dll" (array() As Double) As Integer
Declare Function cReverseSortI Lib "t2win-32.dll" (array() As Integer) As Integer
Declare Function cReverseSortL Lib "t2win-32.dll" (array() As Long) As Integer
Declare Function cReverseSortS Lib "t2win-32.dll" (array() As Single) As Integer
Declare Function cSearchI Lib "t2win-32.dll" (array() As Integer, ByVal Value As Integer) As Long
Declare Function cSearchL Lib "t2win-32.dll" (array() As Long, ByVal Value As Long) As Long
Declare Function cSearchS Lib "t2win-32.dll" (array() As Single, ByVal Value As Single) As Long
Declare Function cSearchD Lib "t2win-32.dll" (array() As Double, ByVal Value As Double) As Long
Declare Function cSetD Lib "t2win-32.dll" (array() As Double, ByVal nValue As Double) As Integer
Declare Function cSetI Lib "t2win-32.dll" (array() As Integer, ByVal nValue As Integer) As Integer
Declare Function cSetL Lib "t2win-32.dll" (array() As Long, ByVal nValue As Long) As Integer
Declare Function cSetS Lib "t2win-32.dll" (array() As Single, ByVal nValue As Single) As Integer
Declare Function cSortD Lib "t2win-32.dll" (array() As Double) As Integer
Declare Function cSortI Lib "t2win-32.dll" (array() As Integer) As Integer
Declare Function cSortL Lib "t2win-32.dll" (array() As Long) As Integer
Declare Function cSortS Lib "t2win-32.dll" (array() As Single) As Integer
Declare Function cSumD Lib "t2win-32.dll" (array() As Double) As Double
Declare Function cSumI Lib "t2win-32.dll" (array() As Integer) As Double
Declare Function cSumL Lib "t2win-32.dll" (array() As Long) As Double
Declare Function cSumS Lib "t2win-32.dll" (array() As Single) As Double

' ieeenum

Declare Function cCVB Lib "t2win-32.dll" (Value As String) As Byte
Declare Function cCVC Lib "t2win-32.dll" (Value As String) As Currency
Declare Function cCVD Lib "t2win-32.dll" (Value As String) As Double
Declare Function cCVI Lib "t2win-32.dll" (Value As String) As Integer
Declare Function cCVL Lib "t2win-32.dll" (Value As String) As Long
Declare Function cCVS Lib "t2win-32.dll" (Value As String) As Single
Declare Function cMKB Lib "t2win-32.dll" (ByVal Value As Byte) As String
Declare Function cMKC Lib "t2win-32.dll" (ByVal Value As Currency) As String
Declare Function cMKD Lib "t2win-32.dll" (ByVal Value As Double) As String
Declare Function cMKI Lib "t2win-32.dll" (ByVal Value As Integer) As String
Declare Function cMKL Lib "t2win-32.dll" (ByVal Value As Long) As String
Declare Function cMKN Lib "t2win-32.dll" (ByVal Value As String) As String
Declare Function cMKS Lib "t2win-32.dll" (ByVal Value As Single) As String

' disk array

'  structure for disk array
Type tagDISKARRAY
   daSize            As Integer           'size of the type'd
   signature         As String * 7        'signature
   nFilename         As String * 128      'name of the file
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Long              'returned handle for use with other functions
   rElementSize      As Long              'returned size of a element
   rFileSize         As Long              'returned size of the file
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset1          As Long              'returned offset 1
   rOffset2          As Long              'returned offset 2
   rTime             As Long              'time for the last correct transaction
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 7        'reserved for future use
End Type

'  definition for variable type in DISK ARRAY
Public Const DA_TYPE = 0
Public Const DA_BYTE = -1
Public Const DA_INTEGER = -2
Public Const DA_LONG = -3
Public Const DA_SINGLE = -4
Public Const DA_DOUBLE = -5
Public Const DA_CURRENCY = -6

'  definition for error type in DISK ARRAY
Public Const DA_NO_ERROR = True
Public Const DA_EMPTY_FILENAME = 1
Public Const DA_BAD_FILENAME = 2
Public Const DA_CAN_KILL_FILE = 3
Public Const DA_CAN_NOT_OPEN_FILE = 4
Public Const DA_FILE_NOT_FOUND = 5
Public Const DA_BAD_TYPE = 6
Public Const DA_BAD_ROWS = 7
Public Const DA_BAD_COLS = 8
Public Const DA_BAD_SHEETS = 9
Public Const DA_CAN_NOT_WRITE_HEADER = 10
Public Const DA_CAN_NOT_WRITE_PART = 11
Public Const DA_CAN_NOT_WRITE_REMAIN = 12
Public Const DA_CAN_NOT_READ_HEADER = 13
Public Const DA_HEADER_SIZE = 14
Public Const DA_BAD_SIGNATURE = 15
Public Const DA_FILE_SIZE_MISMATCH = 16
Public Const DA_CAN_NOT_SEEK = 17
Public Const DA_INVALID_HANDLE = 18
Public Const DA_CAN_NOT_READ_PART = 19
Public Const DA_CAN_NOT_READ_REMAIN = 20

Declare Function cDAClear Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY) As Integer
Declare Function cDAClearCol Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearRow Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cDAClearSheet Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cDAClose Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cDACreate Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cDAGet Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cDAGetType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDAPut Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cDAPutType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cDArGet Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArGetType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cDArPut Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cDArPutType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cDAsClearCol Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Col As Long) As Integer
Declare Function cDAsClearRow Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cDAsGet Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsGetType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cDAsPut Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cDAsPutType Lib "t2win-32.dll" (DISKARRAY As tagDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)

' huge memory array

'  structure for huge memory array
Type tagHMA
   daSize            As Integer           'size of the type'd
   nType             As Integer           'variable type
   nRows             As Long              'number of rows
   nCols             As Long              'number of cols
   nSheets           As Long              'number of sheets
   rHandle           As Long              'returned handle for use with other functions
   rElementSize      As Long              'returned size of a element
   rMemorySize       As Long              'returned size of the memory used
   rParts            As Long              'returned total part
   rRemain           As Long              'returned size of the remain part
   rSheetSize        As Long              'size of a sheet
   rOffset           As Long              'returned offset
   nIsTyped          As Integer           'is nType a type'd variable
   Dummy             As String * 20       'reserved for future use
End Type

'  definition for variable type in HUGE MEMORY ARRAY
Public Const HMA_TYPE = 0
Public Const HMA_BYTE = -1
Public Const HMA_INTEGER = -2
Public Const HMA_LONG = -3
Public Const HMA_SINGLE = -4
Public Const HMA_DOUBLE = -5
Public Const HMA_CURRENCY = -6

'  definition for error type in HUGE MEMORY ARRAY
Public Const HMA_NO_ERROR = True
Public Const HMA_NO_MEMORY = 1
Public Const HMA_BAD_TYPE = 2
Public Const HMA_BAD_ROWS = 3
Public Const HMA_BAD_COLS = 4
Public Const HMA_BAD_SHEETS = 5
Public Const HMA_INVALID_HANDLE = 6

Declare Function cHMAClear Lib "t2win-32.dll" (HMA As tagHMA) As Integer
Declare Function cHMAClearCol Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearRow Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cHMAClearSheet Lib "t2win-32.dll" (HMA As tagHMA, ByVal sheet As Long) As Integer
Declare Function cHMACreate Lib "t2win-32.dll" (HMA As tagHMA) As Integer
Declare Function cHMAFree Lib "t2win-32.dll" (HMA As tagHMA) As Integer
Declare Function cHMAGet Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cHMAGetType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMAPut Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cHMAPutType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cHMArGet Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArGetType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMArPut Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long, Var As Variant)
Declare Sub cHMArPutType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long, nType As Any)
Declare Sub cHMAsGet Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsGetType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cHMAsPut Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cHMAsPutType Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Function cHMAsClearCol Lib "t2win-32.dll" (HMA As tagHMA, ByVal Col As Long) As Integer
Declare Function cHMAsClearRow Lib "t2win-32.dll" (HMA As tagHMA, ByVal Row As Long) As Integer
Declare Function cHMAOnDisk Lib "t2win-32.dll" (HMA As tagHMA, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long

'  structure for multiple disk array
Type tagMULTIPLEDISKARRAY
   daSize               As Integer        'size of the structure
   signature            As String * 7     'signature
   nFilename            As String * 128   'name of the file
   nType(1 To 20)       As Integer        'standard variable type (for 20 arrays)
   nIsTyped(1 To 20)    As Integer        'is a type'd (for 20 arrays)
   nRows(1 To 20)       As Long           'number of rows (for 20 arrays)
   nCols(1 To 20)       As Long           'number of cols (for 20 arrays)
   nSheets(1 To 20)     As Long           'number of sheets (for 20 arrays)
   rHandle              As Long           'returned handle for use with other functions
   rFileSize            As Long           'returned size of the file
   rElementSz(1 To 20)  As Long           'returned size of a element (for 20 arrays)
   rSheetSz(1 To 20)    As Long           'size of a sheet (for 20 arrays)
   rOffsetPos(1 To 20)  As Long           'position of each array in the sFile (for 20 arrays)
   rOffset1             As Long           'returned offset 1
   rOffset2             As Long           'returned offset 2
   rTime                As Long           'time for the last correct transaction
   Dummy                As String * 28    'reserved for future use
End Type

'  definition for variable type in HUGE MEMORY ARRAY
Public Const MDA_TYPE = 0
Public Const MDA_BYTE = -1
Public Const MDA_INTEGER = -2
Public Const MDA_LONG = -3
Public Const MDA_SINGLE = -4
Public Const MDA_DOUBLE = -5
Public Const MDA_CURRENCY = -6

'  definition for error type in MULTIPLE DISK ARRAY
Public Const MDA_NO_ERROR = -1
Public Const MDA_EMPTY_FileName = 1
Public Const MDA_BAD_FileName = 2
Public Const MDA_CAN_KILL_FILE = 3
Public Const MDA_CAN_NOT_OPEN_FILE = 4
Public Const MDA_FILE_NOT_FOUND = 5
Public Const MDA_BAD_TYPE = 6
Public Const MDA_BAD_ROWS = 7
Public Const MDA_BAD_COLS = 8
Public Const MDA_BAD_SHEETS = 9
Public Const MDA_CAN_NOT_WRITE_HEADER = 10
Public Const MDA_CAN_NOT_WRITE_PART = 11
Public Const MDA_CAN_NOT_WRITE_REMAIN = 12
Public Const MDA_CAN_NOT_READ_HEADER = 13
Public Const MDA_HEADER_SIZE = 14
Public Const MDA_BAD_SIGNATURE = 15
Public Const MDA_FILE_SIZE_MISMATCH = 16
Public Const MDA_CAN_NOT_SEEK = 17
Public Const MDA_INVALID_HANDLE = 18
Public Const MDA_CAN_NOT_READ_PART = 19
Public Const MDA_CAN_NOT_READ_REMAIN = 20
Public Const MDA_BAD_MULTIPLE_ARRAY = 21

Declare Function cMDAClear Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY) As Integer
Declare Function cMDAClearCol Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearRow Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal sheet As Long) As Integer
Declare Function cMDAClearSheet Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal sheet As Long) As Integer
Declare Sub cMDAClose Lib "t2win-32.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal DeleteFile As Integer)
Declare Function cMDACreate Lib "t2win-32.dll" (MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal CreateOrUse As Integer) As Integer
Declare Function cMDAGet Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long) As Variant
Declare Sub cMDAGetType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDAPut Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, Var As Variant)
Declare Sub cMDAPutType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, ByVal sheet As Long, nType As Any)
Declare Sub cMDArGet Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArGetType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Sub cMDArPut Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, Var As Variant)
Declare Sub cMDArPutType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long, nType As Any)
Declare Function cMDAsClearCol Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Col As Long) As Integer
Declare Function cMDAsClearRow Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long) As Integer
Declare Sub cMDAsGet Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsGetType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)
Declare Sub cMDAsPut Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, Var As Variant)
Declare Sub cMDAsPutType Lib "t2win-32.dll" (ByVal array As Integer, MULTIPLEDISKARRAY As tagMULTIPLEDISKARRAY, ByVal Row As Long, ByVal Col As Long, nType As Any)

' serialization

'  structure for serialization
Type tagSERIALDATA
   Description1      As String * 52       'serialization description 1
   Description2      As String * 52       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 52       'reserved for future use
End Type

'  definition for error type in SERIAL DATA
Public Const SD_SERIAL_NOT_FOUND = 1
Public Const SD_CAN_NOT_OPEN_FILE = 2

Declare Function cIsSerial Lib "t2win-32.dll" (ByVal sFile As String) As Integer
Declare Function cSerialGet Lib "t2win-32.dll" (ByVal sFile As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "t2win-32.dll" (ByVal sFile As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "t2win-32.dll" (ByVal sFile As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "t2win-32.dll" (ByVal sFile As String) As Integer

' language control

'  definition for properties for language management
Public Const RS_CAPTION = 1
Public Const RS_TEXT = 2
Public Const RS_DATAFIELD = 4
Public Const RS_DATASOURCE = 8
Public Const RS_TAG = 16
Public Const RS_MENU = 32
Public Const RS_ALL = 255

Declare Function cReadCtlLanguage Lib "t2win-32.dll" (ByVal Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cReadCtlLanguageExt Lib "t2win-32.dll" (ByVal Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cSaveCtlLanguage Lib "t2win-32.dll" (ByVal Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer
Declare Function cSaveCtlLanguageExt Lib "t2win-32.dll" (ByVal Frm As Form, ByVal Property As Integer, ByVal FileLanguage As String) As Integer

' interest rate
Declare Function cAtoF Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cAtoFC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cAtoP Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cAtoPC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cFtoA Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cFtoAC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cFtoP Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cFtoPC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cPtoA Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cPtoAC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double
Declare Function cPtoF Lib "t2win-32.dll" (ByVal Interest As Double, ByVal n As Integer) As Double
Declare Function cPtoFC Lib "t2win-32.dll" (ByVal Rates As Double, ByVal n As Integer) As Double

' matrix

'  definition for matrix fill
Public Const MATRIX_ZERO = 0
Public Const MATRIX_UNIT = 1

Declare Sub cMatrixAdd Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixCoFactor Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Function cMatrixCompare Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixCopy Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)
Declare Function cMatrixDet Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double) As Double
Declare Function cMatrixFill Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal nInit As Integer) As Integer
Declare Function cMatrixInv Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Function cMatrixMinor Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ByVal Row As Integer, ByVal Col As Integer) As Double
Declare Sub cMatrixMul Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Sub cMatrixSub Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayB() As Double, ArrayC() As Double)
Declare Function cMatrixSymToeplitz Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double) As Integer
Declare Sub cMatrixTranspose Lib "t2win-32.dll" (ByVal Size As Integer, ArrayA() As Double, ArrayC() As Double)

' is

Declare Function cIsAlnum Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsAlpha Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsAscii Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsBalance Lib "t2win-32.dll" (ByVal nHour As Long, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsCsym Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsCsymf Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsDate Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cIsDigit Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsFileArchive Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileEmpty Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileFlag Lib "t2win-32.dll" (ByVal nFilename As String, ByVal nStatus As Integer) As Integer
Declare Function cIsFileHidden Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileNormal Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileReadOnly Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSubDir Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileSystem Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFileCompressed Lib "t2win-32.dll" (ByVal nFilename As String) As Integer
Declare Function cIsFormEnabled Lib "t2win-32.dll" (ByVal hWnd As Long) As Integer
Declare Function cIsHour Lib "t2win-32.dll" (ByVal nHour As Integer, ByVal nMinute As Integer, ByVal nSecond As Integer) As Integer
Declare Function cIsISBN Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsLeapYear Lib "t2win-32.dll" (ByVal nYear As Integer) As Integer
Declare Function cIsLower Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsPalindrome Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsPunct Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsSpace Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsUpper Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cIsXdigit Lib "t2win-32.dll" (Txt As String) As Integer

' encrypt/decrypt

'  definition for encrypt/decrypt
Public Const ENCRYPT_LEVEL_0 = 0
Public Const ENCRYPT_LEVEL_1 = 1
Public Const ENCRYPT_LEVEL_2 = 2
Public Const ENCRYPT_LEVEL_3 = 3
Public Const ENCRYPT_LEVEL_4 = 4

Declare Function cDecrypt Lib "t2win-32.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cEncrypt Lib "t2win-32.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cFileDecrypt Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long
Declare Function cFileEncrypt Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long

' hicrypt

Declare Function cCrypt Lib "t2win-32.dll" (Txt As String, ByVal Password As String) As String
Declare Function cFileCrypt Lib "t2win-32.dll" (ByVal File1 As String, ByVal File2 As String, ByVal Password As String) As Long

' crc32

'  definition for crc32
Public Const OPEN_MODE_BINARY = 0
Public Const OPEN_MODE_TEXT = 1

Declare Function cFileCRC32 Lib "t2win-32.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cStringCRC32 Lib "t2win-32.dll" (Txt As String) As Long

' string

'  definition for error type for PATTERNMATCHEXT
Public Const MATCH_HEXA = 17
Public Const MATCH_INTERNAL_ERROR = 16
Public Const MATCH_PATTERN = 15
Public Const MATCH_LITERAL = 14
Public Const MATCH_RANGE = 13
Public Const MATCH_ABORT = 12
Public Const MATCH_END = 11
Public Const MATCH_VALID = -1

Public Const PATTERN_VALID = 0
Public Const PATTERN_INVALID = 1
Public Const PATTERN_ESC = 2
Public Const PATTERN_RANGE = 3
Public Const PATTERN_CLOSE = 4
Public Const PATTERN_EMPTY = 5
Public Const PATTERN_INTERNAL_ERROR = 6
Public Const PATTERN_HEXA = 7

' definition for PROPERNAME2
Public Const PN_UPPERCASE = 1
Public Const PN_PUNCTUATION = 2
Public Const PN_KEEP_ORIGINAL = 4
Public Const PN_ONLY_LEADER_SPACE = 8

Declare Function cAddDigit Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cAlign Lib "t2win-32.dll" (Txt As String, ByVal TypeAlign As Integer, ByVal NewLength As Long) As String
Declare Function cAndToken Lib "t2win-32.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cAndTokenIn Lib "t2win-32.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cArabicToRoman Lib "t2win-32.dll" (Var As Variant) As String
Declare Function cBlockCharFromLeft Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Function cBlockCharFromRight Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Sub cChangeChars Lib "t2win-32.dll" (Txt As String, CharSet As String, NewCharSet As String)
Declare Sub cChangeCharsUntil Lib "t2win-32.dll" (Txt As String, CharSet As String, NewCharSet As String, nUntil As String)
Declare Function cCheckChars Lib "t2win-32.dll" (Txt As String, CharSet As String) As Integer
Declare Function cCheckNumericity Lib "t2win-32.dll" (Txt As String) As Integer
Declare Sub cCnvASCIItoEBCDIC Lib "t2win-32.dll" (Txt As String)
Declare Sub cCnvEBCDICtoASCII Lib "t2win-32.dll" (Txt As String)
Declare Function cCompact Lib "t2win-32.dll" (Txt As String) As String
Declare Function cCompress Lib "t2win-32.dll" (Txt As String) As String
Declare Function cCompressTab Lib "t2win-32.dll" (Txt As String, ByVal nTab As Long) As String
Declare Function cCount Lib "t2win-32.dll" (Txt As String, Separator As String) As Integer
Declare Function cCplAlpha Lib "t2win-32.dll" (Txt As String) As String
Declare Function cCplDigit Lib "t2win-32.dll" (Txt As String) As String
Declare Function cCreateAndFill Lib "t2win-32.dll" (ByVal Length As Long, Txt As String) As String
Declare Function cExpandTab Lib "t2win-32.dll" (Txt As String, ByVal nTab As Long) As String
Declare Sub cFill Lib "t2win-32.dll" (Txt As String, Fill As String)
Declare Function cFilterBlocks Lib "t2win-32.dll" (Txt As String, Delimitor As String) As String
Declare Function cFilterChars Lib "t2win-32.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterFirstChars Lib "t2win-32.dll" (Txt As String, CharSet As String) As String
Declare Function cFilterNotChars Lib "t2win-32.dll" (Txt As String, CharSet As String) As String
Declare Function cFromHexa Lib "t2win-32.dll" (Text As String) As String
Declare Function cGet Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Function cGetBlock Lib "t2win-32.dll" (Txt As String, ByVal Position As Long, ByVal Length As Long) As String
Declare Function cGetIn Lib "t2win-32.dll" (Txt As String, Separator As String, ByVal Position As Long) As String
Declare Function cGetInPart Lib "t2win-32.dll" (Txt As String, Separator As String, ByVal Position As Long) As String
Declare Function cGetInPartR Lib "t2win-32.dll" (Txt As String, Separator As String, ByVal Position As Long) As String
Declare Function cGetInR Lib "t2win-32.dll" (Txt As String, Separator As String, ByVal Position As Long) As String
Declare Function cH2I Lib "t2win-32.dll" (ByVal Txt As String) As Integer
Declare Function cH2L Lib "t2win-32.dll" (ByVal Txt As String) As Long
Declare Function cInsertBlocks Lib "t2win-32.dll" (Txt As String, Insert As String) As String
Declare Function cInsertBlocksBy Lib "t2win-32.dll" (Txt As String, Insert As String, Delimitor As String) As String
Declare Function cInsertByMask Lib "t2win-32.dll" (Txt As String, Mask As String, Insert As String) As String
Declare Function cInsertChars Lib "t2win-32.dll" (Txt As String, ByVal Position As Long, Insert As String) As String
Declare Function cLrc Lib "t2win-32.dll" (Txt As String) As String
Declare Function cMixChars Lib "t2win-32.dll" (Txt As String) As String
Declare Function cMorse Lib "t2win-32.dll" (ByVal morse As String) As String
Declare Function cNumDigit Lib "t2win-32.dll" (Txt As String) As Integer
Declare Function cOneCharFromLeft Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Function cOneCharFromRight Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Function cOrToken Lib "t2win-32.dll" (ByVal Txt As String, ByVal Token As String) As Integer
Declare Function cOrTokenIn Lib "t2win-32.dll" (ByVal Txt As String, ByVal Token As String, ByVal Separator As String) As Integer
Declare Function cPatternMatch Lib "t2win-32.dll" (ByVal Txt As String, ByVal pattern As String) As Integer
Declare Function cPatternExtMatch Lib "t2win-32.dll" (ByVal Txt As String, ByVal pattern As String) As Integer
Declare Function cProperName Lib "t2win-32.dll" (Txt As String) As String
Declare Function cProperName2 Lib "t2win-32.dll" (Txt As String, ByVal TokenToUse As String, ByVal Options As Integer) As String
Declare Function cRemoveBlockChar Lib "t2win-32.dll" (Txt As String, ByVal Position As Long, ByVal Length As Long) As String
Declare Function cRemoveOneChar Lib "t2win-32.dll" (Txt As String, ByVal Position As Long) As String
Declare Function cResizeString Lib "t2win-32.dll" (Txt As String, ByVal NewLength As Long) As String
Declare Function cResizeStringAndFill Lib "t2win-32.dll" (Txt As String, ByVal NewLength As Long, Fill As String) As String
Declare Function cReverse Lib "t2win-32.dll" (Txt As String) As String
Declare Function cReverseSortStr Lib "t2win-32.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Function cRomanToArabic Lib "t2win-32.dll" (Txt As String) As Variant
Declare Function cScrollL Lib "t2win-32.dll" (Txt As String) As String
Declare Function cScrollR Lib "t2win-32.dll" (Txt As String) As String
Declare Sub cSetDefaultSeparator Lib "t2win-32.dll" (Separator As String)
Declare Function cSortStr Lib "t2win-32.dll" (Txt As String, ByVal nItem As Integer, ByVal ItemLength As Integer) As Integer
Declare Function cStringSAR Lib "t2win-32.dll" (ByVal Txt As String, ByVal Search As String, ByVal Replace As String, ByVal Sensitivity As Integer) As String
Declare Function cToHexa Lib "t2win-32.dll" (Text As String) As String
Declare Function cTokenIn Lib "t2win-32.dll" (Txt As String, Separator As String, ByVal Position As Integer) As String
Declare Function cUncompact Lib "t2win-32.dll" (Txt As String) As String
 
' random

Declare Sub cRndInit Lib "t2win-32.dll" (ByVal nRnd As Long)
Declare Function cRnd Lib "t2win-32.dll" () As Double
Declare Function cRndD Lib "t2win-32.dll" () As Double
Declare Function cRndI Lib "t2win-32.dll" () As Integer
Declare Function cRndL Lib "t2win-32.dll" () As Long
Declare Function cRndS Lib "t2win-32.dll" () As Single

' swap

Declare Sub cSwapB Lib "t2win-32.dll" (swap1 As Byte, swap2 As Byte)
Declare Sub cSwapD Lib "t2win-32.dll" (swap1 As Double, swap2 As Double)
Declare Sub cSwapI Lib "t2win-32.dll" (swap1 As Integer, swap2 As Integer)
Declare Sub cSwapL Lib "t2win-32.dll" (swap1 As Long, swap2 As Long)
Declare Sub cSwapS Lib "t2win-32.dll" (swap1 As Single, swap2 As Single)
Declare Sub cSwapStr Lib "t2win-32.dll" (swap1 As String, swap2 As String)

' type

Declare Function cCompareTypeString Lib "t2win-32.dll" Alias "cTypesCompare" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer) As Integer
Declare Function cCompareStringType Lib "t2win-32.dll" Alias "cTypesCompare" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer) As Integer
Declare Sub cStringToType Lib "t2win-32.dll" Alias "cTypesCopy" (ByVal Src As String, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Sub cTypeClear Lib "t2win-32.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeMid Lib "t2win-32.dll" (TypeSrc As Any, ByVal offset As Integer, ByVal Length As Integer) As String
Declare Function cTypesCompare Lib "t2win-32.dll" (Type1 As Any, Type2 As Any, ByVal lenType1 As Integer) As Integer
Declare Sub cTypesCopy Lib "t2win-32.dll" (TypeSrc As Any, TypeDst As Any, ByVal lenTypeSrc As Integer)
Declare Function cTypeTransfert Lib "t2win-32.dll" (TypeSrc As Any, ByVal lenTypeSrc As Integer) As String
Declare Sub cTypeToString Lib "t2win-32.dll" Alias "cTypesCopy" (TypeSrc As Any, ByVal Dst As String, ByVal lenTypeSrc As Integer)

' miscelleanous

Declare Function cMax Lib "t2win-32.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Function cMin Lib "t2win-32.dll" (Var1 As Variant, Var2 As Variant) As Variant
Declare Sub cIncrI Lib "t2win-32.dll" (Value As Integer)
Declare Sub cIncrL Lib "t2win-32.dll" (Value As Long)
Declare Sub cDecrI Lib "t2win-32.dll" (Value As Integer)
Declare Sub cDecrL Lib "t2win-32.dll" (Value As Long)
Declare Function cSpellMoney Lib "t2win-32.dll" (ByVal Value As Double, ByVal Units As String, ByVal Cents As String) As String
Declare Function cFraction Lib "t2win-32.dll" (ByVal nValue As Double, nNumerator As Double, nDenominator As Double) As Double
Declare Function cCombination Lib "t2win-32.dll" (ByVal nItems As Integer, ByVal mTimes As Integer) As Double
Declare Function cSgn Lib "t2win-32.dll" (ByVal Value As Integer) As Integer
Declare Function cBetween Lib "t2win-32.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cGetPid Lib "t2win-32.dll" () As Integer
Declare Function cBaseConversion Lib "t2win-32.dll" (ByVal Num As String, ByVal RadixIn As Integer, ByVal RadixOut As Integer) As String

' windows

'  definition for win.ini section
Public Const GET_TIME_SEPARATOR = 1
Public Const GET_DATE_SEPARATOR = 2
Public Const GET_TIME_FORMAT = 3
Public Const GET_DATE_FORMAT = 4
Public Const GET_CURRENCY = 5
Public Const GET_LANGUAGE = 6
Public Const GET_COUNTRY = 7
Public Const GET_COUNTRY_CODE = 8
Public Const GET_LIST_SEPARATOR = 9
Public Const GET_DEFAULT_PRINTER = 10

Declare Sub cArrangeDesktopIcons Lib "t2win-32.dll" ()
Declare Sub cCenterWindow Lib "t2win-32.dll" (ByVal hWnd As Long)
Declare Function cEXEnameActiveWindow Lib "t2win-32.dll" () As String
Declare Function cEXEnameWindow Lib "t2win-32.dll" (ByVal hWnd As Long) As String
Declare Function cEXEnameTask Lib "t2win-32.dll" (ByVal nFilename As String) As String
Declare Function cExitWindowsAndExecute Lib "t2win-32.dll" (ByVal lpszExe As String, ByVal lpszParams As String) As Integer
Declare Function cFindFileInEnv Lib "t2win-32.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As Integer
Declare Function cFindFileInPath Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cGetClassName Lib "t2win-32.dll" (ByVal hWnd As Long) As String
Declare Function cGetCountry Lib "t2win-32.dll" () As String
Declare Function cGetCountryCode Lib "t2win-32.dll" () As String
Declare Function cGetCurrency Lib "t2win-32.dll" () As String
Declare Function cGetCurrentDrive Lib "t2win-32.dll" () As String
Declare Function cGetDateFormat Lib "t2win-32.dll" () As String
Declare Function cGetDateSeparator Lib "t2win-32.dll" () As String
Declare Function cGetDefaultCurrentDir Lib "t2win-32.dll" () As String
Declare Function cGetDefaultPrinter Lib "t2win-32.dll" () As String
Declare Function cGetDevices Lib "t2win-32.dll" () As String
Declare Function cGetDriveCurrentDir Lib "t2win-32.dll" (ByVal lpDrive As String) As String
Declare Function cGetFullNameInEnv Lib "t2win-32.dll" (ByVal lpFilename As String, ByVal lpEnv As String) As String
Declare Function cGetFullNameInPath Lib "t2win-32.dll" (ByVal lpFilename As String) As String
Declare Function cGetHourFormat Lib "t2win-32.dll" () As String
Declare Function cGetIni Lib "t2win-32.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String) As String
Declare Function cGetLanguage Lib "t2win-32.dll" () As String
Declare Function cGetListSeparator Lib "t2win-32.dll" () As String
Declare Function cGetSystemDirectory Lib "t2win-32.dll" () As String
Declare Function cGetTimeSeparator Lib "t2win-32.dll" () As String
Declare Function cGetWindowsDirectory Lib "t2win-32.dll" () As String
Declare Function cGetWinINI Lib "t2win-32.dll" (ByVal Info As Integer) As String
Declare Function cGetWinSection Lib "t2win-32.dll" (ByVal Section As String) As String
Declare Sub cPutIni Lib "t2win-32.dll" (ByVal AppName As String, ByVal szItem As String, ByVal szDefault As String, ByVal InitFile As String)
Declare Function cRebootSystem Lib "t2win-32.dll" () As Integer
Declare Function cRestartWindows Lib "t2win-32.dll" () As Integer
Declare Function cSetHandleCount Lib "t2win-32.dll" (ByVal nHandle As Integer) As Integer
Declare Sub cShowWindow Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Method As Integer, ByVal interval As Integer)
Declare Function cGetSectionItems Lib "t2win-32.dll" (ByVal Section As String, ByVal InitFile As String, nItems As Integer) As String
Declare Function cTaskBarAddIcon Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal hIcon As Long, ByVal lpszTip As String) As Integer
Declare Function cTaskBarDeleteIcon Lib "t2win-32.dll" (ByVal hWnd As Long) As Integer
Declare Function cTaskBarModifyIcon Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal hIcon As Long, ByVal lpszTip As String) As Integer

' list/combo box

Public Const DDL_READWRITE = &H0
Public Const DDL_READONLY = &H1
Public Const DDL_HIDDEN = &H2
Public Const DDL_SYSTEM = &H4
Public Const DDL_DIRECTORY = &H10
Public Const DDL_ARCHIVE = &H20
Public Const DDL_POSTMSGS = &H2000
Public Const DDL_DRIVES = &H4000
Public Const DDL_EXCLUSIVE = &H8000

Declare Function cArrayToComboBox Lib "t2win-32.dll" (ByVal hWnd As Long, array() As String) As Integer
Declare Function cArrayToListBox Lib "t2win-32.dll" (ByVal hWnd As Long, array() As String) As Integer
Declare Function cFileToComboBox Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal nFile As String) As Integer
Declare Function cFileToListBox Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal nFile As String) As Integer
Declare Function cListSetTabs Lib "t2win-32.dll" (ByVal hWnd As Long, TabArray() As Long) As Integer
Declare Function cListFiles Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Attributes As Long, ByVal FilePathMaask As String) As Integer
Declare Function cComboFiles Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Attributes As Long, ByVal FilePathMaask As String) As Integer
Declare Function cListSearchFile Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal StartPath As String, ByVal FileMask As String) As Long
Declare Function cComboSearchFile Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal StartPath As String, ByVal FileMask As String) As Long

' mdtkfv

'  definition for sFile version information
Public Const VER_VERSION_PRODUCT = -1
Public Const VER_VERSION_FILE = 0
Public Const VER_COMPANY_NAME = 1
Public Const VER_FILE_DESCRIPTION = 2
Public Const VER_FILE_VERSION = 3
Public Const VER_INTERNAL_NAME = 4
Public Const VER_LEGAL_COPYRIGHT = 5
Public Const VER_LEGAL_TRADEMARKS = 6
Public Const VER_PRODUCT_NAME = 7
Public Const VER_PRODUCT_VERSION = 8

'  structure for sFile version information
Type tagFILEVERSIONINFO
   VersionProduct    As String
   VersionFile       As String
   CompanyName       As String
   FileDescription   As String
   FileVersion       As String
   InternalName      As String
   LegalCopyright    As String
   LegalTrademarks   As String
   Comments          As String
   ProductName       As String
   ProductVersion    As String
End Type

' structure for modules
Type tagMODULEENTRY
   dwSize               As Long
   th32ModuleID         As Long
   th32ProcessID        As Long
   GlblcntUsage         As Long
   ProccntUsage         As Long
   modBaseAddr          As Byte
   modBaseSize          As Long
   hModule              As Long
   szModule             As String * 256
   szExePath            As String * 260
End Type

Type tagPROCESSENTRY
   dwSize               As Long
   cntUsage             As Long
   th32ProcessID        As Long
   th32DefaultHeapID    As Long
   th32ModuleID         As Long
   cntThreads           As Long
   th32ParentProcessID  As Long
   pcPriClassBase       As Long
   dwFlags              As Long
   szExeFile            As String * 260
End Type

Type tagTHREADENTRY
   dwSize               As Long
   cntUsage             As Long
   th32ThreadID         As Long
   th32OwnerProcessID   As Long
   tpBasePri            As Long
   tpDeltaPri           As Long
   dwFlags              As Long
End Type

Declare Sub cChangeTaskName Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Text As String)
Declare Function cGetFileVersion Lib "t2win-32.dll" (ByVal FileName As String, ByVal nFonction As Integer) As String
Declare Function cGetFileVersionInfo Lib "t2win-32.dll" (ByVal FileName As String, FILEVERSIONINFO As Any) As Integer
Declare Function cGetChangeTaskName Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Text As String) As String
Declare Function cGetTaskName Lib "t2win-32.dll" (ByVal hWnd As Long) As String
Declare Function cModule Lib "t2win-32.dll" (MODULEENTRY As tagMODULEENTRY, ByVal FirstNext As Integer) As Integer
Declare Function cProcess Lib "t2win-32.dll" (PROCESSENTRY As tagPROCESSENTRY, ByVal FirstNext As Integer) As Integer
Declare Function cThread Lib "t2win-32.dll" (THREADENTRY As tagTHREADENTRY, ByVal FirstNext As Integer) As Integer
Declare Function cWalkThruWindow Lib "t2win-32.dll" (Class As String, Caption As String, OwnerHwnd As Long, OwnerClass As String, OwnerCaption As String, ByVal FirstNext As Integer) As Long

' date - time

Declare Function cIntoDate Lib "t2win-32.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateFill Lib "t2win-32.dll" (ByVal nDate As Long) As String
Declare Function cIntoDateNull Lib "t2win-32.dll" (ByVal nDate As Long) As String
Declare Function cIntoFixHour Lib "t2win-32.dll" (Var As Variant, ByVal Length As Integer, ByVal fillZero As Integer, ByVal Centime As Integer) As String
Declare Function cIntoHour Lib "t2win-32.dll" (Var As Variant) As String
Declare Function cIntoVarHour Lib "t2win-32.dll" (Var As Variant) As String
Declare Function cDayOfWeek Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer
Declare Function cDayOfYear Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Integer
Declare Function cDaysInMonth Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer) As Integer
Declare Function cDateToScalar Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer) As Long
Declare Sub cScalarToDate Lib "t2win-32.dll" (ByVal Scalar As Long, nYear As Integer, nMonth As Integer, nDay As Integer)
Declare Sub cScalarToTime Lib "t2win-32.dll" (ByVal Scalar As Long, nHour As Integer, nMin As Integer, nSec As Integer)
Declare Function cTimeBetween Lib "t2win-32.dll" (ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cTimeToScalar Lib "t2win-32.dll" (ByVal nHour As Integer, ByVal nMin As Integer, ByVal nSec As Integer) As Long
Declare Function cWeekOfYear Lib "t2win-32.dll" (ByVal nYear As Integer, ByVal nMonth As Integer, ByVal nDay As Integer, ByVal nISO As Integer) As Integer
Declare Function cCurrentTime Lib "t2win-32.dll" () As Integer
Declare Function cAddTime Lib "t2win-32.dll" (ByVal Hr As Integer) As Integer
Declare Function cAddTwoTimes Lib "t2win-32.dll" (ByVal Time1 As String, ByVal Time2 As String) As String
Declare Function cCheckTime Lib "t2win-32.dll" (ByVal Hr As Integer, ByVal Hr1 As Integer, ByVal Hr2 As Integer) As Integer
Declare Function cTrueBetween Lib "t2win-32.dll" (Var As Variant, Var1 As Variant, Var2 As Variant) As Integer
Declare Function cHourTo Lib "t2win-32.dll" (Txt As String) As Variant
Declare Function cIntoBalance Lib "t2win-32.dll" (Var As Variant) As String
Declare Function cIntoBalanceFill Lib "t2win-32.dll" (Var As Variant) As String

' process id

Declare Sub cPushID Lib "t2win-32.dll" (IDArray() As Integer, ByVal nID As Integer)
Declare Sub cPopID Lib "t2win-32.dll" (IDArray() As Integer, ByVal nID As Integer)
Declare Sub cPopLastID Lib "t2win-32.dll" (IDArray() As Integer)
Declare Function cGetID Lib "t2win-32.dll" (IDArray() As Integer, ByVal nPosition As Integer) As Integer
Declare Sub cClearID Lib "t2win-32.dll" (IDArray() As Integer)

' sFile I/O, direct routines issued from C functionnalities

Declare Function cFopen Lib "t2win-32.dll" (ByVal sFile As String, ByVal Mode As String) As Long
Declare Function cFclose Lib "t2win-32.dll" (ByVal IOstream As Long) As Integer
Declare Function cFgetc Lib "t2win-32.dll" (ByVal IOstream As Long) As Integer
Declare Function cFputc Lib "t2win-32.dll" (ByVal char As Integer, ByVal IOstream As Long) As Integer
Declare Function cFputs Lib "t2win-32.dll" (ByVal Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFgets Lib "t2win-32.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFwrite Lib "t2win-32.dll" (Txt As String, ByVal IOstream As Long) As Integer
Declare Function cFread Lib "t2win-32.dll" (Txt As String, ByVal Length As Integer, ByVal IOstream As Long) As Integer
Declare Function cFcloseall Lib "t2win-32.dll" () As Integer
Declare Function cFflush Lib "t2win-32.dll" (ByVal IOstream As Long) As Integer
Declare Function cFflushall Lib "t2win-32.dll" () As Integer
Declare Function cFeof Lib "t2win-32.dll" (ByVal IOstream As Long) As Integer
Declare Function cFerror Lib "t2win-32.dll" (ByVal IOstream As Long) As Integer
Declare Sub cFclearerr Lib "t2win-32.dll" (ByVal IOstream As Long)
Declare Function cFseek Lib "t2win-32.dll" (ByVal IOstream As Long, ByVal offset As Long, ByVal origin As Integer) As Integer
Declare Function cFtell Lib "t2win-32.dll" (ByVal IOstream As Long) As Long
Declare Sub cFrewind Lib "t2win-32.dll" (ByVal IOstream As Long)
Declare Function cFProcessAsciiFile Lib "t2win-32.dll" (ByVal IOstream As Long, AsciiOffset() As Long) As Long
Declare Function cFGotoRecord Lib "t2win-32.dll" (ByVal IOstream As Long, AsciiOffset() As Long, ByVal Record As Long) As Integer

' day - month

'  definition for language in multi-language management
Public Const LNG_FRENCH = 1
Public Const LNG_DUTCH = 2
Public Const LNG_GERMAN = 3
Public Const LNG_ENGLISH = 4
Public Const LNG_ITALIAN = 5
Public Const LNG_SPANISH = 6
Public Const LNG_CATALAN = 7
Public Const LNG_POLISH = 8

Declare Function cGetAscTime Lib "t2win-32.dll" (ByVal nLanguage As Integer) As String
Declare Function cGetLongDay Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetLongMonth Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetShortDay Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetShortMonth Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Function cGetSmallDay Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetTinyDay Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nDay As Integer) As String
Declare Function cGetTinyMonth Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal nMonth As Integer) As String
Declare Sub cSysMenuChange Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal Position As Integer, ByVal NewMessage As String)

' Functions for calculating 2-D geometry

'  structure for 2-D geometry types
Type tagVECTOR2
   x              As Double
   y              As Double
End Type

Declare Sub cV2Add Lib "t2win-32.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Sub Lib "t2win-32.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Combine Lib "t2win-32.dll" (u As tagVECTOR2, ByVal c1 As Double, v As tagVECTOR2, ByVal c2 As Double, w As tagVECTOR2)
Declare Sub cV2Copy Lib "t2win-32.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Function cV2Dot Lib "t2win-32.dll" (u As tagVECTOR2, v As tagVECTOR2) As Double
Declare Function cV2Length Lib "t2win-32.dll" (u As tagVECTOR2) As Double
Declare Function cV2LengthSquared Lib "t2win-32.dll" (u As tagVECTOR2) As Double
Declare Sub cV2LinearIp Lib "t2win-32.dll" (lo As tagVECTOR2, hi As tagVECTOR2, ByVal alpha As Double, w As tagVECTOR2)
Declare Sub cV2Mul Lib "t2win-32.dll" (u As tagVECTOR2, v As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2Neg Lib "t2win-32.dll" (u As tagVECTOR2)
Declare Sub cV2Normalized Lib "t2win-32.dll" (u As tagVECTOR2)
Declare Sub cV2Ortho Lib "t2win-32.dll" (u As tagVECTOR2, w As tagVECTOR2)
Declare Sub cV2ScaledNewLength Lib "t2win-32.dll" (u As tagVECTOR2, ByVal newlen As Double)
Declare Function cV2SegmentLength Lib "t2win-32.dll" (p As tagVECTOR2, q As tagVECTOR2) As Double

' Functions for calculating 3-D geometry

'  structure for 3-D geometry types
Type tagVECTOR3
   x              As Double
   y              As Double
   z              As Double
End Type

Declare Sub cV3Add Lib "t2win-32.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Sub Lib "t2win-32.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Combine Lib "t2win-32.dll" (u As tagVECTOR3, ByVal c1 As Double, v As tagVECTOR3, ByVal c2 As Double, w As tagVECTOR3)
Declare Sub cV3Copy Lib "t2win-32.dll" (u As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Cross Lib "t2win-32.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Function cV3Dot Lib "t2win-32.dll" (u As tagVECTOR3, v As tagVECTOR3) As Double
Declare Function cV3Length Lib "t2win-32.dll" (u As tagVECTOR3) As Double
Declare Function cV3LengthSquared Lib "t2win-32.dll" (u As tagVECTOR3) As Double
Declare Sub cV3LinearIp Lib "t2win-32.dll" (lo As tagVECTOR3, hi As tagVECTOR3, ByVal alpha As Double, w As tagVECTOR3)
Declare Sub cV3Mul Lib "t2win-32.dll" (u As tagVECTOR3, v As tagVECTOR3, w As tagVECTOR3)
Declare Sub cV3Neg Lib "t2win-32.dll" (u As tagVECTOR3)
Declare Sub cV3Normalized Lib "t2win-32.dll" (u As tagVECTOR3)
Declare Sub cV3ScaledNewLength Lib "t2win-32.dll" (u As tagVECTOR3, ByVal newlen As Double)
Declare Function cV3SegmentLength Lib "t2win-32.dll" (p As tagVECTOR3, q As tagVECTOR3) As Double

Declare Function c3DWeightAverage Lib "t2win-32.dll" (ul3D As tagVECTOR3, ll3D As tagVECTOR3, lr3D As tagVECTOR3, ur3D As tagVECTOR3, ptToLocate3D As tagVECTOR3) As Double

' huge string

Declare Function cHugeStrAdd Lib "t2win-32.dll" (ByVal hsHandle As Long, hsText As String) As Integer
Declare Function cHugeStrAddress Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long
Declare Function cHugeStrAppend Lib "t2win-32.dll" (ByVal hsHandle As Long, hsText As String) As Integer
Declare Function cHugeStrBlocks Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long
Declare Function cHugeStrClear Lib "t2win-32.dll" (ByVal hsHandle As Long) As Integer
Declare Function cHugeStrCreate Lib "t2win-32.dll" (ByVal hsSize As Long) As Long
Declare Function cHugeStrFree Lib "t2win-32.dll" (ByVal hsHandle As Long) As Integer
Declare Function cHugeStrGetNP Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long
Declare Function cHugeStrGetWP Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long
Declare Function cHugeStrLength Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long
Declare Function cHugeStrMid Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsStart As Long, ByVal hsLength As Long) As String
Declare Function cHugeStrNext Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsNext As Long) As String
Declare Function cHugeStrOnDisk Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsFile As String, ByVal hsGetPut As Integer) As Long
Declare Function cHugeStrRead Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsBlock As Long) As String
Declare Function cHugeStrSetNP Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSetWP Lib "t2win-32.dll" (ByVal hsHandle As Long, ByVal hsPtr As Long) As Integer
Declare Function cHugeStrSize Lib "t2win-32.dll" (ByVal hsHandle As Long) As Long

' t2win-32 version

Declare Function cGetVersion Lib "t2win-32.dll" () As Single

' protect

Declare Function cHashMD5 Lib "t2win-32.dll" (Text As String) As String
Declare Function cRegistrationKey Lib "t2win-32.dll" (ByVal RegText As String, ByVal RegKey1 As Long) As Long
Declare Function cRegistrationKey2 Lib "t2win-32.dll" (ByVal RegText As String, ByVal RegKey1 As Long, ByVal RegKey2 As Long) As Long
Declare Function cRegistrationKey3 Lib "t2win-32.dll" (ByVal RegText As String, ByVal RegKey1 As Long, ByVal RegKey2 As Long, ByVal RegKey3 As Long) As Long

' media ID - volume

'  structure for get/set Media ID
Type tagMEDIAID
   VolumeName           As String
   VolumeSerialNumber   As Long
   SystemName           As String
   MaxNameLength        As Long
   FileSystemFlags      As Long
End Type

' structure for get/set DOS Media ID
Type tagDOSMEDIAID
   InfoLevel            As String * 2     'use cCVI for integer conversion
   SerialNumber         As String * 4     'use cCVL for long conversion
   VolLabel             As String * 11
   FileSysType          As String * 8
End Type

Declare Function cGetMediaID Lib "t2win-32.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cGetVolumeLabel Lib "t2win-32.dll" (ByVal nDrive As String) As String
Declare Function cSetVolumeLabel Lib "t2win-32.dll" (ByVal nDrive As String, ByVal nVolumeLabel As String) As Integer
Declare Function cDOSGetMediaID Lib "t2win-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer
Declare Function cDOSSetMediaID Lib "t2win-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer

' network

Declare Function cGetNetConnection Lib "t2win-32.dll" (ByVal lpDrive As String, ErrCode As Integer) As String

' multi-language message box - input box

'  definition for message position
Public Const MB_MESSAGE_LEFT = 0
Public Const MB_MESSAGE_CENTER = 8192
Public Const MB_MESSAGE_RIGHT = 16384

'  definition for timeout management
Public Const MB_TIMEOUT_2 = 32768
Public Const MB_TIMEOUT_4 = 2 * MB_TIMEOUT_2
Public Const MB_TIMEOUT_8 = 2 * MB_TIMEOUT_4
Public Const MB_TIMEOUT_16 = 2 * MB_TIMEOUT_8

Public Const MB_TIMEOUT_6 = MB_TIMEOUT_2 Or MB_TIMEOUT_4
Public Const MB_TIMEOUT_10 = MB_TIMEOUT_2 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_12 = MB_TIMEOUT_4 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_14 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8
Public Const MB_TIMEOUT_18 = MB_TIMEOUT_2 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_20 = MB_TIMEOUT_4 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_22 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_24 = MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_26 = MB_TIMEOUT_2 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_28 = MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16
Public Const MB_TIMEOUT_30 = MB_TIMEOUT_2 Or MB_TIMEOUT_4 Or MB_TIMEOUT_8 Or MB_TIMEOUT_16

Public Const MB_DISPLAY_TIMEOUT = 524288

Declare Function cLngMsgBox Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal Title As String) As Integer
Declare Sub cLngBoxMsg Lib "t2win-32.dll" Alias "cLngMsgBox" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Button As Long, ByVal Title As String)
Declare Function cLngInpBox Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal Message As String, ByVal Title As String, ByVal Default As String) As String
Declare Sub cLngSysMenu Lib "t2win-32.dll" (ByVal nLanguage As Integer, ByVal hWnd As Long)

' desktop

Declare Sub cLoadDesktopBackground Lib "t2win-32.dll" (ByVal FileName As String, ByVal Tile As Integer)

' registry

Public Const RK_NO_ERROR = -1
Public Const RK_KEY_IS_EMPTY = 1
Public Const RK_UNABLE_TO_CREATE_KEY = 2
Public Const RK_UNABLE_TO_OPEN_KEY = 3
Public Const RK_UNKNOWN_DISPOSITION = 4
Public Const RK_CANNOT_SET_THE_VALUE = 5
Public Const RK_UNABLE_TO_QUERY_KEY = 6

Declare Function cPutRegistry Lib "t2win-32.dll" (ByVal lpSection As String, ByVal lpKey As String, ByVal lpValue As String) As Integer
Declare Function cGetRegistry Lib "t2win-32.dll" (ByVal lpSection As String, ByVal lpKey As String, ByVal lpDefault As String) As String
Declare Function cKillRegistry Lib "t2win-32.dll" (ByVal lpSection As String, ByVal lpKey As String) As Integer

' bitmap

Public Const DIB_SAVE_WINDOW = True
Public Const DIB_SAVE_CLIENT = False

Type tagRECT
   Left                 As Long
   Top                  As Long
   Right                As Long
   Bottom               As Long
End Type

Declare Function cDIBSaveScreen Lib "t2win-32.dll" (ByVal lpFilename As String) As Integer
Declare Function cDIBSaveWindow Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal SaveArea As Integer, ByVal lpFilename As String) As Integer
Declare Function cShadeRect Lib "t2win-32.dll" (ByVal hDC As Long, lpRect As tagRECT) As Integer
Declare Function cTileBitmapOnWindow Lib "t2win-32.dll" (ByVal hWnd As Long, ByVal lpFilename As String) As Integer

' hook keyboard

Declare Function cInstallHookKeyboard Lib "t2win-32.dll" (ByVal InstallRemove As Integer) As Integer

' printer

Public Const EPJ_SUCCESS = -1
Public Const EPJ_PRINTER_NAME_EMPTY = 1
Public Const EPJ_CANT_OPEN_PRINTER = 2
Public Const EPJ_STRANGE_ERROR = 3
Public Const EPJ_CANT_ENUMERATE_MORE_JOBS = 4

Public Const JOB_STATUS_PAUSED = &H1
Public Const JOB_STATUS_ERROR = &H2
Public Const JOB_STATUS_DELETING = &H4
Public Const JOB_STATUS_SPOOLING = &H8
Public Const JOB_STATUS_PRINTING = &H10
Public Const JOB_STATUS_OFFLINE = &H20
Public Const JOB_STATUS_PAPEROUT = &H40
Public Const JOB_STATUS_PRINTED = &H80
Public Const JOB_STATUS_DELETED = &H100
Public Const JOB_STATUS_BLOCKED_DEVQ = &H200
Public Const JOB_STATUS_USER_INTERVENTION = &H400

Type tagJOBINFO
   sPrinterName         As String      'name of the printer for which the job is spooled
   sMachineName         As String      'name of the machine that created the print job
   sUserName            As String      'name of the user who owns the print job
   sDocument            As String      'name of the print job (for example, "MS-WORD: Review.doc")
   lJobId               As Long        'job identifier value
   lStatus              As Long        'job status (multiple OR of JOB_STATUS_x)
   lPriority            As Long        'job priority (1 : minimum; 99 : maximum)
   lPosition            As Long        'job's position in the print queue
   lStartTime           As Long        'earliest time that the job can be printed
   lUntilTime           As Long        'latest time that the job can be printed
   lTotalPages          As Long        'number of pages required for the job
   lSize                As Long        'size, in bytes, of the job
   lTime                As Long        'total time, in seconds, that has elapsed since the job began printing
   lPagesPrinted        As Long        'number of pages that have printed
   wYear                As Integer     'year of the job submitted
   wMonth               As Integer     'month of the job submitted
   wDay                 As Integer     'day of the job submitted
   wHour                As Integer     'hour of the job submitted
   wMinute              As Integer     'minute of the job submitted
   wSecond              As Integer     'second of the job submitted
End Type

Declare Function cEnumPrinterJobs Lib "t2win-32.dll" (ByVal PrinterName As String, JOBINFO As tagJOBINFO, ByVal FirstNext As Integer) As Integer

'Declare Function cFormatFloppyDisk Lib "t2win-32.dll" () As Integer

' open files

Public Const ENUMERATE_ALL_OPEN_FILES = True
Public Const ENUMERATE_ONLY_OPEN_UNMOVABLE_FILES = False

Public Const NO_ERROR_OPEN_FILES = True
Public Const NO_MORE_OPEN_FILES = 0
Public Const ERROR_LOCK_LOGICAL_VOLUME = 1
Public Const ERROR_ENUMERATE_OPEN_FILES = 2
Public Const ERROR_UNLOCK_LOGICAL_VOLUME = 3

Declare Function cEnumOpenFiles Lib "t2win-32.dll" (ByVal nDrive As String, ByVal EnumType As Integer, ByVal FirstNext As Integer, OpenFileName As String, OpenFileMode As Long, OpenFileType As Long) As Integer

