unit Settings;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, ExtCtrls, Slider, MMPlot;

type
  TSettingsDlg = class(TForm)
    Notebook: TTabbedNotebook;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Slider: TSlider;
    Panel1: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Panel2: TPanel;
    PanelBkGnd: TPanel;
    ColorDialog: TColorDialog;
    Panel6: TPanel;
    StdBtn: TBitBtn;
    Bevel3: TBevel;
    cbSaveSet: TCheckBox;
    cbShowTB: TCheckBox;
    cbShowNAV: TCheckBox;
    cbAutoStretch: TCheckBox;
    lbPorts: TListBox;
    ScanBtn: TBitBtn;
    cbSendComm: TCheckBox;
    Panel9: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    DLLName: TLabel;
    Registeredfor: TLabel;
    DLLCopyright: TLabel;
    DLLVersion: TLabel;
    Label14: TLabel;
    Komment: TLabel;
    Bevel2: TBevel;
    Bevel1: TBevel;
    Label12: TLabel;
    Label13: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    cboBaud: TComboBox;
    cboParity: TComboBox;
    cboStop: TComboBox;
    cboData: TComboBox;
    cboFlow: TComboBox;
    Destination: TEdit;
    procedure PanelEnter(Sender: TObject);
    procedure PanelExit(Sender: TObject);
    procedure PanelClick(Sender: TObject);
    procedure PanelDblClick(Sender: TObject);
    procedure SliderValueChange(Sender: TObject);
    procedure StdBtnClick(Sender: TObject);
    procedure NotebookChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ScanBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cbSendCommClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    Panel: TPanel;
    procedure InitPortPage;
    procedure GetPorts;
    procedure GetAbout;
    procedure GetPens;
    procedure SetPort;
    procedure SetPens;
    procedure SetDesktop;
    procedure GetDesktop;
  public
    { Public declarations }
    procedure SetPanels(Value: TStdColors);
    function  GetPanels: TStdColors;
  end;

var
  SettingsDlg: TSettingsDlg;

implementation

{$R *.DFM}
uses Main;

procedure TSettingsDlg.SetPanels(Value: TStdColors);
begin
  Panel1.Color := Value[1];
  Panel2.Color := Value[2];
  Panel3.Color := Value[3];
  Panel4.Color := Value[4];
  Panel5.Color := Value[5];
  Panel6.Color := Value[6];
  Panel7.Color := Value[7];
  Panel8.Color := Value[8];
end;

function TSettingsDlg.GetPanels: TStdColors;
begin
  Result[1] := Panel1.Color;
  Result[2] := Panel2.Color;
  Result[3] := Panel3.Color;
  Result[4] := Panel4.Color;
  Result[5] := Panel5.Color;
  Result[6] := Panel6.Color;
  Result[7] := Panel7.Color;
  Result[8] := Panel8.Color;
end;

procedure TSettingsDlg.PanelEnter(Sender: TObject);
begin
  TObject(Panel) := Sender;
  Panel.borderstyle := bssingle;
end;

procedure TSettingsDlg.PanelExit(Sender: TObject);
begin
  Panel.borderstyle := bsnone;
end;

procedure TSettingsDlg.PanelClick(Sender: TObject);
begin
  TPanel(Sender).SetFocus;
end;

procedure TSettingsDlg.PanelDblClick(Sender: TObject);
begin
  Colordialog.Color := TPanel(Sender).Color;
  if Colordialog.Execute then
    TPanel(Sender).Color := Colordialog.Color;
end;

procedure TSettingsDlg.SliderValueChange(Sender: TObject);
begin
  Slider.Trackwidth := Slider.Value+2;
end;

procedure TSettingsDlg.StdBtnClick(Sender: TObject);
begin
  Case Notebook.Pageindex of
  0: begin
      SetPanels(stdcolors);
      PanelBkGnd.Color := clBtnFace;
      Slider.Value := 1;
    end;
  1: begin
      cbSaveSet.checked := true;
      cbShowTB.checked := true;
      cbShowNAV.checked := true;
      cbAutoStretch.checked := true;
    end;
  2: begin
    end;
  end;
end;

procedure TSettingsDlg.NotebookChange(Sender: TObject;
  NewTab: Integer; var AllowChange: Boolean);
begin
  StdBtn.Visible := NewTab = 0;
  AllowChange := true;
end;

procedure TSettingsDlg.FormCreate(Sender: TObject);
begin
  InitPortPage;
  GetPens;
end;

procedure TSettingsDlg.GetPorts;
begin
  lbPorts.Items.Clear;
  lbPorts.Items.Insert(0,'(none)');
  MainForm.MMPlot1.GetPortsAvail(false,lbPorts.Items);
  lbPorts.Itemindex := 0;
end;

procedure TSettingsDlg.SetPort;
begin
  MainForm.MMPlot1.PortName := lbPorts.Items[lbPorts.ItemIndex];
  MainForm.MMPlot1.DirecttoPort := cbsendcomm.checked;
  If not cbsendcomm.checked then
    MainForm.MMPlot1.Destination := destination.text;
end;

procedure TSettingsDlg.SetPens;
begin
  MainForm.MMPlot1.PenColors := GetPanels;
  MainForm.Color := PanelBkGnd.Color;
  MainForm.PaintBox1.Canvas.Pen.Width := Slider.Value;
end;

procedure TSettingsDlg.SetDesktop;
begin
  MainForm.DragPanel.visible := cbShowNav.Checked;
  MainForm.Speedbar.visible  := cbShowTB.Checked;
  MainForm.Autostretch := cbAutoStretch.Checked;
end;

procedure TSettingsDlg.GetAbout;
begin
  Version.Caption := 'Rev.'+MainForm.MMPLot1.Version;
  DLLVersion.Caption := 'Rev.'+MMPlot.GetDLLVersion;
End;

procedure TSettingsDlg.GetPens;
begin
  SetPanels(MainForm.MMPlot1.PenColors);
  PanelBkGnd.Color := MainForm.Color;
  Slider.Value := MainForm.PaintBox1.Canvas.Pen.Width;
End;

procedure TSettingsDlg.GetDesktop;
begin
  cbShowNav.Checked := MainForm.DragPanel.visible;
  cbShowTB.Checked := MainForm.Speedbar.visible;
  cbAutoStretch.Checked := MainForm.Autostretch;
end;

procedure TSettingsDlg.InitPortPage;
begin
  GetPorts;
  cboBaud.Items.Add('110');
  cboBaud.Items.Add('300');
  cboBaud.Items.Add('600');
  cboBaud.Items.Add('1200');
  cboBaud.Items.Add('2400');
  cboBaud.Items.Add('4800');
  cboBaud.Items.Add('9600');
  cboBaud.Items.Add('14400');
  cboBaud.Items.Add('19200');
  cboBaud.Items.Add('38400');
  cboBaud.Items.Add('56000');
  cboBaud.Items.Add('128000');
  cboBaud.Items.Add('256000');

  cboData.Items.Add('4');
  cboData.Items.Add('5');
  cboData.Items.Add('6');
  cboData.Items.Add('7');
  cboData.Items.Add('8');

  cboParity.Items.Add('None');
  cboParity.Items.Add('Odd');
  cboParity.Items.Add('Even');
  cboParity.Items.Add('Mark');
  cboParity.Items.Add('Space');

  cboStop.Items.Add('1');
  cboStop.Items.Add('1.5');
  cboStop.Items.Add('2');

  cboFlow.Items.Add('None');
  cboFlow.Items.Add('RTS/CTS');
  cboFlow.Items.Add('XON/XOFF');
end;


procedure TSettingsDlg.OKBtnClick(Sender: TObject);
begin
  SetPort;
  SetPens;
  SetDesktop;
end;

procedure TSettingsDlg.ScanBtnClick(Sender: TObject);
begin
  GetPorts;
end;

procedure TSettingsDlg.FormActivate(Sender: TObject);
begin
  StdBtn.Visible := Notebook.pageindex = 0;
  GetDesktop;
  GetAbout;
end;

procedure TSettingsDlg.cbSendCommClick(Sender: TObject);
begin
  destination.enabled := not cbsendcomm.checked;
  scanbtn.enabled := cbsendcomm.checked;
  lbports.enabled := cbsendcomm.checked;
  cboBaud.enabled := cbsendcomm.checked;
  cboData.enabled := cbsendcomm.checked;
  cboParity.enabled := cbsendcomm.checked;
  cboStop.enabled := cbsendcomm.checked;
  cboFlow.enabled := cbsendcomm.checked;
end;

procedure TSettingsDlg.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  If cbSaveSet.Checked then;
     { save it }
end;

end.
