{Demonstration program for BisonWare Parser V5.0}
unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Parser, TabNotBk,
  Grids;

type
  TMainForm = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    LB1: TListBox;
    Button1: TButton;
    FP1: TFileParser;
    Label1: TLabel;
    Label2: TLabel;
    Button2: TButton;
    FP2: TFileParser;
    SG1: TStringGrid;
    CheckBox1: TCheckBox;
    GroupBox1: TGroupBox;
    radUpper: TRadioButton;
    radLower: TRadioButton;
    radNone: TRadioButton;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Button3: TButton;
    Label9: TLabel;
    FP3: TFileParser;
    memInput: TMemo;
    LB2: TListBox;
    CheckBox2: TCheckBox;
    Label10: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FP1RecordParse(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FP2RecordParse(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FP3RecordParse(Sender: TObject);
    procedure FP3ParseError(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  end;

var
  MainForm: TMainForm;
  pcMemo: PChar;

implementation

{$R *.DFM}

{process the button 1 click event}
procedure TMainForm.Button1Click(Sender: TObject);
begin
   {Clear out the list}
   LB1.Items.Clear;

   {Start the Parse}
   FP1.ParseFile;
end;

procedure TMainForm.FP1RecordParse(Sender: TObject);
begin
    {Add a line to the listbox if required}
    If FP1.FieldCount > 0 then
        LB1.Items.Add(FP1.ParseList.strings[0]);
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
    {Initialise the case conversion}
    if radNone.Checked then
        FP2.CaseConvert := ctNone;
    if radUpper.Checked then
        FP2.CaseConvert := ctUpper;
    if radLower.Checked then
        FP2.CaseConvert := ctLower;

    {Start the parse}
    FP2.ParseFile;
end;

procedure TMainForm.FP2RecordParse(Sender: TObject);
var
    suba: integer;
begin
    {Fill the grid from the parse list}
    For suba := 1 to FP2.ParseList.Count do
    begin
        SG1.Cells[Suba-1,FP2.RecordCount - 1] := FP2.ParseList.Strings[suba -1];
    end;
end;

procedure TMainForm.CheckBox1Click(Sender: TObject);
begin
    {Decide what to do with text qualifiers}
    if CheckBox1.State = cbUnchecked then
        FP2.TrimTextQualifiers := False
      else
        FP2.TrimTextQualifiers := True;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
    {Point to the memo text}
    FP3.ParsePChar := StrPCopy(pcMemo,memInput.Text);

    {Clear the output list box}
    LB2.Items.Clear;

    {Parse the PChar}
    FP3.ParseMemory;
end;

procedure TMainForm.FormCreate(Sender: TObject);   
begin
    {Allocate some memory}
    pcMemo := StrAlloc(255);
end;

procedure TMainForm.FP3RecordParse(Sender: TObject);
begin
    {Allocate the parse list to the output listbox}
    If FP3.FieldCount > 0 then
        LB2.Items := FP3.ParseList;
end;

procedure TMainForm.FP3ParseError(Sender: TObject);
begin
    {Tell the user about a unterminated text error}
    if FP3.ErrorCode = 3 then
        MessageDlg('Unterminated text string',mtInformation, [mbOK], 0);

    {Tell the user about a unterminated comment error}
    if FP3.ErrorCode = 4 then
        MessageDlg('Unterminated Comment',mtInformation, [mbOK], 0);
end;

procedure TMainForm.CheckBox2Click(Sender: TObject);
begin
    {Set comment delimiters as per the users wishes}
    If CheckBox2.Checked then
        FP1.CommentDelimiters := '{ }'
      else
        FP1.CommentDelimiters := '';
end;

procedure TMainForm.FormActivate(Sender: TObject);
begin
    {Centre the form on the screen}
    MainForm.Left := (Screen.Width - MainForm.Width) div 2;
    MainForm.Top := (Screen.Height - MainForm.Height) div 2;
end;

end.
