// sentry
#if !defined(__VLONG_H)
#define __VLONG_H

#include <iostream.h>

// Copyright (c) by L. Roberts 1996. All Rights Reserved
// Larry Roberts, 1660 Arbutus St., Vancouver, CANADA
// Compuserve ID 103331,575
// Shareware : Register your copy! See accompanying readme.txt.

// note: REQUIRES 80386SX OR LATER PROCESSOR
//			running on an 80286 will fail!

class vlong {
  private:
	 long*   n;

  public:
	 vlong();				// Constructor
								// e.g. vlong x, y, z;
	 vlong(long n);		// constructor with initial value as shown
								// e.g. vlong x = 675847654;
	 vlong(int n);       // constructor with initial value as shown
	 vlong(char *init);	// Constructor with initial value as shown
								// values larger than a 'long' must be in quotes
								// e.g. vlong x = "37648598765435654834462728";
								// hex is OK e.g. vlong x = "0x07e765f8c876d8a87";
	 vlong(const vlong& copy);	// Copy Constructor
								// e.g. vlong x = 345; vlong y = x;

	 ~vlong();				// Destructor

	 vlong& operator= (const vlong& copy);		// Assignment operator
	 vlong& operator= (long i);			// Assignment of ordinary integer

	 friend ostream& operator << (ostream& ostrm, const vlong& arg2);
	 friend istream& operator >> (istream& istrm, vlong& arg2);

	 friend vlong operator+ (const vlong& arg1, const vlong& arg2);	// addition
	 friend vlong operator- (const vlong& arg1, const vlong& arg2);	// subtract
	 friend vlong operator* (const vlong& arg1, const vlong& arg2);	// multiply
	 friend vlong operator/ (const vlong& arg1, const vlong& arg2);	// divide
	 friend vlong operator% (const vlong& arg1, const vlong& arg2);	// remainder
	 friend long operator% (const vlong& arg1, long arg2);	// remainder

	 vlong operator/ (long arg2);		// divide by a long
	 vlong operator/= (long arg2);		// divide by a long
	 vlong operator%= (long arg2);		// remainder by a long

	 vlong operator+= (const vlong& arg2);
	 vlong operator-= (const vlong& arg2);
	 vlong operator*= (const vlong& arg2);
	 vlong operator/= (const vlong& arg2);
	 vlong operator%= (const vlong& arg2);
	 vlong operator- ();			// negate
	 vlong operator++ ();   	//prefix
	 vlong operator++ (int);   //postfix
	 vlong operator-- ();   	//prefix
	 vlong operator-- (int);   //postfix
	 int operator! () const;			// == 0

	 friend int operator== (const vlong& arg1, const vlong& arg2);	// equality
	 friend int operator!= (const vlong& arg1, const vlong& arg2);	// inequality
	 friend int operator<= (const vlong& arg1, const vlong& arg2);	// le
	 friend int operator>=(const vlong& arg1, const vlong& arg2);	// ge
	 friend int operator< (const vlong& arg1, const vlong& arg2);	// less
	 friend int operator> (const vlong& arg1, const vlong& arg2);	// greater

	 // PowerMod works out x to the y mod ... if mod = 0 or not given,
	 //		calculation is not modular
	 // e.g z = PowerMod(x,y); // not modular
	 //     z = PowerMod(x,y,31); // mod 31
	 friend vlong PowerMod(const vlong& x, const vlong& y, const vlong& mod = 0);

	 // turns vlong into a nul terminated character string
	 friend char* vtoa(const vlong& arg2, char *outstring);  // convert to char

	 // turns nul terminated character string into a vlong
	 friend vlong atov(char *instring);  // character to number

    // see demo.cpp for examples of below
	 // moves n characters of a string into a vlong so they can be dealt with
	 // as a number ... e.g. for RSA encryption. if n is 0 or not given
	 // goes to the first nul
	 friend void Import(char *instring, vlong* numb, int n = 0);

	 // moves n characters of a vlong into a character string so they can
	 // be output ... e.g. following decryption
	 friend void Export(const vlong& numb, char *outstring,  int n = 0);

	 // gives the largest number of characters that is shorter than a given
	 // number .. i.e add 1 to result to get number of characters that will
	 // hold a given number
	 friend int CharLength(const vlong& arg);
};

// version number
char* vlong_version();	// returns library version # as a character string

#endif  /* __VLONG_H */



