unit Unit2;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, WpWinCtr, WPRich, WPRuler, ExtCtrls, WPTbar, WPDefs, buttons;

type
  TEditForm = class(TForm)
    WPToolBar1: TWPToolBar;
    WPRuler1: TWPRuler;
    WPRichText1: TWPRichText;
    procedure WPToolBar1IconSelection(Sender: TObject; var Typ: TWpSelNr;
      const str: String; const group, num, index: Integer);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  EditForm: TEditForm;

implementation

{$R *.DFM}

{ please include unit WPDefs }
procedure TEditForm.WPToolBar1IconSelection(Sender: TObject;
  var Typ: TWpSelNr; const str: String; const group, num, index: Integer);
begin
  if (group = WPI_GR_DISK) and
     (num  = WPI_CO_EXIT) then
       ModalResult := IDOK;
end;

(* Group and Number definitions :
   unit WPDefs

const WPI_GR_STYLE = 1;  { Bold ... }
      WPI_GR_ALIGN = 2; { Centerd ... }
      WPI_GR_EDIT  = 3; { copy, paste ... }
      WPI_GR_DISK  = 4; { new,open,save ... }
      WPI_GR_PRINT = 5; { print, print setup }
      WPI_GR_DATA  = 6; { prev, next ... }

      WPI_GR_PARAGRAPH = 10; { Ereignisse der Formatierung }
      WPI_GR_TABSTOP   = 11;
      WPI_GR_PAGE      = 12;

      WPI_GR_USER  = 21; { free for User use }


{ Commands = Numbers}
const WPI_CO_Normal=1;   { Group: WPI_GR_STYLE }
      WPI_CO_Bold  =2;
      WPI_CO_Italic=3;
      WPI_CO_Under =4;
      WPI_CO_Hyperlink = 5;
      WPI_CO_StrikeOut = 6;

      WPI_CO_Left  =1;  { Group: WPI_GR_ALIGN }
      WPI_CO_Right =2;
      WPI_CO_Justified =3;
      WPI_CO_Center=4;

      WPI_CO_Copy  =1; { Group WPI_GR_EDIT }
      WPI_CO_Cut   =2;
      WPI_CO_Paste =3;
      WPI_CO_SelAll =4;
      WPI_CO_HideSel=5;
      WPI_CO_Find   =6;
      WPI_CO_Replace=7;
      WPI_CO_SpellCheck=8;

      WPI_CO_Exit  =1; { Group: WPI_GR_DISK }
      WPI_CO_New   =2;
      WPI_CO_Open  =3;
      WPI_CO_Save  =4;
      WPI_CO_Close =5;

      WPI_CO_Print =1; { Group: WPI_PRINT }
      WPI_CO_PrintSetup=2;

      WPI_CO_Next   =1; { Group: WPI_DATA }
      WPI_CO_Prev   =2;
      WPI_CO_Add    =3;
      WPI_CO_Del    =4;
      WPI_CO_Edit   =5;
      WPI_CO_Cancel =6;
      WPI_CO_ToStart=7;
      WPI_CO_ToEnd  =8;
      WPI_CO_Post   =9;
*)

end.
