/*
**                    --- login.c ---
**
**  EXAMPLE CODE: Very login terminal emulator.
**
*/

#define USECOMM

#include "windows.h"
#include "login.h"
#include "message.h"
#include "wsc.h"
#include "ascii.h"
#include "config.h"
#include "paint.h"
#include "line.h"
#include "menu.h"
#include "modem_io.h"
#include "about.h"
#include "wscerror.h"

/* defines */

#define Handshake_1  11
#define Handshake_2  12
#define Handshake_3  13
#define Dial_1  21
#define Dial_2  22
#define Dial_3  23

/* public globals */

HWND hMainWnd;            /* main window handle */
HWND hInfoWnd;            /* popup handle */
HANDLE hInstance;         /* program instance */
int OnLineFlag = FALSE;   /* TRUE: online */
int FatalFlag = FALSE;    /* TRUE: fatal error */
char Temp[1024];

/* private globals */

static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;

/* miscellaneous functions */

void ErrorCheck(int);
void ErrorMessage(char *);

int PASCAL WinMain(HANDLE hInst,HANDLE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "LoginIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "LoginMenu";
    wc.lpszClassName = "LoginWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "LoginWClass",   "Login",       WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,    CW_USEDEFAULT,
        WinWidth,         WinHeight,
        NULL,             NULL,
        hInstance,        NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,NULL,NULL))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

long FAR PASCAL MainWndProc(HWND hWindow,UINT message,WPARAM wParam,LPARAM lParam)
{int  i;
 int  TheChar;
 int  Count;
 int  rc, Code;
 HDC  hDC;
 UINT idTimer;
 PAINTSTRUCT ps;
 static FARPROC lpProcAbout;
 static int ThePort;
 static int mioState;

 hMainWnd = hWindow;
 switch (message)
    {case WM_COMMAND:
         switch(wParam)
           {case MSG_ABOUT:
              DialogBox(hInstance,"AboutBox",hMainWnd,lpProcAbout);
              break;


            case MSG_BREAK:
              mioBreak(ThePort);
              EnableTheMenu(MSG_BREAK);
              mioState = 0;
              break;

            case MSG_HANDSHAKE:
              if(!OnLineFlag) DisplayLine("Must be online!");
              else
                {mioState = Handshake_1;
                 EnableTheMenu(MSG_BREAK);
                }
              break;

            case MSG_DIAL:
              if(!OnLineFlag) DisplayLine("Must be online!");
              else
                {mioState = Dial_1;
                 EnableTheMenu(MSG_BREAK);
                }
              break;


            /*************/

            case MSG_DEBUG:
              break;

            case MSG_ONLINE:
              if(FatalFlag) ErrorMessage("Fatal Error");
              else
                {/* try to go on-line */
                 ThePort = GetPort();
                 GoOnLine(ThePort);
                 SetTitle();
                 CheckTheMenu(MSG_ONLINE);
                 UncheckTheMenu(MSG_OFFLINE);
                 EnableTheMenu(MSG_OFFLINE);
                 DisableTheMenu(MSG_ONLINE);
                 for(i=0;i<4;i++) DisableTheMenu(MSG_COM1+i);
                 DrawMenuBar(hMainWnd);
                }
              break;

            case MSG_OFFLINE:

              CheckTheMenu(MSG_OFFLINE);
              UncheckTheMenu(MSG_ONLINE);
              EnableTheMenu(MSG_ONLINE);
              DisableTheMenu(MSG_OFFLINE);
              for(i=0;i<4;i++) EnableTheMenu(MSG_COM1+i);
              GoOffLine(ThePort);
              SetTitle();
              DrawMenuBar(hMainWnd);
              break;

            case MSG_EXIT:
              GoOffLine(ThePort);
              KillTimer(hMainWnd,idTimer);
              PostQuitMessage(0);
              break;

            case MSG_110:
              SetBaud(Baud110);
              break;

            case MSG_300:
              SetBaud(Baud300);
              break;

            case MSG_1200:
              SetBaud(Baud1200);
              break;

            case MSG_2400:
              SetBaud(Baud2400);
              break;

            case MSG_4800:
              SetBaud(Baud4800);
              break;

            case MSG_9600:
              SetBaud(Baud9600);
              break;

            case MSG_19200:
              SetBaud(Baud19200);
              break;

            case MSG_38400:
              SetBaud(Baud38400);
              break;

            case MSG_57600:
              SetBaud(Baud57600);
              break;

            case MSG_COM1:
              SetPort(COM1);
              break;

            case MSG_COM2:
              SetPort(COM2);
              break;

            case MSG_COM3:
              SetPort(COM3);
              break;

            case MSG_COM4:
              SetPort(COM4);
              break;

            case MSG_NONE:
              SetParity(NoParity);
              break;

            case MSG_EVEN:
              SetParity(EvenParity);
              break;

            case MSG_ODD:
              SetParity(OddParity);
              break;

            case MSG_1_SB:
              SetStopBits(OneStopBit);
              break;

            case MSG_2_SB:
              SetStopBits(TwoStopBits);
              break;

            case MSG_7_DB:
              SetWordLength(WordLength7);
              break;

            case MSG_8_DB:
              SetWordLength(WordLength8);
              break;

            default:
              return (DefWindowProc(hMainWnd, message, wParam, lParam));
           }
         break;

    case WM_CREATE:

      /* check "OFFLINE" menu item */
      CheckTheMenu(MSG_OFFLINE);
      DisableTheMenu(MSG_OFFLINE);
      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance(AboutDlgProc, hInstance);
      /* initialize paint module */
      InitPaint();
      /* init configuration */
      CheckAll();
      SetText((LPSTR)"LOGIN");
      SetTitle();
      /* start timer */
      idTimer = SetTimer(hMainWnd,1,125,NULL);
      if(idTimer==0)
         {ErrorMessage("No timers remaining !");
          FatalFlag = TRUE;
         }
      break;

    case WM_CHAR:
      SioPutc(ThePort, (char)wParam );
      break;

    case WM_TIMER:
      /* fatal error ? */
      if(FatalFlag) break;
      if(!OnLineFlag) break;
      if(mioState)
        {/* MIO is running ! */
         rc = mioDriver(ThePort);
         if(rc==MIO_IDLE)
           {/* time to go to next MIO state (since driver is idle) */
            switch(mioState)
              {case Handshake_1:
                 /* send "AT" to modem */
                 Code = mioSendTo(ThePort, 125, "!AT!");
                 mioState = Handshake_2;
                 break;
               case Handshake_2:
                 /* expect "OK" back */
                 Code = mioWaitFor(ThePort, 3000, 1, "OK");
                 mioState = Handshake_3;
                 break;
               case Handshake_3:
                 /* did we get expected result ("OK") */
                 if(mioResult(ThePort)) DisplayString (">>>OK was received");
                 else DisplayString (">>>OK was NOT received!");
                 /* all done */
                 EnableTheMenu(MSG_BREAK);
                 mioState = 0;
                 break;
               case Dial_1:
                 /* dial modem */
                 Code = mioSendTo(ThePort, 125, "!ATDT880,9748!");
                 mioState = Dial_2;
                 break;
               case Dial_2:
                 /* expect "CONNECT" back (wait up to 60 seconds) */
                 if(mioWaitFor(ThePort, 60000, 1, "CONNECT")) mioState = Dial_3;
                 else DisplayString (">>>mioWaitFor fails!");
                 break;
               case Dial_3:
                 /* did we get expected result ("CONNECT") */
                 if(mioResult(ThePort)) DisplayString (">>>CONNECT was received");
                 else DisplayString (">>>CONNECT was NOT received!");
                 /* all done */
                 EnableTheMenu(MSG_BREAK);
                 mioState = 0;
              } /* end-switch */
           }
         else
           {/* MIO is not IDLE */
            if(rc != MIO_RUNNING) DisplayChar((char)rc);
           }
        } /* end-if(mioState) */
      else
        {/* MIO is not running */
         Count = 0;
         /* fetch line of up to 1024 chars */
         for(i=0;i<1024;i++)
           {TheChar = SioGetc(ThePort);
            /* character available ? */
            if(TheChar==WSC_NO_DATA) break;
            Temp[Count++] = TheChar;
            /*if((char)TheChar==(char)LF) break;*/
           } /* end while */
         if(Count>0) WriteTheString(Temp,Count);
        }
      break;


    case WM_SETFOCUS:
      /* create client area caret */
      CreateCaret(hMainWnd,NULL,3,10);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      ShowCaret(hMainWnd);
      break;

    case WM_KILLFOCUS:
      DestroyCaret();
      break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      GoOffLine(ThePort);
      if(idTimer) KillTimer(hMainWnd,idTimer);
      PostQuitMessage(0);
      break;

    default:
      return (DefWindowProc(hMainWnd, message, wParam, lParam));
   }
 return (NULL);
} /* end MainWndProc */

void ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {SioError(Code,"Sio Error");
      SioDone(GetPort());
      FatalFlag = TRUE;
     }
}

void ErrorMessage(char *MsgPtr)
{
 MessageBox(hMainWnd,MsgPtr,"ERROR",MB_ICONEXCLAMATION | MB_OK);
}
