' SIMPLINE.BAS

Option Explicit

Dim FatalFlag As Integer
Dim Code As Integer

Sub Aborting ()
  Dim Code As Integer
  SIMPLE.Print "Fatal Error, Aborting..."
  Code = SioDone(ThePort)
  End
End Sub

Sub DisplayChar (ByVal C As Integer)
  Dim Row As Integer
  Dim Col As Integer
  C = &H7F And C
  'process char
  If C = 13 Then
    'carriage control
    CurrentCol = 0
    'plus assumed line feed
    If CurrentRow < 23 Then
      CurrentRow = CurrentRow + 1
      'print CR+LF
      SIMPLE.Print
    Else
      'scroll !
      SIMPLE.Cls
      For Row = 0 To 22
        'print row
        ScreenBuffer(Row) = ScreenBuffer(Row + 1)
        SIMPLE.Print ScreenBuffer(Row)
      Next Row
      'clear bottom row
      ScreenBuffer(23) = Space$(80)
    End If
  ElseIf C = 10 Then
    'throw away line feeds
  Else
    'not CR or LF
    CurrentCol = CurrentCol + 1
    If CurrentCol > 79 Then
      'throw away !
      Exit Sub
    Else
      'save in screen buffer & display
      Mid$(ScreenBuffer(CurrentRow), CurrentCol, 1) = Chr$(C)
      SIMPLE.Print Chr$(C);
    End If
  End If
End Sub

Sub DisplayString (Text As String)
  Dim i As Integer
  Dim Length As Integer
  Length = Len(Text)
  For i = 1 To Length
    Call DisplayChar(Asc(Mid$(Text, i, 1)))
  Next i
  Call DisplayChar(13)
End Sub

Sub GetIncoming ()
  Dim i As Integer
  Dim Buffer As String * 1024
  Dim Count As Integer
  Count = SioGets(ThePort, Buffer, 1024)
  If Count > 0 Then
    For i = 1 To Count
      Call DisplayChar(Asc(Mid$(Buffer, i, 1)))
    Next i
  End If
End Sub

Sub GoOffLine ()
  Dim Code As Integer
  OnLineFlag = 0
  'shut down port
  Code = SioDone(ThePort)
End Sub

Sub GoOnLine ()
  Dim i As Integer
  Dim RxQueSize As Integer
  Dim TxQueSize As Integer
  If OnLineFlag Then
    Exit Sub
  End If
  'reset the port (1024 byte RX buffer & 128 byte TX buffer)
  RxQueSize = 1024
  TxQueSize = 128
  Code = SioReset(ThePort, RxQueSize, TxQueSize)
  If Code < 0 Then
    Call SayError(SIMPLE, Code)
    Exit Sub
  End If
  'set baud rate
  Code = SioBaud(ThePort, TheBaudCode)
  'call Aborting() if detect error after resetting port
  Call DisplayString("COM" + LTrim$(Str$(1 + ThePort)) + " reset")
  'set DTR & RTS
  Code = SioDTR(ThePort, Asc("S"))
  Code = SioRTS(ThePort, Asc("S"))
  'turn on hardware flow control
  Code = SioFlow(ThePort, Asc("H"))
  Call DisplayString("RTS/CTS flow control on")
  ' set parms
  Code = SioParms(ThePort, TheParity, TheStopBits, TheDataBits)
  ' we're online !
  OnLineFlag = 1
End Sub

Sub SetBaud ()
Dim Code As Integer
'Baudrate can be changed while running
Code = SioBaud(ThePort, TheBaudCode)
End Sub

Sub ShowConfig ()
  Dim A As String
  Dim B As String
  Dim C As String
  Dim D As String
  Dim E As String
  If OnLineFlag Then
    A = " (Online)"
  Else
    A = " (Offline)"
  End If
  B = "COM" + LTrim$(Str$(ThePort + 1))
  C = " @ " + BaudRateTable(TheBaudCode) + " "
  D = Str$(TheDataBits) + ParityText(TheParity)
  If TheStopBits = 0 Then
    E = "1"
  Else
    E = "2"
  End If
  SIMPLE.Caption = "SIMPLE: " + B + C + D + E + A
End Sub

                                                                                                   