/* 
  WinStdio V2.1 - Simple stdio facilties for Windows
  Copyright 1989 - 1996 I. H. Ting (I.H.Ting@wlv.ac.uk)
  
  WinStdio provides simple console-based (stdio) input output in Windows.
  At the moment, only the following stdio calls are supported:
  
  puts(), printf(), and gets().
  
  Please feel free to use and distribute the WinStdio source code. 
  Just respect my copyright. No waranty is implied or expressed.
  I will only guarantee that the code will fail occasionally!
*/  

#ifndef WINSTDIO_H
#define WINSTDIO_H
/* WinStdio.h  - prototypes for application-callable WinStdio functions */

/* registers the WinStdio class */
BOOL RegisterWinStdioClass(HANDLE hInstance);

/* Creates and return a handle to a WinStdio window */
HWND CreateStdioWindow(LPSTR szWindowName, HANDLE hInstance,int  nCmdShow);

/* WinStdio's equivalent of puts(). hWnd must be a valid WinStdio handle*/
int WinPuts(HWND hWnd, const char *pstring,int bAddReturn);

/* WinStdio's equivalent of printf(). hWnd must be a valid WinStdio handle.
   Calls wputs() ultimately.*/
int WinPrintf(HWND hWnd, const char *fmt,...);

/* WinStdio's equivalent of gets(). hWnd must be a valid WinStdio handle*/
char *WinGets(HWND hWnd, char *buffer,BOOL bWantNewline);

int WinStdioYield(void);


/*  If you get redefinition problems, comment the following prototypes out */
extern int printf(const char *, ...);
extern int puts(const char *);
extern char *gets(char *);


/* Win32/Win16 portability macros */
#ifndef EXPORT_STD_CALLBACK
  #if defined _WIN32  && !defined __BORLANDC__
    #ifdef TSCRIPT_STATIC_LIB
      #define EXPORT_STD_CALLBACK(FuncReturnType) FuncReturnType CALLBACK
      #define EXPORT_CDECL_CALLBACK(FuncReturnType) FuncReturnType __cdecl
    #else
      #define EXPORT_STD_CALLBACK(FuncReturnType) __declspec(dllexport) FuncReturnType CALLBACK
      #define EXPORT_CDECL_CALLBACK(FuncReturnType) __declspec(dllexport) FuncReturnType __cdecl
    #endif
  #else
    #define EXPORT_STD_CALLBACK(FuncReturnType) FuncReturnType __export CALLBACK
    #define EXPORT_CDECL_CALLBACK(FuncReturnType) FuncReturnType __export _far __cdecl
  #endif
#endif /*EXPORT_STD_CALLBACK*/

#ifndef IMPORT_STD_CALLBACK
  #if defined _WIN32 && !defined __BORLANDC__
    #ifdef TSCRIPT_STATIC_LIB
      #define IMPORT_STD_CALLBACK(FuncReturnType)  extern FuncReturnType CALLBACK
      #define IMPORT_CDECL_CALLBACK(FuncReturnType) extern FuncReturnType __cdecl
    #else
      #define IMPORT_STD_CALLBACK(FuncReturnType) __declspec(dllimport) extern FuncReturnType CALLBACK
      #define IMPORT_CDECL_CALLBACK(FuncReturnType) __declspec(dllimport) extern FuncReturnType __cdecl
    #endif
  #else
    #define IMPORT_STD_CALLBACK(FuncReturnType) extern FuncReturnType CALLBACK
    #define IMPORT_CDECL_CALLBACK(FuncReturnType) extern FuncReturnType _far __cdecl
  #endif
#endif /*IMPORT_STD_CALLBACK*/

#if defined  _WIN32  && !defined __BORLANDC__
  #ifndef __export
    #define __export
  #endif
#endif


#endif /*WINSTDIO_H */
