unit Appmod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,Dialogs,SysUtils;

const AppMaxi = 3;
      AppName : array [1 .. AppMaxi] of string =
                ('NOTEPAD.EXE (Text editor)',
                 'WRITE.EXE (Word Processor)',
                 'WINHELP.EXE (Help visualiser)');
type
  TAppModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Liste: TListBox;
    DDocsPath: TEdit;
    DDocsDriv: TEdit;
    Label1: TLabel;
    DDocsFile: TEdit;
    Label2: TLabel;
    Appli: TListBox;
    Label7: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label3: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AppModDialog: TAppModDialog;

implementation

Uses Decla,Disque;

{$R *.DFM}

(* Ok button *)
procedure TAppModDialog.OKBtnClick(Sender: TObject);
var Tmp : string;
    Tm1 : string;
    Tm2 : integer;
begin
 if VTrans.Positi = 0 then
 begin
  With VRun [VTrans.Number] do
  begin
   if Appli.ItemIndex <> -1 then
   begin
    Tmp := Appli.Items [Appli.ItemIndex];
    FileName := copy (Tmp,1,pos ('(',Tmp) - 2);
    FilePath := '%W';
   end
   else
   begin
    FileName := '';
    FilePath := '';
   end;
   case Liste.ItemIndex of
    0 : begin
         Tm1 := DDocsPath.Text;
         if Tm1 [1] <> '%' then
          if Tm1 [1] <> '\' then Tm1 := '\' + Tm1;
         if pos ('%',Tm1) = 0 then
         begin
          Tm2 := SetPath (DDocsDriv.Text [1] + ':' + Tm1);
          DocsPath := '%' + IntToStr (Tm2);
         end
         else
         begin
          DocsPath := DDocsPath.Text;
          DocsDriv := DDocsDriv.Text [1] + ':';
         end;
        end;
    1 : DocsPath := '%W';
    2 : DocsPath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,DocsPath);
     DocsPath := '%' + DocsPath;
    end;
   end;
  end;
 end
 else
 (* multiple *)
 begin
  With MultiD do
  begin
   if Appli.ItemIndex <> -1 then
   begin
    Tmp := Appli.Items [Appli.ItemIndex];
    FileName := copy (Tmp,1,pos ('(',Tmp) - 2);
    FilePath := '%W';
   end
   else
   begin
    FileName := '';
    FilePath := '';
   end;
   case Liste.ItemIndex of
    0 : begin
         Tm1 := DDocsPath.Text;
         if Tm1 [1] <> '%' then
          if Tm1 [1] <> '\' then Tm1 := '\' + Tm1;
         if pos ('%',Tm1) = 0 then
         begin
          Tm2 := SetPath (DDocsDriv.Text [1] + ':' + Tm1);
          DocsPath := '%' + IntToStr (Tm2);
         end
         else
         begin
          DocsPath := DDocsPath.Text;
          DocsDriv := DDocsDriv.Text [1] + ':';
         end;
        end;
    1 : DocsPath := '%W';
    2 : DocsPath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,DocsPath);
     DocsPath := '%' + DocsPath;
    end;
   end;
  end;
 end;
 ModalResult := mrOk;
end;

(* init dialog *)
procedure TAppModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 Label2.enabled := true;
 DDocsFile.enabled := true;
 (* init *)
 Liste.Clear;
 Liste.Items.Add ('Other');
 Liste.Items.Add (copy (WinDir,3,length (windir) - 2));
 Liste.Items.Add (copy (SysDir,3,length (sysdir) - 2));
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 Liste.ItemIndex := -1;
 Appli.Clear;
 for Bcl := 1 to AppMaxi do
  Appli.Items.Add (AppName [Bcl]);
 Appli.ItemIndex := -1;
 if VTrans.Positi = 0 then
 (* one document *)
 begin
  with VRun [VTrans.Number] do
  begin
   (* name *)
   DDocsFile.Text := DocsName;
   (* drive *)
   DDocsDriv.Text := DocsDriv [1];
   (* path *)
   if DocsPath [1] = '%' then
   begin
    if DocsPath [2] = 'W' then
    begin
     Liste.ItemIndex := 1;
     DDocsPath.Text := copy (Windir,3,length (Windir) - 2);
     DDocsDriv.Text := Windir [1];
    end
    else
    begin
     if DocsPath [2] = 'S' then
     begin
      Liste.ItemIndex := 2;
      DDocsPath.Text := copy (sysdir,3,length (Sysdir) - 2);
      DDocsDriv.Text := Sysdir [1];
     end
     else
     begin
      Val (copy (DocsPath,2,2),Num,Err);
      if Err = 0 then
      begin
       DDocsPath.Text := VPath [Num].PathDriv;
       DDocsDriv.Text := VPath [Num].LettDriv [1];
       Liste.ItemIndex := Num + 2;
      end
      else
      begin
       DDocsPath.Text := DocsPath;
       DDocsPath.Text := DocsDriv [1];
       Liste.ItemIndex := 0;
      end;
     end;
    end;
   end
   else
   begin
    DDocsPath.Text := DocsPath;
    DDocsDriv.Text := DocsDriv [1];
    Liste.ItemIndex := 0;
   end;
   (* laucher *)
   for Bcl := 1 to AppMaxi do
   begin
    if FileName = copy (AppName [Bcl],1,pos ('(',AppName [Bcl]) - 2) then
     Appli.ItemIndex := (Bcl - 1);
   end;
  end;
 end
 else
 (* multiple documents *)
 begin
  Label2.enabled := false;
  DDocsFile.enabled := false;
  (* name *)
  DDocsFile.Text := '';
  (* drive *)
  DDocsDriv.Text := VPath [1].LettDriv [1];
  (* path *)
  DDocsPath.Text := VPath [1].PathDriv;
  Liste.ItemIndex := 0;
  (* laucher *)
  Appli.ItemIndex := -1;
 end;
end;

(* changing directory *)
procedure TAppModDialog.ChangeDir(Sender: TObject);
begin
 if Liste.ItemIndex > 2 then
  DDocsPath.Text := VPath [Liste.ItemIndex - 2].PathDriv
 else
  Case Liste.ItemIndex of
   0 : if VTrans.Positi = 0 then
        DDocsPath.Text := VRun [VTrans.Number].DocsPath
       else
        DDocsPath.Text := '';
   1 : DDocsPath.Text := copy (WinDir,3,length (WinDir) - 2);
   2 : DDocsPath.Text := copy (SysDir,3,length (SysDir) - 2);
  end;
end;

end.
