unit Icomod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,SysUtils,Dialogs;

type
  TIconModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label2: TLabel;
    DNameFile: TEdit;
    Label1: TLabel;
    DDrivFile: TEdit;
    DFilePath: TEdit;
    Liste: TListBox;
    Label5: TLabel;
    Label6: TLabel;
    DSizeTarg: TEdit;
    DSizeSour: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    DCompFile: TCheckBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    DIconName: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    PListGroup: TListBox;
    Label9: TLabel;
    PackList: TListBox;
    AssoBtn: TButton;
    procedure Initialise(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
    procedure KeepIt(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure AssoBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  IconModDialog: TIconModDialog;

implementation

uses Decla,Disque;

{$R *.DFM}

(* init dialog *)
procedure TIconModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 Label2.enabled := true;
 DNameFile.Enabled := true;
 label7.enabled := true;
 DIconName.Enabled := true;
 label3.enabled := true;
 label5.enabled := true;
 DSizeSour.enabled := true;
 label4.enabled := true;
 label6.enabled := true;
 DSizeTarg.Enabled := true;
 DCompFile.Enabled := true;
 (* init *)
 PackList .Clear;
 if Number_Pack > 0 then
 begin
  for Bcl := 1 to Number_Pack do
   PackList.Items.Add (VPack [Bcl].Libelle);
 end;
 PackList.ItemIndex := -1;
 PListGroup.Clear;
 if Number_Group > 0 then
 begin
  for Bcl := 1 to Number_Group do
  begin
   With VGroup [Bcl] do
    PListGroup.Items.Add (GroupName);
  end;
 end;
 PListGroup.ItemIndex := -1;
 Liste.Clear;
 Liste.Items.Add ('Other');
 Liste.Items.Add (copy (Windir,3,length (windir) - 2));
 Liste.Items.Add (copy (Sysdir,3,length (sysdir) - 2));
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 if VTrans.Positi = 0 then
 (* one icon *)
 begin
  with VIcons [VTrans.Number] do
  begin
   (* pack file *)
   PackList.ItemIndex := VIcons [VTrans.Number].PackFile - 1;
   (* name *)
   DNameFile.Text := FileName;
   (* drive *)
   DDrivFile.Text := FileDriv [1];
   (* path *)
   if FilePath [1] = '%' then
   begin
    if FilePath [2] = 'W' then
    begin
     DFilePath.Text := copy (Windir,3,length (windir) -2);
     Liste.ItemIndex := 1;
    end
    else
    begin
     if FilePath [2] = 'S' then
     begin
      DFilePath.Text := copy (sysdir,3,length (sysdir) -2);
      Liste.ItemIndex := 2;
     end
     else
     begin
      Val (copy (FilePath,2,2),Num,Err);
      if Err = 0 then
      begin
       DFilePath.Text := VPath [Num].PathDriv;
       DDrivFile.Text := VPath [Num].LettDriv [1];
       Liste.ItemIndex := Num + 2;
      end
      else
      begin
       DFilePath.Text := FilePath;
       DDrivFile.Text := FileDriv [1];
       Liste.ItemIndex := 0;
      end;
     end;
    end;
   end
   else
   begin
    DFilePath.Text := FilePath;
    DDrivFile.Text := FileDriv [1];
    Liste.ItemIndex := 0;
   end;
   (* sizes *)
   DSizeSour.Text := IntToStr (SizeNorm);
   if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                   else DSizeTarg.Text := IntToStr (SizeNorm);
   (* compress *)
   if Compress = 1 then DCompFile.State := cbChecked
                   else DCompFile.State := cbUnChecked;
   (* iconname*)
   DIconName.Text := IconName;
   (* group name *)
   if GroupNum > Number_Group then GroupNum := 0;
   PListGroup.ItemIndex := VIcons [VTrans.Number].GroupNum - 1;
  end;
 end
 else
 (* multiple icon *)
 begin
  Label2.enabled := false;
  DNameFile.Enabled := false;
  label7.enabled := false;
  DIconName.Enabled := false;
  label3.enabled := false;
  label5.enabled := false;
  DSizeSour.enabled := false;
  label4.enabled := false;
  label6.enabled := false;
  DSizeTarg.Enabled := false;
  DCompFile.Enabled := false;
  (* pack file *)
  PackList.ItemIndex := -1;
  (* name *)
  DNameFile.Text := '';
  (* drive *)
  DDrivFile.Text := VPath [1].LettDriv [1];
  (* path *)
  DFilePath.Text := VPath [1].PathDriv;
  (* sizes *)
  DSizeSour.Text := '';
  DSizeTarg.Text := '';
  (* compress *)
  DCompFile.State := cbgrayed;
  (* iconname*)
  DIconName.Text := '';
  (* group name *)
  PListGroup.ItemIndex := -1;
 end;
end;

(* change directory *)
procedure TIconModDialog.ChangeDir(Sender: TObject);
begin
 if Liste.ItemIndex > 2 then
  DFilePath.Text := VPath [Liste.ItemIndex - 2].PathDriv
 else
  case Liste.ItemIndex of
   0 : if VTrans.Positi = 0 then
        DFilePath.Text := VIcons [VTrans.Number].FilePath
       else
        DFilePath.Text := '';
   1 : DFilePath.Text := copy (Windir,3,length (windir) - 2);
   2 : DFilePath.Text := copy (sysdir,3,length (sysdir) - 2)
  end;
end;

(* keep compress file *)
procedure TIconModDialog.KeepIt(Sender: TObject);
begin
 if VTrans.Positi = 0 then
 begin
  With VIcons [VTrans.Number] do
  begin
   if Compress = 1 then DCompFile.State := cbChecked
                   else DCompFile.State := cbUnChecked;
  end;
 end
 else
  DCompFile.State := cbGrayed;
end;

(* Ok button *)
procedure TIconModDialog.OKBtnClick(Sender: TObject);
var Tm1 : integer;
    Tmp : string;
begin
 if VTrans.Positi = 0 then
 (* one icon *)
 begin
  With VIcons [VTrans.Number] do
  begin
   IconName := DIconName.Text;
   PackFile := PackList.ItemIndex + 1;
   case Liste.ItemIndex of
    0 : begin
         Tmp := DFilePath.Text;
         if Tmp [1] <> '%' then
          if Tmp [1] <> '\' then Tmp := '\' + Tmp;
         if pos ('%',Tmp) = 0 then
         begin
          Tm1 := SetPath (DDrivFile.Text [1] + ':' + Tmp);
          FilePath := '%' + IntToStr (Tm1);
         end
         else
         begin
          FilePath := DFilePath.Text;
          FileDriv := DDrivFile.Text [1] + ':';
         end;
        end;
    1 : FilePath := '%W';
    2 : FilePath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,FilePath);
     FilePath := '%' + FilePath;
    end;
   end;
   if PListGroup.ItemIndex <> -1 then GroupNum := PListGroup.ItemIndex + 1
                                 else GroupNum := 1;
  end;
 end
 else
 (* multiple *)
 begin
  With MultiI do
  begin
   PackFile := PackList.ItemIndex + 1;
   case Liste.ItemIndex of
    0 : begin
         Tmp := DFilePath.Text;
         if Tmp [1] <> '%' then
          if Tmp [1] <> '\' then Tmp := '\' + Tmp;
         if pos ('%',Tmp) = 0 then
         begin
          Tm1 := SetPath (DDrivFile.Text [1] + ':' + Tmp);
          FilePath := '%' + IntToStr (Tm1);
         end
         else
         begin
          FilePath := DFilePath.Text;
          FileDriv := DDrivFile.Text [1] + ':';
         end;
        end;
    1 : FilePath := '%W';
    2 : FilePath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,FilePath);
     FilePath := '%' + FilePath;
    end;
   end;
   if PListGroup.ItemIndex <> -1 then GroupNum := PListGroup.ItemIndex + 1
                                 else GroupNum := 1;
  end;
 end;
 ModalResult := mrOk;
end;

(* No association button *)
procedure TIconModDialog.AssoBtnClick(Sender: TObject);
begin
 PackList.ItemIndex := -1;
end;

end.
