(********************************)
(* global declaration for setup *)
(********************************)
unit Decla;

interface

const Max_Group = 05;             (* max of items group                *)
      Max_Files = 150;            (* max of files allow to copy        *)
      Max_Icons = 100;            (* max of icons allow to create      *)
      Max_Run   = 05;             (* max of application allow to lauch *)
      Max_Path  = 50;             (* max of path allowed               *)
      Max_IniF  = 100;            (* max of INI files instuctions      *)
      Max_Pack  = 05;             (* max of packet group file          *)
      Fch_UnIns = 'UNSETUP.';     (* name for unsetup file             *)
      Fch_Ins   = 'SETUP.';       (* name of setup file                *)
      PrgVersio = '5.00a';        (* program version                   *)
      One_Meg   = 1048576;        (* size of a floppy                  *)
      New_Win   = 3.95;           (* W95 version                       *)
      Old_Win   = 3.1;            (* W3.1x version                     *)

      (* groups vector *)
Type TVect_Group = record
                    GroupName : string [30];    (* Nom du groupe      *)
                    GroupFile : string [79];    (* Fichier de groupe  *)
                   end;
     (* items vector *)
     TVect_Icons = record
                    DiskNumb : byte;            (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [3];      (* variable pointer   *)
                    IconName : string [30];     (* nom de l'icone     *)
                    Compress : byte;            (* Compress Yes / No  *)
                    GroupNum : byte;            (* number of group    *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* files vector *)
     TVect_Files = record
                    DiskNumb : byte;            (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [3];      (* variable pointer   *)
                    Compress : byte;            (* Compress Yes / No  *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* documents vector *)
     TVect_Run =   record
                    FileName : string [12];     (* fichier a lancer   *)
                    FilePath : string [3];      (* variable pointer   *)
                    DocsName : string [12];     (* document associe   *)
                    DocsPath : string [3];      (* variable pointer   *)
                    PackFile : byte;            (* packet file        *)
                   end;
     (* drive and path vector *)
     TVect_Path =  record
                    LettDriv : string [3];      (* la lettre lecteur  *)
                    PathDriv : string [79];     (* chemin lecteur     *)
                   end;
     (* INI files vector *)
     TVect_IniFi = record
                    FileName : string [12];     (* name of ini file   *)
                    FilePath : string [3];      (* variable pointer   *)
                    INISecti : string [50];     (* name of section    *)
                    INIField : string [50];     (* name of filed      *)
                    INIValue : string [50];     (* name of value(s)   *)
                   end;
     (* packet file vector *)
     TPack_File = record
                   Libelle : string [40];       (* description of pack*)
                   Selecte : boolean;           (* True : selected    *)
                  end;

var VGroup : array [1 .. max_group] of TVect_Group;   (* items groups   *)
    VIcons : array [1 .. max_icons] of TVect_Icons;   (* icons or items *)
    VFiles : array [1 .. max_files] of TVect_Files;   (* files          *)
    VRun   : array [1 .. max_run]   of TVect_Run;     (* documents      *)
    VPath  : array [1 .. max_path]  of TVect_Path;    (* drive and path *)
    VIniF  : array [1 .. max_inif]  of TVect_IniFi;   (* INI files      *)
    VPack  : array [1 .. max_pack] of TPack_File;     (* packet file    *)
    Title,SubTitle,Version,Author,Copyright : string; (* informations   *)
    Disk_Number  : integer;                           (* nbr of dsk < 2 *)
    Disk_Space   : longint;                           (* space needed   *)
    Number_Direc : byte;                              (* nbr of target  *)
    Number_Group : byte;                              (* nbr of groups  *)
    Number_Icons : byte;                              (* nbr of icons   *)
    Number_Files : byte;                              (* nbr of files   *)
    Number_Run   : byte;                              (* nbr of docs    *)
    Number_Ini   : byte;                              (* Nbr of INI line*)
    Number_Pack  : byte;                              (* Nbr of packet  *)
    Error        : integer;                           (* <>0 err append *)
    First        : boolean;                           (* =true Creation *)
    CurrentWin   : integer;                           (* win dialog     *)
    Direction    : byte;                              (* =0 up 1= down  *)
    UnInstallCop : boolean;                           (* Copy to Hard D *)
    UnInstallFil : boolean;                           (* Make File      *)
    CustomizeFlg : boolean;                           (* Custom install?*)

implementation

end.

