unit Uninst;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TUnInstallDialog = class(TForm)
    Bevel1: TBevel;
    btBefore: TButton;
    btNext: TButton;
    btCancel: TButton;
    UnInstFile: TCheckBox;
    UnInstCopy: TCheckBox;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    procedure btCancelClick(Sender: TObject);
    procedure btNextClick(Sender: TObject);
    procedure btBeforeClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Initialisation(Sender: TObject);
  private
    { Private declarations }
    procedure GetInformation;
  public
    { Public declarations }
  end;

var
  UnInstallDialog: TUnInstallDialog;

implementation

uses Decla,Generale;

{$R *.DFM}

(* cancel button *)
procedure TUnInstallDialog.btCancelClick(Sender: TObject);
begin
 MainBack.Close;
end;

(* next button *)
procedure TUnInstallDialog.btNextClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 4;
 Direction := 0;
 Close;
end;

(* before button *)
procedure TUnInstallDialog.btBeforeClick(Sender: TObject);
begin
 GetInformation;
 CurrentWin := 9;
 Direction := 1;
 Close;
end;

(* closing dialog *)
procedure TUnInstallDialog.FormClose(Sender: TObject;var Action: TCloseAction);
begin
 MainBack.Initialisation (Sender);
end;

(* get all dialog information *)
Procedure TUnInstallDialog.GetInformation;
begin
 UnInstallCop := UnInstCopy.State = cbChecked;
 UninstallFil := UnInstFile.State = cbChecked
end;

(* dialog initialisation *)
procedure TUnInstallDialog.Initialisation(Sender: TObject);
begin
 If UnInstallCop = true then UnInstCopy.State := cbChecked
                        else UnInstCopy.State := cbUnChecked;
 If UnInstallFil = true then UnInstFile.State := cbChecked
                        else UnInstFile.State := cbUnChecked;
end;

end.
