/* RUNNING.CMD - REXX program to form running averages of messages
in each echo area
Version 1.11 - 24 May, 1995 by Elliott Goodman
*/

/* trace ?a */
                                                                 
/* load if not already loaded */                                 
if RxFuncQuery('SysLoadFuncs') then                              
do                                                               
        call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
        call SysLoadFuncs                                        
end                                                              
                                                                 
/* save directory info */                                        
old_dir = directory()                                            
                                                                 
/* modify as necessary */                                        
call directory('D:\LORA\LANG')                                   

area_names = 0
temp_count = 0
total = 0
temp_name = ' '
smooth_factor = 7

drop messages.

in_name = 'MSGCOUNT.TXT'
out_name = 'RUNNING.TXT'
temp_file_name = 'TEMP.TXT'
old_file = 'RUNNING.BAK'

/* Initialize temp file */
call SysFileDelete(temp_file_name)  /* delete if present */
call SysFileDelete(old_file)
m_txt = 'Running Averages v1.11 by Elliott Goodman'
call lineout temp_file_name, m_txt
time_string = time('C')
date_string = date('N')
m_txt = 'Current time:' time_string || ',' date_string || '. Smooth Factor = ' smooth_factor
call lineout temp_file_name, m_txt
m_txt = '  '
call lineout temp_file_name, m_txt

/* cycle thru old file */
do until lines(out_name) = 0
   work_line = linein(out_name)
   parse upper var work_line area_tag toss_count stuff
   toss_count = strip(toss_count)

/* form smoothed 6 day average: multiply yesterday's average by 5, add
today's number, and divide by 6. (Or whatever the smooth_factor is) */

   if datatype(toss_count) = 'NUM' then
      toss_count = toss_count * smooth_factor

/* skip header */
   if area_tag = 'RUNNING' then iterate
   if area_tag = 'CURRENT' then iterate
   if area_tag = 'TOTAL' then iterate
   if area_tag = 'DAYS' then do
      stuff = strip(stuff)
      stuff = stuff + 1
      m_txt = 'Days =' stuff
      call lineout temp_file_name, m_txt
      m_txt = '  '
      call lineout temp_file_name, m_txt
      end

/* form array of message areas */
   area_names = area_names + 1
   messages.area_names = area_tag
   messages.area_names.count = toss_count
   end

call lineout out_name
'@ren ' out_name old_file

do until lines(in_name) = 0
   work_line = linein(in_name)
   parse upper var work_line area_tag toss_count stuff
   toss_count = strip(toss_count)

/* skip header */
   if area_tag = 'MESSAGE' then iterate
   if area_tag = 'CURRENT' then iterate
   if area_tag = 'MESSAGES' then iterate
   if area_tag = 'TOTAL' then iterate
   if datatype(toss_count) \= 'NUM' then iterate

/* add to totals if present */
   found = 0
   do index = 1 to area_names                                       
      if messages.index = area_tag then do                         
         messages.index.count = messages.index.count + toss_count 
         found = 1                                                
         leave                                                    
         end /* if */                                             
      end /* do index = 1 to area_names */                         
                                                                             
/* area tag not found; add to array */                                       
   if found = 0 then do                                            
      area_names = area_names + 1                                 
      messages.area_names = area_tag                              
/* new area: adjust message count so it won't be divided by 6 */
      if datatype(toss_count) = 'NUM' then toss_count = toss_count * (smooth_factor + 1)
      messages.area_names.count = toss_count
      end /* if found = 0 */                                      
   end /* do until lines() = 0 */                                           

call lineout in_name

do index = 1 to area_names
   if datatype(messages.index.count) = 'NUM' then
       messages.index.count = messages.index.count / (smooth_factor + 1)
   else
       iterate

/* truncate if over 50, keep two decimals if less. this preserves
    accuracy while cleaning up the display */

   if messages.index.count > 50 then
      messages.index.count = trunc(messages.index.count)
   else
      messages.index.count = trunc(messages.index.count, 2)
   total = total + messages.index.count
   end

/* sort routine - not fast but it works */                       
swap = 1                                                         
do until swap = 0                                                
    swap = 0                                                     
    do index = 1 to area_names -1                                
        t_index = index + 1                                      
        if messages.t_index.count > messages.index.count then do 
            temp_name = messages.index                           
            temp_count = messages.index.count                    
            messages.index = messages.t_index                    
            messages.index.count = messages.t_index.count        
            messages.t_index = temp_name                         
            messages.t_index.count = temp_count                  
            swap = 1                                             
            end /* if */                                         
        end /* do */                                             
    end /* do until */                                           

do index = 1 to area_names
   if datatype(messages.index.count) \= 'NUM' then iterate
   m_txt = space(messages.index,
       messages.index.count,(27-length(messages.index)),' ') '      7 days:',
       FormatNumber(trunc(( messages.index.count * 7 )))
   call lineout temp_file_name, m_txt
   end

total = FormatNumber(trunc(total))
m_txt = ' '
call lineout temp_file_name, m_txt
m_txt = space('Total' total,19,' ') 
call lineout temp_file_name, m_txt

call lineout temp_file_name
call SysSleep 2
'@ren temp.txt RUNNING.TXT'
call directory(old_dir)
exit

/* procedure to format numbers */
FormatNumber: Procedure

total_count = arg(1)
millions = 'MILLIONS'

temp = total_count
total_count = ''
if temp > 999999 then do
  millions = temp % 1000000
  temp = temp // 1000000
  end
if temp > 999 then do
  thousands = temp % 1000
  temp = temp // 1000
  end
if millions \= 'MILLIONS' then
  total_count = millions || ','

if millions \= 'MILLIONS' then do
  select
     when thousands = 0 then
        thousands = '000'
     when thousands < 10 then
        thousands = '00' || thousands
     when thousands < 100 then
        thousands = '0' || thousands
     otherwise
        nop
     end
  end

if thousands \= 'THOUSANDS' then do
  select
    when temp = 0 then
       temp = '000'
    when temp < 10 then
       temp = '00' || temp
    when temp < 100 then
       temp = '0' || temp
    otherwise
       nop
    end
  end

if thousands \= 'THOUSANDS' then
  total_count = total_count || thousands || ',' || temp 
else
  total_count = temp
return total_count
