



                                       Preface


     The Data-Wire Four is a Foxpro procedure designed to allow an
     application to verify databases quickly and easily.  DW4 is written in a
     dBASE IV compatible language called Foxpro.

     In essence, the programmer executes DW4, generating a data dictionary
     program.  This data dictionary program, called DBFS.PRG, is a "picture"
     of all databases in the current directory.  When executed, DBFS verifies
     that all specified databases exist and have the correct field layouts.
     Structural indices are also verified.

     When you try to open a database file, you may see the error message "not
     a database file".  The most common cause for this error is a bad record
     count.  DBFS.PRG has the ability to repair a bad record count.

     DBFS.PRG can be executed alone or included within a programmer's
     application.

     This manual is not for the beginner.  We will not be discussing how to
     use MS-DOS, or Foxpro.  Examples will be brief, and there will be a lot
     of technical notes within the regular discussions.

     My advice is to peruse the contents of this manual to familiarize
     yourself with its information.  You also might want to familiarize
     yourself with the DW4 source code.































                                     - Page 1 -







                             Copyright/License/Warranty




     This document and the program Data Wire Four ("the software") are
     copyrighted by the author.  The copyright owner hereby licenses you to
     use the software given these restrictions:


          o  the program shall be supplied in its original, unmodified
             form, which includes this documentation;

          o  for-profit use without a license is prohibited;

          o  the program may not be included - or bundled - with other
             goods or services.  Exceptions may be granted upon written
             request only.

          o  no fee is charged beyond a reasonable amount for the media
             and handling ($10 maximum suggested);


          There is no warranty of any kind.  The copyright owner may not
          be held liable for any damages, including any lost profits or
          other incidental or consequential damages arising out of or
          inability to use the software.  By using the software, you agree
          to this.


     Shareware

          DW4 is distributed as Shareware.  It is not free software.
          You are free to try it and make copies for others.  If you
          continue to use this application beyond a reasonable trial
          period, you are required to register it with the distributor
          and author.


     ASP Ombudsman

          This program is produced by a member of the Association of
          Shareware Professionals (ASP).  ASP wants to make sure that the
          shareware principle works for you.  If you are unable to resolve
          a shareware-related problem with an ASP member by contacting the
          member directly, ASP may be able to help.  The ASP Ombudsman can
          help you resolve a dispute or problem with an ASP member, but
          does not provide technical support for members' products.

          Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
          MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
          via CompuServe Mail to ASP Ombudsman 70007,3536.



          Copyright (C) 1992 Dennis Allen.  All rights reserved.  All
          trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


     Preface                                                    1
     Copyright/License/Warranty                                 2
     Using Data Wire Four                                       4
         Calling DBFS.PRG                                       4
             Customized File Name                               5
             Multiple File Names                                5
         Executing DBFS.PRG                                     5
             Repairing the record count                         6
         Specifying a file name                                 7
     Distribution                                               7
     Index                                                      8












































                                     - Page 3 -







                                Using Data Wire Four


     Using Data Wire Four is simple.  First, you must be the data directory
     of your application.  Remove all temporary files.  If you have
     structural indices, make sure the index tags are in the desired order.
     Then, at the DOS prompt, type:

               FOX  DW4

     and press [Enter].  Data Wire Four will generate a program called
     "DBFS.PRG".  If there are "FXP" files in the current directory,
     "DBFS.PRG" will be compiled.


                                 Calling DBFS.PRG


     You may call DBFS.PRG from either the Foxpro command window, or from
     within your application.  If DBFS.PRG is executed from the Foxpro
     command window, a WAIT WINDOW is performed before exiting.

     Now DBFS.PRG takes the following parameters:


          cPATH          -    Path of data files
          cNAME          -    Specific data file, defined within DBFS.PRG
          bBACK          -    Flag, .t. = create backup files (default)


     If cPATH is not specified, DBFS.PRG will use the path in cDATAPATH.  If
     cDATAPATH does not exist, the current directory is assumed.

     Unless bBACK is specified as false, backup will occur.  Example:


          DO DBFS WITH "D:\DMAIL4"


     In this example, DBFS.PRG will verify all database files in the
     D:\DMAIL4 directory.  If any database file has to be modified, a backup
     of the original is created.  In a backup, the original *.DBF file is
     renamed as a *.BAK file.  Any associated *.FPT file is renamed as a
     *.TBK file.  Example #2:


          DO DBFS WITH "D:\DMAIL4", "MAIL", .F.


     In this example, DBFS.PRG will verify only the file MAIL.DBF in the
     D:\DMAIL4 directory.  No backup will occur.  Example #3:


          bERROR = .NOT. DBFS("D:\DMAIL4","MAIL",.F.)

     In this example, DBFS.PRG is called as a function.  Here, if
     verification fails, DBFS.PRG will return a value of ".F.".

                                     - Page 4 -







                                Using Data Wire Four


                               Customized File Name


     There may be times when you want to verify a database file with a
     customized file name.  For example, you may want to write a mailing list
     application that uses monthly archives.  While each archive file has a
     unique name, they do carry a common structure.  Example #3:


          DO DBFS WITH "D:\DMAIL4", "MAIL:MAIL9412"


     In this example, DBFS.PRG will verify the file MAIL9412.DBF against the
     structure defined by MAIL.DBF.  Backup will occur.


                               Multiple File Names


     You can specify multiple file names.  Example #4:


          DO DBFS WITH "D:\DMAIL4", "FOXERR,MAIL:MAIL9412,STATE"


     In this example, DBFS.PRG will verify the file FOXERR.DBF, the file
     MAIL9412.DBF (against the structure defined by MAIL.DBF), then the file
     STATE.DBF.  Backup will occur.


                                Executing DBFS.PRG


     When DBFS.PRG is executed, all databases in the specified directory are
     inspected.  If a database file doesn't exist, it is created.  If a
     database file is missing a field, it is added.  If a field is not the
     correct length, it is lengthened.  If a structural index tag is missing
     or not in the correct order, the entire CDX file is rebuilt.

     Note:  DBFS.PRG cannot handle a structural index tag containing a
     relationship (SET RELATION TO).  If you must use relations, unknown
     variables, or need to use index tags not defined in DBFS.PRG, simply
     create stand alone compact NDX files.












                                     - Page 5 -







                                Using Data Wire Four




                            Repairing the record count


     If a database file has a bad record count, DBFS.PRG will try to repair
     it.  Normally, if DBFS.PRG cannot repair the database file, verification
     fails.  If you specify backup, however, a new (and empty) database file
     is created.  The corrupted DBF file is renamed as a BAK file (just like
     a backup).  Any associated FPT file will be renamed as a TBK file.

     Please keep this backup feature in mind when you invoke your own
     database repair utility.  Depending on the damage, you may have to use
     the header of the empty DBF file to rebuild your BAK file.


     Acknowledgement:  The algorithm code used to repair a bad DBF record
     count originated from the January 1994 article of Foxpro Advisor (Page
     8) by Jim Booth and Paul Helser.




































                                     - Page 6 -







                                Using Data Wire Four




                              Specifying a file name


     In Data Wire Four, you can specify a file name.  At the DOS prompt, for
     example, you could type:

               FOX  DW4  TEMP

     A file called "TEMP.PRG" (not "DBFS.PRG") would then be generated.


     Note:  DW4 ignores the database file FOXUSER.DBF and all database files
     beginning with a number.  If the file DBFS.PRG is generated, DW4 will
     also ignore the database file SCR.DBF, and all database files beginning
     with "Q".


                                   Distribution


     Now you're ready to add DBFS.PRG to your application.  I suggest
     executing DBFS.PRG before your main menu loop.  In this way, all
     database files are verified BEFORE your application can execute
     sensitive code.  Distributing DBFS.PRG with your application will ensure
     that any client, no matter how old the data files, has the correct file
     layouts.

     Note:  If you decide to distribute DBFS.PRG within your application,
     please add the following copyright notice to your installation:


          Copyright Notices:
          DBFS.PRG is supplied by Dennis Allen




















                                     - Page 7 -







                                        Index


     Backup  4, 6
     Calling DBFS.PRG  4
     Copyright/License/Warranty  2
     Customized File Name  5
     DBFS.PRG  1, 4, 5
     Distribution  7
     DW4  1
     Executing DBFS.PRG  5
     Foxpro  1
     Index  8
     Multiple File Names  5
     Preface  1
     Repairing the record count  6
     Specifying a file name  7
     TABLE OF CONTENTS  3
     Using Data Wire Four  4







































                                     - Page 8 -



