



                                       Preface


     The dMAIL4 System is a set of programs designed to record and track a
     simple mailing list database.  dMAIL4 is written in a dBASE IV
     compatible language called Foxpro.

     Among the dMAIL4 System features is the ability to run in a Multi-user
     environment.  It can access a customer record by either Last Name or
     Zip Code.  dMAIL4 also can save/restore a range of customer records
     to/from a floppy disk.

     An IBM personal computer (80386 or better) is recommended.  For
     improved performance, it is highly recommended that the user obtain at
     least three megabytes of extended memory.  A color monitor and a mouse
     are also recommended.

     Considerable effort was expended to make the user reference manual as
     complete as possible.  However, this documentation is in no way to be
     considered an instructive guide to MS-DOS or Foxpro.  Many reference
     texts are available on the market that explain the MS-DOS operating
     system and Foxpro programming.  If you need more information, your
     reference materials should include one of these texts.

     My advice is to read the contents of this user manual.  Familiarize
     yourself with its information.  If you have any questions concerning
     this application, feel free to write or call.































                                     - Page 1 -







                             Copyright/License/Warranty


          This document and the program dMAIL4 ("the software") are
          copyrighted by the author.  The copyright owner hereby licenses
          you to use the software given these restrictions:


          o  the program shall be supplied in its original, unmodified
             form, which includes this documentation;

          o  for-profit use without a license is prohibited;

          o  the program may not be included - or bundled - with other
             goods or services.  Exceptions may be granted upon written
             request only.

          o  no fee is charged beyond a reasonable amount for the media
             and handling ($10 maximum suggested);


          There is no warranty of any kind.  The copyright owner may not
          be held liable for any damages, including any lost profits or
          other incidental or consequential damages arising out of or
          inability to use the software.  By using the software, you agree
          to this.


     Shareware

          dMAIL4 is distributed as Shareware.  It is not free software.
          You are free to try it and make copies for others.  If you
          continue to use this application beyond a reasonable trial
          period, you are required to register it with the distributor
          and author.


     ASP Ombudsman

          This program is produced by a member of the Association of
          Shareware Professionals (ASP).  ASP wants to make sure that the
          shareware principle works for you.  If you are unable to resolve
          a shareware-related problem with an ASP member by contacting the
          member directly, ASP may be able to help.  The ASP Ombudsman can
          help you resolve a dispute or problem with an ASP member, but
          does not provide technical support for members' products.

          Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
          MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
          via CompuServe Mail to ASP Ombudsman 70007,3536.



          Copyright (C) 1987 Dennis Allen.  All rights reserved.  All
          trademarks mentioned herein belong to their respective owners.



                                     - Page 2 -







                                  TABLE OF CONTENTS


     Preface                                                    1
     Copyright/License/Warranty                                 2
     Introduction                                               5
         Manual Content                                         5
         Notation Convention                                    6
     Invoking dMAIL4                                            7
     Creating a dMAIL4 Record                                   8
         Adding a Customer Record                              11
         Creating a State Record                               13
         Quit                                                  13
     Printing Mailing List                                     14
         Printing Mailing Labels                               14
         Quit                                                  16
     System Setup                                              17
         Expression Builder                                    18
         Printer Control Codes                                 19
         Change Color Set                                      21
             Customizing Color Sets                            21
         Problems & Suggestions                                22
         All About...                                          22
         Edit User Descriptions                                22
         Display/Print Manual                                  22
         Quit                                                  22
     Utilities                                                 23
         Export Mailing List                                   23
             Exporting Different Data Structures               24
         Import Mailing List                                   25
             Importing Different Data Structures               26
             Importing SBT records                             26
         Rebuilding Indices                                    27
         Initializing Databases                                27
         Purging Mailing List                                  27
     Quit to DOS                                               28






















                                     - Page 3 -







                                  TABLE OF CONTENTS


     Appendices                                                29
         Appendix A/ Generic Editor                            29
         Appendix A-1/ System Menu                             36
             Sysmenu edit                                      36
             Foxpro Calculator                                 36
             Foxpro Calendar                                   36
             Foxpro DOS Shell                                  37
             Print Mode                                        37
             Printer Eject                                     37
             Video Mode                                        37
         Appendix B/ Data Files                                38
             Backup/Restore Data files                         39
         Appendix C/ Error Handling                            40
             Verification                                      40
                 Bad Record Count                              40
             Disk Space                                        41
             Printer not Ready                                 41
             Multi-User Errors                                 42
             Syntax Error                                      42
         Appendix D/ Configuring Application                   43
             Foxpro Runtime Unit                               43
                 FOXR.EXE                                      43
                 FOXRW.EXE                                     44
             CONFIG.FP                                         44
                 COLOR SET                                     45
                 EMS                                           45
                 MEMLIMIT                                      45
                 PROGWORK                                      46
                 RESOURCE                                      46
                 TIME                                          47
             FOXPRO.INI                                        48
                 ADD                                           48
                 BORDER                                        49
                 DATA                                          50
                 FONTNAME                                      50
                 FONTSIZE                                      50
                 FONTSTYLE                                     50
                 INIT                                          51
                 LAST                                          51
                 MULT                                          51
                 PROG                                          52
                 RECALL                                        52
                 REFRESH                                       52
                 SYSMENU                                       53
                 TEMP                                          53
                 TERM                                          53
             FOXUSER.DBF                                       54
             FOXUSER2.DBF                                      54
             Printer Codes                                     55
             Record Filters                                    55
             Configuring Sideways                              55
     Glossary                                                  56
     Index                                                     59


                                     - Page 4 -







                                    Introduction


     The dMAIL4 System is a set of programs designed to record and track a
     simple mailing list database.  dMAIL4 is written in a dBASE IV
     compatible language called Foxpro.

     Before continuing, we should explain a couple of terms.  When we refer
     to an "editor", it is a program module that allows us to add, delete,
     or change database records. The word "edit" means to update, maintain,
     or change a database record.

     When we refer to a "window", it is a section of the screen that is
     receiving output.  Windows may overlap each other on the screen.  They
     are characterized by a double line border and usually have some sort
     of title.

     A "record filter" determines the access allowed to a database.  Only
     those records, defined by a record filter, may be viewed, edited, or
     printed.  Record filters are created/selected using an "expression
     builder".

     Finally, when we say "DOS", we refer to the disk operating system.
     It's usually MS-DOS, but could be Microsoft windows, UNIX, or even the
     Macintosh OS.

     The following sections of this manual will describe all available menu
     options, one at a time.  Each menu option will be illustrated.
     Appendices are included to describe all the files in the dMAIL4
     system, the generic operations of editors, error handling, optimizing
     dMAIL4, and establishing a backup procedure.



























                                     - Page 5 -







                                    Introduction


                              Notation Conventions


     CAPITAL LETTERS

          Capital letters indicates a command.  During command entry, this
          text should be entered exactly as it appears.  Unless specified,
          any command may be in upper or lower-case letters.

     lower case

          Parameters to commands are usually typed in lower-case
          characters.

     Ellipsis "..."

          The ellipsis represent repetition of a previous item.

     Single Key "[ ]"

          The single key command is represented by the characters "[" and
          "]".

     Control keys

          Control keys are designated with a "[Ctrl]-" followed by the name
          of another key (for example: [Ctrl]-[S]).  To enter a control
          key, press [Ctrl] on your keyboard and, while holding it down,
          press the additional key.  On some Foxpro menus, control keys are
          designated with a "^" followed by the name of another key (for
          example: ^[End] for [Ctrl]-[End]).

     Carriage Return

          Depending on your keyboard, the same key may be represented by
          different descriptions.  For example, the carriage return may be
          represented as [Enter], [Return], or [Bent arrow symbol].  For
          the most part, this should not be a problem.  Make sure, however,
          that you understand the function of each key so that you
          understand how they appear in this manual.

     Alternate key

          On an IBM PC keyboard, alternate keys are designated with a
          "[Alt]-" followed by the name of another key (for example: [Alt]-
          [V]).  To enter a control key, press [Alt] on your keyboard and,
          while holding it down, press the additional key.

          On a Macintosh keyboard, [Alt] is produced by holding down both
          the [Ctrl] key and the [Option] key.  To produce [Alt]-[V], for
          example, you must press [Ctrl], [Option], and [V] at the same
          time.



                                     - Page 6 -







                               Invoking dMAIL4 System


     The purpose of this section is to help you get started using dMAIL4.
     Your computer should be running and you should be at the DOS prompt
     (in your startup directory).

     You should have already installed the dMAIL4 application and the
     Foxpro runtime unit.  You should also have a functional backup
     procedure (See Appendix B).  To invoke dMAIL4, at the DOS prompt,
     type:

          MAL

     and press [Enter].  All database files are verified (see Appendix C).
     You should see is the following screen:


     +---------------------------------------------------------------------+
                             Mailing List, Version 04.00.00
                      (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      -----------------------  M A I N    M E N U -----------------------
     |                                                                     |
                          E - Create/Edit Mailing List
     |                                                                     |
                          P - Print Mailing List
     |                                                                     |
                          S - System Setup
     |                                                                     |
                          U - Utilities
     |                                                                     |
                          M - Change Status (Single-User)
     |                                                                     |
                          Q - Quit this program
     |                                                                     |
     |---------------------------------------------------------------------|
                               Make a selection:
     +---------------------------------------------------------------------+


     This is our initial screen.  Option 'E' allows you to create and
     maintain all mailing list records.  Option 'P' will print mailing list
     labels or reports.  Option 'S' allows you to change label heights and
     widths.  Option 'U' contain miscellaneous options that allow the user
     to maintain dMAIL4.  Option 'Q' will return you to the DOS prompt.

     By default, dMAIL4 runs in a single-user mode.  Option 'M' is
     available only in multi-user mode.  If you are running in a Multi-user
     environment, you will need to configure dMAIL4 to run Multi-user mode.
     Please refer to Appendix D for more information.

     There are a couple of ways to select an option.  One way is to simply
     press the highlighted key, (example: press [S] for system setup).
     Another way is to press the up and down cursor keys to highlight the
     desired option.  Then, by pressing [Enter], the highlighted option is
     selected.

                                     - Page 7 -







                               Invoking dMAIL4 System



     Note:  If you have a mouse, you can move the mouse cursor to the
     desired option.  Pressing the left mouse button will then select the
     option.


                            Creating Sample Records


     First, we need to create sample data.  At the main menu, press [E].
     You should see the following screen:


     +---------------------------------------------------------------------+
                         Mailing List, Version 04.00.00
                   (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      ----------------------  E D I T    M E N U ------------------------
     |                                                                     |
                         1 - Create/Edit Mailing List
                         2 - Create/Edit State IDs
     |                                                                     |
                         Q - Return to main menu
     |                                                                     |
     |---------------------------------------------------------------------|
                                  Your selection:
     +---------------------------------------------------------------------+


     This is the edit menu.  Here, all components of the mailing list
     system can be maintained.  Option '1' will allow you to maintain each
     mailing list record.  Option '2' will allow you to maintain the two
     character state ID.  Option 'Q' will return you to the main menu.

     Before continuing, notice that the edit window is slightly smaller
     than the main menu window.  This is a built-in feature.  This feature
     allows the user to see how far he/she is into the program.  It is
     intended to give the user a sense of depth.

















                                     - Page 8 -







                           Creating a Mailing List Record


     Creating Mailing List records is simple.  At the edit menu, press [1].
     The following screen will appear:


     +---------------------------------------------------------------------+
                           Mailing List, Version 04.00.00
                       (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      --------------------------- Mailing List --------------------------
      User ID:
      First Name:                       Last:
                 Billing                Shipping
      Address 1 :
      Address 2 :
      City/State:
      Zip Code  :
     |                                                                     |
      Home: (  )    -                   Birth:
      Work: (  )    -                   User Date:
      Soc.Sec. #:   -  -                Active Date:
           [ ] MS-DOS    +------------ Message Memo -------------+
           [ ] CP/M      |                                       |
           [ ] TRSDOS    |                                       |
                         +---------------------------------------+
     |---------------------------------------------------------------------|
             Toggle Index (Last Name)    Toggle Order (Ascending)
             Add    Browse Delete Find   Goto   Help  Update   Quit
     +---------------------------------------------------------------------+


     This screen is typical of a generic editor used with Foxpro.  At the
     bottom of the screen are all the one-character options available to
     the user.

     Like the main menu, there are three ways of selecting a function.  By
     direct keystroke, by the cursor keys and [Enter], or by the mouse.
     Before continuing, we will briefly describe each function.

                                  Add Function

     Pressing [A] will allow you to add a record to the current database.
     The cursor will be positioned on the first field in the record.
     Whether adding or updating a record, there only a few keystrokes you
     need to know.

     You can move the cursor from field to field using the arrow keys.  For
     instance, the Right arrow, the Down arrow, and the Enter key, moves
     the cursor forward one field at a time.  The up arrow moves the cursor
     back one field.

     Note:  If you have a mouse, you also can move from field to field.
     Simply move the mouse cursor to the desired field and press the left
     mouse button.


                                     - Page 9 -







                           Creating a Mailing List Record


     The [Home] key will move the cursor to the beginning of a field.  If
     it is already there, [Home] will move the cursor to the first field in
     the screen.  [End] will move the cursor to the end of the field.  If
     it is already there, [End] will move the cursor to the last field in
     the screen.

     If you need more information on any field, press [F1].  If there is
     help information, a help window will be displayed.  The help window
     will remain until you press either [Esc] or [F10].

     Note:  If you have a mouse, move the mouse cursor to the desired
     field.  Press the right mouse button, once to move to the field, and
     once for the help text.

     After you have entered your data, moving the cursor beyond the last
     input field on the screen tells the editor to accept the record.  You
     can either use the arrow keys to move the cursor, or press [F10].
     [Esc] will abort any updating, returning the screen to its original
     condition.

                                Browse Function

     Pressing [B] will invoke the Foxpro browse function.  The browse
     function will display as many database records as will fit on one
     screen.  You use the arrow keys to move from record to record.
     Pressing [F10] will return you to the edit screen.  The browse
     function is explained in more detail in Appendix A.

                                Delete Function

     Pressing [D] will allow you to delete the currently displayed record.
     You will be prompted whether you are sure.  Pressing [Y] deletes the
     record from the database.

                                 Find Function

     Pressing [F] will invoke the find function.  This option is a quick
     way of finding a desired record.  Since the current database is
     indexed by last name, this option will prompt you for the last name,
     then the first name.  Type the desired customer name, and press
     [Enter].  If found, the desired customer will be displayed.  You could
     then delete it, or update it.

                                 Goto Function

     Pressing [G] will create a pop-up menu.  This popup menu allows the
     user to display different records in the current database.  Press [F]
     for the first record in the database.  Press [L] for the last record.
     Press [N] for the next record.  Press [P] for the previous record.
     The goto window remains active until you press [Esc] or [Q] to quit.
     The goto function is explained in more detail in Appendix A.




                                     - Page 10 -







                           Creating a Mailing List Record


                                 Help Function

     Pressing [H] will display a summary of commands used in the edit menu.
     Pressing any key after that returns you to the edit menu.

                             Toggle Index Function

     For a database with multiple indices, the toggle option will be
     displayed.  The toggle option allows the user to change what index
     will be used with the [F]ind option.  The current index is displayed
     in parenthesis.

     For example, if the current index is by last name, pressing [T] will
     change the current index to zip code.  Upon pressing [F], the user
     will be prompted for the zip code.  Pressing [T], repeatedly, will
     eventually return you to the last name index.

                             Toggle Order Function

     This option toggles the order of the current index.  The current order
     is displayed in parenthesis.

     For example, if the current order is ascending, pressing [O] will
     toggle the order to descending.  If the current index is by last name,
     then 'ALPHA' will come after 'BETA'.  Pressing [O] again will change
     the current index back to ascending.

                                Update Function

     Pressing [U] allows you to update the currently displayed record.
     Like the add function, pressing [F10] will complete the update.
     Pressing [Esc] will abort the update.

                                 Quit Function

     Finally, pressing [Q] will return you the menu that invoked the
     editor.  For more information on the capabilities of this type of
     editor, see Appendix A.


                            Adding a Customer Record


     Now that you have an idea how the editor works, you can add a customer
     record.  Press [A] at the option prompt.

     A customer record has a user id, first name, last name, a billing
     address, and a shipping address.  There is a date of birth and an
     active date field.

     The user id can define a family clan.  The last name, first name, and
     date of birth determine a unique record.  The active date field is
     updated every time you update the current record.


                                     - Page 11 -







                           Creating a Mailing List Record


     For our example, press [Enter] for the user id.  Type "DENNIS" and
     press [Enter] for the first name.  Type "ALLEN" and press [Enter] for
     the last name.

     For billing address, type:

          P.O Box 1
          123 Main St
          Big City , MI  48000

     ...pressing [Enter] on each address field.  When you get to the
     service address, press [Ctrl]-[Home] on each address field.  For each
     service address field, the corresponding billing address field will be
     displayed.  This "repeat" feature should save you a lot of typing.
     For more information about it, see Appendix A.

     Press [Enter] until you see the window titled "Message Memo".  This is
     a memo field.  A memo field may contain any amount of text.  Type text
     as desired.  Then, press [F10] to complete the memo (not the record).

     Notice the three check boxes.  These are user-definable boxes.  Press
     [Space] to toggle a check box.  Press [F10], or press [Enter] until
     the cursor moves past the last input field, to complete the record.
     You will be prompted for another customer record.

     Note: If you need to change the description of these boxes, or change
     the description of the user date field, use option 'S' of the main
     menu.  See System Setup.

     Add other customers, if you wish.  Afterward, press [Esc] to abort the
     add function.  Since we do not need to update any more customers,
     press [Q] to return to the edit menu.























                                     - Page 12 -







                               Creating a State Record


     At the edit menu, we also can edit the state database.  The state
     database ensures that only valid state IDs are typed in the customer
     editor.  At the edit menu, press [2].  You should see the following
     screen:


     +---------------------------------------------------------------------+
                           Mailing List, Version 04.00.00
                       (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      ------------------------- State Editor ---------------------------
     |                                                                     |
                     State      : AK
     |                                                                     |
                     Description: ALASKA
     |                                                                     |
     |---------------------------------------------------------------------|
                                        Toggle Order (Ascending)
            Add    Browse Delete Find   Goto   Help  Update   Quit
     +---------------------------------------------------------------------+


     There should already be records in this database.  The edit functions
     are exactly the same as in the mailing list editor.  Use this editor
     to add a state id.  Since we do not, press [Q] to return to the edit
     menu.


                                      Quit


     Well, that's all you need to know about the edit menu.  Later, you can
     experiment with finding, deleting, and updating records.  For now,
     simply press [Q] to return to the main menu.





















                                     - Page 13 -







                                 Print Mailing List


     In the first half of this manual we learned how to create a mailing
     list record.  Now we are going to learn how to print mailing labels.

     From the previous examples, you should now be at the main menu.  We
     will be printing a record, so make sure your printer is connected and
     on-line.  If not, you may wish to skip this section.  If your printer
     is ready, press [P].  You should see the following screen:


     +---------------------------------------------------------------------+
                          Mailing List, Version 04.00.00
                     (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      ------------------------- P R I N T    M E N U --------------------
     |                                                                     |
                          1 - Print Mailing Labels
                          2 - Print 132 Column Report
                          3 - Print Phone Listing
     |                                                                     |
                          Q - Return to main menu
     |                                                                     |
     |                                                                     |
     |---------------------------------------------------------------------|
                                  Your selection:
     +---------------------------------------------------------------------+


     The menu is simple and self-explanatory.  Option '1' allows you to
     print mailing labels up to 5 addresses across.  Option '2' will print
     a standard 132 column report.    Option '3' will print a standard 80
     column report.  Option 'Q' will return you to the main menu.


                            Printing Mailing Labels


     Option '1', of the print menu, introduces the concept of the option
     grid.  At the print menu, press [1].  You should see the following
     screen:
















                                     - Page 14 -







                                 Print Mailing List


     +---------------------------------------------------------------------+
                         Mailing List, Version 04.00.00
                   (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      ---------------------- Mailing Labels --------------------------
     |                                                                     |
      User ID:
      First Name:                       Last:
     |                                                                     |
      Address 1 :                       Address Type:
      Address 2 :
      City/State:
      Zip Code  :
     |                                                                     |
      Home: (  )    -                   Birth      :   /  /    /  /
      Work: (  )    -                   User Date  :   /  /    /  /
      Soc.Sec. #:   -  -                Active Date:   /  /    /  /
           [ ] MS-DOS    +------------ Message Memo -------------+
           [ ] CP/M      |                                       |
           [ ] TRSDOS    |                                       |
                         +---------------------------------------+
           Index File:                    Order:
     |---------------------------------------------------------------------|
                 Print   Screen    Help   Update    Quit
     +---------------------------------------------------------------------+


     You are given an option grid.  The option grid will look like the
     dMAIL4 edit window.  The option grid prompts will determine what
     records will be printed and in what order.  For example, specifying
     "MI" for state will print all customers within the state of Michigan.

     Most fields provide this wild-carding technique.  Exceptions are the
     date fields.  The date fields provide beginning and/or ending dates.

     For example:  An active date of "01/01/91" will print only those
     customers that have been active since January 1, 1991.  An active date
     range of "01/01/91" to "12/31/93" will print those customers that have
     been active in the years 1991, 1992, and 1993.

     The address type field is useful for those reports that can print
     either the billing or the shipping address, but not both.  Specifying
     an address type of "S", for example, prints only shipping addresses.

     The message window can be very useful.  This is not a memo window, but
     allows you to search the memo window.  For example, typing "Hi there"
     and pressing [Enter] will search all records for a memo that contains
     "Hi there".  To continue, typing "Hello" and pressing [Enter] will
     include "hi there" or "hello" in the search.

     Note:  In a text window, you need to use [Tab] or [Shift]-[Tab] to
     exit.



                                     - Page 15 -







                                 Print Mailing List


     From this option grid, you are also allowed to select the index file
     and index order.  These field are the push button equivalent to the
     toggle index/toggle order found in the mailing list editor.

     Press [F10] to complete the option grid.  You will be given a menu of
     choices, depending on the report.  You can press [U] to update the
     option grid.  You can press [H] for help, or press [Q] to quit to the
     print menu.

     Pressing [S] for screen mode, or [P] for print mode, will start
     creating a print file.  During this operation, you can abort by
     pressing [Esc].

     If you pressed [S], you will see the report displayed upon the screen.
     Press [Pgup] or [Pgdn] to view the report.  Press [Esc] or [F10] to
     return to the option grid.

     Pressing [P] will copy the report to the printer.  When you are
     finished, press [Q] to return to the print menu.

     Note:  If you need to adjust the printer device, printer controls,
     label widths, or label lengths, use option S of the main menu.  See
     System setup.


                                      Quit


     Option '2' of the print menu prints a 132 column report of the mailing
     list database.  This report includes names, addresses, dates, check-
     boxes, and notes.  The same option grid used in mailing labels is
     provided.

     Option '3' of the print menu prints a phone listing of the mailing
     list database.  Records containing the same address and phone numbers
     are concatenated in the listing.  The same option grid used in mailing
     labels is provided.

     When you have experimented enough, press [Q] at the print menu to
     return to the main menu.















                                     - Page 16 -







                                    System Setup


     Option 'S' of the main menu offers several facilities.  Among them,
     the ability to change printer control codes.  Upon pressing [S] at the
     main menu, you should see the following:


     +---------------------------------------------------------------------+
                             Mailing List, Version 04.00.00
                      (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      -------------------  S Y S T E M   S E T U P  ---------------------
     |                                                                     |
                          1 - Edit Expression Builder
                          2 - Edit Printer Control Codes
                          3 - Change Color Set
                          4 - Problems & Suggestions
                          5 - All about...
                          6 - Edit User Descriptions
     |                                                                     |
                          M - Display/Print Manual
     |                                                                     |
                          Q - Quit this Menu
     |                                                                     |
     |---------------------------------------------------------------------|
                                Your selection:
     +---------------------------------------------------------------------+


     Option '1' will invoke the expression builder.  The expression builder
     creates a record filter.  A record filter defines those records that
     can be viewed, edited, and printed.

     Option '2' allows you to change printer control codes.  It also allows
     you to change mailing label dimensions.

     Option '3' will allow you to change the current color set.  If you
     don't like the colors used by dMAIL4, this option lets you change
     them.

     Option '4' will allow you to leave a message to the application
     author.  Messages can point out a problem or can offer a suggestion.

     Option '5' will display status information about this application.
     What version of Foxpro is running and about much memory is available.

     Option '6' allows you to define the check boxes used in the mailing
     list editor.

     Option 'M' allows you to display and/or print the user manual.  Option
     'Q' returns you to the main menu.






                                     - Page 17 -







                                    System Setup


                               Expression Builder


     The expression builder allows you to select a record filter from a
     list of record filters.  A record filter defines those records in a
     database that can be viewed, edited, or printed.  The record filter is
     in effect only while your application is running.  Filters can be
     redefined as often as desired.

     At the system setup menu, press [1].  Upon entry, you are given a list
     of existing record filters.  Chose an existing filter.  For example,
     move the cursor to the filter named "Recent Active".  Press [Enter].
     The filter "Recent Active" is now active and will allow you to view
     only people having an active date changed in the last 12 months.

     You also might want to create a record filter.  At the system setup
     menu, press [1].  Press [F10] for the menu and press "N" to create an
     expression.  Enter "State of Michigan" for the name of your
     expression.  You will be given a choice of the custom expression
     builder, or the Foxpro expression builder.  Unless you know how to use
     the Foxpro expression builder, select the custom builder.

     You will be given a popup list of available field names.  Select the
     field "State".  The next popup will display the action that can be
     taken on "State".  Select the popup "is exactly like".  Now you will
     be prompted for a character string.  Type "MI" and press [Enter].

     The record filter is displayed.  You may add, delete, or edit phrases
     in the expression.  But just press [F10] to accept the current one.

     That's all there is to it!  You've created a filter that views only
     people from the state of Michigan.  Press [Enter] to select the
     filter.  You will be returned to the system setup menu.  If you don't
     want to use this filter, simply return to the expression builder and
     press [Esc] to abort.

     Note:  If you are running on a network, see Appendix D:  Record
     filters.

















                                     - Page 18 -







                                    System Setup




                             Printer Control Codes


     At the setup menu, press [2].  The following screen will be displayed:


     +---------------------------------------------------------------------+
                          Mailing List, Version 04.00.00
                     (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      --------------------- S Y S T E M   S E T U P ---------------------
     |                                                                     |
                    Printer Name         : Default
                    Printer Device       : PRN
                    Printer Default      : CHR(27)+"@"
                    Printer 10 cpi       :
                    Printer 12 cpi       :
                    Printer Condense On  :
                    Printer Bold      On :
                    Printer Bold      Off:
                    Printer Underline On :
                    Printer Underline Off:
     |                                                                     |
                    Number of Straight Lines/Page:
                    Number of Sideways Lines/Page:
     |                                                                     |
                    Print in Draft mode?
     |---------------------------------------------------------------------|
              Press [ESC] to abort and return to main menu...
     +---------------------------------------------------------------------+

                                  Printer Name


     The printer name is simply identifies the current configuration.  If
     the database P_CODES.DBF is available, you may press [F1] for a list
     of all available printers.  A selection changes all printer codes to
     the selected printer.  Press [F10] to complete the screen.

                                 Printer Device

     The printer device defines where output is to be sent.  Typically, you
     would use LPT1 or LPT2.  In the Multi-user environment, this option
     also allows you to define the network spooler.









                                     - Page 19 -







                                    System Setup


                                 Printer Codes

     If you have an 80 column printer, define the control codes required by
     your printer to invoke compressed printing.  These control codes are
     sometimes referred to as 16.7 or 17 characters per inch.  Also define
     the control codes required to cancel condensed printing.  These
     control codes are sometimes referred to as the default.  dMAIL4 will
     use these codes for reports normally requiring a 132 column printer.
     Printer control codes are specified with dBASE expressions such as:

     CHR(27) + CHR(64)

     or:


     CHR(27) + '@'

     In general, most printer manuals give printer control strings as BASIC
     programming statements using the BASIC function CHR$().  The dBASE
     CHR() function is identical, so simply removing the "$" sign from the
     examples in your printer manual should do the job.

     Note:  If you press [F1], you will see a browse popup of available
     printers.  Simply select your printer and press [Enter].  All printer
     codes will be converted to the selected printer.

                            Straight lines per page

     To this day, there are some printers that do not accept form feeds.
     So rather than asking for form feed code, dMAIL4 asks for the number
     of lines per page.  Most printers use 66 lines.  Laser printers
     usually need 66 lines, though some may need 57 lines.

                                    Sideways

     It is sometimes necessary to print large reports using a sideways
     print utility.  So in case it is ever needed, the system setup prompts
     for the number of lines to print sideways.  For an 80 column printer,
     use 53 lines. For a 132 column printer, use 90 lines.

                                   Draft mode

     A report option grid creates a report file.  From the option grid,
     there are two ways to print this file:  Draft mode and non-draft mode.
     In draft mode, the report file is copied directly to the print device.
     Under MS-DOS Windows, draft mode bypasses the print spooler.  In non-
     draft mode, the report file is still copied to the print device, but
     through any and all print spoolers.

     Non-draft mode is only needed when you want the print spooler to
     control font and font pitch.  In that case, set all printer codes to
     empty via double quotes ("").  Otherwise, the printer codes will show
     up on your report.


                                     - Page 20 -







                                    System Setup


                                 Mailing Labels

     Press [F10].  After the initial setup screen, you are prompted for
     Mailing Label information.  That is, label width, number of columns
     between labels, and number of rows between labels.  The column width
     determines the number of characters allowed for each label.  Pressing
     [F10] completes the screen and returns you to the system menu.


                                Change Color Set


     A Foxpro color set defines all color attributes used by this
     application.  Upon pressing [3] at the system setup, a popup menu will
     display all the different color sets available.  These color sets
     reside within the Foxpro resource file (FOXUSER.DBF).  Use the cursor
     keys to highlight the desired color set.  Then, select by pressing
     [Enter].

                             Customizing Color Sets


     A new feature has been added to the color selector.  The user now has
     the ability to customize colors.  Once a color has been selected, the
     color selector will search for a second Foxpro resource file
     (FOXUSER2.DBF).  In this file, color sets are stored in ASCII text
     format.

     If you are a system administrator, you will be prompted whether to
     edit the ASCII text of your selected color set.  The text layout is
     simple.  Twelve lines for the twelve color schemes used by this
     application.  Each line contain ten color pairs.  A color pair
     "W*/B+", for example, would denote a white foreground, blue background
     ("*" denotes blinking and "+" denotes intensity).  For a description
     of color pairs used within a scheme, check the color picker portion of
     the Foxpro manual.

     Experiment with different color sets.  Note that the top of the screen
     may not change color until you exit and reenter the application.  Be
     warned, however.  The color set becomes permanent until the next time
     you select a different color.

     Note:  The second Foxpro resource file can only be created and edited
     by the system administrator.











                                     - Page 21 -







                                    System Setup




                             Problems & Suggestions


     Upon pressing [4], you will be presented with a memo window.  Type any
     message you wish to leave the application programmer.  Press [F10] to
     complete the message, or [Esc] to abort.  Your message will be placed
     in the Foxpro error file (FOXERR.DBF).

     If you have already created messages, you may wish to modify them.  A
     browse, indicating the date and time of each message, will be
     displayed.  Select the desired message record.  Then, press [Ctrl]-
     [Pgdn] to expand the message window.


                                  All About...


     Option '5', of the system menu, will display status information about
     this application.  What version of Foxpro is running, about much
     memory is available, and the different kinds of application modes
     (Multi-user, debug, system administration).  This option will also
     tell you how the various data paths are defined.


                             Edit User Descriptions



     Option '6', of the system menu, allows you to define the check boxes
     that appear in the mailing list editor and the mailing list option
     grids.  You may also define the message text that appears when you
     update a check box.


                              Display/Print Manual



     Option 'M', of the system menu, will display the user manual.  You may
     use [PgUp] or [PgDn] to view various pages.  You may print the entire
     user manual by pressing [Alt]-P].  Press [Esc] to return to the system
     setup menu.


                                      Quit


     Before leaving the system setup menu, a reminder.  Record filters
     remain in effect only for the duration of the application.  Color sets
     and printer control codes, on the other hand, are permanent.  When you
     have experimented enough, press [Q] at the system setup menu to return
     to the main menu.

                                     - Page 22 -







                                      Utilities


     Option 'U' of the main menu provides the miscellaneous options needed
     to maintain the mailing list system.  Upon pressing [U] at the main
     menu, you should see the following:


     +---------------------------------------------------------------------+
                             Mailing List, Version 04.00.00
                      (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      -------------------  U T I L I T Y    M E N U ---------------------
     |                                                                     |
                          1 - Export Mailing List
                          2 - Import Mailing List
     |                                                                     |
                          A - Rebuild indices
                          B - Initialize Databases
                          C - Purging Mailing List
     |                                                                     |
                          Q - Quit this Menu
     |                                                                     |
     |---------------------------------------------------------------------|
                                Your selection:
     +---------------------------------------------------------------------+


     Option '1' will export mailing list records to a variety of file
     formats.  Option '2' will import mailing list records from a variety
     of file formats, including any created by option '1'.

     Option 'A' reconstructs all system indices in the event of a crash or
     other strange system behavior.  Option 'A' also removes deleted
     records, thereby reclaiming disk space.

     Option 'B' will allow you to reset any or all database files in the
     dMAIL4 system.  Option 'C' will allow you to delete specified records
     from the mailing list database.  Option 'Q' will return you to the
     main menu.

     Note:  Options 'A', 'B', and 'C' are available only in single-user
     mode.  Options 'B' and 'C' are only available to the system
     administrator.  See Appendix D.


                              Export Mailing List


     We will discuss how to transfer records between two single-user
     computers.  Once you understand it, the process is simple.  Say, for
     example, we wish to transfer our mailing list to another computer.
     Assuming the other computer is also running the dMAIL4 system, press
     [1] at the utility menu.  You will be given a selection of file
     formats.  For our example, select '1' for the foxbase plus format.



                                     - Page 23 -







                                      Utilities


     You will be given the option grid.  The same option grid available in
     option "1" of the print menu.  Complete the grid and press [F10].  You
     will be given several choices.  You can press [U] to update the option
     grid, [Q] to quit, or [C] to continue.  For our sample, press [C] to
     continue.

     A temporary file is created, containing our selected records.  You
     will then be prompted for the export file name.  Type 'A:TEMP.DBF' and
     press [Enter].  Since the file name contains 'A:' (or 'B:'), you will
     be prompted whether to format the floppy.  Insert your disk into 'A'
     drive, and press 'Y'.  It takes a few moments to format the floppy and
     transfer the mailing list records onto it.  You will be returned to
     the utility menu.

     Note:  Be careful.  The size of the floppy disk limits us to how many
     records can be transferred at one time.


                      Exporting Different Data Structures


     Recently, I've added the ability to export files with different data
     structures.  Select 'Foxpro DBF File' from the list of export file
     formats.

     After entering the option grid and the export file name, you will be
     given a popup of all the field names in the export database.  Select
     the one you need and press [Enter].  You may then enter the correct
     field or field phrase from the mailing list file.  You may repeat
     these prompts as often as desired, until you select the empty field.

     For example, I used the following to convert the mailing list to my
     local astronomy club database:


          REPLACE:  FIRST_NAME     WITH:     FIRST
          REPLACE:  LAST_NAME      WITH:     LAST
          REPLACE:  ADDRESS        WITH:     ADDR_1
          REPLACE:  PHONE          WITH:     SUBSTR(HOME,7)
          REPLACE:  COMMENTS       WITH:     MESS


     Please note that all common field names, such as 'CITY' or 'ZIP', did
     not need to be specified.











                                     - Page 24 -







                                      Utilities


                              Import Mailing List


     Once the diskette is made, remove it from 'A' drive and take it to the
     other computer.  Insert the floppy in the other computer's drive A and
     close the door.  Make sure the dMAIL4 system is running on that
     machine and that you are at the utility menu.  To read that database
     off the diskette, simply press [2] at the utility menu.  You will be
     given a selection of file formats.  For our example, select '1' for
     the Foxbase Plus.

     You will be prompted for the file name.  Type 'A:TEMP.DBF' and press
     [Enter].  A temporary file is created.  It takes a few moments to
     transfer records from the floppy to the temporary file.

     You will be given the option grid.  The same option grid available in
     option "1" of the print menu.  Complete the grid and press [F10].  You
     will be given several choices.  You can press [U] to update the option
     grid, [Q] to quit, or [C] to continue.  For our sample, press [C] to
     continue.

     Only those records, meeting the option grid, will be transferred from
     the temporary file.  If there are any duplicate records, only the most
     recent records will be appended.  You will be returned to the utility
     menu.

     Note:  When all records have been transferred, remove the floppy disk.
     It is always a good practice to remove the floppy diskette when not in
     use.


























                                     - Page 25 -







                                      Utilities


                      Importing Different Data Structures


     Recently, I've added the ability to import files with different data
     structures.  Select 'Foxpro DBF File' from the list of import file
     formats.

     After entering the import file name, you will be given a popup of all
     the field names in the mailing list database.  Select the one you need
     and press [Enter].  You may then enter the correct field or field
     phrase from the import file.  You may repeat these prompts as often as
     desired, until you select the empty field.

     For example, the import file may have a first name field called
     'FNAME'.  You would, therefore, select the dMAIL4 field 'FIRST'.  Then
     you type the field phrase 'FNAME'.  The field phrase can be a
     combination of field names or dbase expressions.  I, myself, used the
     following to convert my local astronomy club database to dMAIL4:


          REPLACE:  FIRST          WITH:     FIRST_NAME
          REPLACE:  LAST           WITH:     LAST_NAME
          REPLACE:  ADDR_1         WITH:     ADDRESS
          REPLACE:  MESS           WITH:     COMMENTS
          REPLACE:  HOME           WITH:     '(616) '+PHONE
          REPLACE   ACT_DATE       WITH:     DATE()
          REPLACE   BOL_1          WITH:     'm'$STATUS
          REPLACE   BOL_2          WITH:     'i'$STATUS


     Please note that all common field names, such as 'CITY' or 'ZIP', did
     not need to be specified.  Also note that I converted the import field
     'STATUS' to the dMAIL4 check boxes.


                             Importing SBT Records


     The import procedure now has the ability to import customer records
     from SBT Receivables.  If any check boxes are defined as 'Employee',
     then any imported employee record will have it's check box marked.

     The import procedure has the ability to import vendor records from SBT
     Payables.  If any check boxes are defined as 'Vendor', then any
     imported vendor record will have it's check box marked.

     This procedure also has the ability to import employee records from
     SBT Payroll.  If any check boxes are defined as 'Employee', then any
     imported employee record will have it's check box marked.  Only active
     employees are imported.





                                     - Page 26 -







                                      Utilities


                               Rebuilding Indices


     Option 'A' of the utility menu will reconstruct all system indices in
     the event of a crash or other strange system behavior.  You will be
     prompted whether to continue.  Upon pressing [Y], all indices will be
     rebuilt.  Option 'A' also removes deleted records, thereby reclaiming
     disk space.  You will then be returned to the utility menu1.


                             Initializing Databases


     Option 'B' of the utility menu will allow you to "reset" any or all
     database files in the dMAIL4 system by removing all data from them.
     You probably will want to use this option after completing the sample
     entries and exercises in this manual, so you can begin fresh with
     "real" data.

     Upon press [B] at the utility menu, you will be prompted whether to
     reset each database file, one at a time.  You will then be returned to
     the utility menu2.


                              Purging Mailing List


     Option 'C' of the utility menu allows you to delete specified mailing
     list records.  You will be given the option grid.  The same option
     grid available in option "1" of the utility menu.  Complete the grid
     and press [F10].  You will be given several choices.  You can press
     [U] to update the option grid, [Q] to quit, or [C] to continue.

     If you were to press [C], then all specified records will be deleted
     from the mailing list database.  You would be returned to the utility
     menu3.  Since, however, we do not wish to delete any records, press
     [Q] to return to the utility menu.  When you have experimented enough,
     press [Q] at the utility menu to return to the main menu.












     ____________________
     1 Not available in Multi-user mode.  See Appendix D.
     2 System Administration function only.  See Appendix D.
     3 System Administration function only.  See Appendix D.

                                     - Page 27 -







                                     Quit to DOS


     Once you have returned to the main menu, press [Q] to return to the
     DOS ready.  It is VERY important that you do not leave the dMAIL4
     System without returning to DOS.  NEVER turn off the machine while in
     the dMAIL4 system.  Doing so may result in file corruption and lots of
     headaches to us developers.

     This concludes the system overview.  If you wish to know more about
     the mailing list editor, or any other editor in the dMAIL4 system, see
     Appendix A.  If you wish to know about the file layouts, see Appendix
     B.  If you ever see the infamous error message "Ignore, Retry,
     Suspend, or Quit", see Appendix C.  If you wish to install the multi-
     user mode, see Appendix D.











































                                     - Page 28 -







                                     Appendix A


     This section describes all characteristics, in detail, of the generic
     editor used in this type of Foxpro application.  While this editor may
     be customized for many applications, all share common functions.
     Thus, to learn one version is to know another version.

     This type of Foxpro application usually has an edit menu.  This menu
     allows the user to invoke one or more editors.  The following is an
     example of the edit menu used in the dMAIL4 System:


     +---------------------------------------------------------------------+
                         Mailing List, Version 04.00.00
                   (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      ----------------------  E D I T    M E N U ------------------------
     |                                                                     |
                         1 - Create/Edit Mailing List
                         2 - Create/Edit State IDs
     |                                                                     |
                         Q - Return to main menu
     |                                                                     |
     |---------------------------------------------------------------------|
                                  Your selection:
     +---------------------------------------------------------------------+


     In this edit menu, the user has the option to use two editors.  Each
     editor allows the user to maintain separate, but related, databases in
     the dMAIL4 System.  While we really don't need to go any further, but
     it is good to know where most editors are invoked.

     Once a generic editor is invoked, its window will be displayed.  The
     window consists of a window title, field descriptions, and all fields
     of the database record that happens to be current.  A menu window is
     also displayed.  The menu window contains all the one-character
     options available to the user.  The following is a sample screen of
     the mailing list editor used in the dMAIL4 System:


















                                     - Page 29 -







                                     Appendix A


     +---------------------------------------------------------------------+
                           Mailing List, Version 04.00.00
                       (c) 1987 Dennis Allen, All rights reserved
     |                                                                     |
      --------------------------- Mailing List --------------------------
      User ID:
      First Name:                       Last:
                 Billing                Shipping
      Address 1 :
      Address 2 :
      City/State:
      Zip Code  :
     |                                                                     |
      Home: (  )    -                   Birth:
      Work: (  )    -                   User Date:
      Soc.Sec. #:   -  -                Active Date:
           [ ] MS-DOS    +------------ Message Memo -------------+
           [ ] CP/M      |                                       |
           [ ] TRSDOS    |                                       |
                         +---------------------------------------+
     |---------------------------------------------------------------------|
             Toggle Index (Last Name)    Toggle Order (Ascending)
             Add    Browse Delete Find   Goto   Help  Update   Quit
     +---------------------------------------------------------------------+


     All editors have the same basic functions.  Before continuing, we will
     describe each function in detail.

                                  Add Function

     Pressing [A] will allow you to add a record to the current database.
     The cursor will be positioned on the first field in the record.  Now
     whether adding or updating a record, there only a few keystrokes you
     need to know.

     You can move the cursor from field to field using the arrow keys.  For
     instance, the Right arrow, the Down arrow, and the [Enter] key, moves
     the cursor forward one field at a time.  The left arrow and up arrow
     will move the cursor back one field.

     Note:  If you have a mouse, you also can move from field to field.
     Simply move the mouse cursor to the desired field and press the left
     mouse button.

     The [Home] key will move the cursor to the beginning of a field.  If
     the cursor is already there, [Home] will move the cursor to the first
     field in the screen.  The [End] key will move the cursor to the end of
     the field.  If the cursor is already there, [End] will move the cursor
     to the last field in the screen.

     If you need more information on any field, press [F1].  If there is
     help information, a help window will be displayed.  The help window
     will remain until you press either [Esc] or [F10].

                                     - Page 30 -







                                     Appendix A



     Pressing [Ctrl]-[Home] will repeat the last text that was displayed in
     the current field.  This function provides a convenient means of
     adding many records with similar field descriptions.

     Once you have entered your data, moving the cursor beyond the last
     field on the screen tells the editor to accept the record.  Pressing
     [F10] also will tell the editor to accept the record.  You would then
     be prompted to add another record.  The [Esc] key will abort the add
     function, returning the screen to its original condition.

                                Browse Function

     Pressing [B] will invoke the Foxpro browse function.  The browse
     function will display as many database records as will fit in one
     window.  You can use the left arrow, right arrow, [Tab], and [Shift]-
     [Tab] keys to move the cursor from field to field.  You can move from
     record to record with the up and down arrow keys.  You use the page
     up/down keys to display the next/previous window of records in the
     current database.

     If you have a mouse, you also can use the characters located on the
     right side of the window.  Place the mouse cursor on the up/down arrow
     characters and press the left button to move one record at a time.
     The diamond character show where you're located in relation to the
     rest of the database.  Place the mouse cursor on the diamond and press
     the left button.  Dragging the diamond will re-position you in the
     database.

     Mouse Note:  After you found the record you want, place the mouse
     cursor on the record and press the left button.  Otherwise, the first
     time you try to update a record will put you back to the last record
     displayed before using the mouse.

     If there are more fields than can be displayed in one window, pressing
     [TAB] will scroll to the next field.  Pressing [Shift]-[TAB] will
     scroll back one field.

     If you have a mouse, you also may use the characters located across
     the bottom of the window.  Place the mouse cursor on the left/right
     arrow characters and press the left button to move one field at a
     time.  The diamond character show where you're located in relation to
     the rest of the database.  Place the mouse cursor on the diamond and
     press the left button.  Dragging the diamond will re-position the
     fields displayed in the database.

     Mouse Note:  After you found the field you want, place the mouse
     cursor on the field and press the left button.  Otherwise, the first
     time you try to update a field will put you back to the last field
     displayed before using the mouse.





                                     - Page 31 -







                                     Appendix A


     In the browse function you may edit any field as desired.  Press
     [Ctrl]-[N] to add a record from the browse.  Press [Ctrl]-[T] to
     delete the current record from the browse.  When finished, press
     [F10] to return to the edit menu.  Pressing [Esc] also will return you
     to the edit menu, but it will abort any change to the current record.

     Note:  The JKEY incremental search has recently been added to the
     browse command.  When performing a browse, press [Ctrl]-[J] to
     activate JKEY.  A search will begin on the current index.  Each new
     keystroke will be added to the search string and the record, closest
     matching to the current string, will be displayed.  You may press
     [BackSpace] to revise the search string, or press [Ctrl]-[Y] to clear
     it.  To abort JKEY, simply press [Ctrl]-[J] once again (or [Esc] to
     abort the browse).

                                Delete Function

     Pressing [D] will allow you to delete the currently displayed record.
     You will be prompted whether you are sure.  Pressing [Y] deletes the
     record from the database.

                                 Find Function

     Pressing [F] will invoke the find function.  This option is only
     available if a database is indexed.

     If invoked, you would type the key of the desired record, and press
     [Enter].  If found, the record would be displayed.  You could then
     delete it, or update it.


     Note:  The key doesn't have to be a complete description.  For
     incomplete keys, the find function will try to find the record with
     the closet matching key.

     Recently, wild-carding has been introduced into the [F]ind function.
     For example, suppose we have a customer file.  It has an index by last
     name.  When the find function prompts us, we could type:

          Last Name:  ..ll..

     In this example, we are searching for a customer whose last name
     contain a "ll".  In another example:

          Last Name:  ..en

     We are searching for a customer whose last name ends with "en".  In
     one more example:

          Last Name:  al..

     We are searching for a customer whose last name begins with "al".



                                     - Page 32 -







                                     Appendix A


     Here's where wild-carding get interesting.  Let's use the first
     example.  Say we find a customer whose last name contains a "ll".  If
     we use the [G]oto function, we get an extra option.  This option,
     called [C]ontinue, will allow us to find the next customer whose last
     name contains a "ll".

     The continue option will remain in effect until you perform another
     find.  It will search for the next wild-card occurrence no matter
     where you are in the database.  In that sense, think of wild-carding
     as an implicit record filter.

     Oh, a new feature has been added to wild-carding:  The triple period
     "...".  Like the double period "..", the triple period denotes wild-
     carding.  Using the triple, however, will also disable the current
     index during the search.

     You see, wild-card searches are a LOT faster when done on an unordered
     database.  So if you are looking for just one record or two records,
     don't care about viewing order, and are using a huge database, the
     triple period might save you valuable time.

                                 Goto Function

     Pressing [G] will create a pop-up menu.  This popup menu allows the
     user to display different records in the current database.  Press [F]
     for the first record in the database.  Press [L] for the last record.
     Press [N] for the next record.  Press [P] for the previous record.
     The goto window remains active until you press [Esc] or [Q] to quit.

     If the current database is indexed, order is defined by the toggle
     order function.  For example, if the current record is customer 5,
     pressing [N] will display customer 6.  If the index order is
     descending, however, pressing [N] will display customer 4.  See toggle
     index order.

     A new option, [W] for window, has been added.  Pressing [W] activates
     the goto window.  The user may then move the goto window to any
     location on the screen.  That location remains in effect for the
     duration of the editor.

     To move the window, press [Ctrl]-[F7].  The goto window border will
     flash.  Press any cursor key to move the window.  Press [Ctrl]-[F7] to
     stop the window from flashing.  Then press [Esc] to resume the normal
     goto prompts.

     Note:  You also may use a mouse to move the goto window.  Press [W].
     Place the mouse cursor on the border of the goto window.  Press the
     left button.  Drag the mouse cursor (and window) to the desired
     location.  Then, press the right button to resume the goto prompts.






                                     - Page 33 -







                                     Appendix A


                                 Help Function

     Pressing [H] will display a summary of commands used in the edit menu
     as in the following screen.  Pressing any key after that returns you
     to the edit menu.


         Command prompt

         [T]oggle Index -  Change Index used by [F]ind command
         Toggle [O]rder -  Current Index in Ascending/Descending Order

         [A]dd        -  Add a record to the current database
         [B]rowse     -  List all records a page at a time
         [D]elete     -  Delete the currently displayed record
         [F]ind       -  Search database for record with specified key
         [G]oto       -  Display the First, Last, Next, or Previous record
         [H]elp       -  Display help information
         [R]ecall     -  Recall Deleted Records
         [U]pdate     -  Update the currently displayed record
         [Q]uit       -  Return to calling program

         Common full screen keystrokes

         [ESC]        -  Abort operation, return to prompt/menu
         [HOME]       -  move cursor to beginning field
         [END]        -  move cursor to ending field
         [CTRL][HOME] -  repeat last input field completed
         [CTRL][END]  -  Complete operation, return to prompt/menu
         [F1]         -  Display Help text
         [F10]        -  Complete operation, return to prompt/menu
























                                     - Page 34 -







                                     Appendix A



                                Recall Function

     Pressing [R] allows you to recall a deleted record.  You will be
     presented with a browse window of all deleted records.  Simply locate
     the record to be recalled and press [Enter].

     Note:  If the current database has no deleted() index, you will be
     prompted for the record key (just like the find function).  Type the
     key of the record to be recalled and press [Enter].  If the deleted
     record is found, it is made active again.


                             Toggle Index Function

     For databases with multiple indices, the toggle option will be
     displayed.  The toggle option allows the user to change what index
     will be used with the [F]ind option.  The current index is displayed
     in parenthesis.

                             Toggle Order Function

     This option toggles the order of the current index.  The current order
     is displayed in parenthesis.

     For example, if the current order is ascending, pressing [O] will
     toggle the order to descending.  If the current index is by last name,
     then 'ALPHA' will come after 'BETA'  Pressing [O] again will change
     the current index back to ascending.

                                Update Function

     Pressing [U] allows you to update the currently displayed record.
     Like the add function, moving the cursor past the last field will
     complete the updating.  Pressing [Esc] will abort any update.

                                 Quit Function

     Finally, pressing [Q] will quit the editor.  You will be returned to
     the menu that invoked the editor.















                                     - Page 35 -







                                    Appendix A-1




     If you ever been on an input field, you may have noticed that pressing
     [Alt] displays a menu at the very top of the screen.  This is called
     the system menu, or sysmenu for short.  The system menu displayed is a
     customized version of the Foxpro sysmenu.  It contains a variety of
     functions and is available to all users.  The following describes only
     a few features available through the sysmenu.  For more information,
     see the Foxpro users manual.


                                  Sysmenu edit


     The sysmenu edit popup is very powerful.  It gives any input field a
     variety of edit functions.  For example, highlighting a section of
     text ([Shift] and cursor key) and pressing [Del] will delete this
     text.  But [Ctrl]-[C] would have copied this text into the clipboard.
     You would then use [Ctrl]-[V] to paste this text.

     Note:  The sysmenu edit popup provides a [Ctrl]-[U] option to undo a
     deletion, copy, cut, or paste.

     Another example:  Suppose you are editing a memo field.  The sysmenu
     edit popup provides a [Ctrl]-[F] option to find specified text.  This
     popup also provides a [Ctrl]-[G] option to repeat the last find.

     There are other functions in the sysmenu edit popup.  See the Foxpro
     users manual for details.


                               Foxpro Calculator


     Simply enter a numeric value on any input field.  Press [Alt]-[F4] to
     activate the Foxpro calculator.  The Foxpro calculator will display
     your numeric value.

     When you have a new calculated value, press [Ctrl]-[F4] to deactivate
     the calculator.  Your new numeric value will be placed into the
     current input field.

     Note:  If you just want the calculator, press [F4].  To close, mouse
     click on the upper left button of the calculator and select [Close].


                                Foxpro Calendar


     Simply enter a date on any input field.  Press [Alt]-[F5] to invoke
     the Foxpro calendar.  The Foxpro calendar will display the year,
     month, and day of the specified date.



                                     - Page 36 -







                                    Appendix A-1


     Select any desired date.  When you have a new date, press [Ctrl]-[F5]
     will deactivate the calendar.  Your new date will be placed into the
     current input field.

     Note:  If you just want the calendar, press [F5].  To close, mouse
     click on the upper left button of the calendar and select [Close].


                                Foxpro DOS Shell


     In Foxpro for DOS, the system pulldown menu provides a DOS shell.  If
     you are a system administrator, pressing [Alt]-[S] [O] brings up the
     DOS command window.  Type any desired DOS command.  Type 'EXIT' and
     press [Enter] to leave the DOS shell.


                                   Print Mode


     In Foxpro for windows, you can print the contents of the current
     window using the 'Print' option of the 'File' popup in sysmenu.  The
     'Print' option is equivalent to printing a report in non-draft mode.
     See system setup, printer codes.

     Note:  'Print' is not currently available in the Foxpro for windows
     runtime unit.


                                 Printer Eject


     Press [F7] for a page eject.  You will be prompted for a form feed.
     If you select [Y], a form feed will be sent to the current printer
     device.  See System Setup, printer codes.  This option is very useful
     for people with Laser Printers.

                                   Video Mode


     Press [Alt]-[V] for the video mode.  In Foxpro for DOS, a VGA screen
     will toggle between 25 and 43 line modes.  All subsequent windows will
     conform to the specified mode.  Very useful in displaying reports.

     In Foxpro for windows, [Alt]-[V] will display a font selector.  All
     sub-windows, to the current window, will conform to the specified
     font.  If you change the main menu window, the font becomes permanent
     to the user.







                                     - Page 37 -







                                     Appendix B


     The dMAIL4 System contains the following files:

     BACK     BAT    DBFS     PRG    EXPRMENU PRG    FOXERR   DBF
     FOXERR   FPT    FOXUSER  DBF    FOXUSER  FPT    MAIL     CDX
     MAIL     DBF    MAIL     FPT    MAL      BAT    MAL      MAN
     MAL      PRG    MALCF    PRG    MALED    PRG    MALED1   PRG
     MALED2   PRG    MALED3   PRG    MALPR    PRG    MALPR1   PRG
     MALPRA   PRG    MALRF    PRG    MALSYS   MEM    MALSYS   PRG
     MALUT    PRG    MALUT1   PRG    MALUT2   PRG    MALUTA   PRG
     MALUTB   PRG    MALUTC   PRG    MANUAL   BAT    SCR      CDX
     SCR      DBF    SCR      FPT    SCRPROC  PRG    STATE    CDX
     STATE    DBF    UNBACK   BAT

     The files with a .BAT extension are batch files.  Files with a .DBF
     extension are database files.  Files with a .CDX are Foxpro compound
     index files.  Files with a .PRG extension are Foxpro source files.
     The files with a .FXP extension are Foxpro object modules.  The files
     with a .FPT extension are Foxpro memo files.

     The dMAIL4 manual is stored in a file with a MAN extension.  A copy
     can be printed simply by typing "MANUAL" at the DOS prompt.

     MAIL.DBF is the mailing list database.  It is edited by the mailing
     list editor.  It is indexed by MAIL.CDX.  MAIL.CDX has tags by last
     name, zip code, and user ids.

     STATE.DBF is the state id database.  It is edited by the state editor.
     It has one index, called STATE.CDX and is keyed by state id.

     SCR.DBF is the data dictionary.  It contains all the information
     defining the screen layouts.  SCR.FPT contains all the help text
     provided by the [F1] key.  It has one index, called SCR.CDX.  See
     Appendix D:  PROG.

     All Q*.* files belong, and are maintained, by the expression builder.
     See Appendix D:  Record Filters.

     MALSYS.MEM is the dMAIL4 system memory file.  It contains system wide
     variables, including printer codes.

     FOXUSER.DBF is the foxuser resource file.  It contains all user
     attributes, including color.  See Appendix D.

     FOXERR.DBF is the Foxpro error file.  All major events are recorded
     here for debugging purposes.










                                     - Page 38 -







                                     Appendix B



                           Backup/Restore Data Files


     To insure the integrity of its data files, any major database should
     have a standardized backup procedure.  Data files should be
     periodically copied to a media, other than where they currently
     reside.  There is NO excuse for not developing a proper backup
     procedure.

     As a supplement, however, this application includes its own backup
     procedure.  To back up data, you must be in the application directory.
     At the DOS prompt type:

               BACK

     and press [Enter].  This command will copy all data files into a
     backup directory ('.\BAK').  In case of power failure, these backup
     files could be used to recover previous work.

     Restoring these backup files is simple.  To restore data, you must be
     in the application directory.  At the DOS prompt type:

               UNBACK

     and press [Enter].  This command restores all data up to the point you
     last invoked BACK.

     Note:  If you decide to store data files in a separate directory (See
     Appendix D:  DATA), make sure the data directory has a '.\BAK' backup
     directory.  You would then execute BACK and UNBACK from your data
     directory.  For convenience, you might consider coping BACK.BAT and
     UNBACK.BAT into your data directory.

     Warning:  If you ever run into a problem with this application, NEVER
     invoke the "BACK" command without first resolving the problem.  If a
     data file is corrupt, using "BACK" would only copy this corrupted file
     over a good backup file.

















                                     - Page 39 -







                                     Appendix C


     In the course of normal events, you shouldn't see any error messages.
     But events can happen to cause an error message.  The most common
     events are:  Verification, disk space used up, printer not ready,
     multi-user, or syntax error.


                                  Verification


     When you start your application, all databases files are inspected.
     If a database file doesn't exist, it is created.  If a database file
     is missing a field, it is added.  If a field is not the correct
     length, it is lengthened.  If a structural index tag is missing or not
     in the correct order, the entire CDX file is rebuilt.

     Of course, the verification could fail.  There are many reasons for
     verification to fail.  On a network, someone could be using the
     database file(s) you're trying to update.  Or, you might not have the
     access permission to create/update database file(s) in your data
     directory.  Whatever the reason, remember that verification fails only
     when a database file needed to be changed, but could not be updated.
     In such an event, consult your system administrator.

                                Bad Record Count

     If a database file has a bad record count, the verification process
     will try to repair it.  If the database file could not be repaired,
     however, a new (and empty) database file is created.  The corrupted
     DBF file is renamed as a BAK file.  Any associated FPT file will be
     renamed as a TBK file.

     Please keep this feature in mind when you invoke your own database
     repair utility.  An empty database file doesn't necessarily mean you
     lost your data.  Your corrupted data probably resides in BAK and TBK
     files.  But, depending on the damage, you may need the header of the
     empty database file to repair your corrupted data.

     Before any repairs, I suggest creating a floppy disk or tape backup of
     your BAK and TBK files.  In fact, it might be best just to backup all
     the files found in your data directory.

     Once repairs are complete, simply rename the repaired BAK file as the
     DBF file.  Rename any associated TBK file as a FPT file.  Oh, and
     remove the associated CDX file (will be rebuilt the next time you
     start the application).










                                     - Page 40 -







                                     Appendix C




                                   Disk Space


     If ever you see data records that look like garbage, you may have bad
     sectors on your hard disk.  Ask your system administrator to take a
     look at it.  The usual procedure is to back up all programs/data, and
     reformat the hard disk.  Any bad sectors found should be locked out
     and should no longer cause a problem.

     Bad data can result from lack of free space on the hard drive.  While
     you cannot start this application without a minimum amount of free
     space, it's always possible you might have used a routine that filled
     up your hard drive.  If this be the case, exit the application.  If
     you cannot get back into the application, due to lack of free space,
     have your system administrator remove all unused temporary files.  If
     you still cannot get back in, you might have to restore backup files.


                               Printer not Ready


     If you're printing a report and the printer is not on, you will get a
     message:

          Printer not ready.
          Press anything to retry, 'Q' to quit"

     Simply turn on your printer, and press any key to retry.  Your report
     should start to print.  Pressing "Q" would have aborted the report and
     returned you to the main menu.

     If you retry and still get "Printer not ready", you may have to
     perform the following DOS command:

          MODE LPT1,,P

     This command tells DOS to perform an infinite number of retries on the
     print device "LPT1".  Depending on you machine, you may also have to
     increase the Foxpro printer time-out.  See Appendix D:  TIME.














                                     - Page 41 -







                                     Appendix C




                               Multi-User Errors


     If you running this application under the multi-user mode, you may be
     presented with two different type of error messages.  Both types have
     to do with file locking.

     For example, you may be updating a database record.  In the meantime,
     however, somebody else may have already updated that record.  When
     your update is complete, you will receive the message:

          Current record has been altered

     In that case, review the updated record and try the update again.

     Another kind of message occurs while you are performing some kind of
     transaction processing.  If you need a record that somebody else has
     locked out, you will receive the message:

          Waiting for access, press [ESC] to abort

     In this case, just wait.  Most of the time, the record you need will
     be quickly released.


                                  Syntax Error


     The last kind of problem is a syntax error.  You shouldn't ever see
     one.  In case you do, however, you will be prompted:

          [I]gnore, [R]etry, [S]uspend, or [Q]uit to Main Menu.

     Unless you're a system administrator, your best bet is to press [Q] to
     Quit to Main menu.  Pressing [Q] will automatically log the error into
     the Foxpro error file (FOXERR.DBF).

     Don't forget to tell your system administrator about the error.  As
     the author, I'll want a copy of your FOXERR.* files to determine the
     type of error that occurred and to possibly correct it.













                                     - Page 42 -







                                     Appendix D


     To use this Foxpro application, each user needs a resource directory.
     A resource directory contains all the files needed to configure this
     application.  On a single-user system, or a network with a local hard
     drive, the resource directory will usually be the Foxpro runtime unit
     directory.

     This appendix will first explain the Foxpro runtime unit.  What's in
     it and how Foxpro determines the resource directory.  From there, this
     appendix will explain the resource directory.  What files are in this
     directory and how to configure them for this application.


                              Foxpro Runtime Unit


     The Foxpro runtime unit contain all the files necessary to run this
     application.  Since many Foxpro applications require the same runtime
     unit, these files are usually stored in their own directory (typically
     C:\FOXRUN).  On a network, the Foxpro runtime unit should be installed
     on each user's local hard drive.  It could, however, be shared among
     users with no local hard drive.

     The runtime unit consists of *.ESL files, *.ESO files, FOXSWAP.COM,
     and FOXR.EXE.

     Foxpro for DOS runtime comes with two versions.  The standard
     (FOXD*.ES?) and the extended (FOXDX*.ES?).  The standard version is
     for machines with only expanded (EMS) memory or less than three
     megabytes of extended memory.  The extended version is for machines
     with three or more megabytes of extended memory.

     Note:  FOXSWAP.COM is used only with the standard version to invoke
     large DOS applications.


                                    FOXR.EXE


     FOXR.EXE is the Foxpro for DOS startup module.  It allows Foxpro to
     launch an application.  FOXR.EXE also determines where the user
     resource directory is located.  Example:

          C:\FOXRUN\FOXR.EXE -cC:\FOXRUN\CONFIG.FP -m2612 mal

     In this example, FOXR.EXE was called from the runtime unit directory.
     It executed the application startup module MAL.FXP.  The -c option
     defined C:\FOXRUN\CONFIG.FP as the Foxpro configuration file.  It is
     the configuration file that determines the user's resource directory.







                                     - Page 43 -







                                     Appendix D


     FOXR.EXE also determines which version of Foxpro, standard or
     extended, to run.  Normally, it takes three megabytes of extended
     memory to invoke the extended version.

     In the last example, however, the -m option was used to reduce the
     amount of extended memory required to invoke the extended version.  In
     this case, only 2.6 megabytes was needed.


                                   FOXRW.EXE


     FOXRW.EXE is the Foxpro for Windows version of FOXR.EXE.  It allows
     the Foxpro for Windows runtime (FOXW*.ES?) to launch an application.
     The same rules and parameters of FOXR.EXE apply to FOXRW.EXE.

     Before continuing, it should be noted.  All the files in the runtime
     unit are self contained.  You need not add a C:\FOXRUN or a C:\FOXRUNW
     to your DOS PATH statement.


                                   CONFIG.FP


     As stated earlier, the CONFIG.FP file (CONFIG.FPW in Foxpro for
     windows) determines the user's resource directory.  It can also be
     used to optimize Foxpro.  The following is the basic CONFIG.FP file
     layout:

               _FOXDOC   = ''
               _FOXGRAPH = ''
               _GENGRAPH = ''
               BELL = OFF
               COLOR SET = FOXDEF
               DEVELOPMENT = OFF
               FILES = 45
               INDEX = NDX
               MVARSIZE = 20
               MVCOUNT = 512
               MEMLIMIT = 40,1024,4096
               RESOURCE = C:\FOXRUN
               RESOURCE = ON
               SAFETY = OFF
               STATUS = OFF
               TALK = OFF

     The following section will describe the most important commands in the
     CONFIG.FP.







                                     - Page 44 -







                                     Appendix D


                                   COLOR SET


     This is the default color set.  Example:  COLOR SET=FOXDEF.  This
     color set used to start your application.  It is also the color set
     used to store any color set changes.  See Change Color Set, provided
     in the System Setup menu.

     If no color set is specified in your CONFIG.FP, the default is DEFAULT
     for DOS, FOXDEF for Windows.


                                      EMS


     The standard version of Foxpro requires expanded memory.  You need at
     least three megabytes of extended memory to run the extended version
     of Foxpro.  If you only have expanded memory, add the following
     command to CONFIG.FP:

               EMS = ON

     If your expanded memory doesn't work with Foxpro, it probably doesn't
     conform to the LIM 4.0 specification for EMS.  In that case, replace
     the EMS on command with the following:

               EMS64 = OFF
               EMS = ON

     These commands allow Foxpro to use EMS memory, but only for file I/O.


                                    MEMLIMIT


     If you are unable to run Foxpro for windows, due to insufficient
     memory, add a MEMLIMIT statement to your CONFIG.FPW file.  The syntax
     for this statement is MEMLIMIT=%,min,max where % is a calculated
     amount based on available memory and min and max represent actual
     minimum and maximum allocations.

     For example, specifying MEMLIMIT=40,1024,4096 allocates 40 percent of
     your system's available memory to Foxpro with a minimum allocation of
     1024K and a maximum of 4096K.











                                     - Page 45 -







                                     Appendix D


                                    PROGWORK


     If you have at least a 450 kilobyte ramdisk, you can add the following
     command:

               PROGWORK = G:\

     This command will place program cache on drive G.  There are similar
     commands you can use to further optimize Foxpro.  If you are
     interested, refer to the Foxpro user guide.


                                    RESOURCE


     This command defines the user resource directory.  For single users,
     or network users with local hard drives, the resource directory would
     also be the runtime unit directory.  Example:

               C:\FOXRUN\FOXR.EXE -CC:\FOXRUN\CONFIG.FP MAL

     Where C:\FOXRUN is the local copy of the runtime unit and the
     CONFIG.FP file.  MAL would be, of course, the startup procedure to our
     application.  The CONFIG.FP file would contain the commands:

               RESOURCE = C:\FOXRUN
               RESOURCE = ON


     In the case of a network with no local hard drive, a work station
     would be invoked as:

               K:\FOXRUN\FOXR.EXE -CK:\USER1\CONFIG.FP MAL

     Where K:\FOXRUN contains the shared copy of the runtime unit and
     K:\USER1 contains the CONFIG.FP.  The CONFIG.FP would contain:

               RESOURCE = K:\USER1
               RESOURCE = ON

     Where K:\FOXRUN is defined as the user resource directory.

     Note:  If a runtime unit is to be shared, all *.ESL, *.ESO, FOXR.EXE
     and/or FOXRW.EXE must be marked as read-only.  The normal
     installation, however, should have already done this.









                                     - Page 46 -







                                     Appendix D




                                      TIME


     Establishes the amount of time that Foxpro waits for the print device
     to accept a character.  If the printer is not ready, this value
     dictates the number of retries that Foxpro will make to the print
     device.  If the retry count is exhausted, Foxpro issues the error
     "Printer not ready. Retry? (Y/N)".  The value of TIME may range from 1
     to 1,000,000 retries.  The default is 6,000.












































                                     - Page 47 -







                                     Appendix D


                                   FOXPRO.INI


     Another resource directory file is FOXPRO.INI.  In the past, this
     Foxpro application was configured using DOS environment variables.
     For example, the DOS command SET MULT=YES would set this application
     into multi-user mode.

     While DOS environment variables are still accepted, the preferred way
     is to add commands to a [GetEnv] section of the FOXPRO.INI file.  The
     following is a basic FOXPRO.INI file layout:


          [FoxPro]
          Zoomed=0
          Row=0
          Column=0
          Height=402
          Width=648
          FontName=FOXFONT
          FontStyle=0
          FontSize=9
          
          [GetEnv]
          FontName=FoxFont
          FontStyle=N
          FontSize=9
          Mult=yes
          Recall=yes


     Note:  The [Foxpro] section is used only by Foxpro for Windows and
     then, only from the FOXPRO.INI stored in the windows directory.

     The following is a list of FOXPRO.INI [GetEnv] commands:


                                      ADD


     In every editor, by default, when you are finished adding a new
     record, you will be prompted for a another record.  This keeps
     happening until you press [Esc].  By specifying ADD=NO, the add mode
     will prompt you for a new record only once.  Just like the update
     mode.

     This option allows you to review a new record before adding the next
     record.







                                     - Page 48 -







                                     Appendix D


                                     BORDER


     The BORDER command allows the user to define the border characters of
     all displayed windows and popups.  Available options are:


          BORDER = [SINGLE | DOUBLE | PANEL | NONE
                   | <border string1>,  <border string2>


     SINGLE:   Creates a single-line border.

     DOUBLE:   Creates a double-line border.  In Foxpro for Windows, this
     option creates a panel effect.

     PANEL:    Creates a wide border.

     NONE:     Suppresses the border entirely.

     <border string1>[, <border string2>]:   Use the border definition
     strings <border string1> and <border string2> to create your own
     borders.  <border string1> is used for menus, popups and boxes and for
     the current output window.  <border string2> specifies the border that
     appears when output isn't being directed to the window.  <border
     string2> doesn't affect boxes or popups.

     A border definition string is a set of ASCII character values defined
     [<1>] [, [<2>] [, [<3>] [, [<4>] [, [<5>] [, [<6>][, [<7>] [,
     [<8>]]]]]]]].  The border string entries 1 through 8 designate the
     top, bottom, left side, right side, upper-left corner, upper-right
     corner, lower-left corner and lower-right corner of the border,
     respectively.  If you include just one ASCII value in the border
     string definition, the entire border is drawn using that one
     character.  Note:  Border strings are ignored in Foxpro for Windows.

     For example, adding the following command to the [GetEnv] section of
     your FOXPRO.INI file:

               BORDER=SINGLE

     ..will draw single line border windows.













                                     - Page 49 -







                                     Appendix D


                                      DATA


     All application data files are assumed in the current directory unless
     the command DATA is specified.  Example:

               DATA=C:\DATA\

     Note: Data files include *.DBF, *.CDX, and *.FPT.  Q*.* are expression
     builder files (see Record Filters).  SCR.* are data dictionary files
     and belong in the program directory (see PROG).


                                    FONTNAME


     In Foxpro for Windows, pressing [Alt]-[V] allows the user to change
     fonts.  When a font is changed at a particular menu, all sub-menus
     will use that font.  If the font is changed at the main menu, the new
     font is stored in the [GetEnv] section of FOXPRO.INI.  When the
     application is restarted, the new font will then be used.

     The following command will define the name of the font:

               FONTNAME=FOXFONT

     ...where Foxfont is the name of the font.


                                    FONTSIZE


     In Foxpro for Windows, the following command will define the startup
     font size:

               FONTSIZE=9

     ..where '9' is 9 point.


                                   FONTSTYLE


     In Foxpro for Windows, the following command will define the style of
     the startup font:

               FONTSTYLE=N

     ..where 'N' is normal, 'I' defines italic, and 'B' for bold.  See the
     Foxpro command DEFINE WINDOW for a list of possible styles.





                                     - Page 50 -







                                     Appendix D


                                      INIT


     The INIT command allows the user to perform system administration
     functions.  These functions provide a measure of system control and
     are not needed for day to day activities.

     To invoke this system administration function, add the following
     command to the [GetEnv] section of your FOXPRO.INI file:

               INIT=YES

     When you run application again, you will notice new options.  If you
     are running on a network, an option M will appear on the main menu.
     Option 'M' allows you to toggle between Multi-user and single-user
     modes.  Some system administration functions can only be provided in
     single-user mode.

     In addition, an option B will appear in the utility menu.  This option
     allows you the purged out entire database files.


                                      LAST


     This application normally resets all browse sessions.  The browse
     layout, however, can be saved by adding the following command to your
     [GetEnv] section of the FOXPRO.INI file:

               LAST=YES

     With this command, fields may be moved around or resized.  Partitions
     may be split or separated.  All these preferences will be saved and
     will be in effect the next time you perform the browse.


                                      MULT


     This application normally comes up in single user mode.  To make it
     wake up in Multi-user mode, add the following command to your [GetEnv]
     section of the FOXPRO.INI file:

               MULT=YES











                                     - Page 51 -







                                     Appendix D


                                      PROG


     All application program files and all data dictionary files are
     assumed in the current directory unless the FOXPRO.INI command PROG is
     specified.  Example:

               PROG=D:\PROG\

     Note: Program files include *.PRG, *.FXP, and SCR.*.


                                     RECALL


     The application normally reuses deleted records.  That is, deleted
     records are blanked out to be reused the next time you add a record.
     You can recall deleted records with the following FOXPRO.INI command:

               RECALL=YES

     When recall is in effect, deleted records are not blanked out.  You
     will be provided with an extra recall option on all editors.  Like the
     find option, recall prompts the user for a record.  If the deleted
     record is found, it becomes active again.

     Note:  If the current database has a deleted() index, deleted records
     are NEVER blanked out.  When recall is in effect, you will be
     presented with a browse of all deleted records.  Select the desired
     record and press [Enter].


                                    REFRESH


     In a network environment, is it possible that the records you are
     currently viewing have changed.  Other users may have edited or even
     deleted these records.  Foxpro, therefore, must periodically refresh
     it's data buffers.  How often this refresh will occur is set by the
     FOXPRO.INI variable REFRESH.  Example:

               REFRESH=15

     In this example, the refresh rate is set to 15 seconds.  The default
     is 30 seconds.










                                     - Page 52 -







                                     Appendix D



                                    SYSMENU


     In Foxpro for DOS, the system menu is normally hidden.  You must press
     the [Alt] key to wake it up.  You can have the system menu always
     displayed with the following FOXPRO.INI command:

               SYSMENU=SHOW


     In Foxpro for Windows, the system menu is normally displayed.  You can
     have the system menu hidden with the following FOXPRO.INI command:

               SYSMENU=HIDDEN


                                      TEMP


     All temporary files are assumed in the current directory unless the
     FOXPRO.INI command TEMP is specified.  Example:

               TEMP=C:\TEMP

     If you have a large enough ramdisk, setting TEMP to the ramdisk should
     improve performance.

     Note:  DOS environment variables take precedent over [GetEnv]
     commands.  That is, a DOS environment variable TEMP is used before a
     [GetEnv] command TEMP.


                                      TERM


     In the very near future, Foxpro will be available for many different
     systems.  To remain compatible, the FOXPRO.INI command TERM was
     created.  If TERM does not exist, or if TERM is equal to ANSI, then
     the system is considered 100% ANSI compatible.  That is, function keys
     [F1]-[F10] exist, [Esc] exists, and the ability to use a mouse exists.
     Example:

               TERM=ANSI

     The file CONFIG.FP stores commands to configure Foxpro.  The [GetEnv]
     section of the file FOXPRO.INI stores commands to configure this
     application.  Other resource directory files include FOXUSER.*, *.MEM
     files, and Q*.* files.  The following describe each of these files:






                                     - Page 53 -







                                     Appendix D


                                  FOXUSER.DBF


     The Foxpro resource file (FOXUSER.DBF) stores all the attributes of
     the user.  What color sets the user desires and how to display browse
     windows.  It also stores certain preferences required by this
     application.  For instance, all files with a "TMP" extension should
     have word wrap enabled and backup disabled.  All files with a "TXT"
     extension should have word wrap disabled and backup disabled.

     The Foxpro resource file stores all the color sets available to
     Foxpro.  If you wish to improve the appearance of your menus, make
     sure "enabled opt." in your user menu (color set 2) is set to the same
     color as your "@ SAY".

     Note:  Foxpro for windows use the default color set "FOXDEF".  All
     other versions of Foxpro use the default color set "DEFAULT".


                                  FOXUSER2.DBF


     The second Foxpro resource file (FOXUSER2.DBF) has the same file
     structure as the Foxpro resource file (FOXUSER.DBF).  Unlike
     FOXUSER.DBF, however, color sets stored in the memo field 'DATA' are
     in ASCII text.

     The text layout is simple.  Twelve lines for the twelve color schemes
     used by this application.  Each line contain ten color pairs.  A color
     pair "W*/B+", for example, would denote a white foreground, blue
     background ("*" denotes blinking and "+" denotes intensity).  For a
     description of color pairs used within a scheme, check the color
     picker portion of the Foxpro manual.

     Note:  As long as the field 'UPDATED' has a more recent date, the
     color set from FOXUSER2.DBF will override the color set found in
     FOXUSER.DBF.


















                                     - Page 54 -







                                     Appendix D


                                 Printer Codes


     Printer codes are maintained by the system setup menu and are stored
     in a ???SYS.MEM memory file.  This memory file is stored in user's
     resource directory.

     On a network, each user will have his/her own set of printer codes.
     To retain a common set of printer codes, allow one user to maintain
     printer codes in the data directory (see DATA).  Then, simply delete
     ???SYS.MEM files from each user's resource directory.  Each user will
     get a fresh copy of printer codes, from the data directory, the next
     time they run the application.


                                 Record Filters


     Record filter files belong, and are maintained, by the expression
     builder.  These include Q*.DBF, Q*.FPT, Q*.CDX.  Record filters are
     stored in the user's resource directory.

     On a network, each user will have his/her own set of record filters.
     To retain a common set of record filters, allow one user to maintain
     record filters in the data directory (see DATA).  Then, simply delete
     all Q*.* files from each user's resource directory.  Each user will
     get a fresh copy of record filters, from the data directory, the next
     time they run the expression builder.


                              Configuring Sideways


     If you are using the sideways utility from Funk software, there are a
     couple of steps necessary configure it.  First, you can select the
     desired printer by running SWSETUP.COM.  This utility will modify
     SIDEWAYS.COM.  After selecting the desired printer, copy SIDEWAYS.COM
     to the user's resource directory.

     Note:  If you ever want to know where your resource directory is
     located, select the option "all about.." in the system setup menu.

     If you need to modify the font proportions, go into your resource
     directory and run SIDEWAYS.COM (no parameters).  A screen will appear,
     displaying all the current setup values.  Adjust these values and
     press [F9] to create the default file, SIDEWAYS.DFT.

     Note:  If you change your resource directory, create a new
     SIDEWAYS.DFT.  Among other things, this file contains it's own
     location.  Moving an DFT file can result in a "file not found" error
     message.




                                     - Page 55 -







                                      GLOSSARY


     ANSI  -  American National Standards Institute.  A standard for both
          screen output and keyboard input.

     Arrow Keys  -  Equivalent to cursor keys.  Those keys on the keyboard
          labeled with arrows.

     ASCII  -  American Standard Code for Information Interchange.  A
          standard 7 bit code used to represent data.

     Batch File  -  A file containing multiple DOS commands.  These
          commands are executed by DOS, one at a time, as if typed by the
          user.

     Byte  -  A unit of information.  In text form, equivalent to an ASCII
          character.

     Code  -  Program code.  Another way of saying program instructions.

     Compiler  -  A program that converts program code from one form to
          another, usually more primitive, form.  The converted code is
          then ready for execution.

     CONFIG.FP  -  The Foxpro configuration file.  This file tells Foxpro
          where is find the resource file.  On a network, there is a one
          copy for each Foxpro user.

     CONFIG.FPM  -  The Foxpro for Macintosh configuration file.

     CONFIG.FPW  -  The Foxpro for windows configuration file.

     Cursor  -  A flashing character on the screen.  It indicates where
          typed text will be next placed.

     Cursor Keys  -  Equivalent to arrow keys.  Those keys on the keyboard
          labeled with arrows.

     Data Dictionary  -  A database file that defines the input/output to
          database files in an application.

     dBASE  -  Popular database management language.  The software package
          dBASE III+ is an interpreter for dBASE code.

     Disk  -  A unit where information is stored.  There are two major
          types: hard disk, and floppy disk.

     Disk Error  -  An error occurring when a program is unable to read or
          write properly to a disk.

     Diskspace  -  A unit of how much room is available on a drive.  It is
          usually measured in bytes.

     DOS  -  Disk Operating System.



                                     - Page 56 -







                                      GLOSSARY


     EMS  -  Refers to expanded memory.  Most 80286 computers have expanded
          memory.  80386 computers have extended memory.  There are,
          however, 80386 software drivers (QEMM for example), that can
          offer either extended or expanded memory.

     Extended  -  Extended memory.  80386 (or better) computers have
          extended memory.  The extended version of Foxpro needs at least
          three megabytes of extended memory.  The standard version of
          Foxpro requires expanded memory.

     Filespec  -  any DOS filename.ext including catalog names, passwords,
          etc.

     Floppy Disk  -  A self contained unit where information is stored.
          Depending on the type, floppy disks are easily transportable.
          Sometimes called a diskette.

     Foxbase  -   A dBASE III plus compatible language.

     Foxpro  -   A dBASE IV compatible language.

     FOXERR.DBF  -  The Foxpro error file.  Every major error event is
          recorded in this file.

     FOXUSER.DBF  -  The Foxpro resource file.  This file stores all the
          attributes of the user.  It also stores all the color sets
          available to Foxpro.  On a network, there is a one copy for each
          Foxpro user.

     Hard Disk  -  A self contained unit where information is stored.
          Usually not removable.

     HELP  -  A facility that provides on-line assistance in the use of a
          given program.

     Highlight  -  A form of a cursor, where an entire field is considered
          the cursor.

     Interpreter  -  A program that executes language code.  Whereas a
          compiler translates program code to executable code, an
          interpreter translates a single line of program code before
          executing it.

     Kilobyte  -  One kilobyte of memory equals 1,024 bytes.

     Megabyte  -  One megabyte of memory equals 1,024,000 bytes.

     Multi-user  -  When more one than one person is capable of
          accessing/updating the same database at the same time.

     MS-DOS  -  Microsoft Disk Operating System.

     Sideways  -  A DOS Utility that will print text up and down instead of
          across the paper.

                                     - Page 57 -







                                      GLOSSARY



     Source Code  -  What a translator/compiler takes in as input.

     Syntax  -  The rules for the arrangement of statements in a
          programming language


















































                                     - Page 58 -







                                        Index


     *.ESL  43                            CONFIG.FPW  44, 45, 56
     *.ESO  43                            Configuring Sideways  55
     .BAT  38                             Copyright/License/Warranty  2
     .CDX  38                             Creating a Mailing List Record
     .DBF  38                                 9
     .FPT  38                             Creating a State Record  13
     .FXP  38                             Creating Sample Records  8
     .PRG  38                             Cursor  30, 56
     [Alt]-[F4]  36                       Cursor Keys  56
     [Alt]-[F5]  36                       Customer  26
     [Alt]-[V]  37                        Customizing Color Sets  21
     [Ctrl]-[F4]  36                      DATA  50
     [Ctrl]-[F5]  37                      Data dictionary  38, 52, 56
     [Ctrl]-[Home]  12, 31                DBASE  56
     [Ctrl]-[J]  32                       DBASE IV  1
     [Ctrl]-[N]  32                       Delete Function  10, 32
     [Ctrl]-[T]  32                       Disk  56
     [Ctrl]-[Y]  32                       Disk Error  56
     [End]  30                            Disk Space  41
     [Esc]  31                            Diskspace  56
     [F1]  30                             Display/Print Manual  22
     [F10]  32                            DMAIL4  1, 5
     [F4]  36                             DOS  5, 56
     [F5]  37                             Draft mode  20
     [F7]  37                             Edit User Descriptions  22
     [Home]  30                           Editor  5
     [Shift]-[TAB]  31                    Employee  26
     [TAB]  31                            EMS  43, 45, 57
     ADD  48                              Expanded  45
     Add Function  9, 30                  Export Mailing List  23
     Adding a Customer Record  11         Exporting Different Data
     All About...  22                         Structures  24
     ANSI  53, 56                         Expression builder  5, 18
     Appendix A  29                       Extended  1, 45, 57
     Appendix A-1  36                     Filespec  57
     Appendix B  38                       Filter  17, 18
     Appendix C  40                       Find Function  10, 32
     Appendix D  43                       Floppy Disk  57
     Arrow Keys  56                       Font  20, 37
     ASCII  56                            FONTNAME  50
     BACK  39                             FONTSIZE  50
     Backup/Restore Data Files  39        FONTSTYLE  50
     Bad Record Count  40                 Foxbase  57
     Batch File  56                       FOXERR.DBF  22, 38, 42, 57
     BORDER  49                           Foxpro  1, 5, 57
     Browse Function  10, 31              Foxpro Calculator  36
     Byte  56                             Foxpro Calendar  36
     Change Color Set  21                 Foxpro DOS Shell  37
     Check boxes  12, 17, 22, 26          Foxpro for DOS  37
     Code  56                             Foxpro for windows  37, 45, 48,
     COLOR SET  45                            50
     Compiler  56                         Foxpro runtime unit  7, 43
     CONFIG.FP  43, 44, 56                Foxpro runtime unit directory
     CONFIG.FPM  56                           43

                                     - Page 59 -







                                        Index


     FOXPRO.INI  48                       Printer Eject  37
     FOXR.EXE  43                         Printer Name  19
     FOXRUN  43                           Printer not Ready  41
     FOXRW.EXE  44                        Printing Mailing Labels  14
     FOXSWAP.COM  43                      Problems & Suggestions  22
     FOXUSER.DBF  21, 38, 54, 57          PROG  52
     FOXUSER2.DBF  21, 54                 PROGWORK  46
     GLOSSARY  56                         Purging Mailing List  27
     Goto Function  10, 33                Q*.*  38
     Hard Disk  57                        Quit  13, 16, 22
     HELP  57                             Quit Function  11, 35
     Help Function  11, 34                Quit to DOS  28
     Highlight  57                        Ramdisk  53
     Import Mailing List  25              Rebuilding Indices  27
     Importing Different Data             RECALL  52
         Structures  26                   Recall Function  35
     Importing SBT Records  26            Record filter  5, 17, 18
     Index  59                            Record Filters  55
     INIT  51                             REFRESH  52
     Initializing Databases  27           RESOURCE  46
     Interpreter  57                      Resource directory  43
     Introduction  5                      SBT  26
     Invoking dMAIL4 System  7            SCR.DBF  38
     JKEY  32                             Sideways  20, 57
     Kilobyte  57                         SIDEWAYS.COM  55
     Laser Printers  37                   SIDEWAYS.DFT  55
     LAST  51                             Source Code  58
     LIM 4.0  45                          STATE.DBF  38
     Macintosh  6                         Straight lines per page  20
     MAIL.DBF  38                         SWSETUP.COM  55
     Mailing Labels  21                   Syntax  58
     MAL  7                               Syntax Error  42
     MALSYS.MEM  38                       Sysmenu  36, 53
     MANUAL  38                           Sysmenu edit  36
     Megabyte  57                         System administration  51
     Megabytes  1                         System administrator  21, 37,
     MEMLIMIT  45                             40, 41, 42
     Memo  12, 22, 38                     System Setup  17
     MODE  41                             TABLE OF CONTENTS  3
     MS-DOS  1, 57                        TEMP  53
     MULT  51                             TERM  53
     Multi-user  19, 57                   TIME  47
     Multi-User Errors  42                Toggle Index Function  11, 35
     Network  19, 43, 51                  Toggle Order Function  11, 35
     Non-draft  37                        UNBACK  39
     Non-draft mode  20                   Update Function  11, 35
     Notation Conventions  6              Utilities  23
     P_CODES.DBF  19                      Vendor  26
     Preface  1                           Verification  40
     Print Mailing List  14               Video Mode  37
     Print Mode  37                       Wild-carding  32
     Printer Codes  20, 38, 55            Window  5
     Printer Control Codes  19
     Printer Device  19

                                     - Page 60 -



