@echo off
ECHO Here's a documented version of BATDEMO.BAT.  It displays this
ECHO message and stops.  Use a text editor to look at it.  Look for
ECHO lines that start with REM to see the comments.
GOTO Quit
REM
REM Place the current directory in the environment in the variable LDIR.
REM We will use this info to be able to find the BatKit programs even
REM if the directory isn't in the Path.
REM This line is where execution would normally start.
REM
SAVEDIR
if errorlevel 4 goto SDERR
if errorlevel 3 goto OLDOS
if errorlevel 1 goto ENVERR
set
REM
REM Pause for 2 seconds or until a key is pressed.
REM
wait 000002
SET TEST=To_determine_whether_there_is_enough_space.
IF not "%TEST%"=="To_determine_whether_there_is_enough_space." goto ENVERR
SET TEST=
REM
REM Save the current directory info to another variable since we will be
REM using LDIR again.
REM
SET BDIR=%LDIR%
:: If BatKit is in a ROOT, set BDIR to strip "\" from end.
if %LDIR%==%LDRV%\ SET BDIR=%LDRV%

:MENU
REM
REM Run SAVEDIR in the BatKit directory and have it take us to that directory
REM
%BDIR%\SAVEDIR %BDIR%
REM 
REM Run GetKey.  Display the file MENU.GKF in the BatKit directory.  Accept
REM any of these keystrokes: "12345DPHLX-".  RAny other keystrokes will be
REM rejected and an error message will be displayed.
REM 
%BDIR%\GetKey /K"12345DPHLX-"/F"%BDIR%\MENU.GKF"/E
REM
REM Based on the ASCII value of the key pressed use ERRORLEVEL to branch
REM to the appropriate part of this batch file
REM
if errorlevel 88 goto STOP
if errorlevel 80 goto PRINT
if errorlevel 76 goto LIST
if errorlevel 72 goto HELP
if errorlevel 68 goto SUBMEN
if errorlevel 53 goto BIGMENU
if errorlevel 52 goto MAKESCRN
if errorlevel 51 goto COLOTONE
if errorlevel 50 goto WP
if errorlevel 49 goto DEMO
goto QUIT
:COLOTONE
:: For DOSs before 3.1 pre-set the environment variable by using the next line
:: SET GK=This is here to save plenty of room for the GK variable
REM
REM Run GetKey, set the current color to 22h, don't wait for a response and
REM don't display any response.
REM
%BDIR%\GetKey /M"#&22@C"/N/W0
REM
REM Run the batch file COLOTONE.BAT.  Newer DOS version could use the CALL
REM command.
REM
:: For DOSs after 3.0 use the /e syntax to expand the environment of the shell
COMMAND /e:2000 /C COLOTONE
goto MENU

:DEMO
REM
REM Run GetKey, display the file DEMO.GKF, don't echo any response
REM
%BDIR%\GetKey /F"DEMO.GKF"/n
Goto MENU

:BIGMENU
REM
REM Run GetKey, suppress the carrage return normally displayed when a response
REM is entered (/S), only accept one of the keys in the list "123456789-X",
REM display the file ASMENU.GKF.  This file was written for GetKey version
REM 4.x so use version 4.x syntax.
REM
GETKEY /S/K"123456789-X"/4/F"ASMENU.GKF"

:TEST
REM
REM Based on the ASCII value of the response use ERRORLEVEL to either return
REM to the main menu or to 'shift' the screen colors.  @S shifts the current
REM screen colors by the number of colors shown.  @S255 acts like a negative
REM shift by one color.  @W0 tells GetKey not to wait for a response; that
REM is it does any displaying it needs to then immediately terminates rather
REM than waiting for the user to press a key.
REM
IF ERRORLEVEL 88 GOTO MENU
IF ERRORLEVEL 57 GETKEY /W0/M"@S9"
IF ERRORLEVEL 56 GETKEY /W0/M"@S8"
IF ERRORLEVEL 55 GETKEY /W0/M"@S7"
IF ERRORLEVEL 54 GETKEY /W0/M"@S6"
IF ERRORLEVEL 53 GETKEY /W0/M"@S5"
IF ERRORLEVEL 52 GETKEY /W0/M"@S4"
IF ERRORLEVEL 51 GETKEY /W0/M"@S3"
IF ERRORLEVEL 50 GETKEY /W0/M"@S2"
IF ERRORLEVEL 49 GETKEY /W0/M"@S1"
IF ERRORLEVEL 45 GETKEY /W0/M"@S255"
REM
REM To keep from redisplaying the ASMENU.GKF file we'll use the next line
REM to set GetKey to only accept the appropriate keys.  The parameter
REM /M"@X65@Y21" positions the cursor so that the response is echoed at
REM the appropriate spot on screen.
REM
GETKEY /K"123456789-X"/M"@X65@Y21"
GOTO TEST

:MAKESCRN
REM
REM Display the MakeScrn demo file MSDEMO.GKF.  Don't wait for a response
REM (/W0), don't echo any response (/N) and don't do a carrage return at
REM termination (/S).  The /S keeps the cursor from dropping down a line
REM which could cause the screen to scroll if we happen to be on the bottom
REM line.
REM
GetKey /w0/f"msdemo.gkf"/s/n
goto MENU

:PRINT
COPY %BDIR%\BATKIT.DOC PRN
goto MENU

:LIST
REM
REM Display the message shown, add a 'beep' (@T), accept either Y or N
REM as a response.
REM
GetKey /k"yn"/m"@T    Do you have a text file viewer called LIST? "
if errorlevel 89 goto HAVELIST
REM
REM Display section L of the file MENU.GKF
REM
GetKey /f"menu.gkf@l"
type %BDIR%\BATKIT.DOC | more
goto MENU

:HAVELIST
LIST %BDIR%\BATKIT.DOC 
goto MENU

:HELP
REM
REM Use GetKey to display the built in help.  Then use GetKey to display
REM the "Press any key" at column 65 of the current line.  Wait 30 seconds
REM for a response then terminate.  Don't display any response (/N) and
REM don't add a final carrage return (/S).
REM
GetKey /h
GetKey /w30/m"@X65#&1FPress any key"/n/s
goto MENU

:SUBMEN
REM
REM Save the current drive and directory
REM
%BDIR%\SAVEDIR
REM
REM Display section S of the file MENU.GKF in the BatKit directory.  Clear
REM the type-ahead buffer (/Z).  Only accept X, L, G, F, D, C, or - for a
REM response.  Display an error message if anything else is entered (/E).
REM The Enter/Return key pressed by itself is also an acceptable response (/A).
REM
%BDIR%\GetKey /K"XLGFDC-"/F"%BDIR%\MENU.GKF@S"/E/A/Z
REM
REM Use the ASCII value of the response and ERRORLEVEL to branch to the
REM appropriate location of this batch file.
REM
if errorlevel 88 goto MENU
if errorlevel 76 goto LSTFILE
if errorlevel 71 goto CHGDIR
if errorlevel 70 goto FORMAT
if errorlevel 68 goto DELETE
if errorlevel 67 goto COPY
goto MENU

:CHGDIR
REM
REM Get a response up to 21 characters long (/L21).  Show a 'guide line' (/G).
REM Place the response in the environment variable NPATH (/V"NPATH").  Display
REM the message shown at row 6 (@Y6) and column 50 (@X50).  Display the time
REM (@DT) in the color 0eh (yellow).  Go to row 20 (@Y20) and column 16 (@X16)
REM and display the message.  Then play a tone of frequency 700h for a
REM duration of 5 clock ticks.
REM
%BDIR%\GetKey /L21/G/V"NPATH"/M"@X50@Y6#&0E@DT@X16@Y20Enter the NEW drive and path: @T&05#&700"
if %NPATH%! == ! goto SUBMEN
%BDIR%\SAVEDIR %NPATH%
set NPATH=
goto SUBMEN

:LSTFILE
REM
REM Use GetKey to clear the screen (@C) using the current colors (@O).  Don't
REM wait for a response (/W0).
REM
%BDIR%\GetKey /w0/m"@O@C"
dir/p
REM
REM Use WAIT to pause for up to 30 seconds.  Display the time while waiting.
REM
%BDIR%\WAIT /c 00:00:30
goto SUBMEN

:DELETE
REM
REM Get a response up to 8 characters long (/L8).  Display a 'guide line' (/G).
REM Instead of echoing the actual key pressed display a '*' (/N"*").  Make
REM any entries in the file GETKEY.RSP be the only acceptable responses.
REM Display the message at row 20, column 20 (@X20@Y20).  'Flash' the screen
REM the default number of times (@F).
REM
%BDIR%\GetKey /L8/G/N"*"/KF"%BDIR%\GetKey.RSP"/M"@X20@Y20Enter password: (Hint - try Password) @F"
REM
REM Display section D of the file MENU.GKF.  Get a response up to 12
REM characters long (/L12).  Clear the keyboard buffer first (/Z).  Display
REM a 'guide line' (/G).  Put the response in the env. variable DFILE
REM (/V"DFILE").
REM
%BDIR%\GetKey /Z/L12/g/v"DFILE"/f"%BDIR%\MENU.GKF@D"
if %DFILE%! == X! goto SUBMEN
echo -
echo -
dir %DFILE%
REM
REM Display the message shown and get a single key response.  Don't echo the
REM response (/N) and don't add a final carrage return (/S).
REM
%BDIR%\GetKey /m"  Press Y to delete %LDIR%\%DFILE%: "/n/s
if errorlevel 90 goto SUBMEN
if errorlevel 89 DEL %DFILE%
REM
REM Use WAIT to pause for up to 30 seconds.  Display the time while waiting.
REM
%BDIR%\WAIT /c 00:00:30
goto SUBMEN

:COPY
REM
REM Display the message shown.  @H moves the cursor to the upper left corner.
REM @T plays a tone.  #&1E and #&9E are screen colors in hexidecimal.  @CR-
REM turns off the cursor.  @O sets the screen colors back to their original
REM values.  /N says don't echo the response.  /W10 says wait 10 seconds for
REm a response then automatically terminate.
REM
getkey /w10/m"@H@T        #&1E  This is just a #&9Esample#&1E menu selection; it is not functional. @CR-@O"/n
goto SUBMEN

:FORMAT
REM
REM Display the message shown.  @X50@Y6#&0E@DT says display the time at
REM row 6, column 50 in the color 0eh.  Next the actual message is displayed
REM at row 20, column 20.  The response will be put in the environment in the
REM variable GK (/V).  Only A, B and X are acceptable responses.
REM
%BDIR%\GetKey /v/k"abx"/m"@X50@Y6#&0E@DT@X20@Y20Diskette drive to format (or X to eXit): "
if errorlevel 88 goto SUBMEN
cls
format %GK%:
goto SUBMEN

:WP
REM
REM Display the message shown.  @H moves the cursor to the upper left corner.
REM @T plays a tone.  #&1E and #&9E are screen colors in hexadecimal.
REM /N says don't echo the response.  /W10 says wait 10 seconds for a 
REM response.  If no response is entered in that time  then automatically
REM terminate.
REM
getkey /w10/m"@H@T    #&1E  This is just a #&9Esample#&1E menu selection; it is not functional."/n
goto MENU

:STOP
REM
REM Display section X of the file MENU.GKF.  Don't echo the response (/N)
REM and don't add a final carrage return (/S).
REM
%BDIR%\GetKey /f"%BDIR%\menu.gkf@x"/N/s
if errorlevel 78 goto PARK
if errorlevel 77 goto MENU

:PARK
REM
REM Change to the directory we started from, clean up the environment then
REM quit.
REM
%BDIR%\SAVEDIR %BDIR%
SET BDIR=
SET LDIR=
SET LDRV=
SET GK=
SET DFILE=
goto QUIT

:OLDOS
REM
REM Display the message shown in the color CAh.  Play a tone first (@T).
REM Clear the keyboard buffer (/Z) and don't wait for a response (/W0).
REM
getkey /w0/z/m"@T       #&CABatKit requires MS or PC-DOS 2.x or above to run!"
REM
REM Use WAIT to pause for up to 30 seconds.  Display the time while waiting.
REM
wait /c 000030
goto QUIT

:ENVERR
REM
REM Display the message shown in the color CAh.  Play a tone first (@T).
REM Clear the keyboard buffer (/Z) and don't wait for a response (/W0).
REM
getkey /w0/z/m"@T   #&CAYou don't have enough free environment space for BatDemo!  See README.1ST."
REM
REM Use WAIT to pause for up to 30 seconds.  Display the time while waiting.
REM
wait /c 000030
goto QUIT

:SDERR
REM
REM SAVEDIR had a problem.  Display the built in help then quit.
REM
echo SaveDir execution error
echo 
SaveDir ?
REM
REM Use WAIT to pause for the default time (1 second).  Display the time
REM while waiting.
REM
wait /c
:QUIT
