#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <process.h>
#include <conio.h>
#include <stdlib.h>
#include <ctype.h>
#include <windows.h>

#include "cgi.h"

CCGI::CCGI()
{
}

CCGI::~CCGI()
{
	delete m_method,
	       m_name,
		   m_value;

}

/////////////////////////////////////////////////////////////////////////////////
//This is primarily for debugging purposes.  Allows a developer to manually set//
//the form data.															   //
/////////////////////////////////////////////////////////////////////////////////
void CCGI::SetContent(char* content)
{
	strcpy(m_content, content);
}


/////////////////////////////////////////////////////////////////////////////////
//Gets the values from the form
/////////////////////////////////////////////////////////////////////////////////
BOOL CCGI::Initialize(const char* method_type)
{
	char* clstr;
	int content_length;
	
	m_method = getenv("REQUEST_METHOD");
	//Check the Method 
	if (strcmp(m_method, method_type) != 0)  
		err("You must submit a <a href=index.html>form</A> to access this URL");
	
	//Check to make sure the browser supports this function
	clstr = getenv("CONTENT_LENGTH");
	if(!clstr)
		err("Your browser didn't send any content.  Is it not POST capable?");
	
	//convert the CONTENT_LENGTH string into an integer
	content_length = atoi(clstr);

	//Check the browsers content type
	if(strcmp(getenv("CONTENT_TYPE"), "application/x-www-form-urlencoded") != 0)
		err("Your browser sent the wrong content type.");
	
	/*
	 * Check for netgative or outrageously large content lengths
	 * An upper limit is set to make sure they don't steal extra system
	 * resources for no good reason
	 */
	
	if ( (content_length < 0 ) || content_length >= MAX_CONTENT_LENGTH )
		err("Your browser created too much data from the form");
		
	fread(m_content, 1, content_length, stdin);

	//Add an additional '&' at the end so the strtok will work correctly in FindData(...)
	strcat(m_content, "&");
	//_strupr(m_content);
	return FALSE;
}

BOOL CCGI::ParamExist(char param_to_find[])
{
	if ( stristr(m_content, param_to_find) != NULL )
		return TRUE;
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////
//Given 'form_variable' will return the contents of the variable.  If it doesn't//
//exist, then it sends out an HTML err stating that the variable does not exist //
//////////////////////////////////////////////////////////////////////////////////
char* CCGI::FindData(char* form_variable, BOOL REQUIRED)
{
	char* strresult = NULL;
	char* token;
	char buf[1000];
	char TempContent[MAX_CONTENT_LENGTH];

	//Parse the form_variable from the whole string(m_content).  Should now be in the 
	//format of form_variable=value&form_variable=value&
	
	//find the form_variable requested 
	strcpy(TempContent, m_content);
	strresult = stristr(TempContent, form_variable); 
	if (strresult == NULL)
		if (!REQUIRED)
			return NULL;
		else
		{
			PrintHeader("Form Information Missing");
			sprintf(buf, "Form name couldn't be found: %s", form_variable);
			err(buf);
		}
	//Just give me all the data associated with the form_variable
	//by finding the & at the end of the value
	token = strtok(strresult, "&");
	
	//Advance the pointer to the value
	strresult = strstr(token, "=");
	
	//Advance the pointer by one to get pasted the '='
	m_value = ++strresult;
	url_decode();
	return m_value;
}

int CCGI::is_hex(char hex)
{
	//*****Taken from the Netscape handbook.  ********
	
	//Make sure it's upper case
	if (isalpha(hex))
		hex = toupper(hex);

	//This just checks the character to see if it's in the two ranges
	if(((hex < 'A') && (hex > 'F')) && ((hex < '0') && (hex > '9')))
		return 0;
	else 
		return 1;
}

void CCGI::url_decode()
{
	//*****Taken from the Netscape handbook.  ********

	//Decodes any special characters.

	//Allocate space for the new string.  We won't need more space than we 
	//already have after decoding
	//char *string = new char[strlen(m_value) + 1];
	char *string = (char *) malloc((strlen(m_value) + 1) * sizeof(char));
	//Index register fo string copy
	char* enc, *dec;
	//Digit is used to translate hex into character
	char digit;

	//string = m_value;
	
	if (string == NULL)
		err("The program ran out of memory.");

	//We go through the string, looking for + signs or percents
	for (enc = m_value, dec = string; *enc; enc++, dec++)
	{
		if (*enc != '%')
		{
			//Plus goes to space
			if (*enc == '+')
			{
				*dec = ' ';
			}
			else 
				*dec = *enc;
		}
		else 
		{
			//Another tricky part.  First, make sure we got what we want
			if ((!is_hex(enc[1])) || (!is_hex(enc[2])))
				err("Invalid escape sequence");

			//Now, advance over the % sign to the first digit and decode
			//The oxdf is to turn the character into upper case
			//Modification made due to that fact that the one in the handbook didn't work.
			++enc;
			digit = 0;
			if (*enc >= 'A')
				digit = (((*enc & 0xdf) - 'A') + 10);
			else
				digit = 16*(*enc - '0');

			++enc;
			if (*enc >= 'A')
				digit += (((*enc & 0xdf) - 'A') + 10);
			else
				digit += (*enc - '0');
		
			//Finally, transfer the digit to the new string
			
			*dec = digit;
		}
	}
	*dec = '\0';
	m_value = string;
}

/**Generic error handler.  Since this function does not PrintHeader, make sure you call PrintHeader
   before using this function, otherwise you will get a server error.  The error has to do with the
   fact that you didn't specify the Content-type
*/
void err(char errstr[])
{
	printf("%s\n", errstr);
	PrintTrailer(NULL);
	exit(0);
}

void PrintHeader(const char* title)
{
	// Two carriage returns (\n\n) are required by the html browser.  Do not remove it 
	//or you will get a web server error
	printf("Content-type: text/html\n\n");
	printf("<HTML>\n");
	if (title != NULL)
		printf("<TITLE>%s</TITLE>", title);
	
}

//Place for any static trailer information
void PrintTrailer(const char* trailer)
{
	if (trailer != NULL)
		printf("%s", trailer);
	printf("\n</HTML>");
}

////////////////////////////////////////////////////////////////////////////////////
//This performs the same function that strstr does, but this is a case-insensitive//
//version.																		  //
////////////////////////////////////////////////////////////////////////////////////
char* stristr(char* source, const char* comparewith)
{
	char* t1,
		* t2,
		* t3;
	char* cw;
	
	t1 = _strdup(source);
	t2 = t1;
	t3 = source;
	cw = _strdup(comparewith);

	t2 = strstr(_strupr(t1), _strupr(cw));

	if (t2 == NULL)
		return NULL;
	
	t3 = source + (t2 - t1);
	
	delete t1, t2, cw;
	return t3;

}

