PROGRAM FixCPT;
{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

USES DOS;
CONST
  progdesc = 'CPT-Fix - Fix CPT v1.36 database files.';
  author   = 'Copyright (c) September 29, 1995, by David Daniel Anderson - Reign Ware.';

PROCEDURE showhelp (problem : BYTE);
{----
 If any *foreseen* errors arise, we are sent here,
  to give a little help and exit (relatively) peacefully
----}
CONST
  usage    = 'Usage:  CPT-Fix <CPT v1.36 file(s)>';
VAR
  message : STRING [79];
BEGIN
  WriteLn;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      1 : message := 'Invalid parameter on command line or parameter missing.';
      2 : message := 'No files found.  First parameter must be a valid file specification.';
      7 : message := 'File handling error.  File may have been corrupted or deleted!';
      ELSE  message := 'Undefined error.'
    END;
    WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message); WriteLn;
  END;
  WriteLn (usage);
  Halt (problem);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN ShowHelp (7);
END;

FUNCTION Upper (w: STRING): STRING;
VAR
  cp : INTEGER;        {The position of the character to change.}
BEGIN
  FOR cp := 1 TO Length (w) DO
    w [cp] := UpCase (w [cp]);
  Upper := w;
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

PROCEDURE EraseFile (CONST FileName : STRING);
VAR
  cFile : FILE;
BEGIN
  IF IsFile (FileName) THEN BEGIN
    Assign (cFile, FileName);
    SetFAttr (cFile, 0);
    Erase (cFile); CheckIO;
  END;
END;

FUNCTION GetName (fn : STRING): STRING;
BEGIN
  IF (Pos ('.', fn) > 0)
    THEN GetName := Copy (fn, 1, (Pos ('.', fn) - 1))
    ELSE GetName := fn;
END;

FUNCTION GetExt (fn : STRING): STRING;
BEGIN
  IF (Pos ('.', fn) > 0)
    THEN GetExt := Copy (fn, Pos ('.', fn), Length (fn))
    ELSE GetExt := '';
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

FUNCTION FixLine (VAR FILE1, FILE2 : TEXT): BOOLEAN;
VAR
  cline : STRING;
  return : BOOLEAN;
BEGIN
  return := FALSE;
  ReadLn (FILE1, cline);
  IF Copy (cline, 1, 9) = 'CPT v1.36' THEN BEGIN
    return := TRUE;
    cline [9] := '7';
    WriteLn (FILE2, cline);
    WHILE (NOT EoF (FILE1)) DO BEGIN
      ReadLn (FILE1, cline);
      IF (Copy (cline, 1, 2) = ': ') AND (cline [38] <> ',') THEN BEGIN
        Insert (',', cline, 38);
        WHILE cline[55]=#32 DO BEGIN
          Delete (cline, 55, 1);
          Insert ('?', cline, 48);
        END;
        WHILE cline[68]=#32 DO BEGIN
          Delete (cline, 68, 1);
          Insert ('?', cline, 61);
        END;
      END;
      cline[50] := '-';
      cline[53] := '-';
      cline[63] := '-';
      cline[66] := '-';
      WriteLn (FILE2, cline)
    END;
  END;
  FixLine := return;
END;

{---- TYPEs, CONSTs and VARs for "main" program ----}
TYPE
  FileList = ^FILEREC;
  FILEREC = RECORD
              Name : STRING [12];
              next : FileList;
            END;

VAR
  dirinfo : SEARCHREC;
  spath   : PATHSTR;
  sdir    : DIRSTR;
  sfn, dfn,
  Swapname : PATHSTR;
  infile, outfile : TEXT;

  anchor, chain : FileList;
  okay,
  done    : BOOLEAN;
  Processed : word;

  fname : NAMESTR;

{---- BEGIN the "main" program ----}

BEGIN
  WriteLn (progdesc);
  WriteLn (author);
  Processed := 0;

  IF ParamCount <> 1 THEN ShowHelp (1);
  sPath := GetFilePath (ParamStr (1), sDir);

  anchor := NIL;

  FindFirst (spath, Archive, dirinfo);
  IF (DosError <> 0) THEN showhelp (2);
  WriteLn;

{---- Okay, let's go! ----}

  WHILE DosError = 0 DO
  BEGIN
    sfn := sdir + dirinfo. Name;
    done := FALSE;
    fname := GetName (dirinfo. Name);
    IF (Upper (GetExt (dirinfo.Name)) = '.BAK') THEN done := TRUE;
    chain := anchor;            { check if file was processed file already }
    WHILE (chain <> NIL) AND (NOT done) DO
      IF (chain^. Name = dirinfo. Name)
        THEN done := TRUE
        ELSE chain := chain^. next;

{---- Only process if not processed before ----}

    IF (NOT done) THEN BEGIN
      Inc (Processed);
      New (chain);
      chain^. Name := dirinfo. Name; { add current name to beginning of list }
      chain^. next := anchor;
      anchor := chain;

{---- Process the file! ----}
      dfn := sDir + fname + '.bak';
      Write ('Checking ', sfn); {tell user file is being processed}

      Assign (infile, sfn); Reset (infile); CheckIO;
      Assign (outfile, dfn); Rewrite (outfile); CheckIO;

      Okay := FixLine (infile, outfile);

{---- Close files, then find next file to process ----}

      IF Okay THEN
      BEGIN
        WriteLn (', adjusted.');
        Close (infile);        CheckIO;
        Close (outfile);       CheckIO;
        Swapname := sDir + 'cpt!#$#!.swp';
        Rename (infile, Swapname);  CheckIO;
        Rename (outfile, sfn); CheckIO;
        Rename (infile, dfn);  CheckIO;
(*      Erase (infile);        CheckIO;  *)
      END
      ELSE BEGIN
        WriteLn (', skipped.');
        EraseFile (dfn);
      END;
    END;
    FindNext (dirinfo);
  END;     { now loop back with name of next file to process }

{---- dispose of pointers - not necessary at end, but good practice ----}

  WHILE chain <> NIL DO BEGIN
    anchor := chain;
    chain := chain^. next;
    Dispose (anchor);
  END;

  Writeln('Processed ',Processed, ' file(s).');

END. {main}
