/*  Tagline Exit Script for PMMail - Copyright 1996, Stephen Berg and IceBerg  */
/*                                   Software Productions.                     */

Parse Arg targetfile
'@echo off'

/*  First we load up the VRexx utilities so we can create and manipulate the   */
/*  The pretty windows!!  =:-)                                                 */
call RxFuncAdd 'Vinit', 'VREXX', 'VINIT'
initcode = VInit()
	if initcode = 'ERROR' then SIGNAL CLEANUP
	signal on failure name CLEANUP
	signal on halt name CLEANUP
	signal on syntax name CLEANUP

/*  Now we create a small dialog to let the user pick how he/she wants the     */
/*  tagline for the current message to be chosen.                              */

pick.0 = 4
pick.1 = 'Let PMTagLine randomly pick a TagLine.'
pick.2 = 'Pick one from the file specifically.'
pick.3 = 'Input your own TagLine manually.'
pick.4 = 'Bypass the TagLine insertion.'
Call VRadioBox 'PMTagLine V 0.10', pick, 1
choice = pick.vstring

/*  Take action according to the user's choice.                                */
SELECT
WHEN choice = pick.1 THEN
	Call PickRandom
WHEN choice = pick.2 THEN
	Call PickOne
WHEN choice = pick.3 THEN
	CALL Insert
WHEN choice = pick.4 THEN
	CALL Cancel
OTHERWISE 
	Call VExit
end

/*  Make sure that the message is closed before we exit.                       */
	rc = LineOut(targetfile)
exit

/*  Kill any remaining VREXX stuff.                                            */
CLEANUP:
	Say 'PMTagLine interrupted!!'
	Call VExit

/*  For randomly picking taglines                                              */
PickRandom:
	Call GetTagArray
	pick = RANDOM(1, tagline.0)
	tag = tagline.pick
	rc = LineOut(targetfile, 'PMTagLine - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call VExit
return

/*  To let the user specifically pick one tagline from the taglines.txt       */
/*  file                                                                      */
PickOne:
	Call GetTagArray
	Call VListBox 'Pick a tagline', tagline, 60, 10, 1
	tag = tagline.vstring
	rc = LineOut(targetfile, 'PMTagLine - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call VExit
return

/*  To let the user insert their own tagline                                   */
Insert:
	msg.0 = 3
	msg.1 = 'Please input your own tagline'
	msg.2 = 'in the window below.'
	msg.3 = ''
	msg.vstring = 'Insert witty remark here'
	Call VInputBox 'PMTagLine V 0.10', msg, 60, 1
	tag = msg.vstring
	rc = LineOut(targetfile, 'PMTagLine - Copyright, 1996, Stephen Berg')
	rc = LineOut(targetfile, '...' tag)
	rc = LineOut(targetfile)
	Call VExit
return

/*  Load the tagline file into an array for either picking or random choice.   */
GetTagArray:
	cnt = 0
	do While Lines('tagline.txt') > 0
		cnt = cnt + 1
		tagline.0 = cnt
		tagline.cnt = LineIn('tagline.txt')
	end
return

/*  For no tagline functions to the current message.                           */
Cancel:
	Call VExit
return

