// RW: in order to test the modifications
unit caltest;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinTypes, WinProcs, Calpnl, StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    tCal: TCalenPnl;
  end;

var
  Form1: TForm1;
  vDate: TDateTime;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin

  // RW: Create the calendar
  tCal := TCalenPnl.Create(Self);
  tcal.Parent := Self;

  with tcal do
  begin
     // RW: set property values
     Left := 1;
     Top := 1;
     Width := 200;
     Height := 200;
     TabOrder := 0;
     UseLongDate := False;
     GermanDate := False;
     ShowDate := True;

     // Holidays for german date
     Holidays.Add('6.6.');
     Holidays.Add('1.5.');
     Holidays.Add('3.7.');
     Markdays.Add('1.7.');
     Markdays.Add('5.7.');

     // Holidays for english date
     Holidays.Add('6/6/');
     Holidays.Add('5/1/');
     Holidays.Add('7/3/');
     Markdays.Add('7/1/');
     Markdays.Add('7/5/');

     // she comes in colors...
     ColMarked := clRed;
     ColHoliday := clAqua;
     ColWeekend := clTeal;
  end;

end;

procedure TForm1.Button1Click(Sender: TObject);
const toggle: boolean = True;
begin
  tcal.CalendarDate := Date;
  tcal.GermanDate := toggle;
  toggle := not(toggle);
end;

end.
