



                                       Preface


     The Hard-Wire Four is a set of Foxpro procedures designed to allow the
     programmer a means to create an application quickly and easily.  HW4 is
     written in a dBASE IV compatible language called Foxpro.

     In essence, the programmer creates a data dictionary.  This database
     defines all parameters necessary to create/maintain all files within an
     application.  An edit procedure, often called "the little black box",
     then can used to perform the actual file maintenance.

     By using such procedure code, developed and debugged from other
     applications, a core application can be quickly created.  A person
     knowledgeable in this technique should, therefore, reduce his/her
     programming time significantly.

     This manual will be using dMAIL4 as an example of a working multi-user
     application.  It is assumed, therefore, that the programmer is familiar
     with dMAIL4.

     This manual is not for the beginner.  We will not be discussing how to
     use MS-DOS, or Foxpro.  Examples will be brief, and there will be a lot
     of technical notes within the regular discussions.

     My advice is to peruse the contents of this manual to familiarize
     yourself with its information.  I would not even attempt to read this
     manual until I first looked at the dMAIL4 system.  You also might want
     to familiarize yourself with the dMAIL4 source code (a printout from
     FoxDoc might help).




























                                     - Page 1 -







                             Copyright/License/Warranty




     This document and the program Hard Wire Four ("the software") are
     copyrighted by the author.  The copyright owner hereby licenses you to
     use the software given these restrictions:


          o  the program shall be supplied in its original, unmodified
             form, which includes this documentation;

          o  for-profit use without a license is prohibited;

          o  the program may not be included - or bundled - with other
             goods or services.  Exceptions may be granted upon written
             request only.

          o  no fee is charged beyond a reasonable amount for the media
             and handling ($10 maximum suggested);


          There is no warranty of any kind.  The copyright owner may not
          be held liable for any damages, including any lost profits or
          other incidental or consequential damages arising out of or
          inability to use the software.  By using the software, you agree
          to this.


     Shareware

          HW4 is distributed as Shareware.  It is not free software.
          You are free to try it and make copies for others.  If you
          continue to use this application beyond a reasonable trial
          period, you are required to register it with the distributor
          and author.


     ASP Ombudsman

          This program is produced by a member of the Association of
          Shareware Professionals (ASP).  ASP wants to make sure that the
          shareware principle works for you.  If you are unable to resolve
          a shareware-related problem with an ASP member by contacting the
          member directly, ASP may be able to help.  The ASP Ombudsman can
          help you resolve a dispute or problem with an ASP member, but
          does not provide technical support for members' products.

          Please write to the ASP Ombudsman at 545 Grover Road, Muskegon,
          MI 49442-9427 USA, FAX 616-788-2765 or send a CompuServe message
          via CompuServe Mail to ASP Ombudsman 70007,3536.



          Copyright (C) 1987 Dennis Allen.  All rights reserved.  All
          trademarks mentioned herein belong to their respective owners.

                                     - Page 2 -







                                  TABLE OF CONTENTS


     Preface                                                    1
     Copyright/License/Warranty                                 2
     Defining the Data Dictionary                               5
         Defining the File Layouts                              5
         Defining the Data Dictionary Layout                    7
         Defining the form number                               8
         Defining the Full Screen Form                          9
             Defining a field description                       9
             Defining a database field                         10
                 Size Fields                                   11
             Defining an @ EDIT field                          12
             Defining a memo field                             12
             Validating a database field                       13
             The WHEN clause                                   15
             The Browse clause                                 15
             The Default clause                                16
             The Restore clause                                17
             Calculated fields                                 18
             The Message clause                                19
             The Second Message clause                         19
             The GET_MEMO clause                               19
             The Popup Clause                                  19
             The Description clause                            21
             The GET_READ clause                               22
         Defining the [F]ind type Form                         22
             Defining a field description                      22
             Defining an input field                           22
             Validating an input field                         23
             The WHEN clause                                   23
             The Default clause                                23
             The Restore clause                                23
             The Message clause                                23
             The GET_MEMO clause                               24
             The Popup clause                                  24
             The GET_READ clause                               24
         Defining the Option Grid Form                         25
             Defining a field description                      25
             Defining an input field                           25
             Displaying an @ EDIT field                        26
             Defining a memo field                             26
             Validating an input field                         27
             The WHEN clause                                   27
             The Default clause                                28
             The Restore clause                                28
             The Message clause                                28
             The Second Message clause                         28
             The GET_MEMO clause                               28
             The Popup Clause                                  29
             The Description clause                            30
             The GET_READ clause                               30
         dMAIL4 Data Dictionary                                31




                                     - Page 3 -







                                  TABLE OF CONTENTS


     Basic Installation                                        32
         FOXPRO.INI                                            32
         Initializing Variables                                32
         Main menu loop                                        35
             PROCEDURE WINDOW                                  36
             PROCEDURE GET                                     37
         Cleanup Code                                          37
         SCRPROC.PRG                                           38
             PROCEDURE EDIT                                    39
                 FUNCTION BRV                                  39
                 FUNCTION BRW                                  39
                 PROCEDURE FLD_BRO                             39
                 PROCEDURE FLD_DES()                           39
                 PROCEDURE FLD_FND                             40
                 PROCEDURE FLD_GET                             40
                 PROCEDURE FLD_POP                             41
                 PROCEDURE FLD_SAY                             41
                 PROCEDURE FLD_SHW                             41
                 PROCEDURE FLD_TXT                             41
                 PROCEDURE FLD_UNQ()                           41
                 PROCEDURE FLD_UQS()                           41
             PROCEDURE OPTION                                  42
                 PROCEDURE OPT_GET                             42
                 PROCEDURE OPT_SAY                             42
                 PROCEDURE OPT_TXT                             42
         Invoking the BROWSE procedure                         42
         Invoking the EDIT procedure                           43
             Initial Variable values                           43
                 Multiple Indices                              43
                 Customized BROWSE                             44
         Invoking the OPTION procedure                         45
             Initial Variable values                           45
     Advanced Installation                                     47
         Installing a header editor                            47
         Multiple Screens                                      50
         Multi-user considerations                             52
         Hard-wiring the Screen editor                         53
         Expression Builder                                    53
         SCRDBFS.PRG                                           54
     Final Word                                                55
     Distribution                                              55
     Glossary                                                  56
     Index                                                     59












                                     - Page 4 -







                            Defining the Data Dictionary


     The first section of this manual will describe the data dictionary
     layout.  The second section will define the basic installation necessary
     to use the data dictionary.  The third section will discuss advanced
     installations, including how generate program code, often called "hard-
     wiring".

     Now we will not be creating a data dictionary.  Rather, we will be
     describing the various parts of the dMAIL4 data dictionary.


                            Defining the File Layouts


     dMAIL4, itself, is a simple two flat file system.  The following
     describes the dMAIL4 file structures:


     Structure for database: MAIL.DBF
     Field  Field Name  Type       Width    Dec    Index
         1  USER_ID     Character     20
         2  FIRST       Character     20
         3  LAST        Character     20            Asc
         4  ADDR_1      Character     30
         5  ADDR_2      Character     30
         6  CITY        Character     20
         7  STATE       Character      2
         8  ZIP         Character     20            Asc
         9  SADDR_1     Character     30
        10  SADDR_2     Character     30
        11  SCITY       Character     20
        12  SSTATE      Character      2
        13  SZIP        Character     20            Asc
        14  HOME        Character     14
        15  WORK        Character     14
        16  SEX         Character      1
        17  STATUS      Character      1
        18  HOUSE       Character      1
        19  SS_NO       Character     11
        20  BIRTH       Date           8
        21  WEDDING     Date           8
        22  ACT_DATE    Date           8
        23  MESS        Memo          10
        24  BOL_1       Logical        1
        25  BOL_2       Logical        1
        26  BOL_3       Logical        1
        27  TEMP1       Logical        1
        28  ALTER       Character      1
     ** Total **                     346







                                     - Page 5 -







                            Defining the Data Dictionary


     Structure for database: STATE.DBF

     Field  Name  Type       Width    Dec
         1  STATE       Character      2
         2  STATES      Character     20
         3  ALTER       Character      1
     ** Total **                      23


     The mailing list contains typical information.  First name, last name,
     address, phone, etc.  We also have special purpose fields.  If you are
     curious about their use, read the dMAIL4 manual.

     All multi-user databases need a one character ALTER field to insure data
     integrity.  For information on the use of ALTER, see the multi-user
     portion of the advanced installation section.

     Each DBF file will have a structural compound index.  Each compound
     index will contain one or more index tags.  For example, MAIL.DBF has a
     compound index called MAIL.CDX.  MAIL.CDX, for example, has one tag by
     last name, another tag by zip code (used for bulk mailing).  As you can
     guess, STATE.DBF has a compound index called STATE.CDX that has a tag by
     the two character state code.

     We will be using the following input layouts:


     012345678901234567890123456789012345678901234567890123456789
     0 User ID:
     1 First Name:                           Last:
     2            Billing                    Shipping
     3 Address 1 :
     4 Address 2 :
     5 City/State:
     6 Zip       :
     7 Home      :                           Birth  :
     8 Work      :                           Wedding:
     9 Soc.Sec. #:                           Active :
     10Sex:           Status:                Head of Household:
     11                   +---------- Messages ----------+
     12     [ ] MS-DOS    |                              |
     13     [ ] CP/M      |                              |
     14     [ ] TRSDOS    |                              |
     15                   +------------------------------+


     012345678901234567890123456789012345678901234567890123456789
     1 State      :
     2 Description:

     These are window layouts, not screen layouts.  If you are going to use
     Foxpro, you better get used to windows.



                                     - Page 6 -







                            Defining the Data Dictionary


     In a window layout, all positions are relative to the currently defined
     window.  You may use any position, including row 0.  However, the
     various procedures, including EDIT and OPTION, will use the last row for
     messages.


                       Defining the Data Dictionary Layouts


     The name of the data dictionary is SCR.DBF.  SCR stands for screen
     database, since it's main purpose is to define screen layouts.  SCR.DBF
     always has a compound index, SCR.CDX, and a tag keyed by FORM.  The
     following is the data dictionary layout:


     Structure for database: SCR.DBF

     Field  Field Name  Type       Width    Dec
         1  FORM        Numeric        2
         2  SAY_ROW     Numeric        2
         3  SAY_COL     Numeric        2
         4  SAY_TXT     Character     40
         5  SAY_PIC     Character     40
         6  SAY_FUNC    Character     40
         7  SAY_COLOR   Character     40
         8  GET_ROW     Numeric        2
         9  GET_COL     Numeric        2
        10  GET_NAME    Character     10
        11  GET_PIC     Character     40
        12  GET_FUNC    Character     40
        13  GET_RANGE   Character     40
        14  GET_VALID   Character     40
        15  GET_BROWSE  Character     40
        16  GET_ERR     Character     40
        17  GET_COLOR   Character     40
        18  GET_WHEN    Character     40
        19  GET_REST    Character     40
        20  GET_DEF     Character     40
        21  GET_MSG     Character     40
        22  GET_MSG     Character     40
        23  GET_MEMO    Memo          10
        24  GET_POPUP   Memo          10
        25  GET_DESC    Memo          40
        26  SIZE_1      Numeric        2
        27  SIZE_2      Numeric        2
        28  SIZE_3      Numeric        2
        29  GET_READ    Character     40
     ** Total **                     767







                                     - Page 7 -







                            Defining the Data Dictionary


                             Defining the form number


     In the data dictionary, there are three types of form input.  The full
     screen, the [F]ind key, and the option grid.

     In a full screen type, you define all the input fields required to
     add/update a database record.  The full screen form defines both a full
     screen window and a [B]rowse window.

     On a [F]ind type, you define all the input fields required to perform a
     search on the current index tag.  The [F]ind type is not only used to in
     searches, but defines multi-key uniqueness.

     The option grid defines all the input fields for a group of memory
     variables.  It allows the user to narrow the selection of records and is
     generally used for reports.

     The data dictionary requires each type of input be defined by a form
     number.  Our dMAIL4 system will need 5 form numbers with the following
     functions:


     Form 1  -  All input fields needed to [F]ind by the Last name
     Form 2  -  All input fields needed to [F]ind by the Billing zip code
     Form 3  -  All input fields needed to [F]ind by the Shipping zip code
     Form 4  -  All input fields needed to [F]ind by the User ID
     Form 5  -  All Mailing list database input fields
     Form 6  -  All input fields needed to [F]ind by the State ID
     Form 7  -  All State database input fields
     Form 15 -  All Mailing list database input fields for an option grid


     The first four forms defines all the mailing list indices.  Form 5
     defines the mailing list database itself.  Form 15 defines the option
     grid for the mailing list database and is very similar to form 5.

     Forms 6 & 7 defines the index key and full screen forms for the state
     database.

     The data dictionary has to be indexed by form number1.  However, input
     fields for a given form must be in physical order.  Order is very
     important.  Physical order determines which input fields will prompt
     first, next, and last.





     ____________________
     1 If you create a screen database, don't create an index.  An index will
     be built, automatically.  Remember, however, to PACK as not to leave
     deleted records floating around.


                                     - Page 8 -







                            Defining the Data Dictionary


                          Defining the Full Screen Form




                           Defining a field description


     For the initial screen layout, we can display text, boxes, panels, or
     any kind of field description.  SAY_ROW, SAY_COL defines the location,
     and SAY_TXT define the actual text.  Any text must be within quotes.  If
     SAY_ROW and SAY_COL are zero, no description is displayed.

     SAY_PIC is used to define the picture format.  All picture formats must
     be within quotes.  SAY_FUNC is used to define the function format.
     SAY_COLOR is used to define the output colors.  The following is an
     example:


          SAY_ROW   [1             ]
          SAY_COL   [1             ]
          SAY_TXT   ["Telephone: " ]
          SAY_COLOR [GB+/N,N/GB+   ]


     This will translate to:

          @ 1,1 SAY "Telephone: " COLOR GB+/N,N/GB+


     If SAY_TXT contains FILL (outside any quotes), the fields GET_ROW and
     GET_COL will get used as the third and fourth output parameters.


     Example:  @ SAY_ROW,SAY_COL FILL TO GET_ROW,GET_COL COLOR GB+/N


     If SAY_TXT contains a TO (outside any quotes), the fields GET_ROW and
     GET_COL also get used as the third and fourth output parameters.


     Example:  @ SAY_ROW,SAY_COL TO GET_ROW,GET_COL COLOR GB+/N


     Note:  If SAY_TXT contains a DOUBLE or PANEL (outside any quotes)  the
     SAY_TXT is considered a variation of the TO parameter.


     One last option.  The TO, DOUBLE, or PANEL parameters may be preceded by
     text indicating a title.  The following is an example:





                                     - Page 9 -







                            Defining the Data Dictionary


          SAY_ROW   [10                      ]
          SAY_COL   [10                      ]
          SAY_TXT   [" Warning  " DOUBLE     ]
          SAY_COLOR [SCHEME 5                ]
          GET_ROW   [20                      ]
          GET_COL   [20                      ]


     This will translate to:


          @ 10,10 TO 20,20 DOUBLE COLOR SCHEME 5
          @ 10,15 SAY " Warning " COLOR SCHEME 5


     A couple of notes:  First, all SAY_TXT fields are displayed once.  That
     is, upon entry into the full screen editor.  This text, therefore, will
     not change from record to record.

     Second, SAY_TXT may contain variables, UDFs, or may be variable length
     only if:  GET_COL and GET_ROW are not zero, or GET_NAME is blank.  If
     GET_COL and GET_ROW are zero, and GET_NAME exists, SAY_TXT must be
     evaluated when hard-wire code is generated (a necessity for mouse
     control).


                            Defining a database field


     For each database field, we can define how it will be displayed and how
     it is to receive input.  GET_ROW and GET_COL define where the field will
     be displayed.  GET_NAME defines the database field itself.  If GET_COL
     and GET_ROW are zero, SAY_ROW and SAY_COL+LEN(&SAY_TXT) will be used.
     If the resulting GET_ROW and GET_COL are zero, or if there is no
     GET_NAME defined, the input field is not displayed.

     GET_PIC is used to define the picture format (both input and output).
     All picture formats must be within quotes.  GET_FUNC is used to define
     the function format.  GET_COLOR is used to define the input colors.  The
     following is an example:


          SAY_ROW   [1             ]
          SAY_COL   [1             ]
          SAY_TXT   ["Telephone: " ]
          GET_ROW   [0                                 ]
          GET_COL   [0                                 ]
          GET_NAME  [HOME                              ]
          GET_PIC   ["(999) 999-9999"                  ]
          GET_COLOR [GB+/N,N/GB+                       ]





                                     - Page 10 -







                            Defining the Data Dictionary


     This will translate to:


          @ 1,12 GET M->HOME PICTURE "(999) 999-9999" COLOR GR+/B,B/GR+


     This statement applies both on input and on displaying the record.  If,
     however, GET_COLOR is defined as:


          GET_COLOR [GB+/N,N/GB+   SAY  GR+/B,B/GR+    ]


     GET_COLOR has a SAY clause.  During a READ, the above example will
     translate to:


          @ 1,12 GET M->HOME PICTURE "(999) 999-9999" COLOR GB+/N,N/GB+


     But during a display (CLEAR GETS), it will translate to:


          @ 1,12 GET M->HOME PICTURE "(999) 999-9999" COLOR GR+/B,B/GR+


     Note:  GET_NAME can now be used to display calculated values.  For
     details, see calculated fields later in this section.


                                   Size Fields


     In Foxpro for Windows, changing fonts can change the way a field is
     displayed. To ensure that the entire input field gets displayed, use the
     SIZE_1, and SIZE_2 to define row height, and column length.  Having both
     field defined will cause Foxpro for Windows to adjust the field,
     regardless of font.

     Typically, SIZE_1 would be defined as 1.  SIZE_2, however, can be
     defined as either the field length, -1, or -2.  A value -1 means to use
     the TXTWIDTH() value of the field itself.  A value of -2 means to use
     the TXTWIDTH() value of the GET_PIC.

     Note:  You can also specify SIZE_3, which determines the number of
     characters in the memory variables to edit.  Typically SIZE_3 is used
     with an @ EDIT.








                                     - Page 11 -







                            Defining the Data Dictionary


                             Defining an @ EDIT field


     IF GET_PIC contains the word "EDIT", and the fields SIZE_1 and SIZE_2
     have value (SIZE_3 is optional), @ GET is converted to @ EDIT.  For
     example:


          GET_ROW   [10            ]
          GET_COL   [10            ]
          GET_NAME  [TEXT          ]
          GET_PIC   ["EDIT"        ]
          GET_COLOR [SCHEME 7      ]
          SIZE_1    [5             ]
          SIZE_2    [50            ]

     The above will translate to:


          @ 10,10 EDIT M->TEXT COLOR SCHEME 7 SIZE 5,50


                              Defining a memo field


     If GET_PIC contains the word "MEMO", GET_NAME is a memo field.  Unlike
     other types, memo fields get modified directly via a MODIFY MEMO WINDOW.
     Memo fields allow multi-user editing and a 'discard changes?' escape
     route.

     The SAY_ROW and SAY_COL is assumed to be the upper left corner of the
     memo window.  GET_ROW and GET_COL may become the lower right corner.  If
     GET_ROW and GET_COL are greater than SAY_ROW and SAY_COL, a memo window
     will always be displayed.

     On the other hand, if GET_ROW and GET_COL are less then SAY_ROW and
     SAY_COL, the memo will be displayed in the upper left corner of the
     screen.  Since the memo field may cover other input fields, it is
     displayed only as needed.  This also goes true if a defined memo window
     does not fit on the screen.

     Note:  The memowidth is defined by the variable nMEMOWIDTH.  nMEMOWIDTH
     is initialized in the startup procedure.












                                     - Page 12 -







                            Defining the Data Dictionary



                           Validating a database field


     The GET_VALID field determines if user input is allowed and the type of
     validation.  No user input can occur if the first character of GET_VALID
     is blank (See the WHEN clause).  You can use any type of validation
     clause, even if it is just ".T.".

     In GET_VALID, you can define a validation function.  Validation
     functions are useful in checking index fields against other databases.
     For example, there is a STATE.DBF database.  This database contains all
     the state ID and descriptions.  The following function is used to check
     the state ID used in dMAIL4:


     *
     PROCEDURE fnSTATE
     *
     *    THIS FUNCTION DISPLAYS A STATE NAME, GIVEN A TWO CHARACTER ID.
     *
     *    PUBLIC:
     *      bDISPLAY  -  FLAG, TO MAKE SURE A FLD_SAY IS NOT OCCURRING
     *      nCOL      -  COLUMN NUMBER
     *      nROW      -  ROW NUMBER
     *
     *    VARIABLES:
     *      bFOUND    -  FLAG, FOUND FLAG
     *      cTEMP     -  TEMPORARY VARIABLE
     *      nDBF      -  SAVED WORK AREA
     *
     PRIVATE bFOUND, cTEMP, nDBF
     IF M->STATE=SPACE(LEN(M->STATE)) .AND. LASTKEY() <> -2
       RETURN .F.
     ENDIF
     STORE SELECT() TO nDBF
     SELECT STATE
     IF LASTKEY() = -2 .AND. bDISPLAY
       IF M->STATE <> STATE
         SET EXACT OFF
         SEEK TRIM(M->STATE)
         SET EXACT ON
         IF RECNO(0) <> 0 .AND. RECNO(0) <= RECCOUNT()
           GO RECNO(0)
         ENDIF
         IF EOF()
           GO TOP
         ENDIF
       ENDIF
       DO WINDOW WITH "BROWSE", " Browse State Database ", .T., ;
         "CLOSE GROW ZOOM SYSTEM"
       ON KEY LABEL ENTER KEYBOARD CHR(23)
       BROWSE FIELDS STATE,STATES NOEDIT NOAPPEND COLOR SCHEME 10
       ON KEY LABEL ENTER

                                     - Page 13 -







                            Defining the Data Dictionary


       DO WINDOW WITH "BROWSE", .F.
       = fnLASTKEY(10)
       STORE STATE TO M->STATE
     ENDIF
     SET EXACT ON
     SEEK M->STATE
     bFOUND=FOUND()
     IF bDISPLAY
       IF bFOUND .AND. (nROW > 0 .OR. nCOL > 0)
         @ nROW,nCOL + LEN(M->STATE) + 2 SAY STATES
       && ELSE
       &&   DO ERR WITH "State ID not found"
       ENDIF
     ENDIF
     SELECT (nDBF)
     RETURN bFOUND


     As you can see in this example, any validation function will be passed
     certain variables:  Memory variables of the current record, nCOL, nROW,
     and bDISPLAY.

     The variables nCOL and nROW define the current window position.  No
     output should be displayed if nCOL and nROW are zero.

     The variable bDISPLAY is set to true if the record has been displayed.
     Use bDISPLAY as a safeguard against accidental execution of code.

     If the LASTKEY function is -2, the [F3] key was pressed.  In fnSTATE(),
     pressing [F3] displays a BROWSE of the state database.  This function
     could easily be modified to produce an entire STATE editor.

     Note:  Your startup codes needs SET FUNCTION "F3" TO ";".  The semi-
     colon will translate to [Enter].  Pressing [F3] can then terminate the
     READ, execute the GET_VALID function, and return LASTKEY() = -2.

     You may have noticed that the state function is prefixed by two lower-
     case characters.  If any GET_VALID has a validation function, and this
     function is prefixed by two lower-case characters, the function will be
     executed during the SAY display as well during a GET.  Any boolean
     result is ignored during the display.

     If the given state ID is found in the database, fnSTATE() will return a
     value of true and will display the state description.  If the value is
     false, the message defined in GET_ERR is displayed.  If there is no
     error message, "Not Acceptable Input" will be displayed.  The user will
     be prompted until a correct state is entered or until [Esc] is pressed.

     Note:  Your UDF can have display it's own error messages (via DO ERR).
     If your function displays an error message (set bERR=.t.), the GET_ERR
     will not be displayed.  In fnSTATE(), for example, see the commented &&
     lines.



                                     - Page 14 -







                            Defining the Data Dictionary


     Before continuing, I want to make a couple of points concerning
     validation functions:

          1)  Upon executing a validation function, save the current work
     area and/or record pointer.  The current area and/or record pointer must
     be restored upon exit.  Otherwise, you may be modifying a record not
     currently displayed.

         2)  Work with memory variables (example: M->GROSS).  Only memo
     fields are modified directly.  Actual fields do not get modified until
     completion of an input screen2.


                                 The WHEN clause


     You should now be seeing a pattern developing.  In essence, any option
     used in @ SAY or @ GET can be defined in our data dictionary.  This
     includes a WHEN.  The GET_WHEN field determines if user input will
     occur.

     Let me clarify the last statement.  The GET_VALID field determines if
     input is allowed.  If allowed, the GET_WHEN field will determine if
     input will occur.  The GET_WHEN may be any boolean expression.  If no
     expression is specified, then the default is '.T.'

     For example, a blank GET_VALID means no input can occur.  If the first
     character of GET_VALID is blank, that is also means no input can occur.
     A GET_VALID can still contain a function, however, and that function
     will still be executed.


     Note:  When the first character of GET_VALID is blank, no input can
     occur.  Therefore, an @ SAY is used instead of an @ GET/CLEAR GETS to
     display a field.  Keep this in mind when you are selecting colors.


                                The BROWSE clause


     Now all the input clauses are utilized in the edit [B]rowse command.  As
     far as variables are concerned, all memory variables will be maintained.
     Upon entry to a browse, however, the variables nCOL and nROW will be
     zero.  bDISPLAY will be false.  Also, LASTKEY() cannot test for [F1]
     during a browse.

     You may use the GET_BROWSE field to specify special handling of the
     input field.  For example, GET_BROWSE can specify "/8" for a field
     length of eight.  Any browse field option, except ":V=", may be used.
     GET_VALID defines your validation.

     ____________________
     2 See the procedure FLD_GET.


                                     - Page 15 -







                            Defining the Data Dictionary


     Note:  If GET_BROWSE contains the expression "OMIT", then the entire
     field is omitted from the browse.


                                The Default clause


     When the [A]dd function is invoked, or when you perform a [Ctrl]-[N] in
     a browse, all memory variables are initialized.  The initial values are
     a macro from GET_DEF.  Any memory variable or numeric constant may be
     used.  Any strings in GET_DEF, however, must be in quotes.  If GET_DEF
     is blank, then the memory variable is initialized via SCATTER MEMVAR
     BLANK.

     Note:  If you need to pass calculated values between fields, use
     GET_REST or use a validation function.  GET_DEF only comes into play at
     the beginning of an add function.  As an example, the following
     validation functions pass calculated values between each other:


     *
     PROCEDURE fnPRICE
     *
     *    THIS FUNCTION RETURNS A MARK-UP FOR THE GIVEN PRICE.
     *
     *    VARIABLES:
     *      bTEMP    -  TEMPORARY VARIABLE
     *
     PRIVATE bTEMP
     STORE .T. TO bTEMP
     M->MARK_UP=0
     IF M->UNIT_COST > 0
       M->MARK_UP=ROUND(100*((M->UNIT_PRICE-M->UNIT_COST)/M->UNIT_COST),2)
     ENDIF
     RETURN bTEMP




















                                     - Page 16 -







                            Defining the Data Dictionary


     *
     PROCEDURE fnMARK
     *
     *    THIS FUNCTION RETURNS A UNIT PRICE FOR THE GIVEN MARK UP.
     *
     *    VARIABLES:
     *      bTEMP    -  TEMPORARY VARIABLE
     *
     PRIVATE bTEMP
     STORE .F. TO bTEMP
     IF M->MARK_UP >= 0 .AND. M->MARK_UP <= 100
       STORE .T. TO bTEMP
     ENDIF
     IF bTEMP
       M->UNIT_PRICE=0
       IF M->UNIT_COST > 0
       M->UNIT_PRICE=ROUND((M->UNIT_COST*(M->MARK_UP/100))+M->UNIT_COST,6)
         DO FLD_SHW&cFORM_SCR
       ENDIF
     ENDIF
     RETURN bTEMP


     As you can see, every time the unit price changes the mark-up will
     change.  Every time mark-up changes, and unit price is changed and
     redisplayed.

     Note:  FLD_SHW is the full screen form of "SHOW GETS".


                                The Restore clause


     In the [A]dd, or [U]pdate modes, pressing [Ctrl]-[Home] will perform a
     restore.  A restore will store a macro of GET_REST into the memory
     variable of the current input field.  The "M->" variable is then
     redisplayed.  If GET_REST is blank, pressing [Ctrl]-[Home] recalls the
     current database field of the current record.

     GET_REST allows calculated recalls.  GET_REST, for example, can recall
     the difference between what was received and what shipped.


          MAX(M->ORD_RVD - M->ORD_SHP,0)


     This example allows the user to ship any quantity remaining.

     As stated earlier, the GET_VALID field determines if user input is
     allowed.  If allowed, the GET_WHEN field will determine if input will
     occur.  If user input is not allowed or cannot occur, GET_REST will be
     used like a GET_DEF field.



                                     - Page 17 -







                            Defining the Data Dictionary


     For example, when defining the dMAIL4 ACT_DATE field, we will leave
     GET_VALID and GET_WHEN blank, and will define GET_REST as "DATE()".  In
     this way, when a customer is updated, ACT_DATE will automatically
     receive the current date.

     Normally, initialization will happen during the update mode and before
     the user is prompted for the first input field.  If the first two
     characters of GET_REST are lower-case, however, then initialization will
     occur during the record display and between each input field.

     For instance, say we had a data dictionary record that did a file
     lookup.  Probably using a defined popup.  Having found the correct
     record, we need some initial field values.  GET_DEF only works before
     user input.  GET_REST with lowercase characters, however, will occur
     between each input field.


          GET_NAME       [CUR_RATE           ]
          GET_VALID      [                   ]
          GET_WHEN       [bADD               ]
          GET_REST       [clIENT->CUR_RATE   ]


     In this example, the CUR_RATE will obtain it's value from the CUR_RATE
     field in the client file.  This will happen between each input field,
     but only in the add mode.


     Note:  Some restore capability has been added to the [B]rowse command.
     If GET_REST is defined, pressing [Ctrl]-[Home] will perform the restore.

     If an input field has a valid UDF, explicit GET_REST (user input is not
     allowed or cannot occur) fields are restored.  Since this is a browse,
     both upper and lower case explicit GET_REST fields are restored.


                                Calculated fields


     Recently, GET_NAME has been given the ability to define a calculated
     field.  For GET_NAME to have a calculated field, GET_DEF, GET_REST, and
     GET_BROWSE must be defined.  Make sure that the first two characters of
     GET_REST are lower-case.  Example:


          GET_ROW        [10                      ]
          GET_COL        [10                      ]
          GET_NAME       [FLAG                    ]
          GET_VALID      [                        ]
          GET_WHEN       [                        ]
          GET_DEF        [" "                     ]
          GET_BROWSE     [=IIF(EMPTY(GIF)," ","*")]
          GET_REST       [iiF(EMPTY(GIF)," ","*") ]


                                     - Page 18 -







                            Defining the Data Dictionary



     There is no database field called FLAG.  If the memo field GIF is not
     empty, an asterisk is displayed.


                                The Message clause


     The screen database field, GET_MSG, simply contains the prompt message
     for each input field.  When prompting the user, the prompt message
     allows you to more clearly describe the input field.  The message must
     be a string and it must be in quotes.


                            The Second Message clause


     If a screen database contains the field, GET_MSG2, a second message is
     displayed for the given input field.  Unlike GET_MSG, however, GET_MSG2
     is displayed from the DIALOG procedure.  Similar to the way popups
     display a message.  Example:

          GET_MSG2       ["Press [F3] for browse","[Esc] to abort"]

     ...converts to:

          DO DIALOG WITH "Press [F3] for browse","[Esc] to abort"

     ...before the field is active, and:

          DO DIALOG WITH .F.

     ...after the field is terminated.


                               The GET_MEMO clause


     The screen database field, GET_MEMO, contains the memo help text for
     each input field.  When the user presses [F1], the help memo window will
     appear (unless there is no help text, then control is passed directly to
     the GET_VALID function).  When the DOS environment variable DEBUG is set
     to YES, the user may alter help memo contents.


                                 The Popup clause


     Popups have recently been added to the data dictionary.  A popup is
     defined in the GET_POPUP memo field.  The following is an example of a
     popup memo defined for the field CITY:




                                     - Page 19 -







                            Defining the Data Dictionary


               "Detroit"      PROMPT    "Detroit"
               "Grand Rapids" PROMPT    "Grand Rapids"
               "Lansing"      PROMPT    "Lansing"

     Each line represents one option in the popup.  The characters after the
     'PROMPT' represent the displayed popup.  The characters before 'PROMPT'
     represent the returned value.

     Once defined in GET_POPUP, a popup can be executed in one of three ways.
     First, when the first character of GET_VALID is blank.  A blank
     GET_VALID means no user input on the field can occur.  The popup is,
     therefore, mandatory.  Second, when the user presses [F2].  Third, when
     validation returns ".F.".

     A POPUP can define a file name lookup.  For example, the following
     defines a popup to all program files in the dMAIL4 directory:

          PROMPT FILES   "D:\DMAIL4\*.PRG"

     In PROMPT FILES, anything before "PROMPT " is ignored.  Only the
     filename is returned.  Not the directory path.

     A GET_POPUP also can define a lookup to another file.  For example, in
     our STATE.DBF, the following defined a popup to the state ID field:

          STATE->STATE   PROMPT FIELD STATES

     You must have the FIELD clause.  Upon execution, the state file will be
     displayed in the popup.  When a state id is selected, the memory
     variable M->STATE will contain STATE->STATE.

     The PROMPT FIELD may also contain a SKIP FOR clause.  Example:

          STATE->STATE   PROMPT FIELD   STATES SKIP FOR STATE="VI"

     The "SKIP FOR" is a temporary "SET FILTER TO .NOT. ()" statement.

     There can be other statements in the popup memo field.  If 'SEEK ' is
     found, validation will use this definition of SEEK.  This statement
     allows multiple-key lookups, while retaining single field results.

     If 'SCATTER MEMVAR' is found, and if the popup selection changes, a
     SCATTER MEMVAR will be performed on the lookup file.  All memory
     variables in the current record will reflect the values in the lookup
     file.

     The statement 'SCATTER MEMVAR' is a quick way of obtaining field values.
     You may also specify individual fields.  Example:

          M->PAR_LAST = LAST

     Note:  It is important that you specify memory variables using 'M->'.
     This system does not recognize 'm.' memory variables.


                                     - Page 20 -







                            Defining the Data Dictionary



                              The Description clause


     The GET_DESC has also been added to the data dictionary.  Whereas
     GET_ERR is displayed when validation is false, GET_DESC is displayed
     when validation is true.  When validation becomes true, GET_DESC will be
     displayed one character beyond the last position of the current field.

     There is one special case, and it occurs when a popup is defined.  If
     GET_DESC contains the value 'PROMPT()', it means one of two things.

     First, of course, the user wants the selection prompt to be displayed
     after the input field.  If the first two characters of GET_VALID are
     lower-case (even ".t"), the selection prompt will be displayed during a
     display as well as during a READ.

     Second, and most important, 'PROMPT()' means to perform a validation on
     the input field against the popup selections.  The fnSTATE() function,
     for example, is no longer needed.  If the GET_VALID is defined simply as
     '.t.', our hard-wire code does all the work.  For simple files,
     'PROMPT()' will actually perform faster than a UDF.

     Note:  The GET_POPUP for the STATE field could contain a list of all
     state ID and descriptions.  This would eliminate the need for a
     STATE.DBF.  In either case, GET_DESC contains 'LEFT(" ",+PROMPT(),1)' to
     allow validation without displaying a description.




























                                     - Page 21 -







                            Defining the Data Dictionary




                               The GET_READ clause


     Each input field executes it's own @ GET/READ.  You need not concern
     yourself with how many nested READs are active.  This feature also
     allows the user to customize the read.  GET_READ may include any READ
     option available in Foxpro.

     For example, if you were using a radio button on the field TYPE, you
     might want to include 'OBJECT M->TYPE' in your GET_READ.  If you wanted
     to do a push button, you might include 'CYCLE' in your GET_READ.

     One note:  In multi-user mode, a 'READ TIMEOUT nTO_READ' is executed
     (nTO_READ is defined in the start-up procedure).  When a timeout occurs,
     the ALTER field is checked.  If you do want to specify your own TIMEOUT,
     however, the GET_READ value will override the nTO_READ value.


                          Defining the [F]ind Type Form


     The find type form is not that much different then the full screen form.
     Most of our data dictionary is used in the same way.  However, each
     record in a find form defines just one line in a dialog box.


                           Defining a field description


     SAY_TXT define the actual prompt text.  SAY_COL defines the number of
     spaces before SAY_TXT.  SAY_ROW, SAY_PIC, SAY_FUNC, and SAY_COLOR are
     ignored.


                             Defining an input field


     GET_NAME defines the input field name.  GET_PIC defines the picture
     format.  All picture formats must be within quotes.  GET_COL and GET_ROW
     are ignored.

     GET_PIC can be used to define the picture format.  GET_FUNC can be used
     to define the function format.  GET_COLOR is used to define the input
     colors.









                                     - Page 22 -







                            Defining the Data Dictionary


                            Validating an input field


     The GET_VALID field determines if user input is allowed.  No user input
     can occur if the first character of GET_VALID is blank (See the WHEN
     clause).  In a find type form, the GET_VALID does not validate.  It is,
     however, executed.  As you will see later, this feature can be very
     useful.3


                                 The WHEN clause


     The GET_VALID field determines if input is allowed.  If allowed, the
     GET_WHEN field will determine if input will occur.  The GET_WHEN may be
     any boolean expression.  If no expression is specified, then the default
     is '.T.'


                                The Default clause


     The GET_DEF clause is always used for all find type forms.  If GET_DEF
     is blank, then the memory variable is initialized via SCATTER MEMVAR
     BLANK.


                                The Restore clause


     Pressing [Ctrl]-[Home] will perform a restore.  A restore will store a
     macro of GET_REST into the memory variable of the current input field.
     The "M->" variable is then redisplayed.  If GET_REST is blank, pressing
     [Ctrl]-[Home] recalls the current database field of the current record.


                                The Message clause


     The screen database field, GET_MSG, has different functions depending on
     the form type.  If the form type is a full screen input, then GET_MSG
     will contain the prompt message for each input field.  When prompting
     the user, the prompt message allows you to more clearly describe the
     input field.  The message must be a string and it must be in double
     quotes.

     If the form type is a [F]ind, then GET_MSG contains the description on
     how to build an index search string.  For example, say we had a tag
     index on the mailing list database by last name/active date.  The index
     would be created as follows:

     ____________________
     3 See the procedure FLD_FND.


                                     - Page 23 -







                            Defining the Data Dictionary



     INDEX ON UPPER(LAST)+DTOC(ACT_DATE,1) TAG DATE OF (cDATAPATH+"MAIL")


     A form 10 could be defined as a [F]ind type.  We would have one input
     field prompting for the last name, another input field prompting for the
     active date.  The GET_MSG for last name would contain     UPPER(M-
     >LAST).  For the active date prompt, GET_MSG would contain DTOC(M-
     >ACT_DATE,1).  The search string then becomes:


     cSEARCH=UPPER(M->LAST)+DTOC(M->ACT_DATE,1)


     Note:  A double quote in GET_MSG indicates a full screen form.  If you
     need to define strings in a [F]ind form, use single quotes.


                               The GET_MEMO clause


     The screen database field, GET_MEMO, contains the memo help text for
     each input field.  When the user presses [F1], the help memo window will
     appear (provided a GET_VALID function doesn't grab the [F1] first).
     When the DOS environment variable DEBUG is set to YES, the user may
     alter help memo contents.


                                 The Popup clause


     Popups have recently been added to the data dictionary.  A popup is
     defined in the GET_POPUP memo field.  They can be used for a full screen
     form, a [F]ind key form, or the option grid form.

     Each memo text line represents one option in the popup.  The characters
     after the 'PROMPT ' represent the displayed popup.  The characters
     before 'PROMPT ' represent the returned value.

     Once defined in GET_POPUP, a popup can be executed in one of three ways.
     First, when the first character of GET_VALID is blank.  A blank
     GET_VALID means no user input on the field can occur.  The popup is,
     therefore, mandatory.  Second, when the user presses [F2].  Third, when
     validation returns ".F.".


                               The GET_READ clause


     Each input field executes it's own @ GET/READ.  You need not concern
     yourself with how many nested READs are active.  This feature also
     allows the user to customize the read.  GET_READ may include any READ
     option available in Foxpro.


                                     - Page 24 -







                            Defining the Data Dictionary


                          Defining the Option Grid Form


     The option grid form is very similar to the full screen form.  All the
     same features are available.  There are only a few differences.


                           Defining a field description


     For the initial screen layout, we can display text, boxes, panels, or
     any kind of field description.  SAY_ROW, SAY_COL defines the location,
     and SAY_TXT define the actual text.  Any text must be within quotes.  If
     SAY_ROW and SAY_COL are zero, no description is displayed.

     SAY_PIC can be used to define the picture format.  SAY_FUNC can be used
     to define the function format.  SAY_COLOR is used to define the output
     colors.

     If SAY_TXT contains FILL (outside any quotes), the fields GET_ROW and
     GET_COL will get used as the third and fourth output parameters.

     If SAY_TXT contains a TO (outside any quotes), the fields GET_ROW and
     GET_COL also get used as the third and fourth output parameters.

     Note:  If SAY_TXT contains a DOUBLE or PANEL (outside any quotes)  the
     SAY_TXT is considered a variation of the TO parameter.

     One last option to consider.  The TO, DOUBLE, or PANEL parameters may be
     preceded by text indicating a title.  The following is an example:


               SAY_ROW   [10                      ]
               SAY_COL   [10                      ]
               SAY_TXT   [" Warning  " DOUBLE     ]
               SAY_COLOR [SCHEME 5                ]
               GET_ROW   [20                      ]
               GET_COL   [20                      ]


     This will translate to:


               @ 10,10 TO 20,20 DOUBLE COLOR SCHEME 5
               @ 10,15 SAY " Warning " COLOR SCHEME 5


                             Defining an input field


     For each input field, we can define where and how it will be displayed.
     GET_ROW and GET_COL define where the field will be displayed.  GET_NAME
     defines the input field itself.


                                     - Page 25 -







                            Defining the Data Dictionary


     For the option grid form, memory variables must be defined in GET_NAME.
     A memory variable is either prefixed by a lower-case letter "cTEMP", or
     contains the characters "->".


     Note:  You must be the same variables in any GET_VALID, GET_DEF or
     GET_REST as defined in GET_NAME.


     GET_PIC defines the picture format (both input and output).  All picture
     formats must be within quotes.  If GET_COL and GET_ROW are zero, SAY_ROW
     and SAY_COL+LEN(&SAY_TXT) will be used.  If the resulting GET_ROW and
     GET_COL are defined as zero, or if there is no GET_NAME defined, the
     input field is not displayed.

     GET_PIC can be used to define the picture format.  GET_FUNC can be used
     to define the function format.  GET_COLOR is used to define the input
     colors.


     Note:  GET_COLOR may have a SAY clause.  A SAY clause means that all
     text before "SAY" define color during a READ.  All text after "SAY"
     define the CLEAR GETS color.


                             Displaying @ EDIT field


     IF GET_PIC contains the word "EDIT", and the fields SIZE_1 and SIZE_2
     have value (SIZE_3 is optional), the @ GET is converted to @ EDIT. This
     is very useful in the option grid.

     For example, in dMAIL4 there is a memo field called MESS.  In the option
     grid, we can use @ EDIT to define a character string M->MESS.  M->MESS
     will look and feel like a memo window.  M->MESS will allow the user to
     define several wild-cards on the memo MESS (please see MALPRA.PRG).  To
     really look like a memo window, you may need to include a DOUBLE with a
     title.


                              Defining a memo field


     If GET_PIC contains the word "MEMO", GET_NAME is a memo field.  Memo
     fields get modified directly via a MODIFY MEMO WINDOW.  Memo fields
     allow multi-user editing and a 'discard changes?' escape route.

     The SAY_ROW and SAY_COL is assumed to be the upper left corner of the
     memo window.  GET_ROW and GET_COL may become the lower right corner.  If
     GET_ROW and GET_COL are greater than SAY_ROW and SAY_COL, a memo window
     will always be displayed.




                                     - Page 26 -







                            Defining the Data Dictionary


     On the other hand, if GET_ROW and GET_COL are less then SAY_ROW and
     SAY_COL, the memo will be displayed in the upper left corner of the
     screen.  Since the memo field may cover other input fields, it is
     displayed only as needed.  This also goes true if a defined memo window
     does not fit on the screen.


                            Validating an input field


     The GET_VALID field determines if user input is allowed and the type of
     validation.  No user input can occur if the first character of GET_VALID
     is blank (See the WHEN clause).  You can use any type of validation
     clause, even if it is just ".T.".

     For validation functions, certain variables are passed.  The variables
     nCOL and nROW define the current window position.  No output should be
     displayed if nCOL and nROW are zero.

     The variable bDISPLAY is set to true if the record has been displayed.
     Use bDISPLAY as a safeguard against accidental execution of code.

     If any GET_VALID has a validation function, and this function is
     prefixed by two lower-case characters, the function will be executed
     during the display as well during a GET.  Any boolean result is ignored
     during the display.

     If the validation is false, the message defined in GET_ERR is displayed.
     If there is no error message, "Not Acceptable Input" will be displayed.
     The user will then be prompted until a correct state is entered or until
     [Esc] is pressed.


                                 The WHEN clause


       The GET_VALID field determines if input is allowed.  If allowed, the
     GET_WHEN field will determine if input will occur.  The GET_WHEN may be
     any boolean expression.  If no expression is specified, then the default
     is '.T.'

     For example, a blank GET_VALID means no input can occur.  If the first
     character of GET_VALID is blank, that is also means no input can occur.
     A GET_VALID can still contain a function, however, and that function
     will still be executed.

     Note:  When the first character of GET_VALID is blank no input can
     occur.  Therefore, an @ SAY is used instead of an @ GET/CLEAR GETS to
     display a field.  Keep this in mind when you are selecting colors.






                                     - Page 27 -







                            Defining the Data Dictionary


                                The Default clause


     Default values may either be defined outside the option grid, or using
     the GET_DEF field.  Any memory variable or numeric constant may be used
     in GET_DEF.  Any strings, however, must be in quotes.


                                The Restore clause


     In the [A]dd or [U]pdate modes, pressing [Ctrl]-[Home] will perform a
     restore.  A restore will store a macro of GET_REST into the GET_NAME
     variable of the current input field.

     In a full screen form, [Ctrl]-[Home] recalls the current database field
     of the current record.  In an option grid, however, the initial values
     of variables are stored in an array call OPT.

     If GET_REST is blank, therefore, the value saved in OPT(nFLD) is
     recalled (Where nFLD indicates the current field location).


                                The Message clause


     The screen database field, GET_MSG, simply contains the prompt message
     for each input field.  When prompting the user, the prompt message
     allows you to more clearly describe the input field.  The message must
     be a string and it must be in quotes.


                            The Second Message clause


     If a screen database contains the field, GET_MSG2, a second message is
     displayed for the given input field.  Unlike GET_MSG, however, GET_MSG2
     is displayed from the DIALOG procedure.  Similar to the way popups
     display a message.


                               The GET_MEMO clause


     The screen database field, GET_MEMO, contains the memo help text for
     each input field.  When the user presses [F1], the help memo window will
     appear (unless there is no help text, then control is passed directly to
     the GET_VALID function).  When the DOS environment variable DEBUG is set
     to YES, the user may alter help memo contents.






                                     - Page 28 -







                            Defining the Data Dictionary


                                 The Popup clause


     Popups have recently been added to the data dictionary.  A popup is
     defined in the GET_POPUP memo field.

     Each line represents one option in the popup.  The characters after the
     'PROMPT' represent the displayed popup.  The characters before 'PROMPT'
     represent the returned value.

     Once defined in GET_POPUP, a popup can be executed in one of three ways.
     First, when the first character of GET_VALID is blank.  A blank
     GET_VALID means no user input on the field can occur.  The popup is,
     therefore, mandatory.  Second, when the user presses [F2].  Third, when
     validation returns ".F.".

     A POPUP can define a file name lookup.  For example, the following
     defines a popup to all program files in the dMAIL4 directory:

          PROMPT FILES   "D:\DMAIL4\*.PRG"

     In PROMPT FILES, anything before "PROMPT " is ignored.  Only the
     filename is returned.  Not the directory path.

     A POPUP also can define a lookup to another file.  For example, the
     following defines a popup to the field STATE:

          STATE->STATE   PROMPT FIELD   STATES

     You must have the FIELD clause.  Upon execution, the state descriptions
     will be displayed in the popup.  When a state is selected, the memory
     variable M->STATE will contain STATE->STATE.

     The PROMPT FIELD may also contain a SKIP FOR clause.  Example:

     STATE->STATE   PROMPT FIELD   STATE SKIP FOR STATE="MI"

     The "SKIP FOR" is a temporary "SET FILTER TO .NOT. ()" statement.

















                                     - Page 29 -







                            Defining the Data Dictionary


                              The Description clause


     The GET_DESC field was recently added to the data dictionary.  Where
     GET_ERR is displayed when validation is false, GET_DESC is displayed
     when validation is true.  When validation becomes true, GET_DESC will be
     displayed one character beyond the last position of the current field.

     There is one special case, and it occurs when a popup is defined.  If
     GET_DESC contains the value 'PROMPT()', it means one of two things.

     First, of course, the user wants the selection prompt to be displayed
     after the input field.  If the first two characters of GET_VALID are
     lower-case (even ".t"), the selection prompt will be displayed during a
     display as well as during a READ.

     Second, and most important, 'PROMPT()' means to perform a validation on
     the input field against the popup selections.


     Note:  Think of 'PROMPT()' as a validation UDF, replacing ".t.", within
     GET_VALID.  For an option grid, it means you can specify a selection not
     within the popup.  Example:

          GET_VALID [.t. .OR. EMPTY(M->STATE)]

     In the option grid, this statement allows the state id to remain blank.
     Otherwise, it is validated against the state database.


                               The GET_READ clause


     Each input field executes it's own @ GET/READ.  You need not concern
     yourself with how many nested READs are active.  This feature also
     allows the user to customize the read.  GET_READ may include any READ
     option available in Foxpro.

     For example, if you were using a radio button on the numeric field
     nTYPE, you might want to include 'OBJECT nTYPE' in your GET_READ.  If
     you wanted to perform a push button, you might include 'CYCLE' in your
     GET_READ.

     One note:  In multi-user mode, a 'READ TIMEOUT nTO_READ' is performed
     (nTO_READ is defined in the start-up procedure).  When a timeout occurs,
     the ALTER field is checked for change.  If you do want to specify your
     own TIMEOUT, however, the GET_READ value will override the nTO_READ
     value.







                                     - Page 30 -







                            Defining the Data Dictionary



                              dMAIL4 Data Dictionary


     Well, now that you have been shown all the fundamentals of a data
     dictionary, it shouldn't be too hard to decipher the dMAIL4 screen
     database.  When creating your own, there is only a couple of points to
     remember:


          1)  SAY_TXT, GET_PIC, GET_DEF, and GET_MSG (for full screen input)
     have to be in string format.  All strings should be surrounded by
     quotes.

          2)  In a full screen form, database fields (outside of GET_NAME)
     should be referenced by it's memory variable counter-part.  With the
     exception of memo fields, which get edited directly, never reference a
     database field directly.  Only when a full screen input is completed
     does database fields get replaced by their memory variables.


     My advice is to browse through the dMAIL4 SCR.DBF.  Compare the fields
     of each record with the documentation you just read.  Then run dMAIL4.
     You'll find that every record defined is doing exactly what it should in
     the application.






























                                     - Page 31 -







                                 Basic Installation




                                    FOXPRO.INI


     The first section described how to create a screen database.  This
     section will describe how to install the screen editor.  The first thing
     you need to know is how to setup the FOXPRO.INI file.  Each user must
     have a FOXPRO.INI file in his/her resource directory.  Within the
     "[GetnEnv]" section are flags required to invoke certain application
     functions.  The following is the list:


     *      ADD=NO       -  FLAG, NO LOOP IN ADD MODE
     *      DATA=D:      -  DATA PATH
     *      DEBUG=YES    -  FLAG, DEBUG & SET ESCAPE
     *      INIT=YES     -  FLAG, PACK/ZAP DATABASES
     *      MULT=YES     -  FLAG, ENABLE MULTI-USER MODE
     *      PROG=D:      -  PROGRAM PATH
     *      RECALL=YES   -  FLAG, RECALL DELETED RECORDS
     *      TEMP=E:      -  TEMPORARY FILE PATH
     *      TERM=ANSI    -  TERMINAL MODE
     *
     For example, if the application is on drive D, you need to add a
     "PROG=D:\DMAIL4\" to the "[GetEnv]" section.  To invoke the application
     to multi-user, add a "MULT=YES" to that user's FOXPRO.INI file.


                              Initializing Variables


     Now your application needs a main module.  This module will need to
     initialize all variables for our "little black box".  In dMAIL4, the
     following variables are initialized in it's main module:


     CLEAR ALL
     CLOSE ALL
     SET RESOURCE ON
     SET SAFETY OFF
     SET TALK OFF

     cPATH_SEP = "\"
     cDRIV_SEP = ":\"
     IF _UNIX
       cPATH_SEP = "/"
       cDRIV_SEP = "/"
     ENDIF

     PRIVATE FLD, cFOXUSER
     cFOXUSER = SYS(2005)
     IF ADIR(FLD,cFOXUSER) = 0 .OR. FLD(1,2) < 1000
       cFOXUSER = SYS(2004)+"FOXUSER.DBF"
       IF ADIR(FLD,cFOXUSER) = 0 .OR. FLD(1,2) < 1000

                                     - Page 32 -







                                 Basic Installation


         cFOXUSER = SYS(2003)
         = fnPATH(@cFOXUSER)
         cFOXUSER = cFOXUSER + "FOXUSER.DBF"
         IF ADIR(FLD,cFOXUSER) = 0 .OR. FLD(1,2) < 1000
           STORE "" TO cFOXUSER
         ENDIF
       ENDIF
       IF LEN(cFOXUSER) > 0
         SET RESOURCE TO (cFOXUSER)
       ENDIF
     ENDIF
     RELEASE FLD, cFOXUSER

     STORE SUBSTR(SYS(2005),1,RAT(cPATH_SEP,SYS(2005))) TO cMEMPATH
     = fnPATH(@cMEMPATH)

     STORE fnGETENV("DATA") TO cDATAPATH
     = fnPATH(@cDATAPATH)

     STORE FULLPATH(fnGETENV("PROG")) TO cPROGPATH
     = fnPATH(@cPROGPATH)

     STORE fnGETENV("TEMP") TO cTEMPPATH
     = fnPATH(@cTEMPPATH)

     These variables set the program and data paths.  Note we use two
     functions, fnGETENV and fnPATH.  fnGETENV will get environment variables
     from FOXPRO.INI.  If none exist, it attempts to get DOS environment
     variables.

     fnPATH returns a valid fullpath string variable.  Both fnGETENV and
     fnPATH must to be in your application startup module.


     IF NETWORK() .AND. LEN(fnGETENV("MULT")) > 0
       SET EXCLUSIVE OFF
       STORE .T. TO bMULT
     ELSE
       SET EXCLUSIVE ON
       STORE .F. TO bMULT
     ENDIF

     IF LEN(fnGETENV("DEBUG"))>0 .AND. .NOT. "RUNTIME" $ UPPER(VERSION());
                               .AND. .NOT. "EXE"     $ UPPER(VERSION())
       STORE .T. TO bDEBUG
       SET DEBUG ON
       SET DEVELOPMENT ON
       SET HELP ON
     ELSE
       STORE .F. TO bDEBUG
       SET DEBUG OFF
       SET DEVELOPMENT OFF
       SET ECHO OFF
       SET HELP OFF

                                     - Page 33 -







                                 Basic Installation


       SET STEP OFF
     ENDIF

     bANSI = _DOS .OR. _MAC .OR. _WINDOWS .OR. ;
       (LEN(fnGETENV("TERM")) > 0 .AND. UPPER(fnGETENV("TERM")) = "ANSI")

     bINIT   = LEN(fnGETENV("INIT")) > 0
     bRECALL = LEN(fnGETENV("RECALL")) > 0


     These variable define some of the system variables needed.  They also
     use the fnGETENV function.


     DIMENSION cWINDOW(1),nWINDOW(1)
     STORE "" TO cWINDOW
     STORE  0 TO nLEVEL,nWINDOW
     STORE  4 TO nSTART

     STORE .F. TO bLOCATE, bNO_CDX, bNO_ERR
     STORE .F. TO bBLK, bEXACT, bINT, bINV, bNO_INT, bUNIQUE
     STORE "" TO cFONT, cSTYLE
     STORE 60  TO nMEMOWIDTH
     STORE  0  TO nFONT, nSCHEME

     STORE 60 TO nTO_READ

     STORE    "" TO cBROWSE, cINDEX
     STORE ".T." TO cFILTER

     STORE "MAL"    TO cMASTER 1
     STORE "MALEDA" TO cREINDEX 2
     STORE "MALSYS" TO cSYSTEM 3


     These variables are needed in the edit and option procedures.


     cPR_PRN  = 'PRN'
     cPR_10   = 'CHR(27)+"P"'
     cPR_12   = 'CHR(27)+"M"'
     cPR_DEF  = 'CHR(27)+"@"'
     cPR_CON  = 'CHR(27)+CHR(15)'
     cPR_BON  = 'CHR(27)+CHR(69)'
     ____________________
     1 Startup procedure file.  When an error is logged into the Foxpro error
     handler, program control is returned to this procedure.

     2 Procedure defined to reindex all database files.  Used in error
     handler.

     3 System memory file.  Used to store printer codes and other system
     variables.


                                     - Page 34 -







                                 Basic Installation


     cPR_BOFF = 'CHR(27)+CHR(70)'
     cPR_UON  = 'CHR(27)+CHR(45)+CHR(1)'
     cPR_UOFF = 'CHR(27)+CHR(45)+CHR(0)'
     nPR_MAX  = 66
     nPR_SW   = 53

     IF fnFILE(cMEMPATH+cSYSTEM+".MEM") 4
       RESTORE FROM (cMEMPATH+cSYSTEM) ADDITIVE
     ENDIF

     SET FUNCTION "F2" TO ""
     SET FUNCTION "F3" TO ";"
     SET FUNCTION "F4" TO ""
     SET FUNCTION "F5" TO ""
     SET FUNCTION "F6" TO ""
     SET FUNCTION "F7" TO ""
     SET FUNCTION "F8" TO ""
     SET FUNCTION "F9" TO ""
     SET FUNCTION "F10" TO ""

     These variables set printer defaults.  If printer codes exists in the
     cSYSTEM file, they are restored.

     There may be other variables, so look at MAL.PRG for the latest code.
     For more information on variable usage, check the Glossary.


                                  Main menu loop


     Your main menu loop should contain the following code:
     .
     .
       POP KEY ALL
       ON ERROR DO FOXERR WITH ERROR(), MESSAGE(), MESSAGE(1), PROGRAM(),
     LINENO(), SYS(16)
       IF bANSI
         IF _DOS
           ON KEY LABEL INS DO INS
         ENDIF
         ON KEY LABEL ALT+O DO OBJLOCK
         ON KEY LABEL ALT+V DO VIDEO
         ON KEY LABEL F1    DO FLD_HELP WITH
     IIF(nLEVEL>0,cWINDOW(nLEVEL),""), 0
         ON KEY LABEL F7    DO EJECT
         ON KEY LABEL F10   KEYBOARD CHR(23)
         IF bDEBUG
           ON KEY LABEL ALT+D DO DEBUGGER WITH PROGRAM(), LINENO()
         ENDIF
         ON KEY LABEL ALT+F4 DO LOAD_CALC
     ____________________
     4 fnFILE is equivalent to !SYS(2000).  fnFILE can also generate
     temporary file names.


                                     - Page 35 -







                                 Basic Installation


         ON KEY LABEL CTRL+F4 DO SET_CALC
         ON KEY LABEL ALT+F5 DO LOAD_CALR
         ON KEY LABEL CTRL+F5 DO SET_CALR
       ENDIF
       SET DELETED ON
       SET ESCAPE OFF
       SET EXACT ON
       SET UDFPARMS TO VALUE
       CLEAR GETS
       CLEAR MENUS
       CLEAR POPUPS
       CLEAR PROMPT
       CLEAR TYPEAHEAD
       CLEAR WINDOWS
       CLOSE MEMO ALL
       FLUSH
       RELEASE _DIALOG, _THERM

       DO SET_VIEW

       STORE 0 TO nLEVEL

       STORE .F. TO bLOCATE, bNO_CDX, bNO_ERR
       STORE .F. TO bBLK, bEXACT, bINT, bINV, bNO_INT, bUNIQUE
       STORE "" TO cFONT, cSTYLE
       STORE  0  TO nFONT, nSCHEME

       STORE    "" TO cBROWSE, cINDEX
       STORE ".T." TO cFILTER


                                 PROCEDURE WINDOW


     Each menu should have it's own window.  Add the following code to your
     main menu loop:

       DO WINDOW WITH "", " M A I N   M E N U "


     Since this procedure is called MAL.PRG, this command defines the window
     "MAL" with a title " M A I N   M E N U ".  The starting row is defined
     by the variable nSTART.  The starting column is determined by the value
     of MOD(nLEVEL,4).  This gives your windows a layered effect.  FYI:
     nLEVEL is the current window level.  cWINDOW(nLEVEL) is the name of the
     current window.

     The WINDOW procedure is quite powerful.  For example, the following:

     nSTART=1
     DO WINDOW WITH "TEMP", " TEMP WINDOW ", .T., "GROW FLOAT"

     ...defines a full screen window that can grow or float.  nLEVEL is
     ignored.  To remove this window, execute the following:

                                     - Page 36 -







                                 Basic Installation



     DO WINDOW WITH "TEMP", .F.


     Note:  If you perform a 'CLEAR WINDOW' and a 'STORE 0 TO nLEVEL' in your
     menu loop, you don't need to add a 'DO WINDOW WITH "", .F.'.


                                  PROCEDURE GET


     Recently, the GET procedure has been introduced.  The GET procedure
     provides an easy way to create and maintain menus.  In essence, each
     call to the GET procedure creates a single @ GET push-button.

     @ GET push buttons have a couple of advantages over traditional @
     PROMPTs.  First, unlike an @ PROMPT, an @ GET push button allows access
     to the system menu.  Second, within Foxpro for windows (and Macintosh),
     @ GET push buttons do conform to the current font selection.

     The following code creates the main menu for dMAIL4:


       STORE "" TO cCHOICES
       nCOL = ROUND(WCOLS()/2,0) - 19
       DO GET WITH  1,nCOL, "[\<E] - Edit  Mailing List"
       DO GET WITH  3,nCOL, "[\<P] - Print Mailing List"
       DO GET WITH  7,nCOL, "[\<S] - System Setup (Query)"
       DO GET WITH  9,nCOL, "[\<U] - Utilities"
       DO GET WITH 11,nCOL, "[\<M] - Change Status
     ("+IIF(bMULT,"Multi","Single") ;
         +"-user)", .NOT. NETWORK() .OR. LEN(fnGETENV("MULT")) = 0 .OR. .NOT.
     bINIT
       DO GET WITH 13,nCOL, "[\<Q] - Quit this program"
       cCHOICES = cCHOICES + "EPSUMQ"
       cCHOICE = fnCHOICE(cCHOICES, "Q")


     As you can see, you pass GET with the desired row, column, and prompt
     (including hot keys).  In our case, nCOL is the column position,
     adjusted for any size screen.

     Once all our push buttons are defined, a simple call to fnCHOICE
     executes the READ and returns the user selection.  If the user presses
     [Esc], fnCHOICE returns the default "Q".


                                   Cleanup code


     When you wish to quit, execute the following code:




                                     - Page 37 -







                                 Basic Installation


         IF YESNO(" Are you Sure (Y or N) ?  ","N") = "N"
           LOOP
         ENDIF
         EXIT
       ENDCASE
     ENDDO
     IF fnFILE(cMEMPATH+PROGRAM()+".MEM")
       DELETE FILE (cMEMPATH+PROGRAM()+".MEM")
     ENDIF
     CLEAR WINDOWS
     CLEAR
     CLOSE ALL
     IF SYS(16,1) = SYS(16) .AND. .NOT. bDEBUG
       QUIT
     ENDIF
     ON ERROR
     ON ESCAPE
     ON KEY
     SET DELETED OFF
     SET PATH TO
     SET PROCEDURE TO
     SET SYSMENU TO DEFAULT
     RETURN


     The YESNO function prevents the user from accidently leaving the
     application.  If have any questions on how to create a startup module,
     see MAL.PRG in dMAIL4.  For more information on variable usage, check
     the Glossary.


                                   SCRPROC.PRG


     Regardless of the application, you will need most of the procedures
     contained in the procedure file SCRPROC.PRG.  The following is a brief
     layout of the file SCRPROC.PRG:


          *
          * PROGRAM SCRPROC.PRG
          *
          . (utility functions)
          . (utility procedures)
          PROCEDURE BROWSE
          . (utility functions and procedures used by BROWSE)
          *
          PROCEDURE EDIT
          . (utility functions and procedures used by EDIT)
          *
          PROCEDURE OPTION
          . (utility functions and procedures used by the option grid)
          *
          ON KEY LABEL routines

                                     - Page 38 -







                                 Basic Installation




     Now I'm not about to explain each and every procedure in detail.  You
     can read the source code yourself.  I do, however, want to explain a
     little of the EDIT procedure and a little of the OPTION procedure.


                                  PROCEDURE EDIT


     The EDIT procedure is our "little black box".  It provides all functions
     necessary to create and maintain a given database (Add, Browse, Delete,
     Find, Goto, Help, Update, or Quit).  There is a set of procedures that
     help EDIT perform these functions.  The following is a brief description
     of a few of them:


                                   FUNCTION BRV


     This function is executed on a BROWSE.  It is passed one parameter.  A
     value of 0 indicates a record to record VALID.  Any other value
     indicates the field number to execute a field to field VALID function.


                                   FUNCTION BRW


     This function is executed on a BROWSE.  It is passed one parameter.  A
     value of 0 indicates a record to record WHEN.  Any other value indicates
     the field number to execute a field to field WHEN function.


                                PROCEDURE FLD_BRO


     This procedure initializes and executes the BROWSE.  In multi-user mode,
     a BROWSE TIMEOUT is performed.  If time is out, and the current record
     has not been altered, the BROWSE is once again executed.


     Note:  Do not confuse this procedure with the procedure BROWSE.  That
     procedure allows you to perform a browse, independent of the full screen
     editor.


                               PROCEDURE FLD_DES()


     This procedure returns the description defined in GET_DESC.  If
     'PROMPT()' is defined, a validation is performed against the popup in
     GET_POP of the current form.



                                     - Page 39 -







                                 Basic Installation


     Note:  FLD_DES can be used outside any form procedures   Example, back
     when there was a STATE.DBF, our reports used the following to retrieve
     state descriptions:


     PRIVATEcFORM_SCR, nFORM_SCR
     nFORM_SCR = 13
     M->STATE = "MI"
     ? PROPER(FLD_DES("M->STATE"))


                                PROCEDURE FLD_FND


     This procedure does all input field prompts for the [F]ind type forms.
     Each record will invoke a single line dialogue box.

     Note: The FLD_FND can used independently of the EDIT procedure.  For
     example, the following code will prompt the user for the customer name:


     DO CTR WITH 3, "Press [ENTER] for default of first record"
     SELECT MAIL
     nFORM_NDX=nMAIL
     cFORM_NDX=LTRIM(STR(nFORM_NDX)) + ' IN SCR'
     DO FLD_FND&cFORM_NDX
     IF LASTKEY() = 27
       RETURN
     ENDIF


     The FLD_FND is very useful in reports.  For instance, we can include a
     GET_VALID function that allows the user to press [F1] for the mailing
     list editor.  Upon exiting the mailing list editor, the current record
     can then become the [F]ind record.  If a wildcard LOCATE is in effect,
     the variable bLOCATE will return true.

     Note:  The statement 'DO FLD_FND&cFORM_NDX' executes the hard-wired
     procedure found in 'SCR.PRG'.  If 'SCR.PRG' does not exist, the error
     handler will set cFORM_NDX to null.  That way, the interpreter procedure
     FLD_FND will be executed.  So if you hear a beep, you know the
     interpreter is working.


                                PROCEDURE FLD_GET


     This procedure does all input field prompts for the Add and Update
     functions.  When a screen input is completed, FLD_GET will then perform
     the appropriate APPEND/REPLACE statements to create/update the current
     record.  If all fields are replaced, bSAVED is set to true.




                                     - Page 40 -







                                 Basic Installation


                                PROCEDURE FLD_POP


     This procedure performs the popup for the current record in the screen
     database.  You may pass it the VARREAD(), the RECNO() of the SCR file.
     If no parameters is passed, the current record of SCR is assumed.  If
     the second parameter is set to true, then FLD_POP is being activated for
     a BROWSE.


                                PROCEDURE FLD_SAY


     This procedure restores all field descriptions to the screen.  It will
     display the values of fields in the current record.  All GET_VALID
     functions are executed.  If all fields were completely displayed,
     bDISPLAY to set to true.


                                PROCEDURE FLD_SHW


     This procedure is equivalent of a SHOW GETS.  It restores all field
     descriptions to the screen.


                                PROCEDURE FLD_TXT


     This procedure initializes all field descriptions to the screen.  It
     also will initialize all mouse cursor locations.


                               PROCEDURE FLD_UNQ()


     This procedure simply determines if an index key is unique.  If bUNIQUE
     was set to true before entering EDIT, the procedure FLD_GET will not let
     the user create a database record with duplicate keys.


                               PROCEDURE FLD_UQS()


     While FLD_UNQ validates one index, FLD_UQS validates all indices defined
     in the cINDEX array.









                                     - Page 41 -







                                 Basic Installation


                                 PROCEDURE OPTION


     This procedure is a mirror image of the EDIT procedure.  The user has
     similar choices (Continue, Help, Update, or Quit).  Unlike EDIT,
     however, OPTION will return a LASTKEY() of 27 if the user pressed [Q] to
     quit.

     There is a set of procedures that help OPTION perform these functions.
     The following is a brief description of each procedure:


                                PROCEDURE OPT_GET


     This procedure performs all input field prompts for the Update function.
     When a screen input is completed, bSAVED is set to true.


                                PROCEDURE OPT_SAY


     This procedure restores all field descriptions to the screen.  It will
     display the values of all fields in the current record.  All GET_VALID
     functions are executed.  If all fields were completely displayed,
     bDISPLAY to set to true.


                                PROCEDURE OPT_TXT


     This procedure initializes all restore values to the screen.  For the
     option grid, it is the job of FLD_TXT to initialize descriptions and
     mouse cursor locations.


                          Invoking the BROWSE procedure


     Similar to EDIT procedure, the BROWSE procedure invokes the [B]rowse
     command directly.  The syntax is the same as the EDIT procedure.  For
     example:


     DO WINDOW WITH "", "Browse"
     SELECT MAIL
     nFORM_NDX=1
     nFORM_SCR=3
     bUNIQUE=.F.
     DO BROWSE
     DO WINDOW WITH "", .F.




                                     - Page 42 -







                                 Basic Installation


                           Invoking the EDIT procedure


     We have initialized all DOS environment and system variables.  We also
     have created the procedure file.  Now we can edit database files.

     A database file can be edited directly from the main menu or from an
     edit menu.  I prefer calling an edit menu.  An edit menu allows you to
     group edit functions, initialize databases, set index orders and reset
     databases filters.  An edit menu also allows you to hide system
     administrator functions, such as reindexing and zapping.

     To invoke the screen editor, you need to initialize your database in a
     work area.  This work area must have an alias.


                             Initial Variable values


     To invoke the edit procedure, you need to set the following variables:

          nFORM_NDX= # of the [F] type form, zero if none
          nFORM_SCR= # of the full screen/option grid input form

     Set bEXACT to true if the form, defined by nFORM_NDX, demands an exact
     match to any find prompt.

     Set bUNIQUE to true if the form, defined by nFORM_NDX, is a unique
     index.

                                 Multiple Indices


     If you have a database file with multiple indices, they can be defined
     in the array cINDEX.  Each row element in cINDEX defines an index.  The
     following is a layout for each index:

          cINDEX(,1)     =    nFORM_NDX number
          cINDEX(,2)     =    TAG name
          cINDEX(,3)     =    bUNIQUE flag
          cINDEX(,4)     =    bEXACT flag
          cINDEX(,5)     =    title used in toggle prompt

     With the above information, multiple unique keys can be validated.  As
     an added bonus, this information allows the user to use the [T]oggle
     index option of the edit procedure.  The following, for example, allows
     the dMAIL4 editor to toggle between the last name and the zip code
     indices:







                                     - Page 43 -







                                 Basic Installation


          DIMENSION cINDEX(2,5)
          STORE "" TO cINDEX
          cINDEX(1,1) = 1
          cINDEX(1,2) = "LAST"
          cINDEX(1,3) = .F.
          cINDEX(1,4) = .F.
          cINDEX(1,5) = "Last Name"

          cINDEX(2,1) = 2
          cINDEX(2,2) = "ZIP"
          cINDEX(2,3) = .F.
          cINDEX(2,4) = .F.
          cINDEX(2,5) = "Zip Code"

     Note:  When using this table, use nFORM_NDX to define the default index
     for the toggle prompt.


                                Customized BROWSE


     If you want to customize your browse, use the variable cBROWSE.
     Example:

          cBROWSE="COLOR SCHEME 13"

     Now simply perform a "DO EDIT".  This routine will perform all the steps
     necessary to add, delete, or change the current database.  Upon return,
     the database filter to reset, and all data in memory is FLUSHED.

     So as you can see, once you define a screen database, it takes very
     little code to maintain a database.  The following, for example provides
     all the code needed to maintain the mailing list:


     DO INITIAL
     DO WINDOW WITH "", "Last Name Index"
     SELECT MAIL
     nFORM_NDX=1
     nFORM_SCR=3
     bUNIQUE=.F.
     DO EDIT
     DO WINDOW WITH "", .F.


     The procedure INITIAL will contain the following code:









                                     - Page 44 -







                                 Basic Installation


     IF .NOT. USED("MAIL")
       SELECT 0
       USE (cDATAPATH+"MAIL") INDEX (cDATAPATH+"MAIL") ALIAS MAIL
     ENDIF
     IF .NOT. USED("STATE")
       SELECT 0
       USE (cDATAPATH+"STATE") INDEX (cDATAPATH+"STATE") ALIAS STATE
     ENDIF
     DO DBCLOSE WITH "MAIL,STATE" 5


                          Invoking the OPTION procedure


     We have initialized all DOS environment and system variables.  We also
     have created the procedure file.  Now we can invoke the OPTION
     procedure.


                             Initial Variable values


     To invoke the option procedure, you need to set the following variables:

          bPR_DRAFT = flag, .t. = draft mode
          bSIDEWAYS = flag, .t. = may have to call sideways
          nFORM_SCR = # of the full screen/option grid input form
          cPRN      = device name (print device, file name, or CON)

     If cPRN is not defined, the option grid will appear.  The user will be
     able to press [C] to continue, and [Q] to quit.  If the user presses [Q]
     to quit, LASTKEY() will have 27 as a value.

     If cPRN is specified, the option grid will appear.  The user will be
     able to press [S] for screen output, [P] to printer output, or [Q] to
     quit.  Again, if the user presses [Q] to quit, LASTKEY() will have 27 as
     a value.

     If the user presses [S] or [P], the option grid will call a procedure
     named PRINT.  This user defined procedure, PRINT, must create a file
     defined as cFILE.  Having created cFILE, option [S] will display it.
     Option [P] will copy this file to the print device specified by cPRN.

     Note:  For people converting foxbase reports, nFORM_SCR can be set to
     zero.  No grid is displayed, and the update mode is disabled.  But the
     screen and print modes are still available.






     ____________________
     5 Use DBCLOSE to close all other databases except those defined.

                                     - Page 45 -







                                 Basic Installation


                                    Draft mode

     There are two ways to print cFILE:  Draft mode and non-draft mode.
     Setting the variable bPR_DRAFT to either true or false.  In draft mode,
     the report file is copied directly to the print device.  Under MS-DOS
     Windows, draft mode bypasses the print spooler.  In non-draft mode, the
     report file is still copied to the print device, but through any and all
     print spoolers.

     Non-draft mode is only needed when you want the print spooler to control
     font and font pitch.  In that case, set all printer codes to empty via
     double quotes ("").  Otherwise, the printer codes will show up on your
     report.


                                     SIDEWAYS


     If you plan to use the SIDEWAYS utility, set the variable bSIDEWAYS to
     true before invoking the OPTION procedure.  The file cFILE will then be
     created in the cMEMPATH directory, rather than the cTEMPPATH directory.
     When the user presses [P], and if the variable bSIDEWAYS is still true,
     the utility called SIDEWAYS will run in the directory cMEMPATH and will
     use the file cFILE as input.

     Note:  The PRINT procedure is allowed to change the value of bSIDEWAYS.
     If bSIDEWAYS is reset to false, cFILE is again copied to the print
     device cPRN.



























                                     - Page 46 -







                                Advanced Installation




                            Installing a header editor


     Suppose, for example, that we wanted to create an invoice editor.  From
     within it, we wanted the ability to edit invoice detail records.  What
     we want is to add an option to the EDIT procedure and to handle detail
     records.

     The EDIT and OPTION procedures have the ability to add options.
     Basically, you perform the following:

          DO EDIT WITH .T.

     Specifying '.T.' adds one extra line to the option grid.  Both EDIT and
     OPTION procedures will allow extra line(s) in the prompt window.  If you
     specify:

          DO EDIT WITH 2

     ..then two extra lines are added.  You may also specify no extra lines
     as in:

          DO EDIT WITH .F.

     In each instance, however, EDIT or OPTION will now execute the following
     procedures:  PROMPT, CHOICE, WHEN, and VALID.  PROMPT will contain code
     for the added prompts, CHOICE will execute these choices.  The WHEN
     procedure will be executed before any update.  The VALID will be
     executed after an update, browse, deletion, or recalled function.

     The following procedure file will illustrate:


     * PROGRAM INV_EDIT.PRG
     * PROGRAMMER D. ALLEN
     * CREATED MAY 20, 1991
     * UPDATED DEC 20, 1993
     * COPYRIGHT(C) 1990
     *
     *    THE PURPOSE OF THIS PROCEDURE IS TO ALLOW THE USER TO
     *    CREATE/MAINTAIN RECORDS IN THE INVOICE DATABASE SYSTEM.
     *
     DO EDIT WITH .T.
     RETURN
     *
     PROCEDURE PROMPT
     *
     *    THE PURPOSE OF THIS PROCEDURE IS TO ADD PROMPTS.
     *
     DO GET WITH 00,12, "\<Edit Details"
     cCHOICES = cCHOICES + "E"
     RETURN

                                     - Page 47 -







                                Advanced Installation


     *
     PROCEDURE CHOICE
     *
     *    THE PURPOSE OF THIS PROCEDURE IS TO EXECUTE CHOICES.
     *
     PRIVATE cCHOICE
     cCHOICE = IIF(mCHOICE > 0,SUBSTR(cCHOICES,mCHOICE,1),"")
     DO CASE
     CASE cCHOICE = "H"
       DO WINDOW WITH "GET_HELP", " H E L P "
       @ 0,0 CLEAR
       TEXT
       Command prompt

         [E]dit Details  -  Allows the user to create/maintain
                            invoice details

       ENDTEXT
       WAIT WINDOW
       DO WINDOW WITH "GET_HELP", .F.
     CASE cCHOICE = "E"
       IF .NOT. bDISPLAY
         DO ERR WITH "Edit what?"
         RETURN
       ENDIF
       PRIVATE cFILE
       nINV_NO=INV_NO
       cFILE=fnFILE()
       SAVE TO (cFILE)
       STORE  .F.  TO bEXACT, bUNIQUE
       STORE    "" TO cBROWSE, cINDEX
       STORE ".T." TO cFILTER
       DO WINDOW WITH "INV_EDIT", "Invoice Details"
       nFORM_NDX=7
       nFORM_SCR=8
       SELECT INV_DET
       cBROWSE="KEY nINV_NO"
       cFILTER="INV_NO=nINV_NO"
       SET EXACT OFF
       SEEK nINV_NO
       SET EXACT ON
       bUNIQUE=.F.
       DO EDIT
       DO WINDOW WITH "INV_EDIT", .F.
       RESTORE FROM (cFILE) ADDITIVE
       DELETE FILE (cFILE)
       DO FLD_SAY&cFORM_SCR
       RETURN
     ENDCASE
     RETURN
     *
     PROCEDURE WHEN
     *
     *    THE PURPOSE OF THIS PROCEDURE IS TO INITIALIZE A RECORD.

                                     - Page 48 -







                                Advanced Installation


     *
     RELEASE _INV_NO
     PUBLIC  _INV_NO
     _INV_NO = M->INV_NO
     && PRIVATE _DELETE, _RECALL
     && _DELETE = IIF(DELETED()       .AND. SET("DELETE") = "ON", .T.,.F.)
     && _RECALL = IIF(.NOT. DELETED() .AND. SET("DELETE") = "OFF",.T.,.F.)
     && IF (_DELETE .OR. _RECALL) .AND. .NOT. bINIT
     &&   DO ERR WITH "Cannot execute.  System administration function."
     &&   STORE .F. TO bSAVED
     &&   RETURN
     && ENDIF
     RETURN
     *
     PROCEDURE VALID
     *
     *    THE PURPOSE OF THIS PROCEDURE IS TO VALIDATE A RECORD.
     *
     PRIVATE _DELETE, _RECALL
     _DELETE = IIF(DELETED()       .AND. SET("DELETE") = "ON", .T.,.F.)
     _RECALL = IIF(.NOT. DELETED() .AND. SET("DELETE") = "OFF",.T.,.F.)
     IF bADD .OR. .NOT. bSAVED
       RELEASE _INV_NO
       RETURN
     ENDIF
     IF .NOT. _DELETE .AND. .NOT. _RECALL ;
      .AND. _INV_NO = M->INV_NO
       RELEASE _INV_NO
       RETURN
     ENDIF
     SELECT INV_DET
     SET EXACT OFF
     SEEK _INV_NO
     SET EXACT ON
     DO WHILE .NOT. EOF() .AND. INV_NO = _INV_NO
       IF .NOT. fnRLOCK()
         EXIT
       ENDIF
       REPLACE INV_NO WITH M->INV_NO
       IF _DELETE
         DO DELETE
       ENDIF
       IF _RECALL .AND. DELETED()
         RECALL
       ENDIF
       DO ALTER
       UNLOCK
       IF INV_NO = _INV_NO
         SKIP
         LOOP
       ENDIF
       SET EXACT OFF
       SEEK _INV_NO
       SET EXACT ON

                                     - Page 49 -







                                Advanced Installation


     ENDDO
     RELEASE _INV_NO
     SELECT (nDBF)
     mALTER = fnALTER()
     RETURN


     The PROMPT procedure defines a single push button @ GET and adds the
     choice "E" to the list of available choices.

     Now let's talk about the CHOICE procedure.  Given the choice of "E", the
     CHOICE procedure saves all memory variables to a file.  The invoice
     detail work area is selected, the first detail is found, and the EDIT
     procedure is performed.  Upon returning from the detail editor, the
     memory file is restored.

     Notice that we had to define two kinds of filters.  cFILTER tells EDIT
     to look at only detail records of the current invoice.  cBROWSE tells
     the BROWSE command to look at only detail records of the current
     invoice.

     Now let's look at the WHEN and VALID procedures.  The WHEN procedure
     saves the invoice number.  This allows the user to change an invoice
     number.  The VALID procedure will then maintain invoice numbers for
     detail record.  Notice that the VALID procedure is capable of deleting
     details if the header is deleted, and recalling details if the header
     was recalled.


     Note:  The WHEN procedure can also prevent the user from deleting the
     current record (See commented code).  Set bSAVED to false if deleting or
     recalling a record cannot occur.


                                 Multiple Screens


     In our previous example, let's suppose our invoice header contained lots
     of fields.  More than could fit on one screen.  So we need a second
     input screen.  Well, there's two ways we could handle this event.  Both
     involve using the OPTION procedure.

     In the first method, we'd add an extra choice to INV_EDIT.PRG.  To add
     another choice, add the following code to the PROMPT procedure:


     DO GET WITH 00,32, "\<Sales"
     cCHOICES = cCHOICES + "S"


     Also add the following code to the CHOICE procedure:


     CASE cCHOICE = "S"

                                     - Page 50 -







                                Advanced Installation


       IF .NOT. bDISPLAY
         DO ERR WITH "Edit what?"
         RETURN
       ENDIF
       PRIVATE cFILE
       cFILE=fnFILE()
       SAVE TO (cFILE)
       DO WINDOW WITH "INV_EDIT", "Sales"
       nFORM_SCR=9
       DO SLS_EDIT
       DO WINDOW WITH "INV_EDIT", .F.
       RESTORE FROM (cFILE) ADDITIVE
       DELETE FILE (cFILE)


     We've defined a procedure called SLS_EDIT, rather than calling OPTION
     directly.  That way, we have a separate set of PROMPT, CHOICE, WHEN, and
     VALID procedures.  The following will illustrate SLS_EDIT.PRG:


     * PROGRAM SLS_EDIT.PRG
     *
     DO OPTION WITH .F.
     RETURN
     *
     PROCEDURE PROMPT
     RETURN
     *
     PROCEDURE CHOICE
     RETURN
     *
     PROCEDURE WHEN
     RETURN
     *
     PROCEDURE VALID
     IF bSAVED
       SELECT (nDBF)
       IF fnRLOCK()
         mALTER = fnALTER()
         GATHER MEMVAR
         DO ALTER WITH CHR(mALTER)
         UNLOCK
       ENDIF
     ENDIF
     RETURN


     When the option grid is completed, the VALID procedure of SLS_EDIT.PRG
     will update the invoice header.

     In our second method, when the first invoice header screen is
     completed/updated, we prompt the user with the second screen.  Instead
     of adding an option to the PROMPT and CHOICE procedures, we add the
     following code to the VALID procedure in INV_EDIT.PRG:

                                     - Page 51 -







                                Advanced Installation



     IF bDISPLAY .AND. bSAVED
       PRIVATE cFILE
       cFILE=fnFILE()
       SAVE TO (cFILE)
       DO WINDOW WITH "INV_EDIT", "Sales"
       nFORM_SCR=9
       DO SLS_EDIT
       DO WINDOW WITH "INV_EDIT", .F.
       RESTORE FROM (cFILE) ADDITIVE
       DELETE FILE (cFILE)
     ENDIF


     Note:  To prevent code execution during a browse, the value of bDISPLAY
     must be true.

     As in the first method, we make the same call to SLS_EDIT.PRG.  For the
     same reasons.  In SLS_EDIT.PRG, however, we'll replace:

     DO OPTION WITH .F.

     ..with:

     DO OPTION WITH 0

     A zero parameter tells the OPTION procedure there is no option grid.
     OPTION will perform the initial input screen.  Regardless is the screen
     is completed or not, however, control is immediately returned to the
     calling procedure.


     Note:  In both multiple-screen methods, our second input screen is an
     option grid.  Remember that an option grid requires memory variables in
     the GET_NAME field.



                            Multi-user considerations


     All multi-user databases need a one character ALTER field to insure data
     integrity.  Typically, you would use the following code to maintain the
     ALTER field:

             IF fnRLOCK()
               REPLACE UPDATED WITH DATE()
               DO ALTER
               UNLOCK
             ENDIF

     For a REPLACE ALL, you need to use the fnALTER(1) UDF:



                                     - Page 52 -







                                Advanced Installation



             IF fnFLOCK()
               REPLACE ALL UPDATED WITH DATE(), ALTER WITH CHR(fnALTER(1))
               UNLOCK
             ENDIF

     For a SCATTER/GATHER, you would have to execute slightly different code:

             IF fnRLOCK()
               SCATTER MEMVAR                && M->ALTER exists
               mALTER = fnALTER()
               :
               STORE DATE() TO M->UPDATED
               :
               GATHER MEMVAR
               DO ALTER WITH CHR(mALTER)
               UNLOCK
             ENDIF


                          Hard-wiring the screen editor


     Once you have your database well defined, you may wish to "hard-wire" a
     database editor.  Though the speed of the generic editor is not bad,
     "hard-wiring" will improve I/O significantly.

     For example, say you wish to hard-wire the mailing list editor.  To
     hard-wire a screen editor, simply run the program HW4.PRG in the program
     directory.  This is where SCR.DBF should be located.

     Running HW4 will create a file called SCR.PRG.  SCR.PRG contains all the
     hard-wired versions FLD_FND, FLD_GET and FLD_SAY routines.  Compile
     SCR.PRG into SCR.FXP.

     To add/delete/change any record in the screen database, first delete the
     files SCR.PRG and SCR.FXP.  You are once again in interpreted mode.
     Make your changes and run HW4 once more.  That's It!


                                Expression Builder


     In the system setup menu of dMAIL4 there is a call to the expression
     builder.  The expression builder allows you to select a record filter
     from a list of record filters.  A record filter defines those records in
     a database that can be viewed, edited, or printed.

     The expression builder is a self-contained program called EXPRMENU.PRG.
     It uses it's own data dictionary, stored in q_*.* files, to define
     expressions.  To create a data dictionary for your own databases is
     simple process.



                                     - Page 53 -







                                Advanced Installation


     For example, suppose you wanted to create a new data dictionary for a
     CLIENT.DBF file.  From the command window, you would first perform a
     'USE CLIENT' to open the file.  Then, you would 'DO DATA_BLD' to execute
     the DATA_BLD.APP application.  Answer the initial questions and define
     the labels needed for each data field.  Saving your work will generate a
     file call QCLIENT.PRG.  This file is similar in nature to SCR.PRG.

     After generating your data dictionary, use the following code to call
     exprmenu.prg:


     DO WINDOW WITH "", " Expression Builder "
     STORE ".T."   TO cCL
     STORE ""      TO cCL_NAME
     STORE "QCLIENT" TO cFILE
     SELECT CLIENT
     SET FILTER TO .T.
     *
     STORE "" TO cTEMP, cTEMP2
     cTEMP = EXPRMENU(cFILE,cFILE,@cTEMP2)
     DO RELEASE
     *
     IF LASTKEY() = 27 .OR. cTEMP = ""
       RETURN
     ENDIF
     *
     SELECT CLIENT
     SET FILTER TO &cTEMP
     cCL = FILTER()
     cCL_NAME = ALLTRIM(cTEMP2)

     The calls 'DO WINDOW' and 'DO RELEASE' defines and reset the current
     procedure window.  Come to think of it, exprmenu.prg never uses our
     system windows.  So you could remove these calls without much trouble.
     Be sure, however, to remove the corresponding 'DO WINDOW WITH ""..F.'
     command from the system menu loop.

     If you look at MALSYS.PRG, a bit more code is used.  For one thing, each
     user's resource directory will always contain a working copy of all
     q_*.* files.  If you want a common set of expressions, remove this code
     and any SET DEFAULT lines.

     Upon exiting exprmenu.prg, cCL will contain the selected filter and
     cCL_NAME will contain the selected filter name.  Notice that if the user
     press [Esc] to exit exprmenu.prg, the filter is reset to '.T.'.


                                   SCRDBFS.PRG


     As a bonus, SCRDBFS.PRG has been added to your hard wire kit.  Generated
     from Data Wire Four shareware application, SCRDBFS.PRG will check the
     SCR.DBF in the current directory.  This procedure will ensure that
     SCR.DBF contain all the correct field elements.

                                     - Page 54 -







                                Advanced Installation




                                    Final Word


     At this point, you should begin to get the idea on how my data
     dictionary works.  But even if you haven't, don't despair.  To create
     your own application, all you need to do is cannibalize dMAIL4.

     For example, if I had an application called 'Client Data Sheet', I'd
     start off with a 'CDS\' directory.  I would copy all my dMAIL4 files
     into and rename all MAL*.PRG files to CDS*.PRG.  I'd go through the
     code, replacing all occurrences of 'MAL' to 'CDS'.

     As you build your own library of applications, you probably won't need
     to use dMAIL4 any longer.  Which is great!  Just keep one thing in mind:
     My software is constantly growing.  There will be improvements.  There
     will be bug fixes.  So I recommend that you obtain the latest copies of
     dMAIL4 and Hard Wire Four.  To keep your code in synchronous with my
     code.


                                   Distribution


     Note:  If you decide to create an application using Hard Wire Four,
     please add the following copyright notices to your installation:


          Copyright Notices:

          Data Dictionary supplied by Dennis Allen
          EXPRMENU is supplied by Robert A. Pope DDS






















                                     - Page 55 -







                                      GLOSSARY


     _DIALOG  -  Variable array of dialog window names.  Internal.

     _THERM  -  Variable array of thermometer window names.  Internal.

     bANSI  -  GETENV('TERM').  If false, not full ANSI implementation.  Only
          24 lines.  Use [Ctrl]-[Q] instead of [Esc].

     bBLK  -  If true, procedures CTR & SAY will blink specified text.

     bDEBUG  -  LEN(GETENV('DEBUG'))>0.  If true, debug Mode on.  [Alt]-[D]
          will invoke debug menu.

     bEXACT  -  If true, procedure FLD_FND must find exact match.

     bINIT  -  LEN(GETENV('INIT'))>0.  If true, system Administration
          enabled.

     bINT  -  If true, procedures CTR & SAY will display text with intensity
          on.

     bINV  -  If true, procedures CTR & SAY will display text with inverse
          on.

     bLOCATE  -  The procedure FLD_FND will set true if wildcard LOCATE is in
          effect.

     bMULT  -  LEN(GETENV('MULT'))>0 .AND. NETWORK().  If true, Multi-user
          mode is in effect.

     bNO_CDX  -  If true, the next dbf in USE does not have to have a CDX
          file.  Error 1707 is ignored by error handler.

     bNO_ERR  -  If true, any error in called procedure will set bNO_ERR to
          false.  You will be returned to calling procedure.

     bNO_INT  -  If true, procedures CTR & SAY will display text with
          intensity off.

     bRECALL  -  LEN(GETENV('RECALL'))>0.  If true, deleted records are not
          blanked and re-used.  They can be recalled.

     bUNIQUE  -  If true, procedure FLD_UNQ will check for key uniqueness.

     cBROWSE  -  SET FILTER string internal to the BROWSE command within the
          EDIT procedure.

     cCHOICE  -  Menu choice.  Internal.

     cCHOICES  -  Menu choices available.  Internal.

     cDATAPATH  -  GETENV('DATA').  Path for all data files..

     cDRIVE_SEP  -  Drive & Path Separator.  Operating system specific.
          Internal.

                                     - Page 56 -







                                      GLOSSARY



     cFILTER  -  SET FILTER string internal to EDIT procedure.

     cFONT  -  If not null, procedures CTR, SAY, and WINDOW will use
          specified font.  Foxpro for windows only.

     cINDEX  -  Variable array.  Invokes toggle option in EDIT procedure.
          Also checks for multiple-key uniqueness.

     cMEMPATH  -  Path for all MEMory files.  Derived from SYS(2005).

     cPATH_SEP  -  Path Separator.  Operating system specific.  Internal.

     cPR_???  -   Printer control codes.

     cPROGPATH  -  GETENV('PROG').  Path for all program files..

     cREINDEX  -   Program name for reindex utility.  Callable from error
          handler.

     cSTYLE  -  If not null, procedures CTR, SAY, and WINDOW will use
          specified font style.  Foxpro for windows only.

     cSYSTEM  -  System memory file name.  Unique to each user, it's the
          preferred place for printer codes.

     cTEMPPATH  -  GETENV('TEMP').  Path for all temporary files..

     cWINDOW  -  Variable array.  Names of all active windows.  See procedure
          WINDOW.  Internal.

     mCHOICE  -  Numeric form of cCHOICE.  Internal.

     mALTER  -  ALTER is the one-character field used to maintain multi-user
          data integrity.  mALTER is the CHR(ALTER) value of the current
          record and is used throughout the system.

     nLEVEL  -  Current window level in cWINDOW().  See procedure WINDOW.
          Internal.

     nMEMOWIDTH  -  Default memo width.

     nFONT  -  If not zero, procedures CTR, SAY, and WINDOW will use
          specified font size.  Foxpro for windows only.

     nPR_???  -   Printer control codes.

     nSCHEME  -  If not zero, procedures CTR, SAY, and WINDOW will display
          specified text/window in COLOR SCHEME nSCHEME.

     nSTART  -  Starting screen row of all active windows.  See procedure
          WINDOW.

     nTO_READ  -  TIMEOUT value for all FLD_GET procedure READs.

                                     - Page 57 -







                                      GLOSSARY



     nWINDOW  -  Variable array.  COLOR SCHEMEs of all active windows.  See
     procedure WINDOW.  Internal.




















































                                     - Page 58 -







                                        Index


     _DIALOG  56
     _THERM  56
     Advanced Installation  47
     ALTER  6, 52
     BANSI  56
     Basic Installation  32
     BBLK  56
     BDEBUG  56
     BDISPLAY  41, 42
     BEXACT  43, 56
     BINIT  56
     BINT  56
     BINV  56
     BLOCATE  40, 56
     BMULT  56
     BNO_CDX  56
     BNO_ERR  56
     BNO_INT  56
     BPR_DRAFT  45, 46
     BRECALL  56
     BSAVED  40, 42
     BSIDEWAYS  45, 46
     BUNIQUE  41, 43, 56
     Calculated fields  18
     CBROWSE  44, 56
     CCHOICE  56
     CCHOICES  56
     CDATAPATH  56
     CDRIVE_SEP  56
     CFILE  45, 46
     CFILTER  57
     CFONT  57
     CFORM_NDX  40
     CFORM_SCR  40
     CINDEX  41, 43, 57
     Cleanup code  37
     CMEMPATH  46, 57
     Copyright/License/Warranty  2
     CPATH_SEP  57
     CPR_???  57
     CPRN  45
     CPROGPATH  57
     CREINDEX  57
     CSTYLE  57
     CSYSTEM  57
     CTEMPPATH  46, 57
     Customized BROWSE  44
     CWINDOW  57
     Data Wire Four  54
     DATA_BLD.APP  54
     Defining a database field  10
     Defining a field description  9, 22, 25
     Defining a memo field  12, 26
     Defining an @ EDIT field  12

                                     - Page 59 -







                                        Index


     Defining an input field  22, 25
     Defining the [F]ind Type Form  22
     Defining the Data Dictionary  5
     Defining the Data Dictionary Layouts  7
     Defining the File Layouts  5
     Defining the form number  8
     Defining the Full Screen Form  9
     Defining the Option Grid Form  25
     Displaying @ EDIT field  26
     Distribution  55
     DMAIL4  1, 38
     DMAIL4 Data Dictionary  31
     Draft mode  46
     Expression Builder  53
     EXPRMENU.PRG  53
     Filter  53
     Final Word  55
     FnCHOICE  37
     Font  46
     Foxpro  1
     Foxpro for Windows  11
     FOXPRO.INI  32
     FUNCTION BRV  39
     FUNCTION BRW  39
     GLOSSARY  56
     Hard-wiring the screen editor  53
     HW4  1
     HW4.PRG  53
     Index  59
     Initial Variable values  43, 45
     Initializing Variables  32
     Installing a header editor  47
     Invoking the BROWSE procedure  42
     Invoking the EDIT procedure  43
     Invoking the OPTION procedure  45
     Main menu loop  35
     MAL.PRG  35, 38
     MALTER  57
     MCHOICE  57
     Multi-user considerations  52
     Multiple Indices  43
     Multiple Screens  50
     NFONT  57
     NFORM_NDX  40, 43
     NFORM_SCR  40, 43, 45
     NLEVEL  57
     NMEMOWIDTH  57
     Non-draft mode  46
     NPR_???  57
     NSCHEME  57
     NSTART  57
     NTO_READ  57
     NWINDOW  58
     Preface  1

                                     - Page 60 -







                                        Index


     PROCEDURE EDIT  39
     PROCEDURE FLD_BRO  39
     PROCEDURE FLD_DES()  39
     PROCEDURE FLD_FND  40
     PROCEDURE FLD_GET  40
     PROCEDURE FLD_POP  41
     PROCEDURE FLD_SAY  41
     PROCEDURE FLD_SHW  41
     PROCEDURE FLD_TXT  41
     PROCEDURE FLD_UNQ()  41
     PROCEDURE FLD_UQS()  41
     PROCEDURE GET  37
     PROCEDURE OPT_GET  42
     PROCEDURE OPT_SAY  42
     PROCEDURE OPT_TXT  42
     PROCEDURE OPTION  42
     PROCEDURE WINDOW  36
     Record filter  53
     SCR.DBF  53
     SCR.PRG  53
     SCRDBFS.PRG  54
     SCRPROC.PRG  38
     SIDEWAYS  46
     Size Fields  11
     SIZE_1  11
     TABLE OF CONTENTS  3
     The BROWSE clause  15
     The Default clause  16, 23, 28
     The Description clause  21, 30
     The GET_MEMO clause  19, 24, 28
     The GET_READ clause  22, 24, 30
     The Message clause  19, 23, 28
     The Popup clause  19, 24, 29
     The Restore clause  17, 23, 28
     The Second Message clause  19, 28
     The WHEN clause  15, 23, 27
     Validating a database field  13
     Validating an input field  23, 27
     YESNO  38
















                                     - Page 61 -



