
PROCEDURE SCRDBFS
PARAMETERS cPATH, cNAME, bBACK
SAVE SCREEN
CLEAR
? "*"
? "* Data Wire Four 01.03.02"
? "* (c) 1993 Dennis Allen"
? "* All rights reserved"
? "*"
?
? "Please Wait..."
?
PRIVATE FLD, FLD1, FLD2, bERROR, bFLAG, cDRIV_SEP, cERROR, cEXACT, cFILE, cPATH_SEP, nCOL, nROW
IF "2.0" $ VERSION()
  STORE .F. TO _MAC, _UNIX, _WINDOWS
  STORE .T. TO _DOS
ENDIF
IF TYPE("cPATH") = "C"
  PRIVATE cDATAPATH
  cDATAPATH = cPATH
ENDIF
cPATH_SEP = "\"
cDRIV_SEP = ":\"
cDATAPATH = FULLPATH(IIF(TYPE("cDATAPATH")<>"C","",ALLTRIM(cDATAPATH)))
IF LEN(cDATAPATH) > 0 .AND. .NOT. RIGHT(cDATAPATH,1) $ cDRIV_SEP
  cDATAPATH=cDATAPATH+cPATH_SEP
ENDIF
IF      ADIR(FLD,ALLTRIM(cDATAPATH)+"*.","D") = 0 ;
  .AND. ADIR(FLD,FULLPATH("")+"*.","D") > 0
  ? "File Path "+cDATAPATH+" does not exist"
  WAIT WINDOW
  IF SYS(16,1) = SYS(16)
    QUIT
  ENDIF
  RETURN
ENDIF
bBACK = IIF(PARAMETERS()=3.AND.TYPE("bBACK")="L",bBACK,.T.)
bBACK = IIF(PARAMETERS()=2.AND.TYPE("cNAME")="L",cNAME,bBACK)
cNAME = IIF(TYPE("cNAME")<>"C","",STRTRAN(UPPER(cNAME),".DBF"))
cFILE = SYS(3)
DO WHILE cFILE = SYS(3)
ENDDO
cERROR = ON("ERROR")
bERROR = .F.
ON ERROR DO DW4ERR
cEXACT = SET("EXACT")
SET EXACT ON
CLOSE DATABASES
IF .NOT. EMPTY(cNAME)
  DO (cNAME)
ELSE
  DO SCR
ENDIF
CLOSE DATABASES
ON ERROR &cERROR
SET EXACT &cEXACT
IF bERROR
  ?
  ? "Verification Failed.  File(s) may be in use..."
ELSE
  ?
  ? "Verification Complete..."
ENDIF
IF SYS(16,1) = SYS(16) .OR. bERROR
  WAIT WINDOW
ENDIF
IF SYS(16,1) = SYS(16)
  QUIT
ENDIF
RESTORE SCREEN
RETURN
*
PROCEDURE SCR
*
IF bERROR
  RETURN
ENDIF
?
? "Verifying SCR.DBF..."
USE
RELEASE FLD1, FLD2
DIMENSION FLD1(29,4), FLD2(1,4)
FLD1(1,1) = "FORM      "
FLD1(1,2) = "N"
FLD1(1,3) = 2
FLD1(1,4) = 0
FLD1(2,1) = "SAY_ROW   "
FLD1(2,2) = "N"
FLD1(2,3) = 2
FLD1(2,4) = 0
FLD1(3,1) = "SAY_COL   "
FLD1(3,2) = "N"
FLD1(3,3) = 2
FLD1(3,4) = 0
FLD1(4,1) = "SAY_TXT   "
FLD1(4,2) = "C"
FLD1(4,3) = 40
FLD1(4,4) = 0
FLD1(5,1) = "SAY_PIC   "
FLD1(5,2) = "C"
FLD1(5,3) = 40
FLD1(5,4) = 0
FLD1(6,1) = "SAY_FUNC  "
FLD1(6,2) = "C"
FLD1(6,3) = 40
FLD1(6,4) = 0
FLD1(7,1) = "SAY_COLOR "
FLD1(7,2) = "C"
FLD1(7,3) = 40
FLD1(7,4) = 0
FLD1(8,1) = "GET_ROW   "
FLD1(8,2) = "N"
FLD1(8,3) = 2
FLD1(8,4) = 0
FLD1(9,1) = "GET_COL   "
FLD1(9,2) = "N"
FLD1(9,3) = 2
FLD1(9,4) = 0
FLD1(10,1) = "GET_NAME  "
FLD1(10,2) = "C"
FLD1(10,3) = 12
FLD1(10,4) = 0
FLD1(11,1) = "GET_READ  "
FLD1(11,2) = "C"
FLD1(11,3) = 40
FLD1(11,4) = 0
FLD1(12,1) = "GET_PIC   "
FLD1(12,2) = "C"
FLD1(12,3) = 40
FLD1(12,4) = 0
FLD1(13,1) = "GET_FUNC  "
FLD1(13,2) = "C"
FLD1(13,3) = 40
FLD1(13,4) = 0
FLD1(14,1) = "GET_RANGE "
FLD1(14,2) = "C"
FLD1(14,3) = 40
FLD1(14,4) = 0
FLD1(15,1) = "SIZE_1    "
FLD1(15,2) = "N"
FLD1(15,3) = 2
FLD1(15,4) = 0
FLD1(16,1) = "SIZE_2    "
FLD1(16,2) = "N"
FLD1(16,3) = 2
FLD1(16,4) = 0
FLD1(17,1) = "SIZE_3    "
FLD1(17,2) = "N"
FLD1(17,3) = 2
FLD1(17,4) = 0
FLD1(18,1) = "GET_VALID "
FLD1(18,2) = "C"
FLD1(18,3) = 40
FLD1(18,4) = 0
FLD1(19,1) = "GET_BROWSE"
FLD1(19,2) = "C"
FLD1(19,3) = 40
FLD1(19,4) = 0
FLD1(20,1) = "GET_ERR   "
FLD1(20,2) = "C"
FLD1(20,3) = 40
FLD1(20,4) = 0
FLD1(21,1) = "GET_COLOR "
FLD1(21,2) = "C"
FLD1(21,3) = 40
FLD1(21,4) = 0
FLD1(22,1) = "GET_WHEN  "
FLD1(22,2) = "C"
FLD1(22,3) = 40
FLD1(22,4) = 0
FLD1(23,1) = "GET_REST  "
FLD1(23,2) = "C"
FLD1(23,3) = 40
FLD1(23,4) = 0
FLD1(24,1) = "GET_DEF   "
FLD1(24,2) = "C"
FLD1(24,3) = 40
FLD1(24,4) = 0
FLD1(25,1) = "GET_MSG   "
FLD1(25,2) = "C"
FLD1(25,3) = 40
FLD1(25,4) = 0
FLD1(26,1) = "GET_MSG2  "
FLD1(26,2) = "C"
FLD1(26,3) = 40
FLD1(26,4) = 0
FLD1(27,1) = "GET_MEMO  "
FLD1(27,2) = "M"
FLD1(27,3) = 10
FLD1(27,4) = 0
FLD1(28,1) = "GET_POPUP "
FLD1(28,2) = "M"
FLD1(28,3) = 10
FLD1(28,4) = 0
FLD1(29,1) = "GET_DESC  "
FLD1(29,2) = "C"
FLD1(29,3) = 40
FLD1(29,4) = 0
STORE .F. TO bFLAG
IF !SYS(2000,cDATAPATH+"SCR.DBF") == ""
  USE (cDATAPATH+"SCR.DBF") ALIAS TEMP SHARED
  = AFIELDS(FLD2)
ENDIF
bFLAG = ADJUST(@FLD1, @FLD2)
IF bFLAG
  ?
  ? " Updating "+cDATAPATH+"SCR.DBF..."
  USE
  CREATE TABLE (cDATAPATH+cFILE) FROM ARRAY FLD1
  IF !SYS(2000,cDATAPATH+"SCR.DBF") == ""
    APPEND FROM (cDATAPATH+"SCR.DBF")
    IF bBACK
      DELETE FILE (cDATAPATH+"SCR.BAK")
      RENAME (cDATAPATH+"SCR.DBF") TO (cDATAPATH+"SCR.BAK")
    ENDIF
    DELETE FILE (cDATAPATH+"SCR.DBF")
  ENDIF
  IF !SYS(2000,cDATAPATH+"SCR.FPT") == ""
    IF bBACK
      DELETE FILE (cDATAPATH+"SCR.TBK")
      RENAME (cDATAPATH+"SCR.FPT") TO (cDATAPATH+"SCR.TBK")
    ENDIF
    DELETE FILE (cDATAPATH+"SCR.FPT")
  ENDIF
  DELETE FILE (cDATAPATH+"SCR.CDX")
  DELETE FILE (cDATAPATH+"SCR.IDX")
  DELETE FILE (cDATAPATH+"SCR.NDX")
  USE
  IF !SYS(2000,cDATAPATH+cFILE+".DBF") == ""
    RENAME (cDATAPATH+cFILE+".DBF") TO (cDATAPATH+"SCR.DBF")
  ENDIF
  IF !SYS(2000,cDATAPATH+cFILE+".FPT") == ""
    RENAME (cDATAPATH+cFILE+".FPT") TO (cDATAPATH+"SCR.FPT")
  ENDIF
ENDIF
*
RELEASE FLD
DIMENSION FLD(1,3)
FLD(1,1) = [FORM]
FLD(1,2) = [FORM]
FLD(1,3) = []
IF .NOT. USED("TEMP") .AND. !SYS(2000,cDATAPATH+"SCR.DBF") == ""
  USE (cDATAPATH+"SCR.DBF") ALIAS TEMP SHARED
ENDIF
STORE .F. TO bFLAG
FOR nROW = 1 TO 1
  IF FLD(nROW,1) <> TAG(nROW) .OR. FLD(nROW,2) <> KEY(nROW) .OR. FLD(nROW,3) <> SYS(2021,nROW)
    STORE .T. TO bFLAG
    EXIT
  ENDIF
ENDFOR
IF bFLAG
  ?
  ? " Updating "+cDATAPATH+"SCR.CDX..."
  USE (cDATAPATH+"SCR.DBF") ALIAS TEMP EXCLUSIVE
  DELETE TAG ALL
  INDEX ON FORM TAG FORM
ENDIF
RETURN
*
*
*
FUNCTION ADJUST
*
PARAMETERS FLD1, FLD2
IF TYPE("FLD2") = "L"
  DIMENSION FLD2(ALEN(FLD1,1),ALEN(FLD1,2))
  = ACOPY(FLD1,FLD2)
  RETURN .T.
ENDIF
PRIVATE bFLAG, nCOL, nDIF, nROW, nROW1, nROW2
FOR nROW = 1 TO ALEN(FLD2,1)
  FLD2(nROW,1) = PADR(FLD2(nROW,1),10)
  nROW1 = ASCAN(FLD1,FLD2(nROW,1))
  nROW1 = IIF(nROW1 <> 0, ASUBSCRIPT(FLD1,nROW1,1),0)
  IF nROW1 = 0
    nROW1 = ALEN(FLD1,1)+1
    DIMENSION FLD1(nROW1,4)
    FOR nCOL = 1 TO 4
      FLD1(nROW1,nCOL) = FLD2(nROW,nCOL)
    ENDFOR
  ENDIF
  IF FLD1(nROW1,2) <> FLD2(nROW,2)
    ? "Warning: "+FLD2(nROW,1)+" has a field type ("+FLD2(nROW,2)+")"
    ? "                  "    +" needs field type ("+FLD1(nROW1,2)+")"
    WAIT WINDOW
    FLD1(nROW1,2) = FLD2(nROW,2)
  ENDIF
  IF FLD1(nROW1,4) < FLD2(nROW,4)
    FLD1(nROW1,4) = FLD2(nROW,4)
  ENDIF
  nDIF = (FLD2(nROW,3) - FLD2(nROW,4)) - (FLD1(nROW1,3) - FLD1(nROW1,4))
  IF nDIF > 0
    FLD1(nROW1,3) = FLD1(nROW1,3) + nDIF
  ENDIF
ENDFOR
STORE .F. TO bFLAG
FOR nROW = 1 TO ALEN(FLD1,1)
  nROW2 = ASCAN(FLD2,FLD1(nROW,1))
  nROW2 = IIF(nROW2 <> 0, ASUBSCRIPT(FLD2,nROW2,1),0)
  IF nROW2 = 0
    STORE .T. TO bFLAG
    EXIT
  ENDIF
  IF FLD2(nROW2,4) < FLD1(nROW,4)
    STORE .T. TO bFLAG
    EXIT
  ENDIF
  nDIF = (FLD1(nROW,3) - FLD1(nROW,4)) - (FLD2(nROW2,3) - FLD2(nROW2,4))
  IF nDIF > 0
    STORE .T. TO bFLAG
    EXIT
  ENDIF
ENDFOR
RETURN bFLAG
*
*
*
PROCEDURE DW4ERR
*
IF ERROR() = 1707
  RETRY
ENDIF
bERROR = .T.
RETURN TO SCRDBFS