#ifdef _plan9_
#include <u.h>
#include <libc.h>
#else
#include <stdlib.h>
#endif
#include "config.h"
#include "zoom.h"
#include "palette.h"


#define SEGMENTSIZE 8
#define NSEGMENTS (255/SEGMENTSIZE)

static unsigned char colors[NSEGMENTS][3];
static unsigned char colors1[NSEGMENTS][3] =
{
    {8, 14, 32},
    {120, 119, 238},
    {24, 7, 25},
    {197, 66, 28},
    {29, 18, 11},
    {135, 46, 71},
    {24, 27, 13},
    {241, 230, 128},
    {17, 31, 24},
    {240, 162, 139},
    {11, 4, 30},
    {106, 87, 189},
    {29, 21, 14},
    {12, 140, 118},
    {10, 6, 29},
    {50, 144, 77},
    {22, 0, 24},
    {148, 188, 243},
    {4, 32, 7},
    {231, 146, 14},
    {10, 13, 20},
    {184, 147, 68},
    {13, 28, 3},
    {169, 248, 152},
    {4, 0, 34},
    {62, 83, 48},
    {7, 21, 22},
    {152, 97, 184},
    {8, 3, 12},
    {247, 92, 235},
    {31, 32, 16}
};
static zoom_context *context;
static int (*set_color) (int, int, int, int);

int mksmooth(int nsegments)
{
    int i, y, n;
    float r, g, b, rs, gs, bs;

    for (i = 0; i < nsegments; i++) {
	r = colors[i][0];
	g = colors[i][1];
	b = colors[i][2];
	rs = (colors[(i + 1) % nsegments][0] - r) / SEGMENTSIZE;
	gs = (colors[(i + 1) % nsegments][1] - g) / SEGMENTSIZE;
	bs = (colors[(i + 1) % nsegments][2] - b) / SEGMENTSIZE;
	for (y = 0; y < SEGMENTSIZE; y++) {
	    if ((n = context->colors[i * SEGMENTSIZE + y] = set_color((int) r, (int) g, (int) b, i == 0 && y == 0)) == -1)
		return 0;
	    n = (unsigned char) n;
	    context->cmap[0][n] = (unsigned char) r;
	    context->cmap[1][n] = (unsigned char) g;
	    context->cmap[2][n] = (unsigned char) b;
	    r += rs;
	    g += gs;
	    b += bs;
	}
    }
    context->num_colors = i * SEGMENTSIZE;
    return 1;
}

void randomize_segments(int whitemode)
{
    int i = 0;

/*
   colors[0][0] = rand() % 10;
   colors[0][1] = rand() % 10;
   colors[0][2] = rand() % 10;
 */
    if (whitemode) {
	colors[0][0] = 255,
	    colors[0][1] = 255,
	    colors[0][2] = 255;
	for (i = 0; i < NSEGMENTS; i += 2) {
	    if (i != 0) {
		colors[i][0] = rand() % 256,
		    colors[i][1] = rand() % 256,
		    colors[i][2] = rand() % 256;
	    }
	    if (i + 1 < NSEGMENTS)
		colors[i + 1][0] = rand() % 35,
		    colors[i + 1][1] = rand() % 35,
		    colors[i + 1][2] = rand() % 35;
	}
    } else {
	for (i = 0; i < NSEGMENTS; i += 2) {
	    colors[i][0] = rand() % 35,
		colors[i][1] = rand() % 35,
		colors[i][2] = rand() % 35;
	    if (i + 1 < NSEGMENTS)
		colors[i + 1][0] = rand() % 256,
		    colors[i + 1][1] = rand() % 256,
		    colors[i + 1][2] = rand() % 256;
	}
    }
}

int mkpalette(zoom_context * c, int (*sethandler) (int, int, int, int), int randomsize)
{
    int i;
    int whitemode = rand() % 2;

    set_color = sethandler;
    context = c;
    randomize_segments(whitemode);
    if (randomsize)
	i = rand() % NSEGMENTS;
    else
	i = NSEGMENTS;
    if (i < 0)
	i = 1;
    for (; i > 0; i--)
	if (mksmooth(i))
	    break;
    return (context->num_colors);
/*
   int ncolors = 16, mul = 16;
   do {
   for (i = 0; i < ncolors; i++)
   if ((c->colors[i] = sethandler(i * mul, i * mul, i * mul, i == 0)) == -1) {
   ncolors /= 2, mul *= 2;
   break;
   }
   }
   while (i != ncolors);
   c->num_colors = i;
   return (c->num_colors);
 */
}

int mkdefaultpalette(zoom_context * c, int (*sethandler) (int, int, int, int), int randomsize)
{
    int i;

    set_color = sethandler;
    context = c;
    memcpy(colors, colors1, sizeof(colors));
    if (randomsize)
	i = 128 / 8;
    else
	i = NSEGMENTS;
    if (i < 0)
	i = 1;
    for (; i > 0; i--)
	if (mksmooth(i))
	    break;
    return (context->num_colors);
}
