#ifdef _plan9_
#include <u.h>
#include <libc.h>
#include <stdio.h>
#else
#include <math.h>
#include <limits.h>
#endif
#include "plane.h"
#include "zoom.h"
#include "complex.h"
char *planename[] =
{
    "mu",
    "1/mu",
    "1/(mu+0.25)",
    "lambda",
    "1/lambda",
    "1/(lambda-1)",
    "1/(mu-1.40115)"
};


void INLINE
 recalculate(zoom_context * d, number_t * x1, number_t * y1)
{
    number_t x = *x1, y = *y1;
    switch (d->plane) {
    case 1:
	{			/* 1/mu */
	    number_t t;
	    if (myfabs(x) + myfabs(y) < 0.000001)
		t = INT_MAX, y = INT_MAX;
	    else {

		c_div(1, 0, x, y, t, y);
	    }
	    x = t;
	}
	break;
    case 2:
	{			/* 1/(mu + 0.25) */
	    number_t t;
	    if (myfabs(x) + myfabs(y) < 0.000001)
		t = INT_MAX, y = INT_MAX;
	    else {

		c_div(1, 0, x, y, t, y);
	    }
	    x = t;
	    x += 0.25;
	}
	break;
    case 3:			/* lambda */
	{
	    number_t tr, ti, mr, mi;

	    mr = x, mi = y;
	    c_pow2(x, y, tr, ti);
	    c_div(tr, ti, 4, 0, x, y);
	    c_div(mr, mi, 2, 0, tr, ti);
	    c_sub(tr, ti, x, y, mr, mi);
	    x = mr, y = mi;
	}
	break;
    case 4:			/* 1/lambda */
	{
	    number_t tr, ti, mr, mi;

	    c_div(1, 0, x, y, tr, y);
	    x = tr;
	    mr = x, mi = y;
	    c_pow2(x, y, tr, ti);
	    c_div(tr, ti, 4, 0, x, y);
	    c_div(mr, mi, 2, 0, tr, ti);
	    c_sub(tr, ti, x, y, mr, mi);
	    x = mr, y = mi;
	}
	break;
    case 5:			/* 1/(lambda-1) */
	{
	    number_t tr, ti, mr, mi;

	    c_div(1, 0, x, y, tr, y);
	    x = tr + 1;
	    mr = x, mi = y;
	    c_pow2(x, y, tr, ti);
	    c_div(tr, ti, 4, 0, x, y);
	    c_div(mr, mi, 2, 0, tr, ti);
	    c_sub(tr, ti, x, y, mr, mi);
	    x = mr, y = mi;
	}
	break;
    case 6:
	{			/* 1/(mu + 0.25) */
	    number_t t;
	    if (myfabs(x) + myfabs(y) < 0.000001)
		t = INT_MAX, y = INT_MAX;
	    else {

		c_div(1, 0, x, y, t, y);
	    }
	    x = t;
	    x -= 1.40115;
	}
	break;
    default:
	break;
    }
    *x1 = x;
    *y1 = y;
}
void INLINE
 recalculateback(zoom_context * d, number_t * x1, number_t * y1)
{
    number_t x = *x1, y = *y1;
    switch (d->plane) {
    case 1:
	{			/* 1/mu */
	    number_t t;

	    c_div(1, 0, x, y, t, y);
	    x = t;
	}
	break;
    case 2:
	{			/* 1/(mu + 0.25) */
	    number_t t;

	    c_div(1, 0, x - 0.25, y, t, y);
	    x = t;
	}
	break;
    case 3:			/* lambda */
	{
	    number_t mr, mi;

	    mr = x, mi = y;
	    c_mul(mr, mi, 1 - mr, mi, x, y);
	}
	break;
    case 4:			/* 1/lambda */
	{
	    number_t tr, ti, mr, mi;

	    c_div(1, 0, x, y, tr, y);
	    x = tr;
	    mr = x, mi = y;
	    c_pow2(x, y, tr, ti);
	    c_div(tr, ti, 4, 0, x, y);
	    c_div(mr, mi, 2, 0, tr, ti);
	    c_sub(tr, ti, x, y, mr, mi);
	    x = mr, y = mi;
	}
	break;
    case 5:			/* 1/(lambda-1) */
	{
	    number_t tr, ti, mr, mi;

	    c_div(1, 0, x, y, tr, y);
	    x = tr + 1;
	    mr = x, mi = y;
	    c_pow2(x, y, tr, ti);
	    c_div(tr, ti, 4, 0, x, y);
	    c_div(mr, mi, 2, 0, tr, ti);
	    c_sub(tr, ti, x, y, mr, mi);
	    x = mr, y = mi;
	}
	break;
    case 6:
	{			/* 1/(mu + 0.25) */
	    number_t t;

	    c_div(1, 0, x, y, t, y);
	    x = t;
	    x -= 1.40115;
	}
	break;
    default:
	break;
    }
    *x1 = x;
    *y1 = y;
}
