#ifdef _plan9_
#include <u.h>
#include <stdio.h>
#include <libc.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <limits.h>
#endif
#include "zoom.h"
#include "gif.h"
#include "autopilot.h"
#include "complex.h"
#include "ui.h"
#include "palette.h"
#include "plane.h"
#define xstoc(x)        ((number_t) (s.nc + x * ((s.mc - s.nc) \
                                / (number_t) context->width)))
#define ystoc(y)        ((number_t) (s.ni + y * ((s.mi - s.ni) \
                                / (number_t) context->height)))

#define FRAMETIME (1000000/FRAMERATE)
static int autopilot = 0;
static double maxstep = MAXSTEP, speedup = STEP;
static int textwidth;
static zoom_context *context;
static double mul;
static vinfo s =
{0.5, -2.0, 1.25, -1.25};
static int drawingtime, tbreak = 0;
#ifndef _plan9_
static struct timeval tv1, tv2;
static struct timezone tzp;
#endif

static int lookup_timer(void)
{
#ifndef _plan9_
    int time;


    do {
	gettimeofday(&tv2, &tzp);
    } while (tv2.tv_usec > 999999);
    time = (1000000 * (tv2.tv_sec - tv1.tv_sec) + (tv2.tv_usec - tv1.tv_usec));
#ifdef DEBUG
    printf("framerate:%f\n", 1000000.0 / time);
#endif
    if (time > 200000)
	time = 200000;
    return time;
#endif
}

static int get_timer(void)
{
    int time;


    time = lookup_timer();
#ifndef _plan9_
    tv1 = tv2;
#endif
    return time;
}

static void (*display_function) (void);
static void (*print_function) (int x, int y, char *text);

void ui_do_fractal(void)
{
    set_view(context, &s);
    do_fractal(context);
    s = context->s;
    display_function();
    drawingtime = get_timer();
    mul = (double) drawingtime / FRAMETIME;
}

void ui_incoloringmode(void)
{
    context->incoloringmode++;
    context->incoloringmode %= INCOLORING;
    ui_message();
    init_tables(context);
    ui_do_fractal();
}

void ui_coloringmode(void)
{
    context->coloringmode++;
    context->coloringmode %= OUTCOLORING;
    ui_message();
    init_tables(context);
    ui_do_fractal();
}

void ui_savefile(void)
{
    char *s;
    char str[256];

    if (!context->dirty) {
	print_function(0, 0, "Recalculating image...");
	init_tables(context);
    }
    ui_do_fractal();
    print_function(0, 0, "Writing gif image..  ");
    s = writegif(context);
    sprintf(str, "File %s saved", s);
    print_function(0, 0, str);
}

void ui_updateparameters(void)
{
    s = context->s;
}

void ui_init(zoom_context * c, void (*function) (), int (*setcolor) (), int randomsize, void (*print) (int, int, char *), int width)
{
    context = c;
    s = context->s;
    textwidth = width;
    print_function = print;
    srand(7);
    mkdefaultpalette(c, setcolor, randomsize);
    srand(time(0));
    display_function = function;
    ui_message();
    ui_do_fractal();
    tbreak = 2;
}

void ui_tbreak(void)
{
    tbreak = 2;
}

int ui_inverse(void)
{
    /*recalculate(context, &s.mc, &s.mi);
       recalculate(context, &s.nc, &s.ni); */
    context->plane++;
    context->plane %= PLANES;
    /*recalculateback(context, &s.mc, &s.mi);
       recalculateback(context, &s.nc, &s.ni); */
    init_tables(context);
    context->s = s;
    ui_message();
    ui_do_fractal();
    ui_tbreak();
    return (context->plane);
}

void ui_mandelbrot(int mousex, int mousey)
{
    context->mandelbrot ^= 1;
    context->pre = xstoc(mousex), context->pim = ystoc(mousey);
    recalculate(context, &context->pre, &context->pim);
    init_tables(context);
    ui_message();
    ui_do_fractal();
    ui_tbreak();
}

int ui_autopilot(void)
{
    return (autopilot ^= 1);
}

void ui_speedup(void)
{
    speedup *= SPEEDUP, maxstep *= SPEEDUP;
}


void ui_slowdown(void)
{
    speedup /= SPEEDUP, maxstep /= SPEEDUP;
}

void ui_help(void)
{
    print_function(0, 0 * textwidth, "/*/*/# Welcome to ugly interface #\\*\\*\\");
    print_function(0, 1 * textwidth, "     The best interface for zooming!   ");
    print_function(0, 2 * textwidth, "***************************************");
    print_function(0, 3 * textwidth, "buttons:                               ");
    print_function(0, 4 * textwidth, "left-zoom in           right-zoom out  ");
    print_function(0, 5 * textwidth, "middle(or left+right)-move             ");
    print_function(0, 6 * textwidth, "keys:                                  ");
    print_function(0, 7 * textwidth, "1-9 fractal type      A autopiot       ");
    print_function(0, 8 * textwidth, "H help                C out coloring   ");
    print_function(0, 9 * textwidth, "F In coloring         I plane switching");
    print_function(0, 10 * textwidth, "S Save                P Palette        ");
    print_function(0, 11 * textwidth, "Q Quit                M Mand/Julia     ");
    print_function(0, 12 * textwidth, "Up/Down-change zooming speed           ");
    print_function(0, 13 * textwidth, "Left/Right-number of interations       ");
    print_function(0, 14 * textwidth, "= resize(svga and MS-DOS version only) ");
}

void ui_status(void)
{
    char str[80];

    sprintf(str, "Fractal name:%s", context->currentformula->name[!context->mandelbrot]);
    print_function(0, textwidth, str);
    sprintf(str, "Fractal type:%s", context->mandelbrot ? "Mandelbrot" : "Julia");
    print_function(0, 2 * textwidth, str);
    sprintf(str, "View:[%1.4E,%1.4E] [%1.4E,%1.4E]", (double) s.mc, (double) s.mi, (double) s.nc, (double) s.ni);
    print_function(0, 3 * textwidth, str);
    sprintf(str, "Screen size:%4i:%-4i", context->width, context->height);
    print_function(0, 4 * textwidth, str);
    sprintf(str, "Iterations:%4i   Palette size:%i", context->maxiter, context->num_colors);
    print_function(0, 5 * textwidth, str);
    sprintf(str, "Autopilot:%-4s    Plane:%s", autopilot ? "On" : "Off", planename[context->plane]);
    print_function(0, 6 * textwidth, str);
    sprintf(str, "zoomspeed:%f", (float) maxstep * 1000);
    print_function(0, 7 * textwidth, str);
    sprintf(str, "incoloring:%s outcoloring:%s", incolorname[context->incoloringmode], outcolorname[context->coloringmode]);
    print_function(0, 8 * textwidth, str);
    if (context->mandelbrot)
	strcpy(str, "Parameter:none");
    else
	sprintf(str, "Parameter:[%f,%f]", (float) context->pre, (float) context->pim);
    print_function(0, 9 * textwidth, str);
}

void ui_message(void)
{
    char s[80];

    sprintf(s, "Please wait while calculating %s", context->currentformula->name[!context->mandelbrot]);
    print_function(0, 0, s);
    ui_status();
}

int ui_mouse(int mousex, int mousey, int mousebuttons, int iterchange)
{
    int inmovement = 0, slowdown = 1;
    static double step = 0, pressed = 0;
    static number_t oldx = 0, oldy = 0;
    static int dirty = 0;
    static int iterstep = 1;

    /*tbreak=1; */
    if (iterchange == 2 && lookup_timer() > FRAMETIME) {
	char s[80];
	get_timer();
	context->maxiter += iterstep;
	if (!(context->maxiter % 10))
	    iterstep = 10;
	dirty = 1;
	sprintf(s, "Iterations:%i ", context->maxiter);
	print_function(0, 0, s);
	init_tables(context);
	return 1;
    }
    if (iterchange == 1 && lookup_timer() > FRAMETIME) {
	char s[80];
	get_timer();
	context->maxiter -= iterstep;
	if (!(context->maxiter % 10))
	    iterstep = 10;
	dirty = 1;
	if (context->maxiter < 0) {
	    context->maxiter = 0;
	    return autopilot;
	} else {
	    sprintf(s, "Iterations:%i ", context->maxiter);
	    print_function(0, 0, s);
	}
	init_tables(context);
	return 1;
    }
    if (!iterchange || iterchange == 3)
	iterstep = 1;
    if (iterchange)
	return 1;
    if (dirty)
	ui_message(), ui_do_fractal(), ui_tbreak(), dirty = 0;
    if (autopilot)
	do_autopilot(context, &mousex, &mousey, &mousebuttons);
    if (tbreak)
	mul = 1;
    if (mul == 0)
	mul = 0.001;
    if (mousebuttons > 0) {
	switch (mousebuttons) {
	case BUTTON1:		/* button 1 */
	    step -= speedup * 2 * mul, slowdown = 0;
	    inmovement = 1;
	    break;
	case BUTTON3:		/* button 3 */
	    step += speedup * 2 * mul, slowdown = 0;
	    inmovement = 1;
	    break;
	case BUTTON2:		/* button 2 */
	    {
		number_t x = xstoc(mousex), y = ystoc(mousey);
		if (pressed && (oldx != x || oldy != y)) {
		    s.nc -= x - oldx;
		    s.mc -= x - oldx;
		    s.ni -= y - oldy;
		    s.mi -= y - oldy;
		    if (!step) {
			ui_do_fractal(), ui_tbreak();
		    }
		}
		pressed = 1;
		oldx = xstoc(mousex), oldy = ystoc(mousey);
	    }
	    break;
	default:
	    break;
	}
    }
    if (!(mousebuttons & BUTTON2))
	pressed = 0;
    if (slowdown) {
	if (step > 0) {
	    if (step < speedup * mul)
		step = 0;
	    else
		step -= speedup * mul;
	} else if (step < 0) {
	    if (step > -speedup * mul)
		step = 0;
	    else
		step += speedup * mul;
	}
    }
    if (step > maxstep)
	step = maxstep;
    else if (step < -maxstep)
	step = -maxstep;
    if (step) {
	s.mc += (s.mc - xstoc(mousex)) * step * mul;
	s.nc += (s.nc - xstoc(mousex)) * step * mul;
	s.mi += (s.mi - ystoc(mousey)) * step * mul;
	s.ni += (s.ni - ystoc(mousey)) * step * mul;
	inmovement = 1;
	ui_do_fractal();
	if (tbreak)
	    tbreak--;
    }
    if (!inmovement)
	ui_tbreak();
    return (inmovement | autopilot);
}
