#include <u.h>
#include <libc.h>
#include <stdio.h>
#include <libg.h>
#include "zoom.h"
#include "ui.h"
#include "palette.h"
#include "gif.h"

Bitmap *mybitmap;
char *buffers[2];
Rectangle rect, rect1;
int width, height;
int current = 1;

static zoom_context *context;
RGB cmap[256];
int ncolors;
static int set_color(int r, int g, int b, int init)
{
    RGB c =
    {r * 256 * 256 * 256, g * 256 * 256 * 256, b * 256 * 256 * 256};
    return (rgbpix(&screen, c));
/*
   ncolors++;
   if (init)
   ncolors=0;
   cmap[ncolors].red=(unsigned long)r*256UL*256UL*256UL;
   cmap[ncolors].green=(unsigned long)g*256UL*256UL*256UL;
   cmap[ncolors].blue=(unsigned long)b*256UL*256UL*256UL;
   wrcolmap(&screen,cmap);
   return (ncolors); */
}

static void myprint(int x, int y, char *text)
{
    Point p =
    {rect.min.x + x, rect.min.y + y};
    string(&screen, p, font, text, S);
    bflush();

}

static void display(void)
{
    wrbitmap(mybitmap, 0, height, (unsigned char *) buffers[current]);
    bitblt(&screen, rect.min, mybitmap, rect1, S);
    bflush();
}

static void myflip_buffers(void)
{
/*
   xflip_buffers(d);
 */
}

void ereshaped(Rectangle rect1)
{
    free(buffers[0]);
    free(buffers[1]);
    bfree(mybitmap);
    bscreenrect(&rect);
    width = rect.max.x - rect.min.x;
    height = rect.max.y - rect.min.y;
    rect1.min.x = 0;
    rect1.min.y = 0;
    rect1.max.x = width;
    rect1.max.y = height;
    mybitmap = balloc(rect1, 3);
    buffers[0] = malloc(width * (height + 1));
    buffers[1] = malloc(width * (height + 1));
    resize_to(context, width, height, buffers[0], buffers[1]);
    ui_updateparameters();
    ui_message();
    ui_do_fractal();
    ui_tbreak();
}

static void main_loop(void)
{
    int mousex = 0, mousey = 0;
    int iflag = 0;
    unsigned int mousebuttons = 0;
    int inmovement = 0;
    Event E;
    int quit = 0;
    while (!quit) {
	while (inmovement && !ecanread(Emouse | Ekeyboard))
	    inmovement = ui_mouse(mousex, mousey, mousebuttons, iflag);
	switch (event(&E)) {
	case Emouse:
	    mousex = E.mouse.xy.x - rect.min.x;
	    mousey = E.mouse.xy.y - rect.min.y;
	    inmovement = E.mouse.buttons;
	    mousebuttons = 0;
	    inmovement = 1;
	    if (E.mouse.buttons & 1)
		mousebuttons = BUTTON1;
	    if (E.mouse.buttons & 2)
		mousebuttons |= BUTTON2;
	    if (E.mouse.buttons & 4)
		mousebuttons |= BUTTON3;
	    break;
	    /*
	       case Expose:
	       #ifdef MITSHM
	       busy++;
	       #endif
	       XSync(d->display, 0);
	       draw_screen(d);
	       ui_tbreak();
	       break;

	       case ConfigureNotify:
	       XSync(d->display, 0);
	       resize();
	       break; */
/*
   case KeyRelease:{
   KeySym ksym;
   switch (ksym = XLookupKeysym(&ev.xkey, 0)) {
   case XK_Left:
   iflag &= 2;
   inmovement = 1;
   break;
   case XK_Right:
   iflag &= 1;
   inmovement = 1;
   break;
   }
   }
   break;
 */
	case Ekeyboard:{
		int sym;
		/*printf("%i\n",E.kbdc); */
		switch (sym = tolower(E.kbdc)) {
/*              case XK_Left:
   iflag |= 1;
   inmovement = 1;
   break;
   case XK_Right:
   iflag |= 2;
   inmovement = 1;
   break;
   case XK_Up:
   ui_speedup();
   break;
   case XK_Down:
   ui_slowdown();
   break; */
		case 'm':
		    ui_mandelbrot(mousex, mousey);
		    break;
		case 'i':
		    ui_inverse();
		    break;
		case 'f':
		    ui_incoloringmode();
		    break;
		case 'c':
		    ui_coloringmode();
		    break;
		case 'h':
		    ui_help();
		    break;
		case 's':
		    ui_savefile();
		    break;
		case 'p':
		    mkpalette(context, set_color, 1);
		    ui_message();
		    init_tables(context);
		    ui_tbreak();
		    ui_do_fractal();
		    break;
		case 'a':
		    ui_autopilot();
		    inmovement = 1;
		    break;
		case 'q':
		    quit = 1;
		    break;
		    break;
		default:
		    if (sym >= '1' && sym <= '9') {
			set_formula(context, sym - '1');
			ui_message();
			ui_updateparameters();
			ui_do_fractal();
			ui_tbreak();
		    }
		    break;
		}
	    }
	    break;
	}
    }
}

int main(int argc, char **argv)
{
    binit(NULL, NULL, "XaoS");
    einit(Ekeyboard | Emouse);
    bscreenrect(&rect);
    width = rect.max.x - rect.min.x;
    height = rect.max.y - rect.min.y;
    rect1.min.x = 0;
    rect1.min.y = 0;
    rect1.max.x = width;
    rect1.max.y = height;
    mybitmap = balloc(rect1, 3);
    buffers[0] = malloc(width * (height + 1));
    buffers[1] = malloc(width * (height + 1));
    context = make_context(width, height, 0, 0, myflip_buffers, buffers[0], buffers[1]);
    ui_init(context, display, set_color, 1, myprint, font->height);
    main_loop();
    bexit();
    exits("Thank you for using XaoS");
}
