#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <limits.h>
#include <math.h>
#include <signal.h>
#include <string.h>
#include <X11/Xlib.h>
#include "xlib.h"
#ifdef MITSHM
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>
#endif
#include "zoom.h"
#include "ui.h"
#include "palette.h"
#include "gif.h"

static xdisplay *d;
static int busy;
static zoom_context *context;

static int set_color(int r, int g, int b, int init)
{
    if (init)
	xfree_colors(d);
    return (xalloc_color(d, r * 256, g * 256, b * 256, init));
}

static void print(int x, int y, char *text)
{
    xmoveto(d, x, y + 15);
    xouttext(d, text);
    XSync(d->display, 0);

}

static void display()
{
#ifdef MITSHM
    if (d->SharedMemFlag)
	busy++;
#endif
    draw_screen(d);
    XFlush(d->display);
}

static void myflip_buffers()
{
    xflip_buffers(d);
}

static void resize()
{
    if (xupdate_size(d)) {
	free_image(d);
	if (!alloc_image(d)) {
	    printf("Falied to attach shared memory\n");
	    exit(-1);
	}
	resize_to(context, d->linewidth, d->height, d->vbuff, d->back);
	ui_updateparameters();
	ui_message();
	ui_do_fractal();
	ui_tbreak();
    }
}

static void main_loop(void)
{
    int mousex = 0, mousey = 0;
    int iflag = 0;
    unsigned int mousebuttons = 0;
    int inmovement = 0, rootx, rooty;
    XEvent ev;
    Bool quit = False;
#ifdef MITSHM
    int Completion = XShmGetEventBase(d->display) + ShmCompletion;
#endif
    Window rootreturn, childreturn;

    while (!quit) {
	while (busy < 2 && inmovement && !XEventsQueued(d->display, QueuedAlready))
	    inmovement = ui_mouse(mousex, mousey, mousebuttons, iflag);
	XNextEvent(d->display, &ev);
	switch (ev.type) {
	case ButtonRelease:
	    mousex = ev.xbutton.x;
	    mousey = ev.xbutton.y;
	    switch (ev.xbutton.button) {
	    case 1:
		mousebuttons &= ~BUTTON1;
		break;
	    case 2:
		mousebuttons &= ~BUTTON2;
		break;
	    case 3:
		mousebuttons &= ~BUTTON3;
		break;
	    }
	    inmovement = 1;
	    break;
	case ButtonPress:
	    mousex = ev.xbutton.x;
	    mousey = ev.xbutton.y;
	    if (mousex < 0 || mousey < 0 || mousex > d->width || mousey > d->height)
		return;
	    switch (ev.xbutton.button) {
	    case 1:
		mousebuttons |= BUTTON1;
		break;
	    case 2:
		mousebuttons |= BUTTON2;
		break;
	    case 3:
		mousebuttons |= BUTTON3;
		break;
	    }
	    inmovement = 1;
	    break;
	case MotionNotify:
	    mousex = ev.xmotion.x;
	    mousey = ev.xmotion.y;
	    mousebuttons = ev.xmotion.state & (BUTTON1 | BUTTON2 | BUTTON3);
	    inmovement = 1;
	    break;
	case Expose:
#ifdef MITSHM
	    busy++;
#endif
	    XSync(d->display, 0);
	    draw_screen(d);
	    ui_tbreak();
	    break;
	case ConfigureNotify:
	    XSync(d->display, 0);
	    resize();
	    break;
	case KeyRelease:{
		KeySym ksym;
		switch (ksym = XLookupKeysym(&ev.xkey, 0)) {
		case XK_Left:
		    iflag &= 2;
		    inmovement = 1;
		    break;
		case XK_Right:
		    iflag &= 1;
		    inmovement = 1;
		    break;
		}
	    }
	    break;
	case KeyPress:{
		KeySym ksym;
		switch (ksym = XLookupKeysym(&ev.xkey, 0)) {
		case XK_Left:
		    iflag |= 1;
		    inmovement = 1;
		    break;
		case XK_Right:
		    iflag |= 2;
		    inmovement = 1;
		    break;
		case XK_Up:
		    ui_speedup();
		    break;
		case XK_Down:
		    ui_slowdown();
		    break;
		case XK_m:
		case XK_M:
		    XQueryPointer(d->display, d->window,
				  &rootreturn, &childreturn,
				  &rootx, &rooty, &mousex,
				  &mousey, &mousebuttons);
		    ui_mandelbrot(mousex, mousey);
		    break;
		case XK_i:
		case XK_I:
		    ui_inverse();
		    break;
		case XK_f:
		case XK_F:
		    ui_incoloringmode();
		    break;
		case XK_c:
		case XK_C:
		    ui_coloringmode();
		    break;
		case XK_h:
		case XK_H:
		    ui_help();
		    break;
		case XK_s:
		case XK_S:
		    ui_savefile();
		    break;
		case XK_p:
		case XK_P:
		    mkpalette(context, set_color, 1);
		    ui_message();
		    init_tables(context);
		    ui_tbreak();
		    ui_do_fractal();
		    break;
		case XK_a:
		case XK_A:
		    ui_autopilot();
		    inmovement = 1;
		    break;
		case XK_Q:
		case XK_q:
		case XK_Escape:
		    quit = True;
		    break;
		    break;
		default:
		    if (ksym >= XK_1 && ksym <= XK_9) {
			set_formula(context, ksym - XK_1);
			ui_message();
			ui_updateparameters();
			ui_do_fractal();
			ui_tbreak();
		    }
		    break;
		}
	    }
	    break;
	default:
#ifdef MITSHM
	    if (ev.xany.type == Completion)
		busy--;
#endif
	    break;
	}
    }
}

int main(int argc, char **argv)
{
    d = xalloc_display("XaoS", XSIZE, YSIZE);
    if (!alloc_image(d)) {
	printf("Falied to initialise shared memory\n");
	exit(1);
    }
    signal(SIGFPE, SIG_IGN);
    context = make_context(d->linewidth, d->height, 0, 0, myflip_buffers, d->vbuff, d->back);
    ui_init(context, display, set_color, 1, print, xsetfont(d, "fixed"));
    main_loop();
    xfree_display(d);
    exit(0);
}
