/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

/* ----------------------------------------------------------------- */
void getimage(int left, int top, int right, int bottom, void *bitmap)
{
  GrContext *gc;
  char      *memory;

  _DO_INIT_CHECK;
  GrSetContext(NULL);
  GrResetClipBox();
  gc = bitmap;
  memory = ((char *)bitmap) + sizeof(GrContext);
  GrCreateContext( right-left+1, bottom-top+1, memory, gc);
  GrBitBlt( gc, 0, 0, NULL, left+VL, top+VT, right+VL, bottom+VT, GrWRITE);
  __gr_Reset_ClipBox();
}

/* ----------------------------------------------------------------- */
void putimage(int left, int top, void *bitmap, int op)
{
  GrContext *gc;

  _DO_INIT_CHECK;
  GrSetContext(NULL);
  GrResetClipBox();
  gc = bitmap;
  GrBitBlt( NULL, left+VL, top+VT, gc, 0, 0, gc->gc_xmax, gc->gc_ymax, op);
  __gr_Reset_ClipBox();
}

/* ----------------------------------------------------------------- */
unsigned imagesize(int left, int top, int right, int bottom)
{
  _DO_INIT_CHECK_RV(0);
  return  sizeof(GrContext)
    + GrContextSize( __ABS(right-left)+1, __ABS(bottom-top)+1);
}

