#define BETA 0 /* 1 if beta version */
#define LL_MAX 16384

#define mouse_x (xoffset + (((mousex - midx) * scalers[scale]) >> 1))
#define mouse_y (yoffset + (((midy - mousey) * scalers[scale]) >> 1))
#define adjustx(x) (midx + (((x - xoffset) / scalers[scale]) << 1))
#define adjusty(y) (midy + (((yoffset - y) / scalers[scale]) << 1))

typedef unsigned char uchar;
typedef unsigned int uint;
typedef unsigned long ulong;

/* main.c */

int main(int argc, char *argv[] );
int general_setup(int argc, char *argv[], char *gname);
void main_loop(void);
void set_flags_mask(void);
void gen_help(void);
void clear_map1(void);
void clear_map(void);
int edit_branch(void);
int map_keys(int key);
void draw_vertex(int num, int color, int size);
int new_point_size(int size);
int re_x(void);
int re_y(void);
int add_vertex(void); /* add vertex for line use */
void del_vertex(int num); /* delete vertex and reroute lines to it */
void flip_line(int num);
int add_sidedef(int num);
int between(int x1, int x2, int x3); /* determine if x1 is between x2 & x3 */
void del_line(int num);
void del_sidedef(int num);
int draw_time_graph(int y);
void time_graph(ulong num, ulong max, int x, int y);
void reset_time_graph(ulong num, ulong max, int x, int y);
void change_maps(int mode);
void mouse_on(void);
void mouse_redraw(void);
void mouse_off(void);
int mouse_check(void);
void next_button(void);
void reconfig_mouse(void);
void print_button(int button, char *name);
void adjust_limit(int x, int y, int *xmin, int *ymin, int *xmax, int *ymax);
int rand_color(void);
int stagger_color(void);
int wall_color(int num); /* return wall color for linedef <num> */
void draw_map(void);
void print_roundoff(void);
void draw_line(int number, int style); /* draw linedef <number> */
void draw_line2(int x1, int y1, int x2, int y2);
void draw_box(int xx1, int yy1, int xx2, int yy2);
void draw_point(int xpos, int ypos, int pmaxx, int pmaxy);
int draw_thing(int xpos, int ypos, int type, int angle, char *buffer);
void center_map(void); /* center the map on the screen */
void text(int xx, int yy, char *msg);
void toptext(char *msg);
void toptext2(char *msg, char *msg2);
void window_text1(char far *msg, int center, int xplus, int yplus);
void window_text(char far *msg, int center);
void text_to_window(int column, int row, char huge *msg, int max_len);
void draw_buttons(void);
void set_window(int columns, int rows, int center);
void set_window1(int xsize, int ysize, int center);
void set_window_bars(void);
void set_cancel_bar(void);
void set_button_statuses(int num);
int window_check(void);
void await_release(void); /* wait until mouse buttons released */
void await_release_on(void);
void draw_cursor(int x, int y, int color);
void fatal_error(char *msg, ...); /* terminate with error */
void error(char *errmsg, ...);
void farmem_error(char *msg, ulong size);
void deadend_error(void);
void rd_error(void);
void wr_error(void);
void dir_error(void);
void erase_text(int x, int y, int xsize);
int cursored_get(int x, int y);
int get_number(int x, int y, int old_num, int max, int min);
int getkey(void); /* get normal or extended keypress */
int get8(char *s, char *deflt, int column, int row);
void fix_wadname(char *name);
int get_wadname(char *mode1, char *mode2);
int file_picklist(char *mask);
void sync_time(void);
int wait(int delay); /* attemp to time sync animation */
void open_prog_file(char *name, char *mode);
void init_graphics(int gmode, char *gname);
void init_mouse(void);

/* debug.c */

void block_test(void);
int seg_test(void);
int node_test(void);
int node_test2(void);
void draw_node(int node, int *ln, int *rn, int *lss, int *rss, int recurse);
void draw_ssec(int ssec);
void draw_seg_vertex(int num, int color);
void color2wall(int line, int col1, int col2);
void test_draw_sector(int line, int sector);

/* things.c */

int thing_edit(void);
void change_thing(int thing);
int picklist(int num);
void reprint_line(int num, int yy, int max);
int draw_thing2(int xpos, int ypos, int num);
int print_typedesc(int num);
void print_angle(int num);
void box_local_thing(int num);
void box_thing(int x1, int y1, uint offset);
int thing_drag(void);
void del_thing(int num);
void draw_item(int num, int x, int y, char *save);
void plot_colored_point(int x, int y, int color);

/* edits.c */

int vertex_edit(void);
int vertex_drag(void);
int line_edit(void);
int line_drag1(void);
int line_drag2(void);
void line_and_seg(int num);
void change_line(int line_num, int cur_side);
int select_wall_textr(char far *farname, int x, int y);
int sector_edit(void);
void redraw_sector(int num);
int sector_light(int num);
int round8(int num);
void make_door(int sector);
void blend_sector(int sector);
int change_adjust(int button, int value);
void change_sector(int sector);
void del_sector(int num);
int make_sector(int x, int y, int line, int side, int sector);
void plot_colored_point(int x, int y, int color);
void restore_point(int num);

/* linemath.c */

int calc_line_cross(int *y, int x1, int y1, int v2, int v3, int v4, uint angle);
int line_visible(int num);
int line_in_rect(int x1, int y1, int x2, int y2, int xmin, int ymin, int xmax, int ymax);
int xclip(int x, int x1, int y1, int x2, int y2);
int yclip(int y, int x1, int y1, int x2, int y2);
int line_dist(int x1, int y1, int x2, int y2);
int line_dist2(int x, int y, int x1, int y1, int x2, int y2);
uint calc_angle(int x1, int y1, int x2, int y2);
int find_next_line(int *vertex, uint *angle, int *line, int side);
int inside_sector(int x, int y);
int line_least_angle(int line1, int line2, uint angle);
int adjusted_angle(uint angle, int x1, int y1, int x2, int y2);
int line_side(int line, int x, int y);
int match_line(int vertex, int vertex2);
int outside_detect(int line1, int side1);
int inside_poly(int x, int y, int *side, int test);
int downward_line(int vertex, int *side, int test);

/* advanced.c */

void misc_options(void);
void check_lines(void);
long summation(uint num);
void fixup_lines(void);
int wall_check(int line, int side);
void generate_sectors(void);
void fixup_sectors(void);
void generate_nodes(void);
void draw_side(int x1, int y1, int x2, int y2);
void fix_sidedefs(int line);
void fix_sidedef(int line, int side);
void generate_blockmap(void);
int blockmap_add(int num);
void plot_list(int size, int far *list);
void calc_map_data(void);
int test_map(void);
int test_map2(int left, int right, int cur, int far *left_list,
	int far *right_list, int far *cur_list);
int showlist(char *name, int size, char far *list);

/* textures.c */

void load_textures(void);
int draw_wall_texture(int xpos, int ypos, int xsize, int ysize,
	int xshift, int yshift, char *name);
void wall_textr_pick(char *name);
int free_patch(void);
void box_textr(int x1, int y1, int color);
void fc_textr_pick(char *name);

/* memory.c */

void *get_mem(uint size, char *name);
void *resize_mem(void *old, uint size, char *name);
void free_mem(void *ptr, char *name);
void huge *get_farmem(ulong size, char *name);
void huge *resize_farmem(void huge *old, ulong size, char *name);
void free_farmem(void huge *ptr, char *name);
void sizeof_mem_block(void *ptr, char *name);
void sizeof_farmem_block(void far *ptr, char *name);
void check_mem(void);
void check_farmem(void);
void mem_log(char *msg, ...);
void statistics(void);
void heaperr(char *func, char *name);
void farheaperr(char *func, char *name);
void fatal_mem_error(char *name, uint size);
void fatal_farmem_error(char *name, ulong size);
void check_if_used(void *ptr, char *name);
void check_if_used_far(void huge *ptr, char *name);

/* wad.c */

int open_wad(char *name, char *fmode);
int open_wad_seek(char *fmode, char *entry);
int open_iwad_seek(char *fmode, char *entry);
void open_wad_seek_map(char *fmode, int which);
int wad_seek(char *entry);
void load_pwad_startup(void);
void load_wad_map(int which); /* load map info from wad file */
void make_new_wad(void);
int remake_wad(int add);
void find_doom_wad(void);
int open_wad_seekto(char *fmode, char *entry);
int check_commercial(void);
int far_read(char huge *farptr, long len); /* read to a far location */
long fread_long(void);
int fwrite_long(long integer);
int cmp_entry(char *look_for, char far *entry); /* compare wad entry name */
int verify_wad(void); /* make sure this is a wad file */

/* reg.c */

void version_info(void);
void save_wad_map(int get_name); /* save map info to a pwad file */
int write_wad_entry(char *name, char huge *farptr, long len, char far *entry);
int far_write(char huge *farptr, long len); /* write from a far location */
void sw_notice(void);
void final_screen(void);

/* template.c */

void make_lists(void);
void mark_vertex(int num);
void mark_line(int num);
int boxmark(int mode);
int mthing_edit(void);
int mvertex_edit(void);
int mline_edit(void);
int msector_edit(void);
void plot_marked(int color);
void move_marked(void);
void unmark_all(void);
void sort_marked(int far *list);
