/*
	This is a DMapEdit source code module.  Though it is copyrighted, you
	may modify it and use it for your own personal use, meaning that new
	modified code and anything derived from it (such as exe files) doesn't
	get distributed to anyone, unless you get my permission first.  Code
	from this file, or code based on ideas from this file may be used with
	other programs, provided that you give credit for it in the source code,
	documentation, and 'about' windows or screens, if one exists, for the
	programs using it.  Giving credit means something like this:

	Code from DMapEdit was used in this program

							  or

	Some code for this program was based on ideas presented in DMapEdit

	Whatever.  Just be sure to mention "DMapEdit" in such a way that it's
	self-evident how it was useful to the new program, and be sure to have
	"DMapEdit is a trademark of Jason Hoffoss" in the docs.  That's all..
*/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <graphics.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <ctype.h>
#include <alloc.h>
#include "dme.h"

#define MAX_ZOOM 7

int read_ini_file(int gmode, char *gname);
void reconfig_mouse(void);
void print_button(int button, char *name);
void sw2_notice(void);

extern cur_box_color;
extern old_mark_color;

int breakpoint=0; /* used for debugging */
int bypass_sw=0; /* bypass the shareware notice message */
int attempt_save=0; /* attempting to save after a fatal error */
int mem_trace=0; /* track all memory calls to the log file */
int sw_doom=0; /* is this shareware doom? */
int flash_mode=1; /* use new style object hilighting */
int backup=1; /* make backup files */
int version=30; /* version number times 10 */
int graph_on=0; /* graphics mode is on */
int testmode=0; /* if in test mode */
int grid=0; /* grid color/off */
int roundoff=2; /* round off mouse (x,y) coords to multiple of 8 or 16 */
int color_num; /* current hilight color */
int points=0; /* display points mode size/off */
int point_size=1; /* point size (same as points, or 1 if points is 0) */
int things_on=1; /* size to draw things/off */
int line_size=1; /* thickness of drawn lines */
int midx, midy; /* center of screen coord */
int mouse; /* is the mouse pointer visible? */
int mousex, mousey; /* mouse screen coord */
int crossx, crossy; /* mouse crosshare coord */
int cross_on=1, cross_draw;
int mouse_maxx, mouse_maxy; /* max mouse screen coord */
int maxx, maxy; /* max screen coord */
int cur_drag; /* # of whatever we are currently draging */
int episode=1, mission=1; /* duh.. */
int edit_mode=0; /* what are we editing now? */
int color_scheme=0; /* method using to color walls */
int mark_mask=0; /* marked items hilighting method */
int flags_mask=7; /* display things bits */
int flags_mask2=7; /* display things match exactly bits */
int text_color=255; /* color to draw text */
int editing_pwad=0; /* are we editing a pwad? */
int systime; /* sync'ed hundred seconds count */
int marked;
uint v_size=0; /* # of vertexes */
uint v_max=0; /* # of vertexes current memory block can hold */
uint max_vertex=0; /* # of vertexes used by lines (below seg used ones) */
uint l_size=0; /* # of linedefs */
uint l_max=0;
uint s_size=0; /* # of sidedefs */
uint s_max=0;
uint t_size=0; /* # of things */
uint t_max=0;
uint b_size=0; /* size of blockmap */
uint n_size=0; /* size of nodes block */
uint n_max=0;
uint r_size=0; /* size of reject block */
uint ss_size=0; /* # of special sectors */
uint ss_max=0;
uint sec_size=0; /* # of sectors */
uint sec_max=0;
uint seg_size=0; /* # of segments */
uint seg_max=0;
long entry_count; /* # entries left in directory structure */
int button_status; /* current mouse buttons state */
int true_button; /* the true mouse button that was pressed */
int ignore_button=0; /* ignore mouse button down until released */
int button_lock=0; /* mouse button locked on (from a keypress) */
int left_button=1; /* function left mouse button performs */
int middle_button=4;
int right_button=2;
int keypress; /* current key pressed on keyboard (ext +1000) */
int scale=4; /* zoom factor, 0 is actually max zoomed in */
int xoffset, yoffset; /* map to screen offsets */
long dir_ptr; /* fseek position of directory in wad file */
long dir_size; /* # of entries in the wad directory */
long entry_ptr; /* fseek position of wad subfile */
long entry_len; /* length of wad subfile */
int thing_max; /* size of things list */
int thing_name_size; /* length of longest name in list */
int linetype_max;
int linetype_name_size;
int test_node=0; /* node being displayed (test mode only) */
int tx1, tx2, tx3, tx4, ty1, ty2, ty3, ty4; /* test drawing points */
char *help; /* help message id */
FILE *fp, *fp2; /* general file pointers */

char pwad[80]="NEW.WAD"; /* working wad filename */
char path[80]; /* program files path */
char iwad[80]; /* path to doom.wad */
unsigned char far doom_color[256]; /* table for doom color convertion */
char *pwad1, *pwad2, *pwad3; /* pwad directory paths */
int thing_types[96]; /* types of all known things */
char far *thing_names[96]; /* descriptions of thing types */
int thing_shapes[96]; /* shape to draw for this thing */
int thing_rad[96]; /* thing's radius */
int linetypes[133];
char far *linetype_names[133];
int adjvx[2000], adjvy[2000]; /* adjusted vertexes (screen coord) */
int ll_size, llines[2000]; /* local lines (ones on the screen) */
int far *mthings; /* marked thing list */
int far *mvertexes; /* marked vertex list */
int far *mlinedefs; /* marked linedef list */
int far *msidedefs; /* marked sidedef list */
int far *msectors; /* marked sector list */
char mouse_save[164]; /* saved background of mouse cursor shape */
char cross_save[29]; /* mouse crosshare image save buffer */
char *point_ptr[5]; /* pointer to point size images */
uint no_shapes, *shp_offsets; /* offset into shapes[] of shapes */
char far *shapes; /* shape image data memory block */
int lthing_count=0; /* # of lthings and memory flag */
int *lthing_num; /* local things indexes */
int *lthingx, *lthingy; /* local things screen coords */
uint *lthing_offsets; /* local things shape table offsets */
int far llist[LL_MAX];

struct { /* small radio button struct */
	int num;
	struct {
		int x;
		int y;
		int on;
		int status;
	} pos[30];
} far b;

struct { /* window struct */
	int top;
	int bottom;
	int left;
	int right;
	int bars;
	int okbar;
	int canbar;
} win;

struct { /* big buttons struct */
	int num;
	struct {
		int x1;
		int x2;
		int y;
	} pos[2];
} bigb;

struct t_struct {
	int x;
	int y;
	int angle;
	int type;
	int flags;
} huge *things;

struct l_struct {
	int v1;
	int v2;
	uint attrib;
	int type;
	int trig;
	int sd1;
	int sd2;
} huge *linedefs;

struct s_struct {
	int xoffset;
	int yoffset;
	char top[8];
	char bottom[8];
	char middle[8];
	int sector;
} huge *sidedefs;

struct v_struct {
	int x;
	int y;
} huge *vertexes;

struct seg_struct {
	int v1;
	int v2;
	uint angle;
	int linedef;
	int dir;
	int dist;
} huge *segs;

struct ss_struct {
	int size;
	int segptr;
} huge *ssectors;

struct n_struct {
	int x;
	int y;
	int dx;
	int dy;
	struct {
		int y1;
		int y2;
		int x1;
		int x2;
	} node1;
	struct {
		int y1;
		int y2;
		int x1;
		int x2;
	} node2;
	uint link1;
	uint link2;
} huge *nodes;

struct sec_struct {
	int floor;
	int ceiling;
	char floor_name[8];
	char ceiling_name[8];
	int light;
	int type;
	int trig;
} huge *sectors;

char huge *reject;

struct {
	int xorigin;
	int yorigin;
	int xsize;
	int ysize;
	int offsets[9];
} huge *blockmap;

int powers[] = { 4, 8, 16, 32, 64, 128, 256 };
int xor_powers[] = { 0xfffc, 0xfff8, 0xfff0, 0xffe0, 0xffc0, 0xff80, 0xff00 };
int scalers[] = { 1, 2, 4, 8, 16, 24, 36, 48 };

char crosshare[] = {
	0x04, 0x00, 0x04, 0x00,
	0x00, 0x81, 0x50, 0x81, 0x00,
	0x81, 0x81, 0x50, 0x81, 0x81,
	0x50, 0x50, 0x32, 0x50, 0x50,
	0x81, 0x81, 0x50, 0x81, 0x81,
	0x00, 0x81, 0x50, 0x81, 0x00 }; /* mouse crosshare image */

char point_image[] = {
	0x02, 0x00, 0x02, 0x00, /* point size 1 */
	0xff, 0xff, 0xff,
	0xff, 0xff, 0xff,
	0xff, 0xff, 0xff,

	0x04, 0x00, 0x04, 0x00, /* point size 2 */
	0x00, 0xff, 0xff, 0xff, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0xff, 0x00,

	0x06, 0x00, 0x06, 0x00, /* point size 3 */
	0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00,

	0x08, 0x00, 0x08, 0x00, /* point size 4 */
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,

	0x0a, 0x00, 0x0a, 0x00, /* point size 5 */
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00 };

char *subfiles[10] = {
	"THINGS",
	"LINEDEFS",
	"SIDEDEFS",
	"VERTEXES",
	"SEGS",
	"SSECTORS",
	"NODES",
	"SECTORS",
	"REJECT",
	"BLOCKMAP" };

int main(int argc, char *argv[] )
{
	char gname[9], beta_msg[9];
	int gmode;

	*beta_msg = 0;
	if (BETA) strcpy(beta_msg, " (Beta)");

/*	printf("Doom Map Editor v%d.%d%s\n", version/10, version%10, beta_msg);*/
	printf("Doom Map Editor v3.01\n");
	gmode = general_setup(argc, argv, gname);
	find_doom_wad();
	load_textures();
	load_pwad_startup();
	init_graphics(gmode, gname);
	init_mouse();
	center_map();
	draw_map();
	sw2_notice();
	sw_notice();
	main_loop();
	closegraph();
	final_screen();
	return;
}

int general_setup(int argc, char *argv[], char *gname)
{
	char str[81], temp[31];
	int i, j, k, gmode=2;
	uint len;

	*iwad = 0;
	help = NULL;
	point_ptr[0] = point_image;
	point_ptr[1] = point_image+13;
	point_ptr[2] = point_image+42;
	point_ptr[3] = point_image+95;
	point_ptr[4] = point_image+180;

	t_size = l_size = s_size = v_size = seg_size = ss_size = n_size =
		sec_size = r_size = b_size = 0;
	unlink("memory.log");
	make_lists();

	strcpy(path, argv[0] );
	i = strlen(path);
	while (i--)
		if (path[i] == '\\')
		{
			path[i+1] = 0;
			break;
		}

	thing_max = 0;
	thing_name_size = 0;
	open_prog_file("itemlist.dme", "r");
	while (fgets(str, 80, fp) != NULL)
	{
		char *name_ptr;

		if (thing_max == 96)
			fatal_error("Item list is too big");
		if (*str == '*' || *str == '\n') continue; /* skip this line */
		sscanf(str, "%d,%d,%d,%n", &thing_types[thing_max],
			&thing_shapes[thing_max], &thing_rad[thing_max], &i);
		str[strlen(str)-1] = 0; /* trash the newline char */
		name_ptr = &str[i];
		j = strlen(name_ptr);
		thing_names[thing_max] = get_farmem(j+1, "thing_names");
		_fstrcpy(thing_names[thing_max], name_ptr);
		if (j > thing_name_size)
			thing_name_size = j;
		thing_max++;
	}
	fclose(fp);

	linetype_max = 0;
	open_prog_file("linetype.dme", "r");
	while (fgets(str, 80, fp) != NULL)
	{
		char *name_ptr;

		if (*str == '*' || *str == '\n' ||
			*str == '%') continue; /* skip this line */

		if (linetype_max == 133)
			fatal_error("Linetype list is too big");

		sscanf(str, "%d,%n", &linetypes[linetype_max], &i);
		str[strlen(str)-1] = 0; /* trash the newline char */
		name_ptr = &str[i];
		j = strlen(name_ptr);
		linetype_names[linetype_max] = get_farmem(j+1, "linetype_names");
		_fstrcpy(linetype_names[linetype_max], name_ptr);
		if (j > linetype_name_size)
			linetype_name_size = j;
		linetype_max++;
	}
	fclose(fp);

	open_prog_file("shapes.dme", "rb");
	fread(&no_shapes, sizeof(no_shapes), 1, fp);
	fread(&len, sizeof(len), 1, fp);
	shp_offsets = get_mem(no_shapes * 2, "shp_offsets");
	fread(shp_offsets, 2, no_shapes, fp);
	shapes = get_farmem(len, "shapes");
	far_read(shapes, len);
	fclose(fp);

	open_prog_file("coltable.dme", "rb");
	far_read(doom_color, 256L);
	fclose(fp);

	gmode = read_ini_file(gmode, gname);
	strcpy(gname, "vesa");

	for (i=1; i<argc; i++)
	{
		if (*argv[i] == '-' || *argv[i] == '/')
		{
			argv[i]++;

			if (*argv[i] == 'v' || *argv[i] == 'V')
			{
				argv[i]++;
				if (!isdigit(*argv[i]))
				{
					j = 0;
					while ((str[j] = argv[i][j]) != ',')
						j++;
					str[j] = str[8] = 0;
					strcpy(gname, str);
					argv[i] += j + 1;
				}
				gmode = atoi(argv[i]);
				continue;
			}

			if (*argv[i] == 'x' || *argv[i] == 'X')
				bypass_sw++;

			if (!strcmp(argv[i], "memtrace"))
			{
				mem_trace++;
				continue;
			}

			if (!strcmp(argv[i], "test"))
			{
				testmode++;
				continue;
			}

			if (*argv[i] == 'i' || *argv[i] == 'I')
			{
				if (strlen(argv[i]) > 80)
					*(argv[i] + 80) = 0;
				strcpy(iwad, argv[i]+1);
			}
		} else {
			if (strlen(argv[i]) > 79)
				*(argv[i] + 79) = 0;
			strcpy(pwad, argv[i]);
			strupr(pwad);
			if (strcmp(pwad + strlen(pwad) - 4, ".WAD"))
			{
				if (strlen(pwad) > 75)
					pwad[75] = 0;
				strcat(pwad, ".WAD"); /* add extention if not there */
			}
			editing_pwad = 1;
		}
	}

	lthing_num = get_mem(1, "lthing_num"); /* dummy pointers */
	lthingx = get_mem(1, "lthingx");
	lthingy = get_mem(1, "lthingy");
	lthing_offsets = get_mem(1, "lthing_offsets");

	return gmode;
}

void main_loop(void)
{
	char name[13];
	int chr, redraw;

	while (1)
	{
		chr = edit_branch();
		redraw = map_keys(chr);
		if (chr == 27)
		{
			window_text("Please confirm you wish to quit\n\n"
				"(be sure to save your map\t"
				"first, if you plan to)\t\n", 1);

			set_window_bars();
			if (window_check() == -1)
				return;
			redraw = 1;
		}

		if (chr == -1)
		{
			window_text("Mode unavailable\n", 1);
			chr = getkey();
		}

		switch (chr)
		{
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
				point_size = points = chr - '0';
				if (!points)
					point_size = 1;
				redraw = 1;
				break;

			case '<':
			case ',':
				if (roundoff)
					roundoff--;
				redraw = 1;
				break;

			case '>':
			case '.':
				if (roundoff < 6)
					roundoff++;
				redraw = 1;
				break;

			case 1059: /* F1 */
				edit_mode = 0;
				points = 0;
				things_on = scale>2 ? 2 : 1;
				redraw = 1;
				break;

			case 1060: /* F2 */
				edit_mode = 2;
				points = point_size;
				things_on = 0;
				redraw = 1;
				break;

			case 1061: /* F3 */
				edit_mode = 4;
				points = point_size;
				things_on = 0;
				redraw = 1;
				break;

			case 1062: /* F4 */
				edit_mode = 7;
				points = 0;
				things_on = 0;
				redraw = 1;
				break;

			case 'c':
				change_maps(0);
				redraw = 1;
				break;

			case 8: /* backspace */
				unmark_all();
				break;

			case 'n':
				clear_map1();
				redraw = 1;
				break;

			case 't':
				if (things_on++ == 2)
					things_on = -1;
				if (!edit_mode && !things_on)
					things_on++;
				redraw = 1;
				break;

			case '\\':
				line_size ^= 2;
				redraw = 1;
				break;

			case 'l':
				if (!get_wadname("Load", "from"))
					change_maps(1);
				redraw = 1;
				break;

			case '\t':
				reconfig_mouse();
				redraw = 1;
				break;

			case 's':
				save_wad_map(1);
				break;

			case 1038: /* Alt-L, load working wad */
				if (editing_pwad)
					load_wad_map(0);
				else if (!get_wadname("Load", "from"))
					change_maps(1);
				redraw = 1;
				break;

			case 1019: /* Alt-R, reload IWAD */
				load_wad_map(1);
				redraw = 1;
				break;

			case 1031: /* Alt-S, save working wad */
				save_wad_map(0);
				break;

			case 1029: /* Alt-W, save to IWAD */
				save_wad_map(1);
				break;

			case 1120: /* Alt-1 */
			case 1121:
			case 1122:
				color_scheme = chr - 1120;
				redraw = 1;
				break;

			case 1067: /* F9 */
				misc_options();
				redraw = 1;
				break;

			case 1068: /* F10 */
				if (testmode)
					edit_mode = 100;
				redraw = 1;
				break;

			case 1133: /* F11 */
				test_node = n_size - 1;
				if (testmode)
					edit_mode = 101;
				redraw = 1;
				break;

			case 1134: /* F12 */
				if (testmode)
					edit_mode = 102;
				redraw = 1;
				break;

			case '_':
				center_map();
				redraw = 1;
				break;

			case '?':
				gen_help();
				redraw = 1;
				break;

			case 'f':
				set_flags_mask();
				redraw = 1;
				break;

			case 'z':
				statistics();
				redraw = 1;
				break;

			case 1047:
				version_info();
				break;

			case 'g':
				grid++;
				if (grid == 1)
					grid = 252;
				if (grid == 255)
					grid = 0;
				redraw = 1;
				break;

			case 1049: /* Alt-N */
				generate_nodes();
				redraw = 1;
				break;

			case '~':
				if (testmode)
					block_test();
				break;
		}

		if (redraw)
		{
			draw_map();
			await_release();
		}
	}
}

void set_flags_mask(void)
{
	int i, button, f, f2;
	int mask[] = { 0x1, 0x2, 0x4, 0x10 };

	f = flags_mask;
	f2 = flags_mask2;

	window_text("Display things for:\t\n"
		"Skill levels 1 & 2. @ @\n"
		"Skill level 3...... @ @\n"
		"Skill level 4...... @ @\n"
		"Deathmatch mode.... @ @\n\n", 1);

	set_window_bars();
	for (i=0; i<4; i++)
	{
		b.pos[i*2].on = f & mask[i];
		b.pos[i*2+1].on = f2 & mask[i];
	}

	while ((button = window_check()) > -1)
	{
		if (button & 1)
		{
			f2 ^= mask[button / 2];
			b.pos[button].on = f2 & mask[button / 2];
		} else {
			f ^= mask[button / 2];
			b.pos[button].on = f & mask[button / 2];
		}
	}

	if (button == -1)
	{
		flags_mask = f;
		flags_mask2 = f2;
	}
	return;
}

void gen_help(void)
{
	window_text("Global commands summary\t\n"
		"F1: Select thing edit mode     Escape: Quit back to dos\n"
		"F2: Select vertex edit mode    Arrows: Scroll map around\n"
		"F3: Select line edit mode\n"
		"F4: Select sector edit mode     Alt-W: Write map to the IWAD\n"
		"F9: Advanced/misc options       Alt-R: Reload map from the IWAD\n"
		" S: Save map to PWAD file       Alt-S: Save map to a PWAD file\n"
		" L: Load map from PWAD file     Alt-L: Load map from a PWAD file\n"
		" C: Change episode & mission #    0-5: Change vertex display size\n"
		" F: Change thing display masks      M: Mark object\n"
		" N: Make new map from scratch       T: Change thing icon size\n"
		" Z: Statistics                      \\: Change line display size\n"
		" +: Zoom in                         -: Zoom out\n"
		" G: Change grid intensity\n\n\n"
		"Editing modes specific commands\t\n"
		"Enter: Copy selected Thing to default Thing (Thing edit mode)\n"
		"    F: Flip line (Line edit mode)\n"
		"Alt-F: Flip line and sidedefs (Line edit mode)\n"
		"    B: Enter Blend mode (Sector edit mode)\n\n\n"
		"Mouse Buttons:\t\n"
		"Left - Move/Add     Mid - Edit     Right - Delete\t"
		"(Ins key)        (Spacebar)       (Del key)\t", 1);

	while (!mouse_check())
		if (keypress)
			break;

	return;
}

void clear_map1(void)
{
	window_text("New map\t\n"
		"This function will erase the current\n"
		"map and start you off with a blank\n"
		"map.  Are you sure this is what you\n"
		"want to do?\n\n", 1);

	set_window_bars();
	if (window_check() == -1)
		clear_map();
	return;
}

void clear_map(void)
{
	unmark_all();
	if (t_max)
		free_farmem(things, "Things");
	if (l_max)
		free_farmem(linedefs, "Linedefs");
	if (s_max)
		free_farmem(sidedefs, "Sidedefs");
	if (v_max)
		free_farmem(vertexes, "Vertexes");
	if (seg_max)
		free_farmem(segs, "Segments");
	if (ss_max)
		free_farmem(ssectors, "Sub Sectors");
	if (n_max)
		free_farmem(nodes, "Nodes");
	if (sec_max)
		free_farmem(sectors, "Sectors");
	if (r_size)
		free_farmem(reject, "Reject");
	if (b_size)
		free_farmem(blockmap, "Blockmap");

	t_size = l_size = s_size = v_size = seg_size = ss_size = n_size =
	sec_size = r_size = b_size = t_max = l_max = s_max = v_max = seg_max =
	ss_max = n_max = sec_max = max_vertex = 0;
	center_map();
}

int edit_branch(void)
{
	if (edit_mode == 0) return thing_edit();
	if (edit_mode == 1) return thing_drag();
	if (edit_mode == 2) return vertex_edit();
	if (edit_mode == 3) return vertex_drag();
	if (edit_mode == 4) return line_edit();
	if (edit_mode == 5) return line_drag1();
	if (edit_mode == 6) return line_drag2();
	if (edit_mode == 7 ||
		edit_mode == 8) return sector_edit();
	if (edit_mode == 100) return seg_test();
	if (edit_mode == 101) return node_test2();
	if (edit_mode == 102) return node_test();
	return getkey();
}

int map_keys(int key)
{
	int redraw=1, fix=0;

	switch (key)
	{
		case '+':
		case '=':
			if (scale > 0)
			{
				scale--;
				fix++;
			}
			break;
		case '-':
			if (scale < MAX_ZOOM)
			{
				scale++;
				fix++;
			}
			break;
		case 1072: /* up */
			yoffset += 100 * scalers[scale] / 2;
			break;
		case 1080: /* down */
			yoffset -= 100 * scalers[scale] / 2;
			break;
		case 1075: /* left */
			xoffset -= 100 * scalers[scale] / 2;
			break;
		case 1077: /* right */
			xoffset += 100 * scalers[scale] / 2;
			break;
		case 1071: /* up-left (Home) */
			yoffset += 100 * scalers[scale] / 2;
			xoffset -= 100 * scalers[scale] / 2;
			break;
		case 1073: /* up-right (PgUp) */
			yoffset += 100 * scalers[scale] / 2;
			xoffset += 100 * scalers[scale] / 2;
			break;
		case 1079: /* down-left (End) */
			yoffset -= 100 * scalers[scale] / 2;
			xoffset -= 100 * scalers[scale] / 2;
			break;
		case 1081: /* down-right (PgDn) */
			yoffset -= 100 * scalers[scale] / 2;
			xoffset += 100 * scalers[scale] / 2;
			break;
		case 'x':
			cross_on = !cross_on;
		default:
			redraw = 0;
	}

	if (fix)
	{
		if (things_on > 0)
			things_on = scale>2 ? 2 : 1;

		point_size = 4 - scale;
		if (point_size < 1)
			point_size = 1;

		points = 0;
		if (edit_mode >= 2 && edit_mode < 7)
			points = point_size;
	}
	return redraw;
}

void draw_vertex(int num, int color, int size)
{
	char image[125];
	int i, x, y;

	if (!size)
		size = 1;

	x = adjvx[num];
	y = adjvy[num];

	if (x < size ||
		 y < size ||
		 x > maxx - (size * 2) ||
		 y > maxy - (size * 2)) return;

	getimage(x-size, y-size, x+size, y+size, image);
	for (i=0; i<121; i++)
		if (point_ptr[size-1][i+4])
			image[i+4] = color;

	putimage(x-size, y-size, image, 0);
	return;
}

int re_x(void)
{
	int x;

	x = mouse_x;
	if (roundoff)
	{
		x += powers[roundoff-1];
		x &= xor_powers[roundoff];
	}
	return x;
}

int re_y(void)
{
	int y;

	y = mouse_y;
	if (roundoff)
	{
		y += powers[roundoff-1];
		y &= xor_powers[roundoff];
	}
	return y;
}

int add_vertex(void) /* add vertex for line use */
{
	int i, x, y;

	x = re_x();
	y = re_y();
	for (i=0; i<max_vertex; i++)
		if (x == vertexes[i].x && y == vertexes[i].y)
			return i;

	if (n_max)
		free_farmem(nodes, "Nodes");
	if (ss_max)
		free_farmem(ssectors, "Sub Sectors");
	if (seg_max)
		free_farmem(segs, "Segments");
	n_size = ss_size = seg_size = n_max = ss_max = seg_max = 0;

	if (max_vertex == v_max)
	{
		void far *ptr;

		if (v_max)
			ptr = resize_farmem(vertexes, (v_max+20) * sizeof(struct v_struct),
				"Vertexes");
		else
			ptr = get_farmem(20 * sizeof(struct v_struct), "Vertexes");

		if (!ptr)
			return -1;
		vertexes = ptr;
		v_max += 20;
	}

	vertexes[max_vertex].x = x;
	vertexes[max_vertex].y = y;

	x = adjustx(x);
	y = adjusty(y);
	if (x < 0) x = 0;
	if (y < 0) y = 0;
	if (x > maxx) x = maxx;
	if (y > maxy) y = maxy;

	adjvx[max_vertex] = x;
	adjvy[max_vertex] = y;
	v_size = max_vertex++;
	return v_size++;
}

void del_vertex(int num) /* delete vertex and reroute lines to it */
{
	int i, v, max, nearv, kill_line, linesto[50];
	double nearest, dist, dx, dy;

	if (n_max)
		free_farmem(nodes, "Nodes");
	if (ss_max)
		free_farmem(ssectors, "Sub Sectors");
	if (seg_max)
		free_farmem(segs, "Segments");
	n_size = ss_size = seg_size = n_max = ss_max = seg_max = 0;

	for (i=0, max=0; i<l_size; i++)
	{
		if (linedefs[i].v1 == num)
			linesto[max++] = i;
		if (linedefs[i].v2 == num)
			linesto[max++] = -i;
	}
	if (max)
	{
		nearest = 3.2e6; /* make it easily the farthest dist.. */
		for (i=0; i<max; i++)
		{
			if (linesto[i] > 0)
				v = linedefs[linesto[i]].v2;
			else
				v = linedefs[-linesto[i]].v1;
			dx = vertexes[num].x - vertexes[v].x;
			dy = vertexes[num].y - vertexes[v].y;
			dist = sqrt(dx * dx + dy * dy);
			if (dist < nearest)
			{
				nearest = dist;
				nearv = v;
			}
		}

		for (i=0; i<max; i++)
		{
			if (linesto[i] > 0)
			{
				if (linedefs[linesto[i]].v2 == nearv)
				{
					kill_line = linesto[i];
					continue;
				}
				linedefs[linesto[i]].v1 = nearv;
			} else {
				if (linedefs[-linesto[i]].v1 == nearv)
				{
					kill_line = -linesto[i];
					continue;
				}
				linedefs[-linesto[i]].v2 = nearv;
			}
		}
		del_line(kill_line);
	}

	for (i=num; i<v_size-1; i++)
		vertexes[i] = vertexes[i+1];

	for (i=0; i<l_size; i++)
	{
		if (linedefs[i].v1 > num)
			linedefs[i].v1--;
		if (linedefs[i].v2 > num)
			linedefs[i].v2--;
	}

	v_size = --max_vertex;
	return;
}

/* flip the line around if the only sidedef is on the wrong side */

void flip_line(int num)
{
	int temp, sd1, sd2, count1, count2;

	if ((sd2 = linedefs[num].sd2) != -1 && linedefs[num].sd1 == -1)
	{
		temp = linedefs[num].v1;
		linedefs[num].v1 = linedefs[num].v2;
		linedefs[num].v2 = temp;

		linedefs[num].sd1 = sd2;
		linedefs[num].sd2 = -1;
	}

	if ((sd1 = linedefs[num].sd1) != -1 && sd2 != -1)
	{
		count1 = count2 = 0;

		if (sidedefs[sd1].top[0] != '-')
			count1++;
		if (sidedefs[sd1].middle[0] != '-')
			count1++;
		if (sidedefs[sd1].bottom[0] != '-')
			count1++;

		if (sidedefs[sd2].top[0] != '-')
			count2++;
		if (sidedefs[sd2].middle[0] != '-')
			count2++;
		if (sidedefs[sd2].bottom[0] != '-')
			count2++;

		if (count2 > count1) /* seems right sidedef is the major one */
		{
			temp = linedefs[num].v1;
			linedefs[num].v1 = linedefs[num].v2;
			linedefs[num].v2 = temp;

			linedefs[num].sd1 = sd2;
			linedefs[num].sd2 = sd1;
		}
	}
	return;
}

int add_sidedef(int num)
{
	struct s_struct default_def = { 0, 0, "-", "-", "BROWN1", -1 };

	if (s_size == s_max)
	{
		void far *ptr;

		if (s_max)
			ptr = resize_farmem(sidedefs, (s_max+20) * sizeof(struct s_struct),
				"Sidedefs");
		else
			ptr = get_farmem(20 * sizeof(struct s_struct), "Sidedefs");

		if (!ptr)
			return -1;
		sidedefs = ptr;
		s_max += 20;
	}

	if (num == -1)
		sidedefs[s_size] = default_def;
	else
		sidedefs[s_size] = sidedefs[num];
	return s_size++;
}

int between(int x1, int x2, int x3) /* determine if x1 is between x2 & x3 */
{
	int temp;

	if (x2 > x3)
	{
		temp = x2;
		x2 = x3;
		x3 = temp;
	}
	return (x1 >= x2 && x1 <= x3);
}

void del_line(int num)
{
	int i, sd1, sd2, sec1, sec2;

	sd1 = linedefs[num].sd1;
	sd2 = linedefs[num].sd2;

	if (sd1 != -1 && sd2 != -1 && (sec1 = sidedefs[sd1].sector) != -1 &&
		(sec2 = sidedefs[sd2].sector) != -1 && sec1 != sec2)
	{ /* merge sectors */
		for (i=0; i<s_size; i++)
		{
			if (sidedefs[i].sector == sec1)
				sidedefs[i].sector = sec2;
			if (sidedefs[i].sector > sec1)
				sidedefs[i].sector--;
		}
		if (sec1 + 1 < sec_size)
			for (i=sec1; i<sec_size-1; i++)
				sectors[i] = sectors[i+1];
		sec_size--;
	}
	if (sd1 != -1)
		del_sidedef(sd1); /* this could make sd2 != sidedef2 */
	if (sd2 != -1)
		del_sidedef(linedefs[num].sd2); /* so do it this way */

	for (i=num; i<l_size-1; i++)
		linedefs[i] = linedefs[i+1];
	l_size--;
	return;
}

void del_sidedef(int num)
{
	int i;

	for (i=num; i<s_size-1; i++)
		sidedefs[i] = sidedefs[i+1];
	s_size--;
	for (i=0; i<l_size; i++)
	{
		if (linedefs[i].sd1 == num)
			linedefs[i].sd1 = -1;
		if (linedefs[i].sd2 == num)
			linedefs[i].sd2 = -1;
		if (linedefs[i].sd1 > num) /* fix linedef pointers */
			linedefs[i].sd1--;
		if (linedefs[i].sd2 > num)
			linedefs[i].sd2--;
	}
	return;
}

int draw_time_graph(int y)
{
	int x;

	x = (win.right + win.left) / 2 - 50;
	rectangle(x-1, y-1, x+101, y+8);
	return x;
}

void time_graph(ulong num, ulong max, int x, int y)
{
	int i, j, xx, yy, percent;

	percent = num * 100 / max;
	xx = x + percent + 1;
	yy = y + 8;

	if (percent)
		for (i=x; i<xx; i++)
			for (j=y; j<yy; j++)
				putpixel(i, j, 96);
	return;
}

void reset_time_graph(ulong num, ulong max, int x, int y)
{
	int i, j, xx, yy, percent;

	percent = num * 100 / max;
	xx = x + percent + 1;
	yy = y + 8;

	if (percent)
		for (i=x; i<xx; i++)
			for (j=y; j<yy; j++)
				putpixel(i, j, 252);
	return;
}

void change_maps(int mode)
{
	char maps[27];
	int i, button, btn=0, temp, count;

	struct
	{
		long ptr;
		long len;
		char fname[8];
	} dir;

	button = (episode - 1) * 9 + (mission - 1);
	for (i=0; i<27; i++)
		maps[i] = -1;

	open_wad(iwad, "rb");
	for (i=0; i<dir_size; i++)
	{
		if (!fread(&dir, sizeof(dir), 1, fp))
			dir_error();
		if (dir.len)
			continue;
		if (dir.fname[0] != 'E')
			continue;
		if (dir.fname[2] != 'M')
			continue;
		if (dir.fname[4])
			continue; /* at this point, we know it's a map header */
		temp = (dir.fname[1] - '1') * 9 + (dir.fname[3] - '1');
		if (temp > 26)
			dir_error(); /* just in case, cause you never know */
		maps[temp] = -2;
	}
	fclose(fp);

	if (editing_pwad)
	{
		if (open_wad(pwad, "rb"))
		{
			error("Can't open \"%s\"", pwad);
			editing_pwad = 0;
			return;
		}

		for (i=0; i<dir_size; i++)
		{
			if (!fread(&dir, sizeof(dir), 1, fp))
				dir_error();
			if (dir.len)
				continue;
			if (dir.fname[0] != 'E')
				continue;
			if (dir.fname[2] != 'M')
				continue;
			if (dir.fname[4])
				continue; /* at this point, we know it's a map header */
			temp = (dir.fname[1] - '1') * 9 + (dir.fname[3] - '1');
			if (temp > 26)
				dir_error(); /* just in case, cause you never know */
			maps[temp] = 0;
		}
		fclose(fp);
	} else
		for (i=0; i<27; i++)
			if (maps[i] == -2)
				maps[i] = 0;

	if (mode == 1)
	{
		for (i=count=0; i<27; i++)
			if (!maps[i])
				if (!count++)
					button = i;
		if (count == 1)
			goto rtn;
	}

	window_text1("Mission\t\n"
		"E    1 2 3 4 5 6 7 8 9   \n"
		"p\n"
		"i  1 @ @ @ @ @ @ @ @ @\n"
		"s\n"
		"o  2 @ @ @ @ @ @ @ @ @\n"
		"d\n"
		"e  3 @ @ @ @ @ @ @ @ @\n\n"
		"[Load]\t\n", 1, 0, 0);

	for (i=0; i<27; i++)
		b.pos[i].status = maps[i];
	draw_buttons();
	set_window_bars();

	if (maps[button] != -1)
		b.pos[button].on = 1;
	while ((btn = window_check()) > -1)
	{
		b.pos[button].on = 0;
		b.pos[btn].on = 1;
		button = btn;
	}

rtn:
	if (btn == -99)
		return;

	episode = button / 9 + 1;
	mission = button % 9 + 1;
	if (btn == -1)
		return;

	load_wad_map(0);
	center_map();
	return;
}

void mouse_on(void)
{
	char msg[30];
	int x, y, i, z;

	setviewport(0, 0, maxx, maxy, 1);
	getimage(mousex-1, mousey-1, mousex+8, mousey+14, mouse_save);
	putimage(mousex-1, mousey-1, shapes, 2); /* mouse mask */
	putimage(mousex-1, mousey-1, shapes+shp_offsets[2+true_button], 3);

	x = re_x();
	y = re_y();
	crossx = adjustx(x) - 2;
	crossy = adjusty(y) - 2;

	cross_draw = 0;
	if (cross_on && crossx >= 0 && crossy >= 0 && crossx < maxx-3 &&
		crossy < maxy-3)
	{
		cross_draw++;
		getimage(crossx, crossy, crossx+4, crossy+4, cross_save);
		for (i=0; i<29; i++)
		{
			z = crosshare[i];
			if (!z)
				z = cross_save[i];
			msg[i] = z;
		}
		putimage(crossx, crossy, msg, 0);
	}

	sprintf(msg, "(%d,%d)          ", x, y);
	msg[15] = 0;
	text(0, -1, msg);
	mouse = 1;
	return;
}

void mouse_redraw(void)
{
	if (!mouse)
		mouse_on();
	else {
		setviewport(0, 0, maxx, maxy, 1);
		putimage(mousex-1, mousey-1, shapes, 2); /* mouse mask */
		putimage(mousex-1, mousey-1, shapes+shp_offsets[2+true_button], 3);
	}
	return;
}

void mouse_off(void)
{
	if (cross_draw)
		putimage(crossx, crossy, cross_save, 0);
	putimage(mousex-1, mousey-1, mouse_save, 0);
	mouse = 0;
	return;
}

int mouse_check(void)
{
	int newx, newy;
	union REGS regs;

	if (!mouse)
		mouse_on();
	regs.x.ax = 11; /* read motion counters */
	int86(0x33, &regs, &regs);
	newx = mousex + regs.x.cx;
	newy = mousey + regs.x.dx;

	if (newx < 1) newx = 1;
	if (newy < 1) newy = 1;
	if (newx > mouse_maxx) newx = mouse_maxx;
	if (newy > mouse_maxy) newy = mouse_maxy;
	if (newx != mousex || newy != mousey)
	{
		mouse_off();
		mousex = newx;
		mousey = newy;
		mouse_on();
	}

	regs.x.ax = 5; /* read button status */
	regs.x.bx = 1;
	int86(0x33, &regs, &regs);
	if (regs.x.ax != true_button)
	{
		true_button = regs.x.ax;
		mouse_off();
		mouse_on(); /* redraw with button indication */
	}

	if (ignore_button)
	{
		if (ignore_button & true_button)
			true_button &= ~ignore_button;
		else
			ignore_button = 0;
	}

	button_status = 0;
	if (true_button & 0x1)
		button_status = left_button;
	if (true_button & 0x2)
		button_status |= right_button;
	if (true_button & 0x4)
		button_status |= middle_button;

	if (button_status)
		button_lock = 0;

	keypress = 0;
	if (kbhit())
	{
		keypress = getkey();
		if (button_lock)
			button_lock = keypress = 0; /* turn off lock */

		switch (keypress)
		{
			case 1082: /* insert key */
				button_status |= 0x1; /* same as left mouse button */
				keypress = 0;
				break;
			case 1162: /* alt-insert */
				button_lock = 0x1;
				keypress = 0;
				break;
			case 1083: /* delete key */
				button_status |= 0x2; /* same as right mouse button */
				keypress = 0;
				break;
			case ' ': /* space bar, of course */
				button_status |= 0x4; /* same as middle mouse button */
				keypress = 0;
				break;
			case 'm':
			case 'M':
				button_status |= 0x8;
				keypress = 0;
				break;
			case 1050:
				button_lock = 0x8;
				keypress = 0;
				break;
		}
	}
	button_status |= button_lock;
	return button_status;
}

void reconfig_mouse(void)
{
	int button, new_button, *swap, *newb, temp, lb, rb, mb;
	int btn[] = { 1, 4, 2, 8 };

	lb = left_button;
	rb = right_button;
	mb = middle_button;

	window_text("Mouse Reconfig\t\n"
		"      @ Add\n"
		"      @ Edit\n"
		"      @ Delete\n"
		"      @ Mark\n\n", 1);

	set_window_bars();

relist:
	print_button(lb, "Left");
	print_button(rb, "Right");
	print_button(mb, "Mid");

	if ((button = window_check()) < 0)
	{
		if (button == -1)
		{
			left_button = lb;
			right_button = rb;
			middle_button = mb;
		}
		return;
	}

	print_button(lb, "");
	print_button(rb, "");
	print_button(mb, "");

	new_button = btn[button];

	if (true_button == 1)
		newb = &lb;
	else if (true_button == 2)
		newb = &rb;
	else if (true_button == 4)
		newb = &mb;
	else goto relist;

	swap = &new_button;
	if (lb == new_button)
		swap = &lb;
	if (rb == new_button)
		swap = &rb;
	if (mb == new_button)
		swap = &mb;

	temp = *swap;
	*swap = *newb;
	*newb = temp;
	goto relist;
}

void print_button(int button, char *name)
{
	int y=0;

	if (button & 0x1)
		y = 24;
	if (button & 0x2)
		y = 44;
	if (button & 0x4)
		y = 34;
	if (button & 0x8)
		y = 54;

	erase_text(win.left + 4, win.top + y, 5);
	outtextxy(win.left + 4, win.top + y, name);
	return;
}

void adjust_limit(int x, int y, int *xmin, int *ymin, int *xmax, int *ymax)
{
	if (x < *xmin)
		*xmin = x;
	if (x > *xmax)
		*xmax = x;
	if (y < *ymin)
		*ymin = y;
	if (y > *ymax)
		*ymax = y;
	return;
}

int rand_color(void)
{
	int color;

	color_num++;
	if (flash_mode)
		switch (color_num %= 6)
		{
			case 0:
				color = 160;
				break;
			case 1:
			case 5:
				color = 158;
				break;
			case 2:
			case 4:
				color = 156;
				break;
			case 3:
				color = 154;
		}
	else
		switch (color_num &= 3)
		{
			case 0:
				color = 255;
				break;
			case 1:
				color = 96;
				break;
			case 2:
				color = 80;
				break;
			case 3:
				color = 32;
		}
	setcolor(color);
	return color;
}

int stagger_color(void)
{
	int color;

	if (flash_mode)
		switch (color_num)
		{
			case 3:
				color = 160;
				break;
			case 2:
			case 4:
				color = 158;
				break;
			case 1:
			case 5:
				color = 156;
				break;
			case 0:
				color = 154;
		}
	else
		switch (color_num)
		{
			case 3:
				color = 255;
				break;
			case 2:
				color = 96;
				break;
			case 1:
				color = 80;
				break;
			case 0:
				color = 32;
		}
	setcolor(color);
	return color;
}

int wall_color(int num) /* return wall color for linedef <num> */
{
	int color, count, type, sec1, sec2;

	if (!color_scheme)
	{
		color = 253;
		count = 0;
		if (linedefs[num].sd1 != -1)
			count++;
		if (linedefs[num].sd2 != -1)
			count++;
		if (count == 1)
			color = 254;

		if (linedefs[num].attrib & 1)
			color = 255;
		if (type = linedefs[num].type)
			color = linedefs[num].type % 125 + 1;
		if (type == 26 || type == 32) /* blue door */
			color = 32;
		if (type == 27 || type == 33) /* yellow door */
			color = 80;
		if (type == 28 || type == 34) /* red door */
			color = 96;
		if (color == 253 && count == 2)
		{
			sec1 = sidedefs[linedefs[num].sd1].sector;
			sec2 = sidedefs[linedefs[num].sd2].sector;
			if (sectors[sec1].floor != sectors[sec2].floor)
				color = 191;
			if (sectors[sec1].ceiling != sectors[sec2].ceiling)
				color = 83;
		}
		if (!count)
			color = 120;

	} else if (color_scheme == 1) {

	} else if (color_scheme == 2) {
		if (linedefs[num].sd1 == -1 || linedefs[num].sd2 == -1)
			color = 83;
		else {
			count = abs(sectors[sidedefs[linedefs[num].sd1].sector].floor -
				sectors[sidedefs[linedefs[num].sd2].sector].floor);
			if (count < 25)
				color = 252;
			else if (count < 65)
				color = 253;
			else if (count < 257)
				color = 254;
			else color = 255;
		}
	}

	setcolor(color);
	return color;
}

void draw_map(void)
{
	char msg[30];
	int i, num, x, y, min, max, bits, pmaxx, pmaxy;

	int gridsize[] = { 0xfff0, 0xffe0, 0xffc0, 0xff80, 0xff00, 0xfe00 };

	for (i=0; i<max_vertex; i++)
	{
		adjvx[i] = adjustx(vertexes[i].x);
		adjvy[i] = adjusty(vertexes[i].y);
	}

	cleardevice();

	if (grid)
	{
		setcolor(grid);
		if (testmode) /* draw blockmap blocks in this case */
		{
			if ((min = adjusty(blockmap->yorigin + blockmap->ysize * 128)) < 0)
				min = 0;
			if ((max = adjusty(blockmap->yorigin)) > maxy)
				max = maxy;
			for (x=0; x<=blockmap->xsize; x++)
			{
				i = adjustx(blockmap->xorigin + x * 128);
				line(i, min, i, max);
			}
			if ((min = adjustx(blockmap->xorigin)) < 0)
				min = 0;
			if ((max = adjustx(blockmap->xorigin + blockmap->xsize*128)) > maxx)
				max = maxx;
			for (y=0; y<=blockmap->ysize; y++)
			{
				i = adjusty(blockmap->yorigin + y * 128);
				line(min, i, max, i);
			}
		} else if (roundoff) {
			i = 1;
			while ((num = ((powers[roundoff] * i / scalers[scale]) << 1)) < 8)
				i *= 2;

			x = xoffset - ((midx * scalers[scale]) >> 1) & xor_powers[roundoff];
			x = adjustx(x);
			while (x <= maxx)
			{
				line(x, 0, x, maxy);
				x += num;
			}

			y = yoffset + ((midy * scalers[scale]) >> 1) & xor_powers[roundoff];
			y = adjusty(y);
			while (y <= maxy)
			{
				line(0, y, maxx, y);
				y += num;
			}
		}
	}

	if (points)
	{
		pmaxx = maxx - points * 2;
		pmaxy = maxy - points * 2;
		for (i=0; i<max_vertex; i++)
			draw_point(adjvx[i], adjvy[i], pmaxx, pmaxy);
	}

	free_mem(lthing_num, "lthing_num");
	free_mem(lthingx, "lthingx");
	free_mem(lthingy, "lthingy");
	free_mem(lthing_offsets, "lthing_offsets");
	lthing_count = 0;

	if (t_size && things_on)
	{
		char *bitfield, *buffer;
		char bitmask[] = { 0x1, 0x2, 0x4, 0x8, 0x10, 0x20, 0x40, 0x80 };
		int count=0, size;

		size = (t_size + 7) >> 3;
		bitfield = get_mem(size, "bitfield");
		for (i=0; i<size; i++)
			bitfield[i] = 0;

		for (i=0; i<t_size; i++)
		{
			bits = things[i].flags;
			if ((bits & flags_mask) &&
				((bits & flags_mask2) == (flags_mask & flags_mask2)))
			{
				bitfield[i >> 3] |= bitmask[i & 7];
				count++;
			}
		}

		count++; /* space for one added thing */
		count *= 2; /* make it reflect # of bytes instead of # of ints */
		lthing_num = get_mem(count, "lthing_num");
		lthingx = get_mem(count, "lthingx");
		lthingy = get_mem(count, "lthingy");
		lthing_offsets = get_mem(count, "lthing_offsets");

		if (count != 1)
		{
			buffer = get_mem(4096, "thing image buffer");
			setcolor(254);
			for (i=0; i<t_size; i++)
			{
				if (bitfield[i >> 3] & bitmask[i & 7])
				{
					lthing_num[lthing_count] = i;
					if ((num = draw_thing(x = adjustx(things[i].x),
						y = adjusty(things[i].y), things[i].type,
						things[i].angle, buffer)) != -1)
					{
						lthingx[lthing_count] = x;
						lthingy[lthing_count] = y;
						lthing_offsets[lthing_count++] = num;
					}
				}
			}
			free_mem(buffer, "thing image buffer");
		}
		free_mem(bitfield, "bitfield");

	} else {
		lthing_num = get_mem(2, "lthing_num");
		lthingx = get_mem(2, "lthingx");
		lthingy = get_mem(2, "lthingy");
		lthing_offsets = get_mem(2, "lthing_offsets");
	}

	ll_size = 0;
	setlinestyle(SOLID_LINE, 0, line_size);
	for (i=0; i<l_size; i++)
		if (line_visible(i))
		{
			llines[ll_size++] = i;
			wall_color(i);
			line(win.left, win.top, win.right, win.bottom);
		}

	strcpy(msg, "Mode: ");
	switch (edit_mode)
	{
		case 0:
		case 1:
			strcat(msg, "Thing");
			break;
		case 2:
		case 3:
			strcat(msg, "Vertex edit");
			break;
		case 4:
		case 5:
		case 6:
			strcat(msg, "Line edit");
			break;
		case 7:
			strcat(msg, "Sector edit");
			break;
		case 8:
			strcat(msg, "Sector blend/copy");
		default:
			*msg = 0;
	}
	text_color = 254;
	if (*msg)
	{
		text(0, -11, msg);
	}

	if (editing_pwad)
	{
		sprintf(msg, "Pwad: %s", pwad);
		i = 0;
		while (msg[i] != '.') /* strip off the extention */
			i++;
		msg[i] = 0;
		text(-1, -11, msg);
	}
	text_color = 255;

	setcolor(255);
	sprintf(msg, "Map: E%dM%d", episode, mission);
	text(-1, -1, msg);
	print_roundoff();
	mouse = cur_box_color = old_mark_color = 0;
	return;
}

void print_roundoff(void)
{
	char msg[15];
	int i;

	i = 1;
	if (roundoff)
		i = powers[roundoff];
	sprintf(msg, "Roundoff: %-2d", i);
	text(maxx / 3 - 48, -1, msg);
	return;
}

void draw_line(int number, int style) /* draw linedef <number> */
{
	struct linesettingstype lineinfo;

	if (line_visible(number))
	{
		getlinesettings(&lineinfo);
		setlinestyle(style, 0, line_size);
		line(win.left, win.top, win.right, win.bottom);
		setlinestyle(lineinfo.linestyle, 0, lineinfo.thickness);
	}
	return;
}

void draw_line2(int x1, int y1, int x2, int y2)
{
	if (line_in_rect(x1, y1, x2, y2, 0, 0, maxx, maxy))
		line(win.left, win.top, win.right, win.bottom);
	return;
}

void draw_box(int xx1, int yy1, int xx2, int yy2)
{
	int x1, y1, x2, y2;

	x1 = adjustx(xx1);
	x2 = adjustx(xx2);
	y1 = adjusty(yy1);
	y2 = adjusty(yy2);

	draw_line2(x1, y1, x2, y1);
	draw_line2(x1, y1, x1, y2);
	draw_line2(x1, y2, x2, y2);
	draw_line2(x2, y1, x2, y2);
	return;
}

void draw_point(int xpos, int ypos, int pmaxx, int pmaxy)
{
	if (xpos < point_size ||
		 ypos < point_size ||
		 xpos > pmaxx ||
		 ypos > pmaxy) return;

	putimage(xpos-point_size, ypos-point_size, point_ptr[point_size-1], 3);
	return;
}

int draw_thing(int xpos, int ypos, int type, int angle, char *buffer)
{
	char far *shape, *ptr1, far *ptr2;
	int i, end, shape_no, x, y, z;
	int xsize, ysize; /* size of shape */
	int xhalf, yhalf; /* size of half the shape */

	shape_no = 0;
	for (i=0; i<thing_max; i++)
	{
		if (thing_types[i] == type)
		{
			shape_no = thing_shapes[i];
			break;
		}
	}

	if (things_on == -1)
	{
		z = (thing_rad[i] / scalers[scale]) << 1;
		if (xpos < z || ypos < z || xpos+z > maxx || ypos+z > maxy)
			return -1;

		circle(xpos, ypos, z);
		return z;
	}

	if (shape_no > 9 && shape_no < 170) /* monster shape */
		shape_no += (angle + 22) / 45 * 2 % 16; /* angle pictures */

	if (things_on == 2) /* small icons */
		shape_no++;

	if (shape_no >= no_shapes)
		fatal_error("shape # out of bounds");

	shape = shapes + shp_offsets[shape_no]; /* point to the shape */
	xsize = *shape;
	ysize = *(shape+2);
	xhalf = xsize / 2;
	yhalf = ysize / 2;
	xpos -= xhalf;
	ypos -= yhalf;

	if (xpos < 0 ||
		 ypos < 0 ||
		 xpos+xsize > maxx ||
		 ypos+ysize > maxy) return -1; /* off screen, don't draw */

	getimage(xpos, ypos, xpos+xsize, ypos+ysize, buffer);
	ptr1 = buffer+4;
	ptr2 = shape+4;
	end = (xsize + 1) * (ysize + 1);

	for (i=0; i<end; i++)
	{
		if (z = *ptr2++)
			*ptr1++ = z;
		else
			ptr1++;
	}
	putimage(xpos, ypos, buffer, 0);
	return shp_offsets[shape_no];
}

void center_map(void) /* center the map on the screen */
{
	int i, xmax=0, ymax=0, xmin=0, ymin=0, xx, yy;

	if (v_size)
	{
		xmax = xmin = vertexes[0].x;
		ymax = ymin = vertexes[0].y;
		for (i=1; i<v_size; i++)
		{
			xx = vertexes[i].x;
			yy = vertexes[i].y;
			if (xx > xmax) xmax = xx;
			if (xx < xmin) xmin = xx;
			if (yy > ymax) ymax = yy;
			if (yy < ymin) ymin = yy;
		}
	}
	xoffset = (xmin + xmax) / 2;
	yoffset = (ymin + ymax) / 2;

	max_vertex = 0;
	for (i=0; i<l_size; i++)
	{
		xx = linedefs[i].v1;
		if (xx >= max_vertex && xx < v_size)
			max_vertex = xx + 1;
		xx = linedefs[i].v2;
		if (xx >= max_vertex && xx < v_size)
			max_vertex = xx + 1;
	}
	return;
}

void text(int xx, int yy, char *msg)
{
	int x1, y1, x2, y2;

	if (xx < 0)
		xx += maxx - textwidth(msg) + 1;
	if (yy < 0)
		yy += maxy - textheight(msg) + 1;
	x1 = 1;
	y1 = 1;
	x2 = xx + textwidth(msg);
	y2 = yy + textheight(msg);

	if (xx == 0)
		x1 = 0;
	if (yy == 0)
		y1 = 0;
	if (x2 > maxx)
		x2 = maxx;
	if (y2 > maxy)
		y2 = maxy;

	setviewport(xx - x1, yy - y1, x2, y2, 1);
	clearviewport();
	setcolor(text_color);
	outtextxy(x1, y1, msg);
	setviewport(0, 0, maxx, maxy, 1);
	return;
}

void toptext(char *msg)
{
	int m;

	if (m = mouse)
		mouse_off();
	setviewport(0, 0, maxx, textheight(msg)+1, 1);
	clearviewport();
	setcolor(255);
	outtextxy(1, 1, msg);
	setviewport(0, 0, maxx, maxy, 1);
	if (mouse)
		mouse_on();
	return;
}

void toptext2(char *msg, char *msg2)
{
	setviewport(0, 0, maxx, textheight(msg)+textheight(msg2)+2, 1);
	clearviewport();
	setcolor(255);
	outtextxy(1, 1, msg);
	setcolor(128);
	outtextxy(1, textheight(msg)+2, msg2);
	setviewport(0, 0, maxx, maxy, 1);
	return;
}

void window_text1(char far *msg, int center, int xplus, int yplus)
{
	int i, len, lines, max_len;

	if (!graph_on) /* if graphics not on yet, ignore messages */
		return;

	max_len = 0; /* setup */
	lines = 0;

	for (i=0, len=0; i<strlen(msg); i++) /* calc texts dimensions */
	{
		if (msg[i] == '\t' || msg[i] == '\n')
		{
			if (len > max_len)
				max_len = len;
			len = 0;
			lines++;
			continue;
		}
		len++;
	}

	set_window1(max_len * 8 + xplus, lines * 10 + yplus, center);
	text_to_window(0, 0, msg, max_len);
	return;
}

void window_text(char far *msg, int center)
{
	if (!graph_on) /* if graphics not on yet, ignore messages */
		return;

	window_text1(msg, center, 0, 0);
	draw_buttons();
	return;
}

void text_to_window(int column, int row, char huge *msg, int max_len)
{
	char textline[81];
	int i, index, len, xoffset;
	int last_num, last_bigb, half_space;

	index = 0;
	while (msg[index])
	{
		len = 0;
		last_num = b.num;
		last_bigb = bigb.num;
		half_space = 0;
		while (msg[index] != '\t' && msg[index] != '\n')
		{
			if (msg[index] == '@')
			{
				b.pos[b.num].x = win.left + 7 + len*8;
				b.pos[b.num].y = win.top + row*10 + 7;
				b.pos[b.num].on = 0;
				b.num++;
				textline[len++] = ' ';
				index++;
				continue;
			}

			if (msg[index] == '|')
			{
				half_space = 1;
				index++;
				continue;
			}

			if (msg[index] == '^')
			{
				setcolor(128);
				index++;
				continue;
			}

			if (msg[index] == '[')
			{
				bigb.pos[bigb.num].x1 = win.left + len*8 + 6;
				index++;
				continue;
			}

			if (msg[index] == ']')
			{
				bigb.pos[bigb.num].x2 = win.left + len*8;
				bigb.pos[bigb.num++].y = win.top + row*10 + 7;
				index++;
				continue;
			}
			textline[len++] = msg[index++];
		}
		textline[len] = 0;
		xoffset = column * 8 + half_space * 4;
		if (msg[index] == '\t')
			xoffset += (max_len - len) * 4;
		for (i=last_num; i<b.num; i++)
			b.pos[i].x += xoffset;
		outtextxy(xoffset + 4, row*10 + 4, textline);
		setcolor(255);
		for (i=last_bigb; i<bigb.num; i++)
		{
			bigb.pos[i].x1 += xoffset; /* centering compensation */
			bigb.pos[i].x2 += xoffset;
		}
		row++;
		index++;
	}
	return;
}

void draw_buttons(void)
{
	int i, x1, x2, y;

	setviewport(0, 0, maxx, maxy, 1);
	for (i=0; i<b.num; i++)
	{
		setcolor(255);
		if (b.pos[i].status)
			setcolor(128);
		circle(b.pos[i].x, b.pos[i].y, 4);
	}

	setcolor(255);
	for (i=0; i<bigb.num; i++)
	{
		x1 = bigb.pos[i].x1;
		x2 = bigb.pos[i].x2;
		y = bigb.pos[i].y;

		line(x1 - 4, y - 6, x2 + 4, y - 6);
		line(x1 - 4, y + 6, x2 + 4, y + 6);
		line(x1 - 6, y - 4, x1 - 6, y + 4);
		line(x1 - 5, y - 4, x1 - 5, y + 4);
		line(x2 + 5, y - 4, x2 + 5, y + 4);
		line(x2 + 6, y - 4, x2 + 6, y + 4);
		line(x1 - 5, y - 5, x1 - 4, y - 5);
		line(x2 + 4, y - 5, x2 + 5, y - 5);
		line(x1 - 5, y + 5, x1 - 4, y + 5);
		line(x2 + 4, y + 5, x2 + 5, y + 5);
	}
	return;
}

void set_window(int columns, int rows, int center)
{
	set_window1(columns*8, rows*10, center);
	return;
}

void set_window1(int xsize, int ysize, int center)
{
	int x1, x2, y1, y2;

	b.num = bigb.num = win.bars = 0;

	y1 = midy - ysize/2 - 2;
	y2 = y1 + ysize + 4;
	switch (center)
	{
		case 1:
			x1 = midx - xsize/2 - 4;
			x2 = x1 + xsize + 5;
			break;

		case 0:
			x2 = maxx-4;
			x1 = x2 - xsize - 5;
			break;

		case 2:
			x1 = midx/2 - xsize/2 - 4;
			x2 = x1 + xsize + 5;
	}

	if (x1 < 4)
		x1 = 4;
	if (y1 < 4)
		y1 = 4;
	if (x2 > maxx-4)
		x2 = maxx-4;
	if (y2 > maxy-4)
		y2 = maxy-4;
	win.left = x1;
	win.right = x2;
	win.top = y1;
	win.bottom = y2;

	setcolor(80);
	line(x1-4, y1-4, x2+4, y1-4);
	line(x1-4, y1-4, x1-4, y2+4);
	line(x1-3, y1-3, x2+3, y1-3);
	line(x1-3, y1-3, x1-3, y2+3);
	setcolor(82);
	line(x1-2, y1-2, x2+2, y1-2);
	line(x1-2, y1-2, x1-2, y2+2);
	line(x2+1, y1, x2+1, y2+1);
	line(x1, y2+1, x2+1, y2+1);
	line(x2+2, y1-1, x2+2, y2+2);
	line(x1-1, y2+2, x2+2, y2+2);
	setcolor(84);
	line(x1-1, y1-1, x2+1, y1-1);
	line(x1-1, y1-1, x1-1, y2+1);
	line(x2+3, y1-2, x2+3, y2+3);
	line(x1-2, y2+3, x2+3, y2+3);
	setcolor(86);
	line(x2+4, y1-3, x2+4, y2+4);
	line(x1-3, y2+4, x2+4, y2+4);

	setviewport(x1, y1, x2, y2, 1);
	clearviewport();
	setcolor(255);
	return;
}

void set_window_bars(void)
{
	win.okbar = win.left + (win.right  - win.left) / 4 - 24;
	win.canbar = win.left + (win.right - win.left) * 3 / 4 - 24;

	putimage(win.okbar, win.bottom-4, shapes+shp_offsets[292], 0);
	putimage(win.canbar, win.bottom-4, shapes+shp_offsets[293], 0);

	win.bars = 1;
	return;
}

void set_cancel_bar(void)
{
	win.canbar = win.left + (win.right - win.left) * 3 / 4 - 24;
	putimage(win.canbar, win.bottom-4, shapes+shp_offsets[293], 0);
	win.bars = 2;
	return;
}

void set_button_statuses(int num)
{
	int i;

	for (i=0; i<30; i++)
		b.pos[i].status = num;
	return;
}

int window_check(void)
{
	int i, color, cross_status;

	for (i=0; i<b.num; i++)
	{
		color = 0;
		if (b.pos[i].on)
			color = 254;
		draw_cursor(b.pos[i].x-2, b.pos[i].y-2, color);
	}
	cross_status = cross_on;
	cross_on = 0;
	mouse_on();
	while (mouse_check());
	while (1)
	{
		while (!mouse_check())
		{
			if (keypress == 27 || keypress == 13)
			{
				mouse_off();
				cross_on = cross_status;
				if (keypress == 13)
				{
					if (win.bars != 1)
						return -2;
					return -1;
				}
				return -99;
			}

			if (keypress == '\t')
				next_button();
		}

		if (true_button)
			button_status = true_button;

		if (win.bars == 1 &&
			mousex < win.okbar + 22 &&
			mousex > win.okbar + 2 &&
			mousey < win.bottom + 9 &&
			mousey > win.bottom - 2)
		{
			mouse_off();
			cross_on = cross_status;
			return -1;
		}

		if (win.bars &&
			mousex < win.canbar + 47 &&
			mousex > win.canbar + 2 &&
			mousey < win.bottom + 9 &&
			mousey > win.bottom - 2)
		{
			mouse_off();
			cross_on = cross_status;
			return -99;
		}

		for (i=0; i<b.num; i++)
			if ((abs(mousex - b.pos[i].x) + abs(mousey - b.pos[i].y)) < 5)
				if (b.pos[i].status != -1)
				{
					mouse_off();
					cross_on = cross_status;
					return i;
				}

		for (i=0; i<bigb.num; i++)
			if (line_dist(bigb.pos[i].x1, bigb.pos[i].y,
				bigb.pos[i].x2, bigb.pos[i].y) < 7)
			{
				mouse_off();
				cross_on = cross_status;
				return -2 - i;
			}
	}
}

void next_button(void)
{
	int i, num, dist, min_dist=999;

	for (i=0; i<b.num; i++)
	{
		dist = abs(mousex - b.pos[i].x) + abs(mousey - b.pos[i].y);
		if (dist < min_dist && b.pos[i].status != -1)
		{
			min_dist = dist;
			num = i;
		}
	}

	if (min_dist < 5)
	{
		num++;
		goto next;
	}

	for (i=0; i<bigb.num; i++)
	{
		dist =line_dist(bigb.pos[i].x1, bigb.pos[i].y,
			bigb.pos[i].x2, bigb.pos[i].y);
		if (dist < min_dist)
		{
			min_dist = dist;
			num = -2 - i;
		}
	}

	if (min_dist < 7)
	{
		num--;
		goto next;
	}

	if (win.bars == 1)
	{
		dist = line_dist(win.okbar+4, win.bottom+3, win.okbar+19,
			win.bottom+3);
		if (dist < min_dist)
		{
			min_dist = dist;
			num = -1;
			if (min_dist < 7)
			{
				num = -99;
				goto next;
			}
		}
	}

	if (win.bars)
	{
		dist = line_dist(win.canbar+4, win.bottom+3, win.canbar+44,
			win.bottom+3);
		if (dist < min_dist)
		{
			num = -99;
			if (dist < 7)
			{
				num = 0;
				goto next;
			}
		}
	}
	goto set;

next:
	if (num == b.num)
		num = -2;

	if ((-num - 2) == bigb.num)
		num = -1;

	if (num == -1 && win.bars != 1)
		num = -99;

	if (num == -99 && !win.bars)
	{
		num = 0;
		goto next;
	}

set:
	mouse_off();
	if (num > -1)
	{
		mousex = b.pos[num].x;
		mousey = b.pos[num].y;

	} else if (num == -1) {
		mousex = win.okbar + 12;
		mousey = win.bottom + 3;

	} else if (num == -99) {
		mousex = win.canbar + 24;
		mousey = win.bottom + 3;

	} else {
		num = -num - 2;
		mousex = (bigb.pos[num].x1 + bigb.pos[num].x2) / 2;
		mousey = bigb.pos[num].y;
	}
	mouse_on();
	return;
}

void await_release(void) /* wait until mouse buttons released */
{
	mouse_check();
	ignore_button = true_button;
	mouse_off();
	return;
}

void await_release_on(void)
{
	mouse_check();
	ignore_button = true_button;
	return;
}

void draw_cursor(int x, int y, int color)
{
	char image[125];
	int i;

	for (i=0; i<4; i++)
		image[i] = point_ptr[1][i];
	for (i=0; i<121; i++)
		image[i+4] = point_ptr[1][i+4] & color;
	putimage(x, y, image, 0);
	return;
}

void fatal_error(char *msg, ...) /* terminate with error */
{
	va_list args;

	if (attempt_save)
	{
		fprintf(stderr, "Failed.\n");
		exit(1);
	}

	closegraph();
	open_prog_file("error.log", "a");
	va_start(args, msg);

	fprintf(fp, "--------------------\n");
	fprintf(stderr, "Fatal error: ");
	fprintf(fp, "Fatal error: ");
	vfprintf(stderr, msg, args);
	vfprintf(fp, msg, args);
	fprintf(stderr, "\n");
	fprintf(fp, "\n");

	va_end(args);
	attempt_save = 1;
	fprintf(stderr, "Attempting to save map to 'exit.wad'...");
	strcpy(pwad, "exit");
	save_wad_map(0);
	fprintf(stderr, "successful.\n");
	exit(1);
}

void error(char *errmsg, ...)
{
	char msg[4096] = "Error!\t\n";
	va_list args;

	if (!graph_on)
		fatal_error(errmsg);

	va_start(args, errmsg);
	vsprintf(msg + 8, errmsg, args);
	va_end(args);

	strcat(msg, "\n");
	window_text(msg, 1);
	await_release();

	while (!mouse_check())
		if (keypress)
			break;

	await_release();
	return;
}

void farmem_error(char *msg, ulong size)
{
	char errmsg[200];

	sprintf(errmsg, "Out of far memory\t"
		"Couldn't allocate space for the %s\t"
		"Needed %lu bytes and only had %lu", msg, size, farcoreleft());
	error(errmsg);
	return;
}

void deadend_error(void)
{
	error("Line dead-end.  Use error checker on the Sectors.");
}

void rd_error(void)
{
	fatal_error("Failed on read from WAD file");
}

void wr_error(void)
{
	fatal_error("Failed on write to WAD file");
}

void dir_error(void)
{
	fatal_error("WAD file directory structure corrupt");
}

void sw2_notice(void)
{
	if (!sw_doom)
		return;

	error("In compliance with id's requests, this editor 'utility' has\n"
		"been made to not work with the shareware version of doom.\n"
		"Your version of doom has been detected as the shareware\n"
		"version.  Please register doom if you wish to use DMapEdit.\n");

	fatal_error("Shareware Doom");
}

void erase_text(int x, int y, int xsize)
{
	setviewport(x, y, x + xsize*8 - 1, y + 7, 1);
	clearviewport();
	setviewport(0, 0, maxx, maxy, 1);
	return;
}

int cursored_get(int x, int y)
{
	int color, counter;

	color = 254;
	counter = 0;
	while (!kbhit())
		if (counter++ == 1500)
		{
			draw_cursor(x+1, y+1, color);
			color ^= 254;
			counter = 0;
		}
	draw_cursor(x+1, y+1, 0);
	return getch();
}

int get_number(int x, int y, int old_num, int max, int min)
{
	char key[7];
	int column, row, pos, neg;
	long value, num;

	column = win.left + x * 8 + 4;
	row = win.top + y * 10 + 4;
	pos = neg = 0;
	num = strlen(itoa(max, key, 10));
	if (strlen(itoa(min, key, 10)) > num)
		num = strlen(key);
	erase_text(column, row, num);
	key[1] = num = 0;

	while ((*key = cursored_get(column, row)) != 13)
	{
		if (*key == 8)
		{
			if (!pos)
				continue;
			pos--;
			if (!pos && neg)
			{
				neg = 0;
				continue;
			}
			num /= 10;
			column -= 8;
			erase_text(column, row, 1);
			continue;
		}
		if (*key == '-' && pos == 0 && min < 0)
			neg = 1;
		else {
			if (!isdigit(*key))
				continue;
			if (neg)
				value = num * 10 - *key + '0';
			else
				value = num * 10 + *key - '0';
			if (value > max || value < min)
				continue;
			num = value;
		}
		outtextxy(column, row, key);
		column += 8;
		pos++;
	}
	if (pos == neg)
	{
		num = old_num;
		sprintf(key, "%d", num);
		text(column - (neg*8), row, key);
	}
	return num;
}

int getkey(void) /* get normal or extended keypress */
{
	int key;

	if (!(key = getch()))
		key = getch() + 1000;
	if (key >= 'A' && key <= 'Z')
		key += 0x20; /* remap uppercase to lowercase */
	if (key == 1016 || key == 1045) /* alt-q and alt-x */
		key = 27; /* escape key */
	return key;
}

/* input 8 characters (for filenames and wad subfilenames) */

int get8(char *s, char *deflt, int column, int row)
{
	char inbuf[256], key[2];
	int pos;

	erase_text(column, row, 8);
	pos = 0;
	key[1] = 0;
	while ((*key = cursored_get(column, row)) != 13)
	{
		if (*key == 27)
		{
			strcpy(s, deflt); /* use default */
			erase_text(column - pos*8, row, 8);
			text(column - pos*8, row, s);
			return 1;
		}

		if (*key == 8)
		{
			if (!pos)
				continue;
			pos--;
			column -= 8;
			erase_text(column, row, 1);
			continue;
		}

		if (!(isdigit(*key) || isalpha(*key) || *key == '_'))
			continue;
		if (pos == 8)
			continue;

		if (islower(*key))
			*key -= 32;
		outtextxy(column, row, key);
		column += 8;
		s[pos] = *key;
		pos++;
	}

	if (!pos) /* null string? */
	{
		strcpy(s, deflt); /* use default */
		text(column, row, s);
		return 0;
	}
	while (pos<9)
		s[pos++] = 0;
	return 0;
}

void fix_wadname(char *name)
{
	int i, len;

	i = strlen(pwad);
	while (--i)
		if (pwad[i] == '\\')
		{
			i++;
			break;
		}

	len = 0;
	while (pwad[i] && pwad[i] != '.' && len < 8)
		name[len++] = pwad[i++];
	name[len] = 0;
	return;
}

int get_wadname(char *mode1, char *mode2)
{
	char inbuf[128], name[9];
	int i, column, row;

	fix_wadname(name);
	sprintf(inbuf, "%s map %s working WAD file\t\n"
		"Filename (%s):           \n", mode1, mode2, name);
	window_text(inbuf, 1);

	column = win.left + strlen(name) * 8 + 108;
	row = win.top + 24;
	i = get8(inbuf, name, column, row);
	if (!i)
	{
		editing_pwad = 1;
		strcpy(pwad, inbuf);
		strcat(pwad, ".WAD");
	}
	return i;
}

int file_picklist(char *mask)
{ /*
	char msg[60], temp[6];
	int i, list_num, list_size, columns, rows, type;
	int old_num, new_num;

	/* work on this */

	rows = (maxy / 20) * 2 - 1; /* make sure it's an odd number */
	columns = thing_name_size + 13;
	list_size = (rows - 6) / 2;

	list_num = 0;
	for (i=0; i<thing_max; i++)
		if (thing_types[i] == num)
		{
			list_num = i - list_size / 2;
			break;
		}

re_list:
	if (list_num < 0)
		list_num += thing_max; /* wrap around */

	set_window(columns, rows, 0);
	text_to_window(0, 0, "Select type:\t\n\n[ More ]\t", columns);
	text_to_window(0, rows-1, "[ More ]\t", columns);
	for (i=0; i<list_size; i++)
	{
		type = thing_types[list_num];
		sprintf(msg, "%Fs\n", thing_names[list_num]);
		text_to_window(6, i*2+5, msg, 0);
		yy[i] = i * 20 + 57;
		xx[i] = draw_thing2( (i & 1) * 24 + 14, yy[i], list_num);
		xx[i] += win.left;
		yy[i] += win.top;
		index[i] = list_num++;
		if (list_num >= thing_max)
			list_num = 0;
	}
	draw_buttons();
	mouse_on();
	old_num = -1;

	while (mouse_check()); /* wait for mouse button release */
	while (1)
	{
		while (!mouse_check() && !keypress)
		{
			new_num = -1;
			for (i=0; i<list_size; i++)
				if ((abs(mousex - xx[i]) + abs(mousey - yy[i])) < 16)
					new_num = i;
			if (new_num != old_num)
			{
				if (old_num != -1)
				{
					image_restore(xx[old_num], yy[old_num]);
					setcolor(255);
					mouse_off();
					reprint_line(index[old_num], old_num, columns-6);
					mouse_on();
				}
				if (new_num != -1)
				{
					mouse_off();
					box_thing(xx[new_num], yy[new_num],
						shp_offsets[thing_shapes[index[new_num]]]);
					setcolor(254);
					reprint_line(index[new_num], new_num, columns-6);
					mouse_on();
				}
				old_num = new_num;
			}
		}

		if (keypress)
		{
			if (keypress == 27)
			{
				mouse_off();
				return num;
			}

			if (keypress == 13 && new_num != -1)
			{
				mouse_off();
				return thing_types[index[new_num]];
			}

			if (keypress == 1073) /* page up */
			{
				list_num -= list_size * 2;
				mouse_off();
				goto re_list;
			}

			if (keypress == 1081) /* page down */
			{
				mouse_off();
				goto re_list;
			}

			if (keypress == 1071) /* home */
			{
				list_num = 0;
				mouse_off();
				goto re_list;
			}
			continue; /* end of key checks, below is mouse button pressed */
		}

		if (mousex < win.left - 5 ||
			mousex > win.right + 5 ||
			mousey < win.top - 5 ||
			mousey > win.bottom + 5)
		{
			mouse_off();
			return num;
		}

		if (line_dist(bigb.pos[0].x1, bigb.pos[0].y,
			bigb.pos[0].x2, bigb.pos[0].y) < 7)
		{
			list_num -= list_size * 2;
			mouse_off();
			goto re_list;
		}

		if (line_dist(bigb.pos[1].x1, bigb.pos[1].y,
			bigb.pos[1].x2, bigb.pos[1].y) < 7)
		{
			mouse_off();
			goto re_list;
		}

		if (new_num != -1)
		{
			mouse_off();
			return thing_types[index[new_num]];
		}
	} */
}

void sync_time(void)
{
	struct time t;

	gettime(&t);
	systime = t.ti_sec * 100 + t.ti_hund;
	return;
}

int wait(int delay) /* attemp to time sync animation */
{
	int tm, dif;
	struct time t;

	gettime(&t);
	tm = t.ti_sec * 100 + t.ti_hund;
	dif = tm - systime;
	if (dif < 0)
		dif += 6000; /* wrap-around */
	if (dif < delay)
		return 0;
	systime = tm;
	return 1;
}

void open_prog_file(char *name, char *mode)
{
	char fullpath[100];

	strcpy(fullpath, path);
	strcat(fullpath, name);

	if ((fp = fopen(fullpath, mode)) == NULL)
		fatal_error("Can't open \"%s\"", name);
	return;
}

int read_ini_file(int gmode, char *gname)
{
	char str[101], *var, *setting;
	int line=0, num, *int_ptr;

	char *variables[] = {
		"doom path",
		"edit mode",
		"zoom",
		"video driver",
		"video mode",
		"episode",
		"mission",
		"backup",
		"grid",
		"pwad path1",
		"pwad path2",
		"pwad path3",
		"crosshare",
		"flash mode",
		"skip intro",
		"left mouse button",
		"middle mouse button",
		"right mouse button",
		"*end"
	};

	if (!(fp = fopen("dmapedit.ini", "r"))) /* check current directory.. */
	{
		strcpy(str, path); /* if not there, see if it's in home dir */
		strcat(str, "dmapedit.ini");

		if ((fp = fopen(str, "r")) == NULL)
			return gmode; /* no ini file, so forget about reading it */
	}

	while (fgets(str, 100, fp))
	{
		line++;
		if (*str == '\n' || *str == '*')
			continue; /* skip blank lines and comments */

		var = strtok(str, "=");
		if (!var)
		{
			fclose(fp);
			fatal_error("Error in \"dmapedit.ini\", line #%d", var, line);
		}

		setting = strtok(NULL, "\n");
		for (num=0; stricmp(variables[num], "*end"); num++)
			if (!stricmp(variables[num], var))
				break;

		if (!stricmp(variables[num], "*end"))
		{
			fclose(fp);
			fatal_error("Unknown variable: \"%s\"\n"
				"   In \"dmapedit.ini\", line #%d", var, line);
		}

		switch (num)
		{
			case 0: /* doom path */
				strncpy(iwad, setting, 79);
				iwad[79] = 0;
				break;

			case 1: /* edit mode */
				if (!stricmp(setting, "things"))
					edit_mode = 0;
				else if (!stricmp(setting, "vertexes"))
					edit_mode = 2;
				else if (!stricmp(setting, "lines"))
					edit_mode = 4;
				else if (!stricmp(setting, "sectors"))
					edit_mode = 7;
				else goto err;
				break;

			case 2: /* zoom */
				num = atoi(setting);
				if (num < 0 || num > MAX_ZOOM)
					goto err;
				scale = num;
				things_on = scale>2 ? 2 : 1;
				break;

			case 3: /* video driver */
				strncpy(gname, setting, 8);
				gname[8] = 0;
				break;

			case 4: /* video mode */
				gmode = atoi(setting);
				break;

			case 5: /* episode */
				num = atoi(setting);
				if (num < 1 || num > 3)
					goto err;
				episode = num;
				break;

			case 6: /* mission */
				num = atoi(setting);
				if (num < 1 || num > 9)
					goto err;
				mission = num;
				break;

			case 7: /* backup */
				if (!stricmp(setting, "yes"))
					backup = 1;
				else if (!stricmp(setting, "no"))
					backup = 0;
				else goto err;
				break;

			case 8: /* grid */
				if (!stricmp(setting, "off"))
				{
					grid = 0;
					break;
				}

				num = atoi(setting);
				if (num < 1 || num > 3)
					goto err;

				grid = num + 251;
				break;

			case 9: /* pwad path1 */
				pwad1 = get_mem(strlen(setting) + 1, "pwad path1");
				strcpy(pwad1, setting);
				break;

			case 10: /* pwad path2 */
				pwad2 = get_mem(strlen(setting) + 1, "pwad path2");
				strcpy(pwad2, setting);
				break;

			case 11: /* pwad path3 */
				pwad3 = get_mem(strlen(setting) + 1, "pwad path3");
				strcpy(pwad3, setting);
				break;

			case 12: /* crosshare */
				if (!stricmp(setting, "on"))
					cross_on = 1;
				else if (!stricmp(setting, "off"))
					cross_on = 0;
				else goto err;
				break;

			case 13: /* flash mode */
				if (!stricmp(setting, "old"))
					flash_mode = 0;
				else if (!stricmp(setting, "new"))
					flash_mode = 1;
				else goto err;
				break;

			case 14: /* skip intro */
				if (!stricmp(setting, "yes"))
					bypass_sw = 1;
				else if (!stricmp(setting, "no"))
					bypass_sw = 0;
				else goto err;
				break;

			case 15: /* left mouse button */
				int_ptr = &left_button;

			case 16: /* middle mouse button */
				if (num == 16)
					int_ptr = &middle_button;

			case 17: /* right mouse button */
				if (num == 17)
					int_ptr = &right_button;

				if (!stricmp(setting, "add"))
					*int_ptr = 1;
				else if (!stricmp(setting, "delete"))
					*int_ptr = 2;
				else if (!stricmp(setting, "edit"))
					*int_ptr = 4;
				else if (!stricmp(setting, "mark"))
					*int_ptr = 8;
				else goto err;
				break;
		}
	}
	fclose(fp);
	return gmode;

err:
	fclose(fp);
	fatal_error("File \"dmapedit.ini\", line #%d\n"
		"unknown setting: \"%s\"\n"
		"   for variable: \"%s\"", line, setting, var);
}

void init_graphics(int gmode, char *gname)
{
	int i, low, high;
	char name[80], pal[768];
	int gdriver, errorcode;
	union REGS regs;
	struct SREGS segregs;

	/* initialize graphics and local variables */
	gdriver = installuserdriver(gname, 0);
	initgraph(&gdriver, &gmode, path);

	/* read result of initialization */
	errorcode = graphresult();
	if (errorcode != grOk) /* an error occured */
		fatal_error("Graphics: %s", grapherrormsg(errorcode));

	graph_on = 1;
	maxx = getmaxx();
	maxy = getmaxy();
	if (maxx < 639 || maxy < 399)
		fatal_error("Get a real video card!");

	midx = maxx / 2;
	midy = maxy / 2;
	setbkcolor(0);
	settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);

	strcpy(name, path);
	strcat(name, "palette.dme");
	if ((fp = fopen(name, "rb")) == NULL)
		fatal_error("Can't open file \"palette.dme\"");
	if (fread(pal, sizeof(pal), 1, fp) != 1)
		fatal_error("file \"palette.dme\" is corrupt");
	fclose(fp);

	regs.h.ah = 0x10;
	regs.h.al = 0x12;
	regs.x.bx = 0;
	regs.x.cx = 256;
	regs.x.dx = FP_OFF(pal);
	segregs.es = FP_SEG(pal);
	int86x(0x10, &regs, &regs, &segregs); /* set the palette */
	return;
}

void init_mouse(void)
{
	union REGS regs;

	regs.x.ax = 0;
	int86(0x33, &regs, &regs);
	if (regs.x.ax == 0)
		fatal_error("Mouse driver not installed (required)");

	mouse_maxx = maxx - 8;
	mouse_maxy = maxy - 14;
	mousex = maxx / 2;
	mousey = maxy / 2;
	button_status = 0;
	return;
}
