/*
  C source for Winsock Chess
  
  Revision 1994-03-15
  Modified by Donald Munro for use as a 2 player chess game over a 
  WINSOCK layer on a TCP (or other WinSock supporting) network.
  Source code and make files for MS Visual C/C++ V1.00/1.50.
  February/March 1994
  All GNU copyright and distribution conditions as described below and in the
  file COPYING also apply to WinSock Chess.
  This module is Winsock Chess specific.
 
  C source for GNU CHESS
  
  Revision: 1990-09-30
  Modified by Daryl Baker for use in MS WINDOWS environment

  Copyright (C) 1986, 1987, 1988, 1989, 1990 Free Software Foundation, Inc.
  Copyright (c) 1988, 1989, 1990  John Stanback

  This file is part of CHESS.

  CHESS is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY.  No author or distributor accepts responsibility to anyone for
  the consequences of using it or for whether it serves any particular
  purpose or works at all, unless he says so in writing.  Refer to the CHESS
  General Public License for full details.

  Everyone is granted permission to copy, modify and redistribute CHESS, but
  only under the conditions described in the CHESS General Public License.
  A copy of this license is supposed to have been given to you along with
  CHESS so you can know your rights and responsibilities.  It should be in a
  file named COPYING.  Among other things, the copyright notice and this
  notice must be preserved on all copies.
*/

#define NOATOM         
#define NOCREATESTRUCT
#define NOFONT
#define NOREGION
#define NOSOUND
#define NOWH
#define NOKANJI

#define STRICT 
#include <windows.h>         
#include <windowsx.h>
#include <string.h>  
#include <ddeml.h>
#include <commdlg.h>

#include "gnuchess.h"
#include "defs.h"    
#include "chess.h"

extern DWORD idDdeServInst,idDdeClntInst;
extern HCONV hconvHost,hconvClient;
extern HWND hwndHostDlg,hwndMain;               
extern BOOL bHost,bConnected,bWaiting,bMoveReady;
extern int User_Move;    
extern HINSTANCE hInst;
extern void (*SendMove)(WORD);
extern HSZ hszServName,hszTopic,hszServNameCl,hszTopicCl,hszItem,hszGet;


extern MoveInfo moveinfo;
static DWORD    dwXactId;

HDDEDATA CALLBACK __export DdeServerProc(UINT type, UINT fmt, HCONV hconv, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2)
//------------------------------------------------------------------------                                
{ LPSTR lpszGetBuf;
  HDDEDATA hddedata;
  
  switch (type)
    { case XTYP_CONNECT :
        if ( (hsz1 == hszTopic) || (hsz1 == hszTopicCl) )
          if ( (hwndHostDlg == NULL) && (bHost == TRUE) ) 
            return FALSE;
          else  
            return (HDDEDATA)TRUE;
        else
          return (HDDEDATA)FALSE;  
          
      case XTYP_CONNECT_CONFIRM :
        hconvHost = hconv;
        if (hwndHostDlg != NULL)
           SendMessage(hwndHostDlg,WM_CONNECTED,NULL,NULL);
        return (HDDEDATA)NULL;
        
      case XTYP_REQUEST :   
        if (hsz2 == hszGet)
         { lpszGetBuf = EncodeGame();
           hddedata = DdeCreateDataHandle(idDdeServInst,lpszGetBuf,
                                          4096,0,hszGet,CF_TEXT,0);
           GlobalFreePtr(lpszGetBuf);
           player = opponent;
           User_Move = TRUE;
           return hddedata;
         }                                     
        if (bMoveReady)
         { bMoveReady = FALSE;
           return DdeCreateDataHandle(idDdeServInst,&moveinfo,
                                      sizeof(MoveInfo),0,hszItem,CF_TEXT,0);
         }
        else
          return (HDDEDATA)CBR_BLOCK;                               
        break;
        
      case XTYP_DISCONNECT :
        bConnected = bHost = FALSE;
        SetWindowText(hwndMain,"Winsock Chess (Not Connected)");
        hconvHost = hconvClient = NULL;
        return (HDDEDATA)NULL;           
    }
  return (HDDEDATA)NULL;  
}            
        

HDDEDATA CALLBACK __export DdeClientProc(UINT type, UINT fmt, HCONV hconv, HSZ hsz1,
                                HSZ hsz2, HDDEDATA hData, DWORD dwData1,
                                DWORD dwData2)
//------------------------------------------------------------------------                                
{ switch (type)
   { case XTYP_XACT_COMPLETE :
       if ( (dwData1 == dwXactId) && (hsz2 == hszItem) )
         { DdeGetData(hData,(LPBYTE)&moveinfo,sizeof(MoveInfo),0L);
           bWaiting = TRUE;
           SendMessage(hwndMain,MSG_COMPUTER_MOVE,NULL,NULL);
         }
       return (HDDEDATA)NULL;    
         
     case XTYP_DISCONNECT :
        bConnected = bHost = FALSE;
        hconvHost = hconvClient = NULL;
        return (HDDEDATA)NULL;               
   }
 return (HDDEDATA)NULL;  
}           
       

BOOL InitialiseDDE(void)
//----------------------
{ BOOL bServInit,bClientInit;
  FARPROC lpDdeServer,lpDdeClient;  

  lpDdeServer = MakeProcInstance((FARPROC)DdeServerProc,hInst);       
  lpDdeClient = MakeProcInstance((FARPROC)DdeClientProc,hInst);       
  bServInit    = DdeInitialize(&idDdeServInst,(PFNCALLBACK)lpDdeServer,
                 CBF_FAIL_EXECUTES | CBF_FAIL_POKES | CBF_FAIL_SELFCONNECTIONS,
                 0L);
  bClientInit  = DdeInitialize(&idDdeClntInst,(PFNCALLBACK)lpDdeClient,
                 CBF_FAIL_EXECUTES | CBF_FAIL_POKES | CBF_FAIL_SELFCONNECTIONS, 
                 0L);
  hszServName   = DdeCreateStringHandle(idDdeServInst,"WSCHESSH",NULL);
  hszTopic      = DdeCreateStringHandle(idDdeServInst,"MOVES",NULL);
  hszServNameCl = DdeCreateStringHandle(idDdeServInst,"WSCHESSC",NULL);
  hszTopicCl    = DdeCreateStringHandle(idDdeClntInst,"MOVES",NULL);
  hszItem       = DdeCreateStringHandle(idDdeServInst,"MOVE",NULL);
  hszGet        = DdeCreateStringHandle(idDdeServInst,"GET",NULL);
  if (! bServInit) 
    if (bHost)
     if (DdeNameService(idDdeServInst,hszServName,(HSZ)NULL,DNS_REGISTER) == 0)
       return FALSE;
     else;
    else
     if (DdeNameService(idDdeServInst,hszServNameCl,(HSZ)NULL,DNS_REGISTER) == 0)
       return FALSE;
  return !(bServInit && bClientInit);
}                               


void DisconnectDDE(void)
//----------------------
{ DdeDisconnect(hconvHost);
  DdeDisconnect(hconvClient);
}  

void GetOpponentsMoveDDE(WORD cbBytes)
//------------------------------------
{ HDDEDATA hddedata;
  

  hddedata = DdeClientTransaction(NULL,0,hconvClient,hszItem,CF_TEXT,
                                  XTYP_REQUEST, TIMEOUT_ASYNC,&dwXactId);
}

void SendMoveDDE(WORD cbBytes) 
//----------------------------
{ bMoveReady = TRUE;
  DdeEnableCallback(idDdeServInst,NULL,EC_ENABLEALL);
}  

void GetGameDDE(void)
//-------------------
{ char szFileName[256];

  if (GetFileName(szFileName,OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST,
                  MSG_CHESS_GET))
   { NewGame(hwndMain);                            
     GetGame(hwndMain,szFileName);               
     lstrcpy(moveinfo.szMove,"COMG\r\n");
     (*SendMove)(7);
   }   
}   

void NewGameDDE(void)
//-------------------
{ short opp;

  opp = opponent;
  lstrcpy(moveinfo.szMove,"COMN\r\n");
  (*SendMove)(7);
  NewGame(hwndMain);
  if (opp == black)
   { computer = white;
     opponent = black;
     User_Move = FALSE;
     flag.reverse = !flag.reverse;   
     PostMessage ( hwndMain, MSG_COMPUTER_MOVE, NULL, (LPARAM)NULL);
   }
  else
   { computer = black;
     opponent = white;
     User_Move = TRUE;
   }  
  UpdateDisplay(hwndMain,0,0,1,0);
  flag.force = false;
  Sdepth = 0; 
}  

void SetTimeDDE(int id)
//---------------------
{ short sKeepTCmoves,sKeepTCtime;     

  
  sKeepTCmoves = TCmoves;
  sKeepTCtime  = TCminutes;  
  if ( TimeControlDialog (hwndMain, hInst, id) ) 
   { TCflag = (TCmoves>1);
     if (TCflag)
       SetTimeControl ();
     wsprintf(moveinfo.szMove,"COMT%3d%3d\r\n",TCmoves,TCminutes);
     (*SendMove)(12);     
   }  
}  