;-----------------------------------------------------------------------
; DL!SRCH.RS - Robocomm 4.x script: Search for Files On Datalink/TBBS
;........................................................................
; Author:   Rick Matthews
; Date:     07/03/93
; Version:  2.1
;
; Notes:    The PARAMETER statements below will be asked of you when you
;           add this script to an agenda.  When asked by RoboComm, you
;           should mark this script as temporary so that it will be
;           deleted once the search is complete.  Your responses will be
;           used to search the file names and descriptions in all file
;           areas. Search strings may include any printable characters,
;           and may include embedded spaces.
;
;           The files that match your search strings will be listed in
;           DL$_MMDD.CAP, where MM = month and DD = day.  This capture
;           file, like all others that end with .CAP, is viewable from
;           within Robocomm by pressing <F9>.  It is up to the user to
;           delete old DL$_MMDD.CAP files.
;
;           You might want to make sure that this script is the last one
;           in an agenda that does any realy work, ie. right before the
;           logoff.  If the number of files found is large, the BBS will
;           time you out while this script is doing the file conversion
;           below.  If the only script after this one is to log off,
;           there is no real loss.
;
;-----------------------------------------------------------------------
TITLE "Search DataLink Files With Keywords"

;------------------------------------------------------------------
PARAMETER "   Text to Search for in the File List->"
PARAMETER "   Text to Search for in the File List->"
PARAMETER "   Text to Search for in the File List->"
PARAMETER "   Text to Search for in the File List->"
PARAMETER "   Text to Search for in the File List->"
ENDPARAMS
;------------------------------------------------------------------
; Get ready for to perform search

        SEND "F"
        WHEN "TO CONTINUE"              SEND "|"
        WHEN "Read Now(Y/N)?"           SEND "N"
        WHEN "-Press Any Key-"          SEND "|"
        WHEN "-More-"                   SEND "|"
        WHEN "Select File Area"         SEND "1|S"
        WHEN "If you would like access" GOTO No_File_Access
        WHEN "breaking in to chat"      SEND "Script file, cannot respond.|"
        WAITFOR "Command:"              FAILURE GOTO NOGO
        SEND "C~S"
        WAITFOR "<D>ownload"            FAILURE GOTO NOGO

:SUBMARINES

        IF NOT EMPTY "%P1%" GOSUB SCAN-ONE
        IF NOT EMPTY "%P2%" GOSUB SCAN-TWO
        IF NOT EMPTY "%P3%" GOSUB SCAN-THREE
        IF NOT EMPTY "%P4%" GOSUB SCAN-FOUR
        IF NOT EMPTY "%P5%" GOSUB SCAN-FIVE
        MESSAGE "That's all the scans!"
;------------------------------------------------------------------
:THATSIT

        MESSAGE "Checking for DL$_%NMONTH%%DOM%.CAP file..."
        IF NOT EXIST "DL$_%NMONTH%%DOM%.CAP" MESSAGE "File not found!"
        IF NOT EXIST "DL$_%NMONTH%%DOM%.CAP"  GOTO RESET_MENU
        MESSAGE "Converting File, Please Stand By..."
        RUN "dir4robo DL$_%NMONTH%%DOM%.CAP"
        COPY "NEWLIST.DAT" TO "DL$_%NMONTH%%DOM%.CAP"
        ERASE "newlist.dat"

:RESET_MENU

        SEND "|="
        WAITFOR "Command"
        EXIT 0

:NOGO

        MESSAGE "Unable to locate file menu.  Aborting."
        SEND "|="
        WAITFOR "Command"
        EXIT 1

:No_File_Access

        MESSAGE "****************************************************"
        MESSAGE "*                                                  *"
        MESSAGE "*    You must purchase download time on this       *"
        MESSAGE "*    BBS before the file search script will        *"
        MESSAGE "*              function properly.                  *"
        MESSAGE "*                                                  *"
        MESSAGE "****************************************************"
        SEND "|="
        WAITFOR "Command"
        EXIT 1

;------------------------------------------------------------------
:SCAN-ONE

        TIMEOUT 300
        MESSAGE "Opening Capture File DL$_%NMONTH%%DOM%.CAP for %P1%"
        CAPTURE "DL$_%NMONTH%%DOM%.CAP" OVERWRITE
        SEND "l %P1%|"
        WHEN "File Not Found"   GOTO SCANONEFAIL
        WHEN "Illegal Cmd"      GOTO SCANONEFAIL
        WAITFOR "<D>ownload"    FAILURE GOTO SCANONEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        CLEAR
        RETURN

        :SCANONEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        MESSAGE "The Scan for %P1% Failed < < < < <"
        CLEAR
        WAITFOR "<CR> to exit:"
        RETURN

;------------------------------------------------------------------
:SCAN-TWO

        TIMEOUT 300
        MESSAGE "Opening Capture File DL$_%NMONTH%%DOM%.CAP for %P2%"
        CAPTURE "DL$_%NMONTH%%DOM%.CAP" APPEND
        SEND "l %P2%|"
        WHEN "File Not Found"   GOTO SCANTWOFAIL
        WHEN "Illegal Cmd"      GOTO SCANTWOFAIL
        WAITFOR "<D>ownload"    FAILURE GOTO SCANTWOFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        CLEAR
        RETURN

        :SCANTWOFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        MESSAGE "The Scan for %P2% Failed < < < < <"
        CLEAR
        WAITFOR "<CR> to exit:"
        RETURN

;------------------------------------------------------------------
:SCAN-THREE

        TIMEOUT 300
        MESSAGE "Opening Capture File DL$_%NMONTH%%DOM%.CAP for %P3%"
        CAPTURE "DL$_%NMONTH%%DOM%.CAP" APPEND
        SEND "l %P3%|"
        WHEN "File Not Found"   GOTO SCANTHREEFAIL
        WHEN "Illegal Cmd"      GOTO SCANTHREEFAIL
        WAITFOR "<D>ownload"    FAILURE GOTO SCANTHREEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        CLEAR
        RETURN

        :SCANTHREEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        MESSAGE "The Scan for %P3% Failed < < < < <"
        CLEAR
        WAITFOR "<CR> to exit:"
        RETURN

;------------------------------------------------------------------
:SCAN-FOUR

        TIMEOUT 300
        MESSAGE "Opening Capture File DL$_%NMONTH%%DOM%.CAP for %P4%"
        CAPTURE "DL$_%NMONTH%%DOM%.CAP" APPEND
        SEND "l %P4%|"
        WHEN "File Not Found"   GOTO SCANFOURFAIL
        WHEN "Illegal Cmd"      GOTO SCANFOURFAIL
        WAITFOR "<D>ownload"    FAILURE GOTO SCANFOURFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        CLEAR
        RETURN

        :SCANFOURFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        MESSAGE "The Scan for %P4% Failed < < < < <"
        CLEAR
        WAITFOR "<CR> to exit:"
        RETURN

;------------------------------------------------------------------
:SCAN-FIVE

        TIMEOUT 300
        MESSAGE "Opening Capture File DL$_%NMONTH%%DOM%.CAP for %P5%"
        CAPTURE "DL$_%NMONTH%%DOM%.CAP" APPEND
        SEND "l %P5%|"
        WHEN "File Not Found"   GOTO SCANFIVEFAIL
        WHEN "Illegal Cmd"      GOTO SCANFIVEFAIL
        WAITFOR "<D>ownload"    FAILURE GOTO SCANFIVEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        CLEAR
        RETURN

        :SCANFIVEFAIL
        MESSAGE "Closing Capture File DL$_%NMONTH%%DOM%.CAP"
        CLOSE
        MESSAGE "The Scan for %P5% Failed < < < < <"
        CLEAR
        WAITFOR "<CR> to exit:"
        RETURN

;------------------------------------------------------------------
