;-----------------------------------------------------------------------
; DL!UpFLS.RS - Robocomm 4.x script: Upload files to Datalink
;........................................................................
; Author:   Rick Matthews
; Date:     04/05/93
; Version:  2.0
;
; Notes:    The PARAMETER statements below will be asked of you when you
;           add this script to an agenda.  If you specify that it is
;           temporary the files will be uploaded and this script will
;           drop out of the agenda until the next time you need it.  It
;           is assumed that the file will exist in the RoboComm
;           configured upload directory.
;-----------------------------------------------------------------------
TITLE "Upload files to DataLink"

;------------------------------------------------------------------
PARAMETER 1 "   Name of File to Upload   ----------->"
PARAMETER 2 "File Description (45 Characters Max!)-->"
PARAMETER 3 "   Name of File to Upload   ----------->"
PARAMETER 4 "File Description (45 Characters Max!)-->"
PARAMETER 5 "   Name of File to Upload   ----------->"
PARAMETER 6 "File Description (45 Characters Max!)-->"
PARAMETER 7 "   Name of File to Upload   ----------->"
PARAMETER 8 "File Description (45 Characters Max!)-->"
ENDPARAMS
;------------------------------------------------------------------
; Get ready for uploads

        TIMEOUT 20
        SEND "U"
        WHEN "TO CONTINUE"              SEND "|"
        WHEN "Read Now(Y/N)?"           SEND "N"
        WHEN "-Press Any Key-"          SEND "|"
        WHEN "-More-"                   SEND "|"
        WHEN "does not solicit uploads" GOTO NOUPLOAD
        WHEN "breaking in to chat"      SEND "Script file, cannot respond.|"
        WAITFOR "Command:"              FAILURE GOTO NOGO

:SUBMARINES

        IF NOT EMPTY "%P1%" GOSUB UL-ONE
        IF NOT EMPTY "%P3%" GOSUB UL-TWO
        IF NOT EMPTY "%P5%" GOSUB UL-THREE
        IF NOT EMPTY "%P7%" GOSUB UL-FOUR
;------------------------------------------------------------------
:THATSIT

        SEND "|="
        WAITFOR "Command"
        EXIT 0

:NOGO

        MESSAGE "Unable to locate file menu.  Aborting."
        SEND "|="
        WAITFOR "Command"
        EXIT 1

:NOUPLOAD

        MESSAGE "****************************************************"
        MESSAGE "*                                                  *"
        MESSAGE "*    You are not permitted to Upload on this       *"
        MESSAGE "*    system.  Please send a message addressed      *"
        MESSAGE "*    to SYSOP requesting file upload capability    *"
        MESSAGE "*                                                  *"
        MESSAGE "****************************************************"
        SEND "|="
        WAITFOR "Command"
        EXIT 1

;------------------------------------------------------------------
:UL-ONE

        SEND "U"
        WAITFOR "full file name:"   FAILURE GOTO ULONEFAIL
        TIMEOUT 15
        SEND "%P1%|"
        WHEN "Bad file spec"        GOTO ULONEFAIL
        WHEN "-Press Any Key-"      SEND "|"
        WHEN "already exists"       GOTO ULONEFAIL
        WAITFOR "(45 chars max"
        SEND "%P2%|"
        WAITFOR "Ready to receive"  FAILURE GOTO ULONEFAIL
        TIMEOUT 170
        UPLOAD "%ULDIR%%P1%"
        WAITFOR "Command:"          FAILURE GOTO ULONEFAIL
        CLEAR
        RETURN

        :ULONEFAIL
        MESSAGE "The Upload of %P1% Failed < < < < <"
        CLEAR
        WHEN "-Press Any Key-"      SEND "|"
        WAITFOR "Command:"
        RETURN

;------------------------------------------------------------------
:UL-TWO

        SEND "U"
        WAITFOR "full file name:"   FAILURE GOTO ULTWOFAIL
        TIMEOUT 15
        SEND "%P3%|"
        WHEN "Bad file spec"        GOTO ULTWOFAIL
        WHEN "-Press Any Key-"      SEND "|"
        WHEN "already exists"       GOTO ULTWOFAIL
        WAITFOR "(45 chars max"
        SEND "%P4%|"
        WAITFOR "Ready to receive"  FAILURE GOTO ULTWOFAIL
        TIMEOUT 170
        UPLOAD "%ULDIR%%P3%"
        WAITFOR "Command:"          FAILURE GOTO ULTWOFAIL
        CLEAR
        RETURN

        :ULTWOFAIL
        MESSAGE "The Upload of %P3% Failed < < < < <"
        CLEAR
        WHEN "-Press Any Key-"      SEND "|"
        WAITFOR "Command:"
        RETURN

;------------------------------------------------------------------
:UL-THREE

        SEND "U"
        WAITFOR "full file name:"   FAILURE GOTO ULTHREEFAIL
        TIMEOUT 15
        SEND "%P5%|"
        WHEN "Bad file spec"        GOTO ULTHREEFAIL
        WHEN "-Press Any Key-"      SEND "|"
        WHEN "already exists"       GOTO ULTHREEFAIL
        WAITFOR "(45 chars max"
        SEND "%P6%|"
        WAITFOR "Ready to receive"  FAILURE GOTO ULTHREEFAIL
        TIMEOUT 170
        UPLOAD "%ULDIR%%P5%"
        WAITFOR "Command:"          FAILURE GOTO ULTHREEFAIL
        CLEAR
        RETURN

        :ULTHREEFAIL
        MESSAGE "The Upload of %P5% Failed < < < < <"
        CLEAR
        WHEN "-Press Any Key-"      SEND "|"
        WAITFOR "Command:"
        RETURN

;------------------------------------------------------------------
:UL-FOUR

        SEND "U"
        WAITFOR "full file name:"   FAILURE GOTO ULFOURFAIL
        TIMEOUT 15
        SEND "%P7%|"
        WHEN "Bad file spec"        GOTO ULFOURFAIL
        WHEN "-Press Any Key-"      SEND "|"
        WHEN "already exists"       GOTO ULFOURFAIL
        WAITFOR "(45 chars max"
        SEND "%P8%|"
        WAITFOR "Ready to receive"  FAILURE GOTO ULFOURFAIL
        TIMEOUT 170
        UPLOAD "%ULDIR%%P7%"
        WAITFOR "Command:"          FAILURE GOTO ULFOURFAIL
        CLEAR
        RETURN

        :ULFOURFAIL
        MESSAGE "The Upload of %P7% Failed < < < < <"
        CLEAR
        WHEN "-Press Any Key-"      SEND "|"
        WAITFOR "Command:"
        RETURN

;------------------------------------------------------------------

