/* pmemacs.h
   Copyright (C) 1993 Eberhard Mattes.

This file is part of GNU Emacs.

GNU Emacs is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Emacs is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Emacs; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Requests */

typedef enum
{
  PMR_CURSOR,                   /* Move the (visible) cursor */
  PMR_GLYPHS,                   /* Display glyphs */
  PMR_CLEAR,                    /* Clear a frame */
  PMR_CLREOL,                   /* Clear to end of line */
  PMR_BELL,                     /* Ring the bell */
  PMR_CREATE,                   /* Create a frame */
  PMR_DESTROY,                  /* Destroy a frame */
  PMR_VISIBLE,                  /* Make frame visible or invisible */
  PMR_NAME,                     /* Set frame name */
  PMR_FOCUS,                    /* Set focus to frame */
  PMR_ICONIFY,                  /* Turn window into an icon */
  PMR_SIZE,                     /* Set size of frame  */
  PMR_LINES,                    /* Insert or delete lines */
  PMR_POPUPMENU,                /* Popup menu */
  PMR_MODIFY,                   /* Modify parameters */
  PMR_MOUSEPOS,                 /* Query mouse position */
  PMR_PASTE,                    /* Get text from clipboard */
  PMR_CUT,                      /* Copy text to clipboard */
  PMR_MENUBAR,                  /* Set menubar (top level only) */
  PMR_QUITCHAR,                 /* Set the quit character */
  PMR_CLOSE,                    /* Close connection */
  PMR_RAISE,                    /* Raise frame */
  PMR_LOWER,                    /* Lower frame */
  PMR_FACE,                     /* Define a face */
  PMR_BACKGROUND,               /* Change background color */
  PMR_FONTLIST,                 /* Get list of fonts */
  PMR_MENU,                     /* Set one menu of the menubar */
  PMR_TRACKMOUSE,               /* Turn on/off mouse tracking */
  PMR_FRAMEPOS,                 /* Get position of frame window */
  PMR_SETPOS                    /* Set positition of frame window */
} pm_request_type;

typedef struct
{
  pm_request_type type;
  unsigned long frame;
} pmr_header;

typedef struct
{
  pmr_header header;
  int height, width;
} pmr_create;

typedef struct
{
  pmr_header header;
  int x, y, on;
} pmr_cursor;

typedef struct
{
  pmr_header header;
  int count, x, y, face;
} pmr_glyphs;

typedef struct
{
  pmr_header header;
  int x0, x1, y;
} pmr_clreol;

typedef struct
{
  pmr_header header;
  int visible;
} pmr_visible;

typedef struct
{
  pmr_header header;
  int count;
} pmr_name;

typedef struct
{
  pmr_header header;
  int width, height;
} pmr_size;

typedef struct
{
  pmr_header header;
  int y, max_y;
  int count;                    /* Insert this many lines if positive */
} pmr_lines;

typedef struct
{
  pmr_header header;
  int panes, lines;
  int button;
  int x, y;
  int title_size;               /* Length of title */
  int size;                     /* Size of data to follow */
} pmr_popupmenu;

typedef struct
{
  pmr_header header;
  int get_text;
} pmr_paste;

typedef struct
{
  pmr_header header;
  unsigned long size;           /* Size of data to follow */
} pmr_cut;

typedef struct
{
  pmr_header header;
  int menus;                    /* Number of menus in the menubar */
  int size;                     /* Size of data to follow */
} pmr_menubar;

typedef struct
{
  pmr_header header;
  int quitchar;                 /* The quit character */
} pmr_quitchar;

typedef struct
{
  pmr_header header;
  int foreground;               /* Foreground color */
  int background;               /* Background color */
  int name_length;              /* Length of font name to follow */
  char underline;               /* Underline */
} pmr_face;

typedef struct
{
  pmr_header header;
  int background;               /* Background color */
} pmr_background;

typedef struct
{
  pmr_header header;
  int panes, lines;
  int title_size;               /* Length of title */
  int size;                     /* Size of data to follow */
} pmr_menu;

typedef struct
{
  pmr_header header;
  int flag;
} pmr_track;

typedef struct
{
  pmr_header header;
  int top, left;
} pmr_setpos;

typedef union
{
  pmr_header header;
  pmr_create create;
  pmr_cursor cursor;
  pmr_glyphs glyphs;
  pmr_clreol clreol;
  pmr_visible visible;
  pmr_name name;
  pmr_size size;
  pmr_lines lines;
  pmr_popupmenu popupmenu;
  pmr_paste paste;
  pmr_cut cut;
  pmr_menubar menubar;
  pmr_quitchar quitchar;
  pmr_face face;
  pmr_background background;
  pmr_menu menu;
  pmr_track track;
  pmr_setpos setpos;
} pm_request;

/* Additional data for PMR_POPUPMENU, PMR_MENUBAR and PMR_MENU. */

typedef struct
{
  int size;                     /* Length of string to follow */
} pm_menubar_entry;

typedef struct
{
  int lines;
  int size;                     /* Length of string to follow */
} pm_menu_pane;

typedef struct
{
  unsigned long item1;
  unsigned long item2;
  unsigned long item3;
  int enable;                   /* Menu entry enabled */
  int size;                     /* Length of string to follow */
} pm_menu_line;

/* Additional data for PMR_MODIFY */

#define CURSORTYPE_BOX          1
#define CURSORTYPE_BAR          2
#define CURSORTYPE_FRAME        3
#define CURSORTYPE_UNDERLINE    4
#define CURSORTYPE_HALFTONE     5

#define COLOR_NONE              (-99)
#define DONT_MOVE               (-999999)

#define PMR_FALSE               1
#define PMR_TRUE                2

typedef struct
{
  int width, height;
  int top, left;
  int cursor_type, cursor_blink;
  int alt_modifier, altgr_modifier;
  int disable_shortcuts;
  char buttons[3];
  char font_name[100];
} pm_modify;


/* Events */

typedef enum
{
  PME_PAINT,                    /* Repaint a frame */
  PME_KEY,                      /* Key pressed */
  PME_BUTTON,                   /* Mouse button */
  PME_SIZE,                     /* Size of frame changed */
  PME_RESTORE,                  /* Frame window restored  */
  PME_MENUBAR,                  /* Recompute menubar */
  PME_MOUSEMOVE,                /* Mouse moved */
  PME_MINIMIZE,                 /* Frame window minimized */
  PME_FRAMEMOVE                 /* Frame window moved */
} pm_event_type;

typedef enum
{
  PMK_ASCII,
  PMK_VIRTUAL,
  PMK_SYMBOL
} pm_key_type;

typedef struct
{
  pm_event_type type;
  unsigned long frame;
} pme_header;

typedef struct
{
  pme_header header;
  int x0, x1, y0, y1;
} pme_paint;

typedef struct
{
  pme_header header;
  pm_key_type type;
  int code, modifiers;
} pme_key;

typedef struct
{
  pme_header header;
  int width, height;
} pme_size;

typedef struct
{
  pme_header header;
  int button, modifiers, x, y;
  unsigned long timestamp;
} pme_button;

typedef struct
{
  pme_header header;
  int number;
} pme_menubar;

typedef struct
{
  pme_header header;
  int x, y;
} pme_mouse;

typedef struct
{
  pme_header header;
  int top, left;
} pme_framemove;

typedef union
{
  pme_header header;
  pme_paint paint;
  pme_key key;
  pme_size size;
  pme_button button;
  pme_menubar menubar;
  pme_mouse mouse;
  pme_framemove framemove;
} pm_event;

/* Out-of-band data */

typedef struct
{
  unsigned long frame;
  int x, y;
} pmd_mousepos;

typedef struct
{
  int size, count;
} pmd_fontlist;

typedef struct
{
  int top, left;
} pmd_framepos;
