/* MOUSECHG.CMD -- utility to change the mouse pointer for OS/2 2.1

Steve Allen
Altech Computer Services
121 Herta St.
Easley, SC 29640

Aug 93
*/

call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

say ""
say "MOUSECHG v1.3 1993"
say "Altech Computer Services" 'fe'x "Steve Allen"
say ""

arg mouseptr

if mouseptr = "" then 
    do
        call beep_error
        say "Usage is MOUSECHG mouse_pointer_name (give full path name)"
        say "Example: MOUSECHG c:\mouse.ptr"
        exit(1)
    end

ptr = stream(mouseptr, 'c', 'query exists')

if ptr = "" then 
    do
        call beep_error
        say "Please check to make sure" mouseptr "is valid filename."
        say "Make sure you have the COMPLETE pathname, including the "
        say "correct drive name."
        exit(2)
    end

ver = SysOS2Ver()
if ver = "2.10" then 
    do
        say "Backing up \OS2\OS2.INI to OS2.BAK"
        "COPY \OS2\OS2.INI OS2.BAK"
        backup = stream("\OS2\OS2.BAK", 'c', 'query exists')
        if backup = "" then
            do
                call beep_err
                say "Error creating backup file OS2.BAK from \OS2\OS2.INI."
                say "For safety's sake, this file must exist before"
                say "you may run MOUSECHG again.  You may wish to back up"
                say "this file manually."
                exit(3)
            end
    end
else
    do
        call beep_error
        say "MOUSECHG runs ONLY under OS/2 2.1.   Your version is OS/2" ver
        say "MOUSECHG aborted."
        exit(4)
    end


say "Creating custom mouse pointer in OS2.INI file..."
key = x2c('01 00 00 00')||mouseptr||x2c('00');

result = sysini('user', 'PM_SysPointer', '1', key)

if result = "" then
    say "New mouse pointer installed successfully.  Now reboot."
else
    do
        call beep_error
        say "Error creating new mouse pointer."
        exit(5)
    end

return


beep_error:
    duration = 100
    call beep 262, duration
    call beep 330, duration
    call beep 262, duration
return

/* end of MOUSECHG.CMD */
