///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: serial.h                                             //
//            started on: 5/2/92                                         //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  This class sends and receives data via interrupt driven Serial       //
//  engine. very comfortable interface (I think). Might not work on      //
//  slow machines in high baud rates (after all it's written in a high   //
//  level language).                                                     //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef __SERIAL_H
#define __SERIAL_H

#include "public.h" // definitions.
#include "buff.h"     // BUFF
#include "isc.h"      // ISC

class SERIAL_PORT : public ISC {

protected:
          // base baud rate (devide this with requested baud rate and send to UART).
          static const unsigned long BAUD_CONST;

          // data about ports and interrupts
          //
          enum PORT {DATA=0, IER, BAUDLOW= 0,BAUDHIGH, IID,
                     LCR, MCR, LSR, MSR}; // port structure...
          enum INT_ID {NO_INT_ACTIVE= 1, MODEM_STATUS_INT= 0,
                       TX_INT= 2, RX_INT= 4, LINE_STATUS_INT= 6};
          enum PIC_PORT {PIC_DATA= 0, PIC_IMR};

          // do_send private vars.
          // will be initialized in activate()...
          unsigned do_send_recursive_count;
          BOOLEAN do_send_recursive_flag;

          // com parameters.
          //
          unsigned com_port;
          unsigned com_int;
          unsigned com_pic_port;
          unsigned char com_imr_mask;

          BUFF in_buff, out_buff; // buffers.

          // if true  :- may send out.
          // if false :- flow inhibited.

          BOOLEAN flow_enabled;

          BOOLEAN InitFlag;

          // sets up imr.
          //
          inline void set_imr(void);

          // sends eoi to the pic.
          //
          inline void eoi(void);

          // communication interrupt.
          //
          virtual void isr(void);

          // function that sets flow_enabled.
          //
          virtual inline void flow_check();
          virtual inline BOOLEAN flow_set(BYTE in_byte) { return FALSE;};

          // send top byte out.
          // - overload this function for enabling/disabling of stream io
          //            if (not enabled- do not call hook back, if it is
          //            call back - be sure to have an interrupt or something
          //            that calls this function when sending might be
          //            allowed.
          //
          virtual void do_send(void);

          // msr_int - is called when something in the modem status has changed
          //         after this function is called- the isr attempts to send
          //         data through.
          // - overload this function to do more specific things in case a
          //   specific modem control changes (Ring, DCD, DSR, CTS).
          //
          virtual void msr_int(const BYTE /* msr */) {};

          // function that extends the port initialization.
          //      called when serial port initializes, for CLASS dependent
          //      init.
          //
          virtual void extended_init() {};

          // this function gets called when a BREAK has been received.
          //
          virtual void com_break() {};

          // this function gets called when a framing error, parity error,
          // of overrun error has been received.
          virtual void com_error();



public:
       // constructor which does nothing.
       SERIAL_PORT();

       // constructor for non-standard com port.
       //
       SERIAL_PORT (const unsigned port_num, const unsigned irq_line_num,
                   const unsigned int_num, const unsigned pic_port_num);

       // setup constructor.
       void activate(const unsigned port_num, const unsigned irq_line_num,
            const unsigned int_num, const unsigned pic_port_num);

       // constructor for com1-com4
       //
       SERIAL_PORT (const unsigned com_num);

       // setup constructor.
       //
       void activate(const unsigned com_num);

       ~SERIAL_PORT();

       // access out.

       virtual OPERATION operator >> (BYTE& in_byte);
       virtual OPERATION operator << (const BYTE out_byte);
       virtual OPERATION operator >  (BYTE& peek_byte);
       inline unsigned output_buff_len(void);
       inline unsigned input_buff_len(void);
       inline void empty_io_buffers(void);
       inline void set_controls(BYTE mcr);

       void set_up_port(const long baud_rate,const BYTE word_len,
                        const BYTE parity, const BYTE stop_bits);


};

#endif /* __SERIAL_H */
