Program Sample4;

{
 This is a sample programme using RkPlus.
 It uses 2 registration levels (0 and 1).
 If a Level 1 key has expired, it will be treated as Level 0.
 If a Level 0 key has expired, it will be treated as Unregistered.
 This is a very simple programme that doesn't actually do anything, but it
 should demonstrate some of what can be done with RkPlus.

 It is identical to Sample1, except that it uses a "branding" programme
 (such as Brand) to write the information directly into the EXE file,
 rather than using a key file.  It uses the same keys as Sample1 (which
 can be generated with GenKey).

 Sample4 uses the Rkp3Enc unit to cause RkPlus to use the new version 3.x
 keys.
}


Uses
  Crt,
  RkPlus,
  Rkp3Enc;


Const
  MonthNames : Array[1..12] of String[3]
  = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');


Var
  kc : Char;
  Owner : Array[0..16] of Char;
  Prog  : Array[0..5] of Char;
  Ver   : Real;


Procedure BadRegBeep;

Begin
  Sound(1200);
  Delay(200);
  Sound(600);
  Delay(200);
  Sound(1200);
  Delay(200);
  Sound(600);
  Delay(200);
  NoSound;
End;


Procedure NotRegBeep;

Begin
  Sound(600);
  Delay(200);
  Sound(1200);
  Delay(200);
  NoSound;
End;


Procedure DoView;

Begin
  WriteLn('Sample data :');
  WriteLn;
  WriteLn('4.465536  7.918270  0.118373  5.367233');
  WriteLn('1.396349  4.868343  7.079323  4.783021');
  WriteLn('3.947924  8.864673  8.846264  2.999999');
  WriteLn('8.490832  6.874378  5.338329  3.729270');
  WriteLn('6.839882  8.873478  6.750373  7.018948');
  WriteLn('5.034784  3.003763  3.253290  4.892387');
  WriteLn('3.874378  8.314159  9.880869  3.987842');
  WriteLn('2.764947  9.265358  4.013002  9.903278');
End;


Procedure DoCalc;

Begin
  If Rkp.Registered then Begin
    Write('The calculated result is ');
    WriteLn(4.465536+7.918270+0.118373+5.367233+1.396349+4.868343+7.079323+4.783021
    +3.947924+8.864673+8.846264+2.999999+8.490832+6.874378+5.338329+3.729270
    +6.839882+8.873478+6.750373+7.018948+5.034784+3.003763+3.253290+4.892387
    +3.874378+8.314159+9.880869+3.987842+2.764947+9.265358+4.013002+9.903278);
  End Else
    WriteLn('Only available in registered version!');
End;


Procedure DoTest;

Begin
  If Rkp.Registered then Begin
    If (Rkp.Level > 0) then Begin
      Write('Performing tests...');
      Delay(300);
      WriteLn;
      WriteLn('All tests passed.');
    End Else
      WriteLn('Not available in demo version!');
  End Else
    WriteLn('Only available in registered version!');
End;


Begin
  If Not RkpOK then Begin
    WriteLn('Unexpected Error ',RkpError,'!');
    Halt(255);
  End;
  If BadSystemDate then Begin
    WriteLn('You must correctly set your system clock to run Demo!');
    BadRegBeep;
    Halt(1);
  End;
  Owner := 'ArgleBarbWotsLeeb';
  Prog := 'Sample';
  Ver := 1.0;
  SetOwnerCode(Owner,SizeOf(Owner));
  SetProgCode(Prog,SizeOf(Prog));
  SetVerCode(Ver,SizeOf(Ver));
  VerifyKey;
  Write('Sample4');
  If Not RkpOK then
    WriteLn(' [invalid]')
  Else If Rkp.Registered and (Rkp.Level > 0) then
    WriteLn(' [registered]')
  Else If Rkp.Registered then
    WriteLn(' [demo]')
  Else
    WriteLn(' [unregistered]');
  WriteLn('Sample of RkPlus method 5 (using version 3.x/compatible keys)');
  WriteLn('See RKPLUS.DOC for more info');
  WriteLn;
  If (RkpError = InvalidFile) or (RkpError = InvalidKey) then Begin
    WriteLn(ExeFileName,' has been altered!');
    BadRegBeep;
    Halt(1);
  End Else If (RkpError = ExpiredKey) then Begin
    If (Rkp.Level > 0) then Begin
      WriteLn('Your registration key has expired!');
      WriteLn('You will be given access at the DEMO level.');
      NotRegBeep;
      Rkp.Level := 0;
    End Else Begin
      WriteLn('Your limited use demo key has expired!');
      WriteLn('You will be given access at the UNREGISTERED level.');
      NotRegBeep;
      Rkp.Registered := False;
    End;
  End Else If Rkp.Registered then Begin
    If (Rkp.Level > 0) then Begin
      WriteLn('This version of Sample4 is registered to ',Rkp.Name1);
      If (Rkp.ExpYear <> 0) and (Rkp.ExpMonth <> 0) then
        WriteLn('This registration will expire ','1-',MonthNames[Rkp.ExpMonth],'-',Rkp.ExpYear,'.');
      WriteLn('Thank you for registering!');
    End Else Begin
      WriteLn('This version of Sample4 is a limited use demo for ',Rkp.Name1);
      If (Rkp.ExpYear <> 0) and (Rkp.ExpMonth <> 0) then
        WriteLn('This limited use demo will expire ','1-',MonthNames[Rkp.ExpMonth],'-',Rkp.ExpYear,'.');
      WriteLn('Don''t forget to register!');
    End;
  End Else If Not RkpOK then Begin
    WriteLn('Unexpected error ',RkpError,'!');
    Halt(255);
  End Else Begin
    WriteLn('This version of Sample4 is unregistered.');
    NotRegBeep;
    Delay(500);
  End;
  WriteLn;
  WriteLn('Sample4 Menu');
  WriteLn;
  WriteLn('[V]iew sample data');
  Write('[C]alculate');
  If Not Rkp.Registered then
    WriteLn('  (only available in registered version)')
  Else
    WriteLn;
  Write('[T]est results');
  If Not Rkp.Registered then
    WriteLn('  (only available in registered version)')
  Else If (Rkp.Level <= 0) then
    WriteLn('  (not available in demo version)')
  Else
    WriteLn;
  WriteLn;
  Write('Selection : ');
  kc := UpCase(ReadKey);
  WriteLn;
  WriteLn;
  Case kc of
  'V' :
    DoView;
  'C' :
    DoCalc;
  'T' :
    DoTest;
  Else
    WriteLn('Invalid selection!');
  End;
End.
