{$R+}

program tsuntzTest;

uses TSUNTL,
     TSUNTE,
     TSUNTG
     {$IFDEF VER40}
     ,TSUNT45
     {$ELSE}
     ,Dos
     {$ENDIF}
     ;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTL unit test by Prof. Timo Salmi, 24-Feb-93');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;  (* logo *)

(* Test scrolling a window up and down *)
procedure TEST1;
var i, j : byte;
begin
  for i := 0 to 23 do
    begin
      case (i mod 2) of
        0 : for j := 1 to 79 do write (j mod 10);
      end;
      writeln
    end;
  write ('Press any key');
  {}
  for i := 1 to 4 do
    begin
      repeat until KEYPREFN;              { from TSUNTG }
      CLB;                                { from TSUNTE }
      SCROLLUP (1, 0, 3, 20, 18, 39);
    end;
  for i := 1 to 6 do
    begin
      repeat until KEYPREFN;
      CLB;
      SCROLLDN (1, 0, 3, 20, 20, 39);
    end;
end;  (* test1 *)

(* Test if an EGA or better is available *)
procedure TEST2;
begin
  if ISEGAFN then
    writeln ('EGA or better detected')
  else
    writeln ('No EGA or better');
end;  (* test2 *)

{$IFNDEF VER40}  (* Not Turbo Pascal 4.0 *)
(* Set a disk volume label *)
procedure TEST3;
const drive = 'R';                     { I have ramdisk on R: }
      newLabel : string = 'ramdisk';
var s        : string11;
    ok       : boolean;
    i        : byte;
    nonblank : boolean;
begin
  {... the new label must contain something ...}
  if newLabel = '' then exit;
  nonblank := false;
  for i := 1 to Length(newLabel) do
    if (newLabel[i] <> ' ') then nonblank := true;
  if not nonblank then exit;
  {}
  s :=  LABELFN (drive);  { from TSUNTE }
  writeln ('Label on ', drive, ': is ', s);
  SETLABEL (drive, newlabel, ok);
  {}
  if ok then
    writeln ('Success in setting the label on drive ', drive, ':')
  else
    writeln ('Error in setting the label on drive ', drive, ':');
  {}
  s := LABELFN (drive);
  writeln ('Label on ', drive, ': is ', s);
end;  (* test3 *)
{$ENDIF}  (* Not Turbo Pascal 4.0 *)

(* Main program *)
begin
  LOGO;
  TEST2;
  {}
  {... if you want the rest of the tests, just include them ...}
  {}
  write ('Press <-'' '); readln;
  {}
end.  (* tsuntl.tst *)
