(* This is a test program for the TSUNTH.TPU unit 25-Feb-89
   Updated 21-Mar-90, 23-Jul-90, 1-Aug-90, 5-Jan-91, 21-Jul-91,
           24-Nov-91, 23-Aug-92, 4-Feb-93 *)

uses Dos, TSUNTH;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTH unit test by Prof. Timo Salmi, 4-Feb-93');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
end;  (* logo *)

(* Testing if graftabl is loaded *)
procedure TEST1;
begin
  if GRTABLFN then
     writeln ('GRAFTABL has been loaded')
   else
     writeln ('GRAFTABL has not been loaded');
end;  (* test1 *)

(* Testing for the processor type *)
procedure TEST2;
begin
  write ('The processor is a ');
  case CPUFN of
    0 : writeln ('8086');
    2 : writeln ('80286');
    3 : writeln ('80386');
    4 : writeln ('80486');
  end;
end;  (* test2 *)

(* Is a math coprocessor present *)
procedure TEST4;
begin
  if MATHCOFN then
     writeln ('A math coprocessor is present')
   else
     writeln ('No math coprocessor present');
end;  (* test4 *)

(* Number of serial ports *)
procedure TEST5;
begin
  writeln ('Number of serial ports ', RS232FN);
  Flush (output);
end;  (* test5 *)

(* Number of parallel ports *)
procedure TEST6;
begin
  writeln ('Number of parallel ports ', PARPORFN);
  Flush (output);
end;  (* test6 *)

(* Country code *)
procedure TEST7;
begin
  writeln ('The country code is ', COUNTRFN);
  Flush (output);
end;  (* test7 *)

(* Get ROM BIOS version *)
procedure TEST9;
begin
  writeln ('The ROM BIOS version (date) is ', ROMDTEFN);
  Flush (output);
end;  (* test9 *)

(* Is an enhanced keyboard present *)
procedure TEST10;
begin
  if ISENHAFN then
    writeln ('Enhanced keyboard')
  else
    writeln ('Not an enhanced keyboard');
end;  (* test10 *)

(* Last drive, and interleave values *)
procedure TEST11;
var lastdrive  : char;
    interleave : byte;
    ch         : char;
begin
  lastdrive := LASTDRFN;
  writeln ('The last drive on this system is ', lastdrive);
  if lastdrive > 'B' then
    for ch := 'C' to lastdrive do
      writeln ('Drive ', ch, ' interleave is ', INTERLFN (ch));
  writeln;
  for ch := 'A' to lastdrive do
    writeln ('Drive ', ch, ' number of FATs is ', FATSFN (ch));
end;  (* test11 *)

(* Show date and time formats of your configuration *)
procedure TEST13;
begin
  writeln ('The country-dependent date format is ', DATEFMFN);
  writeln ('The country-dependent time format is ', TIMEFMFN);
end;  (* test13 *)

procedure TEST14;
const drive = 'A';
begin
   writeln ('Number of cylinders on ', drive, ', is ', NRCYLFN(drive));
end;  (* test14 *)

(* Test whether a mouse is available *)
procedure TEST15;
begin
  write ('MOUSTAFN: ');
  case MOUSTAFN of
    0 : writeln ('No mouse & driver detected');
    1 : writeln ('Mouse detected, with other than two buttons');
    2 : writeln ('Mouse detected, with two buttons');
    3 : writeln ('Mouse Systems or Logitech mouse detected, EEEEEK!!!!');
    4 : writeln ('Mouse status unknown');
  end;
end;  (* test15 *)

(* Simple false/true test whether a mouse is available *)
procedure TEST16;
begin
  write ('ISMOUSFN: ');
  case ISMOUSFN of
    true  : writeln ('Mouse detected');
    false : writeln ('No mouse detected');
  end;
end;  (* test16 *)

(* Main program *)
begin
  LOGO;
  TEST2;
  TEST4;
  TEST5;
  TEST6;
  TEST7;
  TEST9;
  TEST10;
  TEST15;
  {}
  {... if you want the rest of the tests, just include them ...}
  {}
  write ('Press <ͼ'); readln;
end.  (* tsunth.tst *)
