/* $XFree86: mit/server/ddx/x386/common/x386Vendor.h,v 1.9 1993/06/03 15:29:04 dawes Exp $ */
/*
 * Copyright 1993 by David Wexelblat <dwex@goblin.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of David Wexelblat not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  David Wexelblat makes no representations
 * about the suitability of this software for any purpose.  It is provided
 * "as is" without express or implied warranty.
 *
 * DAVID WEXELBLAT DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL DAVID WEXELBLAT BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */

#ifndef _X386_VENDOR_H
#define _X386_VENDOR_H

/*
 * Structures and macros for handling vendor/option flags.
 */
#define MAX_VFLAGS	128
#define FLAGBITS	sizeof(unsigned long)
typedef struct {
	unsigned long flag_bits[MAX_VFLAGS/FLAGBITS];
} VFlagSet;

#define VFLG_SET(f,p)	((p)->flag_bits[(f)/FLAGBITS] |= (1 << ((f)%FLAGBITS)))
#define VFLG_CLR(f,p)	((p)->flag_bits[(f)/FLAGBITS] &= ~(1 << ((f)%FLAGBITS)))
#define VFLG_ISSET(f,p)	((p)->flag_bits[(f)/FLAGBITS] & (1 << ((f)%FLAGBITS)))
#define VFLG_ZERO(p)	memset((char *)(p), 0, sizeof(*(p)))

/*
 * Vendor flags.  Define these in numeric order.
 *
 * The keyword is being changed from "Vendor" to "Option", so use the
 * names OPTION_*
 */
#define VENDOR_LEGEND		0  /* Legend board with 32 clocks           */
#define VENDOR_SWAP_HIBIT	1  /* WD90Cxx-swap high-order clock sel bit */
#define VENDOR_INTERN_DISP	2  /* Laptops - enable internal display (WD)*/
#define VENDOR_EXTERN_DISP	3  /* Laptops - enable external display (WD)*/
#define VENDOR_NOLINEAR_MODE	4  /* chipset has broken linear access mode */
#define VENDOR_ICD2061A		5  /* use ICD 2061A programable clocks      */

#define OPTION_LEGEND		VENDOR_LEGEND
#define OPTION_SWAP_HIBIT	VENDOR_SWAP_HIBIT
#define OPTION_INTERN_DISP	VENDOR_INTERN_DISP
#define OPTION_EXTERN_DISP	VENDOR_EXTERN_DISP
#define OPTION_NOLINEAR_MODE	VENDOR_NOLINEAR_MODE
#define OPTION_ICD2061A		VENDOR_ICD2061A

#define OPTION_16CLKS		6  /* probe for 16 clocks instead of 8 */
#define OPTION_PROBE_CLKS	7  /* Force clock probe for cards where a
				      set of preset clocks is used */
#define OPTION_HIBIT_HIGH	8  /* Initial state of high order clock bit */
#define OPTION_HIBIT_LOW	9
#define OPTION_FORCE_BITS	10 /* Test option for ET4000 */

/*
 * Table to map vendor strings to tokens.
 */
typedef struct {
  char *name;
  int  token;
} VendFlagRec, *VendFlagPtr;

#ifdef IN_X386CONF
VendFlagRec x386VendorTab[] = {
  { "legend",		OPTION_LEGEND },
  { "swap_hibit",	OPTION_SWAP_HIBIT },
  { "intern_disp",	OPTION_INTERN_DISP },
  { "extern_disp",	OPTION_EXTERN_DISP },
  { "nolinear",		OPTION_NOLINEAR_MODE },
  { "icd2061a",		OPTION_ICD2061A },
  { "16clocks",		OPTION_16CLKS },
  { "probe_clocks",	OPTION_PROBE_CLKS },
  { "hibit_high",	OPTION_HIBIT_HIGH },
  { "hibit_low",	OPTION_HIBIT_LOW },
  { "force_bits",	OPTION_FORCE_BITS },
  { "",			-1 },
};
#else
extern VendFlagRec x386VendorTab[];
#endif

#endif /* _X386_VENDOR_H */

